<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP level class
// Classe pour gerer les niveaux utilisateurs
// create : 12/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* level
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class level {
    /* @param
	* */
    var $TDB_LEVEL = T_LEVEL; // nom de la table.
    var $URI_INPUT = "level/visual/"; // dossier racine de stockage des photos
    var $DATE_FORMAT = "%d-%m-%Y";
    var $ID;
    var $NAME;
    var $DESCRIPTION;
    var $COMMENT;
    var $VISUAL_URI;
    var $RANGE;
    var $DATE_CREA;
    var $STATUT;
    var $LAST_MODIFY;

    var $UPLOAD_MAX_MO = 1024000; // taille maximale d'upload des photos en octets
    var $MAX_PHOTO_MAX_WIDTH = 50;
    var $MAX_PHOTO_MIN_WIDTH = 50;

    /**
    * level::CheckDataIntegrity()
    * vrifie l'integrit des donnes d'un niveau
    * 
    * @access public 
    * @param array $table_level : contient les composants d'un niveau
    * @param object $sql_object 
    * @return boolean true
    * si verifi, sinon string 'message d'erreur'
    */
    function CheckDataIntegrity($table_level)
    {
        if (strlen($table_level[0]) < 2) return $GLOBALS['lang']['level']['object_notdenomination'];

        return true;
    } 

    /**
	* level::AddLevel()
    * Ajout d'un niveau
    * 
    * @access public 
    * @param array $table_level contient les composants d'un niveau
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddLevel($table_level, $sql_object)
    {
        if ($table_level[0] != '') {
            $this->NAME = strip_tags($table_level[0]);
        } 
        if ($table_level[1] != '') {
            $this->DESCRIPTION = strip_tags($table_level[1]);
        } 
        $this->COMMENT = strip_tags($table_level[2]);

        $this->VISUAL_URI = strip_tags($table_level[3]);

        if (is_numeric($table_level[4])) {
            $this->RANGE = $table_level[4];
        } 
        if ($table_level[5] != '') {
            strtoupper($table_level[5]);
            switch ($table_level[5]) {
                case 'P':
                    $this->STATUT = $table_level[5];
                    break;
                case 'D':
                    $this->STATUT = $table_level[5];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } else $this->STATUT = 'P';

        $requete = "INSERT INTO " . $this->TDB_LEVEL . "(level_name, level_description, level_comment, level_visual_identity, " . "level_range, level_statut, level_date_crea) " . "VALUES('" . $this->NAME . "', '" . $this->DESCRIPTION . "', '" . $this->COMMENT . "', '" . $this->VISUAL_URI . "', " . $this->RANGE . ", '" . $this->STATUT . "', CURRENT_TIMESTAMP());";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

    /**
	* level::ModifyLevel()
    * modification d'un niveau
    * 
    * @access public 
    * @param int $id identifiant niveau a modifier
    * @param array $table_level contient les composants d'un niveau
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyLevel($ID, $table_level, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($table_level[0] != '') {
            $this->NAME = strip_tags($table_level[0]);
        } 
        if ($table_level[1] != '') {
            $this->DESCRIPTION = strip_tags($table_level[1]);
        } 
        $this->COMMENT = strip_tags($table_level[2]);

        $this->VISUAL_URI = strip_tags($table_level[3]);

        if (is_numeric($table_level[4])) {
            $this->RANGE = $table_level[4];
        } 
        if ($table_level[5] != '') {
            strtoupper($table_level[5]);
            switch ($table_level[5]) {
                case 'P':
                    $this->STATUT = $table_level[5];
                    break;
                case 'D':
                    $this->STATUT = $table_level[5];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } else $this->STATUT = 'P';

        $requete = "UPDATE  " . $this->TDB_LEVEL . " set level_name='" . $this->NAME . "', level_description='" . $this->DESCRIPTION . "' , level_comment='" . $this->COMMENT . "', level_visual_identity='" . $this->VISUAL_URI . "',level_range=" . $this->RANGE . ", level_statut='" . $this->STATUT . "' WHERE level_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* level::StateLevel()
    * modification du statut d'un niveau
    * -- NE PREND PAS EN CHARGE l'EFFACEMENT --
    * 
    * @access public 
    * @param int $ID identifiant du niveau
    * @param string $state 'P' Public | 'D' Draft/
    * @param object $sql_object 
    * @return bool $result
    */
    function StateLevel($ID, $state, $sql_object)
    {
        $this->ID = $ID;
        strtoupper($state);
            switch ($state) {
                case 'P':
                    $this->STATUT = $state;
                    break;
                case 'D':
                    $this->STATUT = $state;
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        $requete = "UPDATE  " . $this->TDB_LEVEL . " set level_statut='" . $this->STATUT . "' WHERE level_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* level::DeleteLevel()
    * suppression d'un niveau
    *  -- NON IMPLEMENTEE/NON TESTEE DANS L'APPLICATION --
	* 
    * @access public 
    * @param int $ID identifiant du niveau
	* @param object $sql_object
    * @param string $type type : 'MASS_DELETE' toutes les ressources associes  l'chelle sont rendues inactives
    * 'MASS_MODIFY' remplacement de l'ancienne chelle par $ID_new
    * @param int $ID_new identifiant du nouveau niveau a rattacher
    * @return object $affected
    */

    function DeleteLevel($ID, $sql_object, $type, $ID_new = -1)
    {
        $affected = 0;
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($type == 'MASS_MODIFY') {
            if ($ID_new != -1 && is_numeric($ID_new)) {
                $requete = "UPDATE  " . $this->TDB_LEVEL . " set level_statut='E' WHERE level_id=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete);
                if ($result == true) {
                    $requete_news = "UPDATE  " . T_NEWS . " set news_level=" . $ID_new . " WHERE  news_level=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_news);
                    $affected += mysql_affected_rows();
                    $requete_publication = "UPDATE  " . T_PUBLI . " set publi_level=" . $ID_new . " WHERE  publi_level=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_publication);
                    $affected += mysql_affected_rows();
                } 
            } 
        } 
        if ($type == 'MASS_DELETE') {
            $requete = "UPDATE  " . $this->TDB_LEVEL . " set level_statut='E' WHERE level_id=" . $this->ID . ";";
            $result = $sql_object->DBQuery($requete);
            if ($result == true) {
                $requete_news = "UPDATE  " . T_NEWS . " set news_statut='E' WHERE  news_level=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_news);
                $affected += mysql_affected_rows();
                $requete_publication = "UPDATE  " . T_PUBLI . " set publi_statut='E' WHERE  publi_level=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_publication);
                $affected += mysql_affected_rows();
            } 
        } 
        return $affected;
    } 

	
} 

?>
