<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP scale class
// Class pour gerer l'echelle geographique
// create : 23/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* scale
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class scale {
    /* @param
	* */
    var $TDB_SCALE = T_SCALE; // nom de la table.
    var $DATE_FORMAT = "%d-%m-%Y";
    var $ID;
    var $DENOMINATION;
    var $ROOT;
    var $SURFACE;
    var $INHABITANTSNUM;
    var $COMMENT;
    var $DEPENDENCIES;
    var $DATE_CREA;
    var $STATUT;
    var $LAST_MODIFY;

    var $DEPTH_TABLE = array (); // tableau contenant les profondeurs d'chelles
    var $SON_TABLE = array (); // tableau contenant les fils d'chelles
    var $ALL_REC = array (); // tableau contenant les fils d'chelles
    /**
    * scale::CheckDataIntegrity()
    * Vrification des donnes d'une echelle
    * 
    * @access public 
    * @param array $table_scale : contient les composants d'une echelle
    * @return boolean si vrai renvoie true sinon message d'erreurs (string)
    */
    function CheckDataIntegrity($table_scale)
    {
        $notdenomination = $GLOBALS['lang']['scale']['object_notdenomination'];
        $notnumsurface = $GLOBALS['lang']['scale']['object_notnumsurface'];
        $notnuminhabitants = $GLOBALS['lang']['scale']['object_notnuminhabitants'];
        $notroot = $GLOBALS['lang']['scale']['object_notroot'];

        if (strlen($table_scale[0]) < 2) return $notdenomination;
        if (trim($table_scale[1]) != '' && !is_numeric($table_scale[1])) return $notnumsurface;
        if (trim($table_scale[2]) != '' && !is_numeric($table_scale[2])) return $notnuminhabitants;
        if (!is_numeric($table_scale[3]) || $table_scale[3] == -1) return $notroot;
        return true;
    } 

    /**
    * scale::getMaxDepth()
    * obtention de la profondeur max d'une chelle ( par rapport a ses filles )
    * 
    * @access public 
    * @param  $id : identifiant de l'chelle courante
    * @param  $sql_object 
    * @return array $return_table contennat profondeur et chelle d'exclusion
    */
    function getMaxDepth($id, $sql_object)
    {
        $this->ID = $id;

        $requete = "SELECT scale_dependencies FROM " . $this->TDB_SCALE . " WHERE scale_id='" . $this->ID . "';";
        $result = $sql_object->DBSelect($requete);
        $this->DEPENDENCIES = $result[0]['scale_dependencies'];
        array_push($this->DEPTH_TABLE, $this->DEPENDENCIES);
        array_push($this->SON_TABLE, $this->ID);

        $this->getAllRecord($sql_object);
        $this->getScaleDepthAndSon($this->ALL_REC, $this->ID);
        rsort($this->DEPTH_TABLE);

        $return_table["depth"] = MAX_SCALE_LEVEL - ($this->DEPTH_TABLE[0] - ($this->DEPTH_TABLE[(count($this->DEPTH_TABLE)-1)])) - 1;
        $return_table["exclusion"] = $this->SON_TABLE;

        return $return_table;
    } 

    /**
    * scale::getScaleDepthAndSon()
    * obtention des fils et profondeur ( rcursif ) par rapport  une chelle donnes
    * stockage dans des tableaux respectifs.
    * 
    * @param  $table Ensemble des chelles
    * @param  $id chelle courante
    * @return void 
    */
    function getScaleDepthAndSon($table, $id)
    {
        for($i = 0; $i < count($table); $i++) {
            $current_dep = $table[$i]['scale_dependencies'];
            $current_root = $table[$i]['scale_root'];
            $current_id = $table[$i]['scale_id'];

            if ($id == $current_root) {
                if (!in_array($current_dep, $this->DEPTH_TABLE)) array_push($this->DEPTH_TABLE, $current_dep);
                if (!in_array($current_id, $this->SON_TABLE)) array_push($this->SON_TABLE, $current_id);
                $this->getScaleDepthAndSon($table, $current_id);
            } 
        } 
    } 

    /**
    * scale::getAllRecord()
    * Obtention de toutes les chelles.
    * 
    * @param  $sql_object 
    * @return void 
    */
    function getAllRecord($sql_object)
    {
        $requete = "SELECT scale_dependencies, scale_id, scale_root FROM " . $this->TDB_SCALE . ";";
        $this->ALL_REC = $sql_object->DBSelect($requete);
    } 

    /**
    * scale::AddScale()
    * Ajout d'une echelle
    * 
    * @access public 
    * @param array $table_scale contient les composants d'une echelle
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddScale($table_scale, $sql_object)
    {
        if (strlen($table_scale[0]) > 1) {
            $this->DENOMINATION = strip_tags(trim($table_scale[0]));
        } else return $notdenomination;
        if (trim($table_scale[1]) == '') {
            $this->SURFACE = 0;
        } else {
            $this->SURFACE = trim($table_scale[1]);
        } 
        if (trim($table_scale[2]) == '') {
            $this->INHABITANTSNUM = 0;
        } else {
            $this->INHABITANTSNUM = trim($table_scale[2]);
        } 
        if (is_numeric($table_scale[3])) {
            $this->ROOT = $table_scale[3];
        } 

        $this->COMMENT = strip_tags(trim($table_scale[4]));

        if ($table_scale[5] != '') {
            strtoupper($table_scale[5]);
            switch ($table_scale[5]) {
                case 'P':
                    $this->STATUT = $table_scale[5];
                    break;
                case 'D':
                    $this->STATUT = $table_scale[5];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } else $this->STATUT = 'P'; 
        // On Determine le rang de l'chelle
        $requete = "SELECT scale_dependencies FROM " . $this->TDB_SCALE . " WHERE scale_id=" . $this->ROOT . ";";
        $result = $sql_object->DBSelect($requete);
        $this->DEPENDENCIES = $result[0]['scale_dependencies'] + 1;

        $requete = "INSERT INTO " . $this->TDB_SCALE . "(scale_denomination, scale_surface, scale_inhabitantsnumber, scale_root, scale_comment, " . "scale_dependencies, scale_statut, scale_date_crea) " . "VALUES('" . $this->DENOMINATION . "', " . $this->SURFACE . ", " . $this->INHABITANTSNUM . ", " . $this->ROOT . ", '" . $this->COMMENT . "', " . $this->DEPENDENCIES . ", '" . $this->STATUT . "', CURRENT_TIMESTAMP());";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

    /**
    * scale::ModifyScale()
    * modification d'une echelle
    * 
    * @access public 
    * @param int $ID identifiant de l'echelle
    * @param object $sql_object 
    * @param array $table_scale contient les composants d'une echelle
    * @return bool $result
    */
    function ModifyScale($ID, $table_scale, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($table_scale[0] != '') {
            $this->DENOMINATION = strip_tags(trim($table_scale[0]));
        } 
        if (trim($table_scale[1]) == '') {
            $this->SURFACE = 0;
        } else {
            $this->SURFACE = trim($table_scale[1]);
        } 
        if (trim($table_scale[2]) == '') {
            $this->INHABITANTSNUM = 0;
        } else {
            $this->INHABITANTSNUM = trim($table_scale[2]);
        } 
        if (is_numeric($table_scale[3])) {
            $this->ROOT = $table_scale[3];
        } 

        $this->COMMENT = strip_tags(trim($table_scale[4]));

        if ($table_scale[5] != '') {
            strtoupper($table_scale[5]);
            switch ($table_scale[5]) {
                case 'P':
                    $this->STATUT = $table_scale[5];
                    break;
                case 'D':
                    $this->STATUT = $table_scale[5];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } 
        // On Determine le rang de l'chelle
        $requete = "SELECT scale_dependencies FROM " . $this->TDB_SCALE . " WHERE scale_id=" . $this->ROOT . ";";
        $result = $sql_object->DBSelect($requete);
		// Si ce n'est pas l'chelle racine on assigne sinon =-1
		$current_depth= (empty($result)) ? -1 : $result[0]['scale_dependencies'];
        $this->DEPENDENCIES = $current_depth + 1; 
        // mise  jour du niveau des informations relatives  l'chelle
        $requete = "UPDATE  " . $this->TDB_SCALE . " set scale_denomination='" . $this->DENOMINATION . "', scale_surface=" . $this->SURFACE . ", scale_inhabitantsnumber=" . $this->INHABITANTSNUM . ", scale_root=" . $this->ROOT . ", scale_comment='" . $this->COMMENT . "', scale_dependencies=" . $this->DEPENDENCIES . ", scale_statut='" . $this->STATUT . "' WHERE scale_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete); 
        // si la nouvelle chelle root diffre de la prcdente, update rcursif des dpendances des chelles filles.
        if ($table_scale[6] != $this->ROOT) {
            $this->getAllRecord($sql_object);
            $tabledepth = $this->update_all_dependencies($this->ALL_REC, $this->DEPENDENCIES, $this->ID, $sql_object);
        } 

        return true;
    } 

    /**
    * scale::update_all_dependencies()
    * Mise  jour de l'ensemble des chelles filles par rapport  ul'chelle courante.
    * 
    * @param  $table 
    * @param  $depth 
    * @param  $id 
    * @param  $sql_object 
    * @return void 
    */
    function update_all_dependencies($table, $depth, $id, $sql_object)
    {
        $table_depth = array();
        for($i = 0; $i < count($table); $i++) {
            $current_dep = $table[$i]['scale_dependencies'];
            $current_root = $table[$i]['scale_root'];
            $current_id = $table[$i]['scale_id'];

            if ($id == $current_root) {
                $requete = "UPDATE  " . $this->TDB_SCALE . " SET scale_dependencies='" . ($depth + 1) . "' WHERE scale_id='" . $current_id . "';";
                $result = $sql_object->DBQuery($requete);
                $this->update_all_dependencies($table, $depth + 1, $current_id, $sql_object);
            } 
        } 
    } 

    /**
    * scale::StateScale()
    * modification du statut d'une chelle
    * 
    * @access public 
    * @param int $id identifiant de l'echelle
    * @param string $state (facultatif) 'P' Public/'D' Draft
    * @param object $sql_object 
    * @return bool $result
    */
    function StateScale($ID, $state, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($state != '') {
            strtoupper($state);
            switch ($state) {
                case 'P':
                    $this->STATUT = $state;
                    break;
                case 'D':
                    $this->STATUT = $state;
                    break;
                default:
                    $this->STATUT = $state;
                    break;
            } 
        } else $this->STATUT = 'P';
        $requete = "UPDATE  " . $this->TDB_SCALE . " set scale_statut='" . $this->STATUT . "' WHERE scale_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
    * scale::DeleteScale()
    * suppression d'une echelle
    * 
    * @access public 
    * @param int $ID identifiant de l'echelle
    * @param string $type 'MASS_DELETE' 
    * 'MASS_DELETE' toutes les ressources associes  l'chelle sont rendues inactives
    * 'MASS_MODIFY' remplacement de l'ancienne chelle par $ID_new
    * @param int $ID_new nouvel id de rattachement
    * @param object $sql_object 
    * @return integer $affected // nombre de ressources affectes par les changements
    */
    function DeleteScale($ID, $sql_object, $type, $ID_new = -1)
    {
        $affected = 0;
        $this->ID = $ID;
        if ($type == 'MASS_MODIFY') {
            if ($ID_new != -1 && is_numeric($ID_new)) {
                $requete = "UPDATE  " . $this->TDB_SCALE . " set scale_statut='E' WHERE scale_id=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete);
                if ($result) {
                    $requete = "SELECT scale_dependencies FROM " . $this->TDB_SCALE . " WHERE scale_id=" . $ID_new . ";";
                    $result = $sql_object->DBSelect($requete);
                    $dependencies = $result[0]['scale_dependencies'];
                    $requete = "UPDATE  " . $this->TDB_SCALE . " set scale_root=" . $ID_new . " WHERE scale_root=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete); 
                    // modification rcursive des dpendances.
                    $this->getAllRecord($sql_object);
                    $this->update_all_dependencies($this->ALL_REC, $dependencies, $ID_new, $sql_object); 
                    // mise  jour des ressources.
                    $requete_news = "UPDATE  " . T_NEWS . " set news_scale=" . $ID_new . " WHERE  news_scale=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_news);
                    $affected += mysql_affected_rows();
                    $requete_publication = "UPDATE  " . T_PUBLI . " set publi_scale=" . $ID_new . " WHERE  publi_scale=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_publication);
                    $affected += mysql_affected_rows();
                    $requete_sdi = "UPDATE  " . T_SDI_VALUE . " set sdiv_scale=" . $ID_new . " WHERE  sdiv_scale=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_sdi);
                    $affected += mysql_affected_rows();
                } 
            } 
        } 
        if ($type == 'MASS_DELETE') {
            $this->getAllRecord($sql_object);
            $this->getScaleDepthAndSon($this->ALL_REC, $this->ID);

            $update_bdd_scale = '';
            $update_bdd_news = '';
            $update_bdd_publi = '';
            $update_bdd_sdi = '';
            for($i = 0; $i < count($this->SON_TABLE); $i++) {
                $update_bdd_scale .= " OR scale_id='" . $this->SON_TABLE[$i] . "'";
                $update_bdd_news .= " OR news_scale='" . $this->SON_TABLE[$i] . "'";
                $update_bdd_publi .= " OR publi_scale='" . $this->SON_TABLE[$i] . "'";
                $update_bdd_sdi .= " OR sdiv_scale='" . $this->SON_TABLE[$i] . "'";
            } 
            // Effacement de l'chelle et ses fils
            $requete = "UPDATE  " . $this->TDB_SCALE . " set scale_statut='E' WHERE scale_id='" . $this->ID . "'";
            $requete .= $update_bdd_scale;
            $requete .= ";";

            $result = $sql_object->DBQuery($requete);

            if ($result == 1) {
                $requete_news = "UPDATE  " . T_NEWS . " SET news_statut='E' WHERE  news_scale='" . $this->ID . "'";
                $requete_news .= $update_bdd_news;
                $requete_news .= ";";

                $result = $sql_object->DBQuery($requete_news);
                $affected += mysql_affected_rows();

                $requete_publication = "UPDATE  " . T_PUBLI . " SET publi_statut='E' WHERE  publi_scale='" . $this->ID . "'";
                $requete_publication .= $update_bdd_publi;
                $requete_publication .= ";";

                $result = $sql_object->DBQuery($requete_publication);
                $affected += mysql_affected_rows();

                $requete_sdi = "UPDATE  " . T_SDI_VALUE . " SET sdiv_statut='E' WHERE  sdiv_scale='" . $this->ID . "'";
                $requete_sdi .= $update_bdd_sdi;
                $requete_sdi .= ";";

                $result = $sql_object->DBQuery($requete_sdi);
                $affected += mysql_affected_rows();
            } 
        } 
        return $affected;
    } 
} 

?>
