<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP session class
// Gestion des sessions
// create : 31/03/2004
// last_modify : 31/03/2004
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* class.session.php
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class session {
    /* @param
	* */
	var $S_ID;
    var $S_LOGIN;
    var $S_PASS;
    var $ACTIVE_TYPE; // valeur 'P' || 'W'
    var $WR_ID;
    var $WR_TITLE;
    var $WR_BODY;
    var $WR_DATE_CREA;
    var $WR_LAST_MODIFY;
    var $WR_TABLE = T_WORK_REP_CONT;

    var $P_ID;
    var $P_TITLE;
    var $P_BODY;
    var $P_TEMPLATE;
    var $P_PHOTOS_URI;
    var $P_DATE_CREA;
    var $P_LAST_MODIFY;
    var $P_TABLE = T_PUBLI_CONT;
    var $P_MAX_PHOTO_MAX_WIDTH = 600;
    var $P_MAX_PHOTO_MIN_WIDTH = 160;
    var $P_UPLOAD_MAX_MO = 102400; // taille maximale d'upload des fichiers en octets
    var $P_URI_INPUT = "publication/contents/"; // dossier racine de stockage des elements multimedias
    var $P_URI_OUTPUT = "publication/contents/"; // dossier racine de diffusion des elements multimedias
    /**
    * contents::CheckDataIntegrity()
    * vrifie l'integrit d'un partie avant Insertion
    * 
    * @access public 
    * @param array $table contient les composants d'une partie
    * @param string $type 'P', 'W'
    * @param string $type_test 'LIGHT', 'ROCK'
    * @return boolean true
    * si verifi, sinon string 'message d'erreur'
    */
    function session()
    {
        session_start();

        return true;
    } 

    /**
    * contents::GetTemplateName()
    * Retourne la forme textuelle du template
    * 
    * @access public 
    * @param integrer $num 
    * @return void 
    */
    function GetTemplateName($num)
    {
        if ($num == 1) return $GLOBALS['lang']['contents']['template_1'];
        if ($num == 2) return $GLOBALS['lang']['contents']['template_2'];
        if ($num == 3) return $GLOBALS['lang']['contents']['template_3'];
    } 

    /**
    * contents::_wichType()
    * initialisation des tables SQL
    * 
    * @access private 
    * @param string $type : type du CONTENU 'WORKSHOP' ou 'PUBLICATION'
    * @return string -void
    */
    function _wichType($type)
    {
        switch ($type) {
            case 'WORKSHOP':
                $this->ACTIVE_TABLE = $this->WR_TABLE;
                $this->ACTIVE_TYPE = 'W';
                break;
            case 'PUBLICATION':
                $this->ACTIVE_TABLE = $this->P_TABLE;
                $this->ACTIVE_TYPE = 'P';
                break;
            default:
                return "error";
        } 
    } 

    /**
    * contents::AddContents()
    * ajout d'une partie de contenu
    * 
    * @access public 
    * @param integer $ID identifiant du pre (rattachement)
    * @param array $contents_table tableau contenant les infos ressources
    * @param string $type 'WORKSHOP' ou 'PUBLICATION'
    * @param object $ 
    * @return integer $last_id
    */
    function AddContents($ID, $contents_table, $type, $sql_object)
    {
        if ($this->_wichType($type) == "error") exit;
        $requete = "INSERT INTO " . $this->ACTIVE_TABLE . " ";
        if ($type == "WORKSHOP") {
            $this->WR_TITLE = strip_tags($contents_table[0]);
            $this->WR_BODY = strip_tags($contents_table[1], ALLOWABLE_TAGS);
            $requete .= " VALUES('','" . $this->WR_TITLE . "', '" . $this->WR_BODY . "', CURRENT_TIMESTAMP(),CURRENT_TIMESTAMP(), 'Y');";
        } 
        if ($type == "PUBLICATION") {
            $this->P_TITLE = strip_tags($contents_table[0]);
            $this->P_BODY = strip_tags($contents_table[1], ALLOWABLE_TAGS);
            $this->P_TEMPLATE = $contents_table[2];
            $this->P_PHOTOS_URI = strip_tags($contents_table[3]);
            $requete .= " VALUES('','" . $this->P_TITLE . "', '" . $this->P_BODY . "', " . $this->P_TEMPLATE . ", '" . $this->P_PHOTOS_URI . "', CURRENT_TIMESTAMP(),CURRENT_TIMESTAMP(), 'Y');";
        } 
        $last_id = $sql_object->DBInsert ($requete, 1);

        if (is_numeric($last_id)) {
            $requete = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
            $result = $sql_object->DBInsert ($requete);
        } 
        return $result;
    } 

    /**
    * contents::ModifyContents()
    * modification d'une partie de contenu
    * 
    * @access public 
    * @param integer $ID : identifiant de la partie  modifier
    * @param array $contents_table : tableau contenant les infos ressources
    * @param string $type 'WORKSHOP' ou 'PUBLICATION'
    * @param object $sql_object 
    * @return boolean $result
    */
    function ModifyContents($ID, $contents_table, $type, $sql_object)
    {
        if ($this->_wichType($type) == "error") exit;
        if (!is_numeric($ID)) return false;
        if ($type == "WORKSHOP") $this->WR_ID = $ID;
        if ($type == "PUBLICATION") $this->P_ID = $ID;

        $requete = "UPDATE " . $this->ACTIVE_TABLE . " SET ";
        if ($type == "WORKSHOP") {
            $this->WR_TITLE = strip_tags($contents_table[0]);
            $this->WR_BODY = strip_tags($contents_table[1]);
            $requete .= "workrepcon_title='" . $this->WR_TITLE . "', workrepcon_body='" . $this->WR_BODY . "' WHERE workrepcon_id='" . $this->WR_ID . "';";
        } 
        if ($type == "PUBLICATION") {
            $this->P_TITLE = strip_tags($contents_table[0]);
            $this->P_BODY = strip_tags($contents_table[1]);
            $this->P_TEMPLATE = strip_tags($contents_table[2]);
            $this->P_PHOTOS_URI = strip_tags($contents_table[3]);
            $requete .= "publicon_title='" . $this->P_TITLE . "', publicon_body='" . $this->P_BODY . "', publicon_template='" . $this->P_TEMPLATE . "',  publicon_photos_uri='" . $this->P_PHOTOS_URI . "' WHERE publicon_id='" . $this->P_ID . "';";
        } 
        $result = $sql_object->DBQuery($requete);

        return $result;
    } 

    /**
    * contents::DeleteContents()
    * suppression d'une partie
    * 
    * @access public 
    * @param integer $ID : identifiant du contents a supprimer
    * @param string $type :  'WORKSHOP' ou 'PUBLICATION'
    * @param object $sql_object 
    * @return boolean $result
    */
    function DeleteContents($ID, $type, $sql_object)
    {
        if (is_numeric($ID)) {
            if ($type == "WORKSHOP") {
                $champ1 = "workrepcon_id";
                $champ2 = "jwp_contents_id";
                $champ3 = "workrepcon_validity";
            } 
            if ($type == "PUBLICATION") {
                $champ1 = "publicon_id";
                $champ2 = "jpp_contents_id";
                $champ3 = "publicon_validity";
            } 
        } else return false;
        if ($this->_wichType($type) == "error") return false;
        $requete = "UPDATE " . $this->ACTIVE_TABLE . " SET " . $champ3 . "='N'  WHERE " . $champ1 . "='" . $ID . "';";
        $result = $sql_object->DBQuery($requete);

        return $result;
    } 
} 

?>
