<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP theme class
// Class pour gerer les themes
// create : 23/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* theme
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class theme {
    /* @param
	* */
    var $TDB_THEME = T_THEME; // nom de la table.  
    // var $URI_INPUT = "theme/visual/"; // dossier racine de stockage des photos
    // var $UPLOAD_MAX_MO = 102400; // taille maximale d'upload des photos en octets
    var $DATE_FORMAT = "%d-%m-%Y";
    var $ID;
    var $NAME;
    var $VISUAL_URI;

    var $SD_THEME;
    var $DESC_DASHBOARD;
    var $DESC_PUBLICATION;
    var $DESC_NEWS;
    var $DESC_WORKSHOP;
    var $RANGE_DASHBOARD;
    var $RANGE_PUBLICATION;
    var $RANGE_NEWS;
    var $RANGE_WORKSHOP;
    var $DATE_CREA;
    var $STATUT;
    var $LAST_MODIFY;

    /**
    * theme::CheckDataIntegrity()
    * Vrification des donnes d'un thme
    * 
    * @access public 
    * @param array $table_theme : contient les composants d'un thme
    * @return boolean si vrai renvoie true sinon message d'erreurs (string)
    */
    function CheckDataIntegrity($table_theme)
    {
        if (strlen($table_theme[0]) < 2) return $GLOBALS['lang']['theme']['object_notdenomination'];
        if (!is_numeric($table_theme[2]) || $table_theme[2] == -1) return $GLOBALS['lang']['theme']['object_notSDtheme'];

        if (defined('MOD_SDI') && strlen($table_theme[3]) < 2) return $GLOBALS['lang']['theme']['object_notdesc_completed'];
        if (defined('MOD_PUBLICATION') && strlen($table_theme[4]) < 2) return $GLOBALS['lang']['theme']['object_notdesc_completed'];
        if (defined('MOD_NEWS') && strlen($table_theme[5]) < 2) return $GLOBALS['lang']['theme']['object_notdesc_completed'];
        if (defined('MOD_WORKSHOP') && strlen($table_theme[6]) < 2) return $GLOBALS['lang']['theme']['object_notdesc_completed'];

        return true;
    } 

    /**
    * theme::AddTheme()
    * Ajout d'un nouveau theme
    * 
    * @access public 
    * @param array $table_theme : contient les composants d'un theme
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddTheme($table_theme, $sql_object)
    {
        if ($table_theme[0] != '') {
            $this->NAME = strip_tags(trim($table_theme[0]));
        } 
        if ($table_theme[1] != '') {
            $this->VISUAL_URI = strip_tags(trim($table_theme[1]));
        } 
        if (is_numeric($table_theme[2])) {
            $this->SD_THEME = $table_theme[2];
        } 
        $this->DESC_DASHBOARD = strip_tags(trim($table_theme[3]), ALLOWABLE_TAGS);
        $this->DESC_PUBLICATION = strip_tags(trim($table_theme[4]), ALLOWABLE_TAGS);
        $this->DESC_NEWS = strip_tags(trim($table_theme[5]), ALLOWABLE_TAGS);
        $this->DESC_WORKSHOP = strip_tags(trim($table_theme[6]), ALLOWABLE_TAGS);

        if (is_numeric($table_theme[7])) {
            $this->RANGE_DASHBOARD = $table_theme[7];
        } 
        if (is_numeric($table_theme[8])) {
            $this->RANGE_PUBLICATION = $table_theme[8];
        } 
        if (is_numeric($table_theme[9])) {
            $this->RANGE_NEWS = $table_theme[9];
        } 
        if (is_numeric($table_theme[10])) {
            $this->RANGE_WORKSHOP = $table_theme[10];
        } 
        if ($table_theme[11] != '') {
            strtoupper($table_theme[11]);
            switch ($table_theme[11]) {
                case 'P':
                    $this->STATUT = $table_theme[11];
                    break;
                case 'D':
                    $this->STATUT = $table_theme[11];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } else $this->STATUT = 'P';

        $requete = "INSERT INTO " . $this->TDB_THEME . "(theme_name, theme_visual_uri, theme_sd_theme, theme_desc_dashboard, " . "theme_desc_publication, theme_desc_news, theme_desc_workshop, theme_range_dashboard, theme_range_publication, theme_range_news, theme_range_workshop, theme_statut, theme_date_crea) " . "VALUES('" . $this->NAME . "', '" . $this->VISUAL_URI . "', " . $this->SD_THEME . ", '" . $this->DESC_DASHBOARD . "', '" . $this->DESC_PUBLICATION . "', '" . $this->DESC_NEWS . "', '" . $this->DESC_WORKSHOP . "', " . $this->RANGE_DASHBOARD . ", " . $this->RANGE_PUBLICATION . ", " . $this->RANGE_NEWS . ", " . $this->RANGE_WORKSHOP . ", '" . $this->STATUT . "', NOW());";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

    /**
    * theme::ModifyTheme()
    * modification d'un theme
    * 
    * @access public 
    * @param int $ID : identifiant du theme
    * @param array $table_theme : contient les composants d'un theme
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyTheme($ID, $table_theme, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($table_theme[0] != '') {
            $this->NAME = strip_tags(trim($table_theme[0]));
        } 
        if ($table_theme[1] != '') {
            $this->VISUAL_URI = strip_tags(trim($table_theme[1]));
        } 
        if (is_numeric($table_theme[2])) {
            $this->SD_THEME = $table_theme[2];
        } 
        $this->DESC_DASHBOARD = strip_tags(trim($table_theme[3]), ALLOWABLE_TAGS);
        $this->DESC_PUBLICATION = strip_tags(trim($table_theme[4]), ALLOWABLE_TAGS);
        $this->DESC_NEWS = strip_tags(trim($table_theme[5]), ALLOWABLE_TAGS);
        $this->DESC_WORKSHOP = strip_tags(trim($table_theme[6]), ALLOWABLE_TAGS);
        if ($table_theme[7] != '') {
            strtoupper($table_theme[7]);
            switch ($table_theme[7]) {
                case 'P':
                    $this->STATUT = $table_theme[7];
                    break;
                case 'D':
                    $this->STATUT = $table_theme[7];
                    break;
                default:
                    $this->STATUT = 'P';
                    break;
            } 
        } else $this->STATUT = 'P';

        $requete = "UPDATE  " . $this->TDB_THEME . " set theme_name='" . $this->NAME . "', theme_visual_uri='" . $this->VISUAL_URI . "' , theme_sd_theme='" . $this->SD_THEME . "', theme_desc_dashboard='" . $this->DESC_DASHBOARD . "',theme_desc_publication= '" . $this->DESC_PUBLICATION . "', theme_desc_news='" . $this->DESC_NEWS . "' , theme_desc_workshop='" . $this->DESC_WORKSHOP . "' , theme_statut='" . $this->STATUT . "' WHERE theme_id='" . $this->ID . "';";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
    * theme::StateTheme()
    * modification du statut d'un theme
    * 	-- NE PREND PAS EN CHARGE l'EFFACEMENT --
    * 
    * @access public 
    * @param int $ID identifiant de l'entreprise
    * @param string $state (facultatif) 'P' Public/'D' Draft
    * @param object $sql_object 
    * @return bool $result
    */
    function StateTheme($ID, $state, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($state != '') {
            strtoupper($state);
            switch ($state) {
                case 'P':
                    $this->STATUT = $state;
                    break;
                case 'D':
                    $this->STATUT = $state;
                    break;
                default:
                    $this->STATUT = $state;
                    break;
            } 
        } else $this->STATUT = 'P';
        $requete = "UPDATE  " . $this->TDB_THEME . " set theme_statut='" . $this->STATUT . "' WHERE theme_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
    * theme::DeleteTheme()
    * suppression d'un theme
    * 
    * @access public 
    * @param int $ID identifiant du theme
    * @param string $type 'MASS_DELETE' toutes les ressources associes aus themes sont rendues inactives
    * 'MASS_MODIFY' remplacement de l'ancien theme par $ID_new
    * @param int $id_new nouvel id de rattachement
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteTheme($ID, $sql_object, $type, $ID_new = -1)
    {
        $affected = 0;
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($type == 'MASS_MODIFY') {
            if ($ID_new != -1 && is_numeric($ID_new)) {
                $requete = "UPDATE  " . $this->TDB_THEME . " set theme_statut='E' WHERE theme_id=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete);
                if ($result == true) {
                    $requete_news = "UPDATE  " . T_NEWS . " set news_theme=" . $ID_new . " WHERE  news_theme=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_news);
                    $affected += mysql_affected_rows();
                    $requete_publication = "UPDATE  " . T_PUBLI . " set publi_theme=" . $ID_new . " WHERE  publi_theme=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_publication);
                    $affected += mysql_affected_rows();
                    $requete_workshop = "UPDATE  " . T_WORK . " set workshop_theme=" . $ID_new . " WHERE  workshop_theme=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_workshop);
                    $affected += mysql_affected_rows();
                    $requete_sdiinfo = "UPDATE  " . T_SDI_INFO . " set sdii_theme=" . $ID_new . " WHERE  sdii_theme=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_workshop);
                    $affected += mysql_affected_rows();
                    $requete_yellowpages = "UPDATE  " . T_YELLOWPAGES . " set yellowp_theme=" . $ID_new . " WHERE  yellowp_theme=" . $this->ID . ";";
                    $result = $sql_object->DBQuery($requete_yellowpages);
                    $affected += mysql_affected_rows();
                } 
            } 
        } 
        if ($type == 'MASS_DELETE') {
            $requete = "UPDATE  " . $this->TDB_THEME . " SET theme_statut='E' WHERE theme_id=" . $this->ID . ";";
            $result = $sql_object->DBQuery($requete);
            if ($result == true) {
                $requete_news = "UPDATE  " . T_NEWS . " SET news_statut='E' WHERE  news_theme=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_news);
                $affected += mysql_affected_rows();
                $requete_publication = "UPDATE  " . T_PUBLI . " SET publi_statut='E' WHERE  publi_theme=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_publication);
                $affected += mysql_affected_rows();
                $requete_workshop = "UPDATE  " . T_WORK . " SET workshop_statut='E' WHERE  workshop_theme=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_workshop);
                $affected += mysql_affected_rows();
                $requete_sdiinfo = "UPDATE " . T_SDI_INFO . ", " . T_SDI_VALUE . " SET sdii_statut='E', sdiv_statut='E' WHERE  sdii_theme=" . $this->ID . " AND sdiv_sdi_info=sdii_id;";
                $result = $sql_object->DBQuery($requete_sdiinfo);
                $affected += mysql_affected_rows();
                $requete_yellowpages = "UPDATE  " . T_YELLOWPAGES . " SET yellowp_statut='AA' WHERE  yellowp_theme=" . $this->ID . ";";
                $result = $sql_object->DBQuery($requete_yellowpages);
                $affected += mysql_affected_rows();
            } 
        } 
        return $affected;
    } 

    /**
    * theme::SetThemeRange()
    * modification des RANGE des themes
    *   --- NON IMPLEMENTE/NON TESTE ---
    * 
    * @access public 
    * @param string $module spcifie le module concerne : valeur 'DASHBOARD', 'PUBLICATION', 'NEWS', 'WORKSHOP', 'ALL'
    * @param array $table_range tableau contenant les id des themes
    * @param object $sql_object 
    * @return bool $result
    */
    /**
    * function SetThemeRange($table_range, $sql_object, $module)
    * {
    * $result = false;
    * if (count($table_range) > 0) {
    * if (strlen($module) > 2) {
    * if ($module != 'ALL') {
    * $champ = 'theme_range_';
    * if ($module == 'DASHBOARD') $champ .= 'dashboard';
    * if ($module == 'PUBLICATION') $champ .= 'publication';
    * if ($module == 'NEWS') $champ .= 'news';
    * if ($module == 'WORKSHOP') $champ .= 'workshop';
    * for($i = 0; $i < count($table_range); $i++) {
    * $range = $i + 1;
    * $requete = "UPDATE  " . $this->TDB_THEME . " SET " . $champ . "=" . $range . " WHERE theme_id='" . $table_range[$i] . "';";
    * $result = $sql_object->DBQuery($requete);
    * echo $requete . "<br>";
    * } 
    * } elseif ($module == 'ALL') {
    * for($i = 0; $i < count($table_range); $i++) {
    * $range = $i + 1;
    * $to_update = "theme_range_dashboard=" . $range . ", theme_range_publication=" . $range . ", theme_range_news=" . $range . ", theme_range_workshop=" . $range;
    * $requete = "UPDATE  " . $this->TDB_THEME . " SET " . $to_update . " WHERE theme_id=" . $table_range[$i] . ";";
    * $result = $sql_object->DBQuery($requete);
    * echo $requete . "<br>";
    * } 
    * } 
    * } 
    * } 
    * 
    * return $result;
    * }
    */
} 

?>
