<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP workshop class
// Class pour gerer les groupes de travail
// create : 23/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* workshop
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class workshop {
    /* @param
	* */
    var $TDB_WORKSHOP = T_WORK; // nom de la table.
    var $DATE_FORMAT = "%d-%m-%Y";
    var $ID;
    var $DENOMINATION;
    var $RESUME;
    var $THEME;
    var $COMMENT;
    var $LEVEL;
    var $DATE_CREA;
    var $LAST_MODIFY;
    var $STATUT;

    /**
    * workshop::CheckDataIntegrity()
    * Vrification intgrit des donnes
    * 
    * @access public 
    * @param array $table contient les composants d'un groupe de travail
    * @return boolean true
    * si verifi, sinon string 'message d'erreur'
    */
    function CheckDataIntegrity($table, $sql_object)
    {
        if (strlen($table[0]) < 3) return $GLOBALS['lang']['workshop']['no_title'];
        if (strlen($table[1]) < 3) return $GLOBALS['lang']['workshop']['no_resume'];
        if ($table[2] == -1) return $GLOBALS['lang']['workshop']['no_theme'];
        if ($table[4] == -1) return $GLOBALS['lang']['workshop']['no_level'];

        if (substr($table[6], -1) == ';') {
            $table[6] = substr($table[6], 0, -1);
        } 
        $table_organizer = @explode(';', $table[6]);
        for ($i = 0;$i < count($table_organizer);$i++) {
            $table_organizer[$i] = str_replace(" ", "", $table_organizer[$i]);
            if (strlen(trim($table_organizer[$i])) < 2) $return = $GLOBALS['lang']['workshop']['no_author'];
            $result = $this->_CheckUserValidity($table_organizer[$i], $sql_object);
            if (!is_numeric($result)) $return = $GLOBALS['lang']['workshop']['author_not_valid'] . " : " . $table_organizer[$i];
            else $return = $result;
            $result_admin = $this->_CheckAdmin($sql_object, -1, $table_organizer[$i]);
            if ($result_admin == false) $return = $GLOBALS['lang']['workshop']['author_not_admin'] . " : " . $table_organizer[$i];
            if (!is_numeric($return)) return $return;
        } 
        return $return;
    } 

    /**
    * workshop::_CheckAdmin()
    * Vrification droits d'utilisation avanc Admin ou Animateur
    * 
    * @access private 
    * @param object $sql_object 
    * @return integer $user_id (option)
    * @param string $user_login (option)
    * @return integer id de l'utilisateur si verifi, sinon false
    */
    function _CheckAdmin($sql_object, $user_id = -1, $user_login = -1)
    {
        if ($user_id <> -1) {
            $requete = "SELECT rights_workshop, U.user_id FROM " . T_USER . " AS U LEFT OUTER JOIN " . T_RIGHT . " AS R on U.user_rights=R.rights_id  WHERE user_id='" . $user_id . "' AND user_validity='Y';";
        } 
        if ($user_login <> -1) {
            $requete = "SELECT rights_workshop, U.user_id FROM " . T_USER . " AS U LEFT OUTER JOIN " . T_RIGHT . " AS R on U.user_rights=R.rights_id  WHERE user_login= BINARY '" . $user_login . "' AND user_validity='Y';";
        } 
        $result = $sql_object->DBSelect($requete);
        if ($result[0]['rights_workshop'] == 'A' || $result[0]['rights_workshop'] == 'O') return $result[0]['user_id'];
        else return false;
    } 

    /**
    * workshop::_CheckUserValidity()
    * Vrification validit de l'utilisateur
    * 
    * @access private 
    * @param string $login 
    * @param object $sql_object 
    * @return integer si $login existe
    * sinon renvoie false
    */
    function _CheckUserValidity($login, $sql_object)
    {
        $requete = "SELECT user_id FROM " . T_USER . " WHERE user_login= BINARY '" . $login . "' AND user_validity='Y';";
        $result = $sql_object->DBSelect($requete);
        if ($result == 0) return false;
        if (count($result) > 1) exit();
        else return (int)$result[0]['user_id'];
    } 

    /**
    * workshop::CheckUserIntegrity()
    * Vrification pour ajout de l'utilisateur
    * 
    * @access public 
    * @param string $login 
    * @param integer $id 
    * @param object $sql_object 
    * @param string $statut 
    * @return string $result
    */
    function CheckUserIntegrity($login, $id, $sql_object, $statut)
    { 
        // include('../languages/' . LANGUAGE . '/lang_workshop.php');
        if (strlen(trim($login)) < 2) return $GLOBALS['lang']['workshop']['no_author'];
        $result = $this->_CheckUserValidity($login, $sql_object);
        if ($statut == 'O') {
            $result_admin = $this->_CheckAdmin($sql_object, -1, $login);
            if ($result_admin == false) return $GLOBALS['lang']['workshop']['author_not_admin'] . " : " . $login;
        } 
        if (!is_numeric($result)) return $GLOBALS['lang']['workshop']['author_not_valid'] . " : " . $login;
        $requete_yetuser = "SELECT user_id FROM " . T_USER . " WHERE user_login= BINARY '" . $login . "' AND user_validity='Y';";
        $result_yetuser = $sql_object->DBSelect($requete_yetuser);

        $requete_yetuser2 = "SELECT COUNT(jwu_id) AS NB FROM " . J_WORK_USERS . " WHERE jwu_user_id=" . $result_yetuser[0]['user_id'] . " AND jwu_workshop_id=" . $id . ";";
        $result_yetuser2 = $sql_object->DBQuery($requete_yetuser2);
        $data = mysql_fetch_object($result_yetuser2);
        if ($data->NB != 0) $return = $GLOBALS['lang']['workshop']['yet_author'];

        else $return = $result;
        return $return;
    } 

    /**
    * workshop::AddWorkshop()
    * Ajout d'un groupe de travail
    * 
    * @access public 
    * @param array $table_workshop contient les composants d'un workshop
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddWorkshop($table_workshop, $sql_object)
    {
        $this->DENOMINATION = strip_tags(trim($table_workshop[0]), ALLOWABLE_TAGS);
        $this->RESUME = strip_tags(trim($table_workshop[1]), ALLOWABLE_TAGS);
        $this->THEME = $table_workshop[2];
        $this->COMMENT = strip_tags(trim($table_workshop[3]), ALLOWABLE_TAGS);
        $this->LEVEL = $table_workshop[4];
        $this->STATUT = $table_workshop[5];

        $requete = "INSERT INTO " . $this->TDB_WORKSHOP . "(workshop_denomination, workshop_resume, workshop_theme, workshop_comment, workshop_level, workshop_statut, workshop_date_crea) VALUES('" . $this->DENOMINATION . "', '" . $this->RESUME . "', " . $this->THEME . ", '" . $this->COMMENT . "', " . $this->LEVEL . ", '" . $this->STATUT . "', CURRENT_TIMESTAMP());";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

    /**
    * workshop::ModifyWorkshop()
    * modification d'un workshop
    * 
    * @access public 
    * @param int $ID identifiant d'un workshop
    * @param array $table_workshop contient les composants d'un workshop
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyWorkshop($ID, $table_workshop, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 

        $this->DENOMINATION = strip_tags(trim($table_workshop[0]));
        $this->RESUME = strip_tags(trim($table_workshop[1]));
        $this->THEME = $table_workshop[2];
        $this->COMMENT = strip_tags(trim($table_workshop[3]));
        $this->LEVEL = $table_workshop[4];

        $requete = "UPDATE  " . $this->TDB_WORKSHOP . " set workshop_denomination='" . $this->DENOMINATION . "', workshop_resume='" . $this->RESUME . "' , workshop_theme=" . $this->THEME . ", workshop_level=" . $this->LEVEL . ", workshop_comment='" . $this->COMMENT . "' WHERE workshop_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
    * modification du statut d'un workshop
    * 
    * @access public 
    * @param int $id identifiant du workshop
    * @param string $state (facultatif) 'P' Public/'D' Draft/'AA' AdminArchive/'PA' PublicArchive/'E' Erase
    * @param object $sql_object 
    * @return bool $result
    */

    function StateWorkshop($ID, $state, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        if ($state != '') {
            strtoupper($state);
            switch ($state) {
                case 'P':
                    $this->STATUT = $state;
                    break;
                case 'D':
                    $this->STATUT = $state;
                    break;
                case 'AA':
                    $this->STATUT = $state;
                    break;
                case 'PA':
                    $this->STATUT = $state;
                    break;
                case 'E':
                    $this->STATUT = $state;
                    break;
                default:
                    $this->STATUT = 'D';
                    break;
            } 
        } else $this->STATUT = 'D';
        $requete = "UPDATE  " . $this->TDB_WORKSHOP . " set workshop_statut='" . $this->STATUT . "' WHERE workshop_id=" . $this->ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
    * suppression d'un workshop
    * 
    * @access public 
    * @param int $id identifiant du workshop a supprimer
    * @param object $sql_object 
    * @return bool $result
    */

    function DeleteWorkshop($ID, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->ID = $ID;
        } 
        $result = $this->StateWorkshop($this->ID, 'E', $sql_object);

        return $result;
    } 

    /**
    * changement des LEVEL des workshop
    * 
    * @access public 
    * @param array $table_level tableau contenant les id des themes
    * @param object $sql_object 
    * @return bool $result
    */

    function SetWorkshopLevel($table_level, $sql_object)
    {
        $result = false;
        if (count($table_level) > 0) {
            for($i = 0; $i < count($table_level); $i++) {
                $level = $i + 1;
                $requete = "UPDATE  " . $this->TDB_WORKSHOP . " SET workshop_level=" . $level . " WHERE workshop_id=" . $table_level[$i] . ";";
                $result = $sql_object->DBQuery($requete);
                echo $requete . "<br>";
            } 
        } 

        return $result;
    } 

    /**
    * workshop::AddUserWorkshop()
    * Ajout d'un utilisateur au workshop
    * 
    * @access public 
    * @param int $work_id identifiant du workshop
    * @param string $user_login login de l'utilisateur
    * @param array $user_right droit confi a l'utilisateur sur le workshop
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddUserWorkshop($work_id, $user_login, $user_right , $sql_object)
    {
        if (is_numeric($work_id)) {
            $this->ID = $work_id;
        } else return false;
        if (strlen($user_login) >= 3) {
            $requete = "SELECT user_id FROM " . T_USER . " WHERE user_login= BINARY '" . $user_login . "';";
            $result = $sql_object->DBQuery($requete);
            $data = mysql_fetch_object($result);
            $user_id = $data->user_id;
        } 
        $requete = "INSERT INTO " . J_WORK_USERS . "(jwu_workshop_id, jwu_user_id, jwu_user_right) VALUES(" . $this->ID . ", " . $user_id . ",'" . $user_right . "');";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

    /**
    * workshop::DeleteUserWorkshop()
    * suppression d'un utilisateur au workshop
    * 
    * @access public 
    * @param int $user_id identifiant du workshop
    * @param string $work_id login de l'utilisateur
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteUserWorkshop($user_id, $work_id, $sql_object)
    {
        if (is_numeric($work_id) && is_numeric($user_id)) {
            $requete = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_id=" . $user_id . ";";
            $result = $sql_object->DBQuery($requete);
            return $result;
        } else return false;
    } 

    /**
    * workshop::ModifyUserWorkshop()
    * modification d'un utilisateur au workshop
    * 
    * @access public 
    * @param int $work_id identifiant du workshop
    * @param string $user_login login de l'utilisateur
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyUserWorkshop($work_id, $user_login, $sql_object)
    {
        if (is_numeric($work_id)) {
            $user_id = $this->_CheckUserValidity($user_login, $sql_object);
            $requete = "UPDATE " . J_WORK_USERS . " SET jwu_user_id=" . $user_id . " WHERE jwu_user_right='O'  AND jwu_workshop_id=" . $work_id . " ;";
            $result = $sql_object->DBQuery($requete);
            return $result;
        } else return false;
    } 

    /**
    * workshop::ModifyOrganizerWorkshop()
    * modification des organisateurs d'un workshop
    * 
    * @access public 
    * @param int $work_id identifiant du workshop
    * @param string $table_login string des organisateurs spars par ';'
    * @param object $sql_object 
    * @return int $last_id
    */
    function ModifyOrganizerWorkshop($work_id, $table_login, $sql_object)
    {
        $table_login = str_replace(" ", "", $table_login);
        if (substr($table_login, -1) == ';') {
            $table_login = substr($table_login, 0, -1);
        } 
        $table_login = @explode(';', $table_login);
        $requete = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_right='O';";
        $result = $sql_object->DBQuery($requete);
        for ($i = 0;$i < count($table_login);$i++) {
            $user_id = $this->_CheckUserValidity($table_login[$i], $sql_object);
            $requete2 = "DELETE FROM " . J_WORK_USERS . " WHERE jwu_workshop_id=" . $work_id . " AND jwu_user_id=" . $user_id . ";";
            $result2 = $sql_object->DBQuery($requete2);
            $requete3 = "INSERT INTO " . J_WORK_USERS . "(jwu_workshop_id, jwu_user_id, jwu_user_right) VALUES(" . $work_id . ", " . $user_id . ",'O');";
            $last_id = $sql_object->DBInsert ($requete3, 1);
        } 
        return $last_id;
    } 

} 

?>