<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP mysql_object class
// Interfacage Base de donnes MySQL
// create : 01/09/03
// last_modify : 28/10/03
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////
/**
* mysql
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class mysql {
    /* PROPRIETES DE LA CLASSE */
	var $DB_DEBUG = true;
    var $DB_HOST = DB_HOST;
    var $DB_USER = DB_USER;
    var $DB_PASS = DB_PASS;
    var $DB_NAME = DB_NAME;
    var $DB_LINK = "";
    var $DB_ADMINMAIL = DB_ADMINMAIL;
    var $DB_PAGE_ERR = CURRENT_PAGE;

    /**
    * mysql::DBInitialise()
    * Initialisation de la connexion
    * 
    * @access public 
    * @param string $user : utilisateur base de donnes
    * @param string $pass : password utilisateur base de donnes
    * @param string $serveur : serveur de base de donnes
    * @param string $bdd : nom de la base de donnes
    * @return boolean 
    */

    function DBInitialise($user = '', $pass = '', $serveur = '', $bdd = '')
    {
        if ($user != '') {
            $this->DB_USER = $user;
        } 
        if ($pass != '') {
            $this->DB_PASS = $pass;
        } 
        if ($serveur != '') {
            $this->DB_HOST = $serveur;
        } 
        if ($bdd != '') {
            $this->DB_NAME = $bdd;
        } 
        return true;
    } 

    /**
    * mysql::DBConnexion()
    * connexion Base de donnes
    * 
    * @access public 
    * @param none $ 
    * @return boolean 
    */

    function DBConnexion()
    {
        $this->DB_LINK = @mysql_connect($this->DB_HOST, $this->DB_USER, $this->DB_PASS) or die($this->DBError("La connexion  MySql  choue"));
        $this->DBSelectDB();
        return true;
    } 

    /**
    * mysql::DBSelectDB()	
    * Slection de la Base de donnes
    * 
    * @access public 
    * @param none $ 
    * @return boolean 
    */

    function DBSelectDB()
    {
        mysql_select_db($this->DB_NAME, $this->DB_LINK) or die($this->DBError("Slection de la base de donnes impossible."));
        return true;
    } 

    /**
    * mysql::DBError()
    * Gestion des erreurs MySQL
    * 
    * @access private 
    * @param string $message_err : message retourn par la requte
    * @param string $requete : requte provoquant l'erreur
    * @return boolean 
    */
    function DBError($message_err, $requete = -1)
    {
        $erreur = $message_err . "<br />[<em> erreur n " . @mysql_errno() . " : " . @mysql_error() . "</em> ]<br />\n";
        if ($requete != -1) {
            $erreur .= "Requte SQL : $requete<br />\n";
        } 
        $date = date("[D d/M/y H:i:s]<br />\n");
        $erreur .= $date;
        $erreur .= "script en cours :" . $this->DB_PAGE_ERR . "<br />";
        if($this->DB_DEBUG===true) echo $erreur;
        if ($this->DB_ADMINMAIL != -1) @error_log ($erreur, 1, $this->DB_ADMINMAIL);
    } 

    /**
    * mysql::DBInsert()
    * Insertion de donnes dans la BDD
    * 
    * @access public 
    * @param string $requete : requte SQL
    * @param string $returnid : Si $returnid==1 ==> renvoie last_id()
    * @return integer || boolean : $result last_id()
    */

    function DBInsert ($requete, $returnid = -1)
    {
        if (!($result = $this->DBQuery($requete))) return false; 
        // Si returnid=1 on renvoie l'id de l'enregistrement
        // A utiliser uniquement si attribut auto_increment
        if ($returnid == 1) {
            if (!(mysql_insert_id())) {
                $requete = "SELECT LAST_INSERT_ID() as last_id";
                $result = $this->DBQuery($requete);
            } else {
                $result = mysql_insert_id();
            } 
        } else {
            $result = true;
        } 
        return $result;
    } 

    /**
    * mysql::DBQuery()
    * effectue une requte en tous genres -UPDATE - DELETE - SELECT
    * 
    * @access public 
    * @param string $requete : requte SQL
    * @return boolean : $result
    */
    function DBQuery ($requete)
    {
        $result = mysql_query($requete, $this->DB_LINK) or die($this->DbError("echec de la requte mysql", $requete));
        return $result;
    } 

    /**
    * mysql::DBSelect()
    * Requtes - SELECT
    * 
    * @access public 
    * @param string $requete : requte SQL
    * @param string $fetch : renvoie des donnes, valeur ASSOC (default), ARRAY, OBJECT
    * @return array : $result
    */

    function DBSelect ($requete, $fetch = 'ASSOC')
    {
        if (!($result = $this->DBQuery($requete))) {
            @mysql_free_result($result);
            return false;
        } 
        if ($fetch == 'ARRAY') {
            $i = 0;
            while ($data = @mysql_fetch_array($result)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'OBJECT') {
            $i = 0;
            while ($data = @mysql_fetch_object($result)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'ASSOC') {
            $i = 0;
            while ($data = @mysql_fetch_assoc($result)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        @mysql_free_result($result);
        if (!isset($table)) $table = 0;
        return $table;
    } 
} 

?>