<?php
include_once('../contents/'.SQL.'.inc.php');

function DisplayOneWorkshopPart($work_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOneWorkshopParts($work_id));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$workrepcon_title=formatText($data[0]['workrepcon_title'], '2HTML');
			$workrepcon_body=linkin_content(formatText($data[0]['workrepcon_body'], '2HTML'));
			$workrepcon_date_crea_display=formatText($data[0]['workrepcon_date_crea_display'], '2HTML');
			
			$content.='<h1>'.$workrepcon_title.'</h1>'.END_LINE;
			$content.='<p class="textcontent">'.$workrepcon_body.'</p>';
			$content.='<hr />';
			
	}	
	echo $content;
}

function DisplayOnePublicationPart($publi_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnePublicationParts($publi_id));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$title=formatText($data[0]['publicon_title'], '2HTML');
			$body=linkin_content(formatText($data[0]['publicon_body'], '2HTML'));
			$photouri=$data[0]['publicon_photos_uri'];
			$template=$data[0]['publicon_template'];
			$publicon_date_crea_display=formatText($data[0]['publicon_date_crea_display'], '2HTML');
			
			$formatted_content=TemplateFormat($title, $body, $template, $photouri);
			
			$content.='<h1>'.$title.'</h1>'.END_LINE;
			$content.=$formatted_content;
			$content.='<hr />';
			
	}	
	echo $content;
}

function TemplateFormat($title, $body, $template, $photouri) {
	
	// Pas de Template avec 2 photos
	if($template==1 || $template==2) list($photo1_src)=GetAllPhotoUri($photouri);
	if($template==1) $style=' class="tplimgleft"';
	if($template==2) $style=' class="tplimgright"';
	
	$content='<div>';
	if($template!=3) $content.=EnlargeImage('../'.$photo1_src, $style,  'visuel '.$title);
	$content.='<p class="textcontent">'.$body.'</p>'.END_LINE;
	$content.='</div>';
	$content.='<br style="clear:both" />';
	
	return $content;
}

function DisplayWorkshopNameAndGroup($work_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopRepTitleAndGroup($work_id));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$link_workshop= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'id'=>$data[0]['workshop_id']);
			$link_workshoprep= array('rub'=> $GLOBALS['links']['rapport']['linkvalue'],'id'=>$data[0]['workrep_id']);
			
			$workrep_title=formatText($data[0]['workrep_title'], '2HTML');
			$workshop_denomination=formatText($data[0]['workshop_denomination'], '2HTML');
			
			$content.='<p>'.END_LINE;
			$content.=$GLOBALS['lang']['workshoprep']['name'].' : ';
			$content.='<a href="'.HrefMaker($link_workshoprep).'" title="'.$GLOBALS['links']['rapport']['desc']. ' ('.$workrep_title.')">'.$workrep_title.'</a>';
			$content.=' | ';
			$content.='<span class="workshopname">';
			$content.='<a href="'.HrefMaker($link_workshop).'" title="'.$GLOBALS['lang']['workshoprep']['workshop_product']. ' : '.$workshop_denomination.'">'.$workshop_denomination.'</a>';
			$content.='</span>';
			$content.='</p>'.END_LINE;
			$content.='<hr />'.END_LINE;
			
	}	
	echo $content;
}

function DisplayPublicationTitle($publi_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationTitle($publi_id));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$link_publi= array('rub'=> $GLOBALS['links']['dossier']['linkvalue'],'id'=>$data[0]['publi_id']);
			$publi_title=formatText($data[0]['publi_title'], '2HTML');

			$content.='<p>'.END_LINE;
			$content.=''.$GLOBALS['lang']['publication']['name'].' : ';
			$content.='<a href="'.HrefMaker($link_publi).'" title="'.$GLOBALS['links']['dossier']['desc']. ' ('.$publi_title.')">'.$publi_title.'</a>';
			$content.='</p>'.END_LINE;
			$content.='<hr />'.END_LINE;		
			
	}	
	echo $content;
}

function DisplayWorkshopRepLinkinPart($id, $parentid, $format='TEXT') {
	/**
	* $id -> partie courante
	* $parentid -> id du dossier
	* $format 'NUM' || 'TEXT'
	*/
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopParts($parentid));
	$content = '';
	$nb_parts=count($data)-1;
	if($data!=0) 
	{	
		$content.='<div id="linkinparts">';
		//$content.=$GLOBALS['lang']['publication']['goto'].' : '.END_LINE;
		
		if($format=='TEXT') {
			$content.='<ul>'.END_LINE;
			for($i=$nb_parts; $i>=0; $i--)
			{
				$link_parts= array('rub'=> $GLOBALS['links']['rapport-partie']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid);
				$workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
				$content.='<li>'.END_LINE;
				$content.='<span class="num">'.($nb_parts - $i +1).' - </span>'.END_LINE;
				if($id!=$data[$i]['workrepcon_id']) {
					$content.='<a href="'. HrefMaker($link_parts).'" title="'.$workrepcon_title.'">';
					$content.=$workrepcon_title;
					$content.='</a>';
				} else {
					$content.=$workrepcon_title;
				}
				$content.='</li>'.END_LINE;
			} 
			$content.='</ul>'.END_LINE;
		} else {
			$content.='Partie : '.END_LINE;
			$sep='';
			for($i=$nb_parts; $i>=0; $i--) 
			{	
				$link_parts= array('rub'=> $GLOBALS['links']['rapport-partie']['linkvalue'],'id'=> $data[$i]['workrepcon_id'],'parentid'=>$parentid);
				$workrepcon_title=formatText($data[$i]['workrepcon_title'], '2HTML');
				$content.=$sep;
				if($id!=$data[$i]['workrepcon_id']) {
					$content.='<a href="'. HrefMaker($link_parts).'" title="'.$workrepcon_title.'">';
					$content.=($nb_parts-$i +1);
					$content.='</a>';
				} else {
					$content.=($nb_parts-$i +1);
				}
				$sep=' - ';
			} 
		}
		$content.='</div>'.END_LINE;
		$content.='<hr />'.END_LINE;
	}	
	echo $content;
}



function DisplayPublicationLinkinPart($id, $parentid, $format='TEXT') {
	/**
	* $id -> partie courante
	* $parentid -> id du dossier
	* $format 'NUM' || 'TEXT'
	*/
	
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($parentid));
	$content = '';
	$nb_parts=count($data)-1;
	if($data!=0) 
	{	
		$content.='<div id="linkinparts">'.END_LINE;
		//$content.=$GLOBALS['lang']['publication']['goto'].' : '.END_LINE;
		if($format=='TEXT') {
			$content.='<ul>'.END_LINE;
			for($i=$nb_parts; $i>=0; $i--)
			{
				$link_parts= array('rub'=> $GLOBALS['links']['dossier-partie']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$parentid);
				$publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
				$content.='<li>'.END_LINE;
				$content.='<span class="num">'.($nb_parts - $i +1).' - </span>'.END_LINE;
				if($id!=$data[$i]['publicon_id']) {
					$content.='<a href="'. HrefMaker($link_parts).'" title="'.$publicon_title.'">';
					$content.=$publicon_title;
					$content.='</a>';
				} else {
					$content.=$publicon_title;
				}
				$content.='</li>'.END_LINE;
			} 
			$content.='</ul>'.END_LINE;
		} else {
			$content.=''.$GLOBALS['lang']['publication']['part_number2'].' : '.END_LINE;
			$sep='';
			for($i=$nb_parts; $i>=0; $i--) 
			{	
				$link_parts= array('rub'=> $GLOBALS['links']['dossier-partie']['linkvalue'],'id'=> $data[$i]['$publicon_id'],'parentid'=>$parentid);
				$publicon_title=formatText($data[$i]['$publicon_title'], '2HTML');
				$content.=$sep;
				if($id!=$data[$i]['workrepcon_id']) {
					$content.='<a href="'. HrefMaker($link_parts).'" title="'.$publicon_title.'">';
					$content.=($nb_parts-$i +1);
					$content.='</a>';
				} else {
					$content.=($nb_parts-$i +1);
				}
				$sep=' - ';
			} 
		}
		$content.='</div>'.END_LINE;
			
	}	
	echo $content;
}

function DisplayLinkParts($current_part, $parentid, $direction, $type) {
	if($direction=='NEXT') {
		if($type=='W') $requete=SQL_getNextWorkshopRepParts($current_part, $parentid);
		if($type=='P') $requete=SQL_getNextPublicationParts($current_part, $parentid);
		$class='next';
		$prefix='&gt; &gt; ';
		$suffix='';
		$title=$GLOBALS['lang']['publication']['next_part'];
		
	}
	if($direction=='PREVIOUS') {
		if($type=='W') $requete=SQL_getPreviousWorkshopRepParts($current_part, $parentid);
		if($type=='P') $requete=SQL_getPreviousPublicationParts($current_part, $parentid);
		$class='previous';
		$prefix='';
		$suffix=' &lt; &lt;';
		$title=$GLOBALS['lang']['publication']['prev_part'];
		}
	$data=$GLOBALS['sql_object'] -> DBSelect($requete);
	
	if($data==false || count($data)!=1) $content = '';
	else 
	{		
			if($type=='W') $link_rub=$GLOBALS['links']['rapport-partie']['linkvalue'];
			if($type=='P') $link_rub=$GLOBALS['links']['dossier-partie']['linkvalue'];
			$link_part= array('rub'=> $link_rub,'id'=>$data[0]['part_id'], 'parentid' =>$parentid);
			$part_title=formatText(cutText($data[0]['part_title'], 45), '2HTML');
			$part_complete_title=formatText($data[0]['part_title'], '2HTML');

			$content ='<div class="'.$class.'">'.END_LINE;
			$content.=$prefix;
			$content.='<a href="'.HrefMaker($link_part).'" title="'.$title.' : '.$part_complete_title.'">'.$part_title.'</a>';
			$content.=$suffix;
			$content.='</div>'.END_LINE;
			
	}
	echo $content;
}
?>

