<?php

/**
* IncludeLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie publique )
* 
* @return void (include)
*/
function IncludeLang()
{
    include_once('../languages/' . LANGUAGE . '/lang_common.php');
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['annuaire']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_yellowpages.php');
    }
    if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['tableau-de-bord-idd']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_sdi.php');
		include_once('../languages/' . LANGUAGE . '/lang_dashboard.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['groupe-de-travail']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_workshop.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['dossier']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_publication.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['prefs-utilisateur']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_user.php');
    }
    if ($GLOBALS['activeitem'] == $GLOBALS['links']['actualite']['linkvalue'] || $GLOBALS['activeitem'] == $GLOBALS['links']['actualite-archives']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_news.php');
    }
	if ($GLOBALS['activeitem'] == $GLOBALS['links']['abonnement-newsletter']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_newsletter.php');
    } 
    if ($GLOBALS['activeitem'] == $GLOBALS['links']['rapport']['linkvalue'] || $GLOBALS['activeitem'] == $GLOBALS['links']['rapport-partie']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_workshoprep.php');
		include_once('../languages/' . LANGUAGE . '/lang_publication.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['recherche']['linkvalue']) {
        include_once('../languages/' . LANGUAGE . '/lang_search.php');
    }

    $GLOBALS['lang'] = $lang;
} 

/**
* IncludeAdminLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie admin )
* 
* @return void (include)
*/
function IncludeAdminLang($rubrique)
{
    include_once('../languages/' . LANGUAGE . '/lang_common.php');
    include_once('../languages/' . LANGUAGE . '/lang_' . $rubrique . '.php');

    if ($rubrique === 'dashboard') {
        include_once('../languages/' . LANGUAGE . '/lang_sdi.php');
    } 
    if ($rubrique === 'sdi') {
        include_once('../languages/' . LANGUAGE . '/lang_dashboard.php');
    } 

    $GLOBALS['lang'] = $lang;
} 

?>