<?php
/**
* ThemeSelectBox()
* Gnre une select-box pour les thmes
* 
* @param array $data 
* @param string $field_name 
* @param integer $current_theme 
* @param string $URL 
* @return string $select_theme
*/
function ThemeSelectBox($data, $field_name, $current_theme = -1, $URL = -1)
{
    $current_sdtheme = '';
    $theme_list = '';
    $close = '';
    for ($i = 0;$i < count($data);$i++) {
        if ($data[$i]['sdtheme_id'] != $current_sdtheme) {
            $current_sdtheme = $data[$i]['sdtheme_id'];
            $current_sdtheme_display = formatText(cutText($data[$i]['sdtheme_name'], 46));
            $theme_list .= $close . "<optgroup label=\"" . $current_sdtheme_display . "\">\n";
            $close = "</optgroup>\n";
        } 
        if ($data[$i]['theme_id'] == $current_theme) {
            $mask = " selected=\"selected\"";
        } else $mask = "";
        $current_theme_display = formatText(cutText($data[$i]['theme_name'], 46));
        if ($URL <> -1)$theme_list .= "<option value=\"" . $URL . $data[$i]['theme_id'] . "\"" . $mask . ">" . $current_theme_display . "</option>\n";
        else $theme_list .= "<option value=\"" . $data[$i]['theme_id'] . "\"" . $mask . ">" . $current_theme_display . "</option>\n";
    } 
    $theme_list .= "</optgroup>\n";
    if ($URL <> -1) {
        $select_theme = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" onchange=\"ChangeLocation(this)\" class=\"textfield\">\n";
        $select_theme .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice'] . "</option>\n";
    } else {
        $select_theme = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
        $select_theme .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice'] . "</option>\n";
    } 
    $select_theme .= $theme_list;
    $select_theme .= "</select>\n";

    return $select_theme;
} 

/**
* SDThemeSelectBox()
* Gnre une select-box pour les thmes Dveloppement Durable
* 
* @param array $data 
* @param string $field_name 
* @param integer $current_sdtheme 
* @return string $select_sdtheme
*/
function SDThemeSelectBox($data, $field_name, $current_sdtheme = -1)
{
    $sdtheme_list = '';
    for($i = 0; $i < count($data); $i++) {
        if ($data[$i]['sdtheme_id'] == $current_sdtheme) $mask = " selected=\"selected\"";
        else $mask = "";
        $sdtheme_display = formatText(cutText($data[$i]['sdtheme_name'], 46), '2HTML');
        $sdtheme_list .= "<option value=\"" . $data[$i]['sdtheme_id'] . "\"" . $mask . ">" . $sdtheme_display . "</option>\n";
    } 
    $select_sdtheme = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">";
    $select_sdtheme .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice2'] . "</option>";
    $select_sdtheme .= $sdtheme_list;
    $select_sdtheme .= "</select>";

    return $select_sdtheme;
} 

/**
* LevelSelectBox()
* Gnre une select-box pour les chelles
* 
* @param array $data 
* @param string $field_name 
* @param integer $current_level 
* @return string $select_level
*/
function LevelSelectBox($data, $field_name, $current_level = -1)
{
    $level_list = '';
    for ($i = 0;$i < count($data);$i++) {
        if ($data[$i]['level_id'] == $current_level) {
            $mask = " selected=\"selected\"";
        } else $mask = "";
        $level_display = formatText(cutText($data[$i]['level_name'], 46));
        $level_list .= "<option value=\"" . $data[$i]['level_id'] . "\"" . $mask . ">" . $level_display . "</option>\n";
    } 
    $select_level = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
    $select_level .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice'] . "</option>\n";
    $select_level .= $level_list;
    $select_level .= "</select>\n";

    return $select_level;
} 

/**
* ScaleSelectBox()
* Gnre une select-box pour les chelles
* 
* @param array $data 
* @param string $field_name 
* @param integer $current_scale 
* @param string $URL 
* @return string $select_scale
*/
function ScaleSelectBox($data, $field_name, $current_scale = -1, $URL = -1)
{
    $scale_list = '';
    for ($i = 0;$i < count($data);$i++) {
        if ($data[$i]['scale_id'] == $current_scale) {
            $mask = " selected=\"selected\"";
        } else $mask = "";
        $scale_display = formatText(cutText($data[$i]['scale_denomination'], 46));
        if ($URL <> -1)$scale_list .= "<option value=\"" . $URL . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
        else $scale_list .= "<option value=\"" . $data[$i]['scale_id'] . "\"" . $mask . ">" . $scale_display . "</option>\n";
    } 
    if ($URL <> -1) {
        $select_scale = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" onchange=\"ChangeLocation(this)\">\n";
        $select_scale .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice'] . "</option>\n";
    } else {
        $select_scale = "<select name=\"" . $field_name . "\" id=\"" . $field_name . "\" class=\"textfield\">\n";
        $select_scale .= "<option value=\"-1\">" . $GLOBALS['lang']['divers']['select_choice'] . "</option>\n";
    } 
    $select_scale .= $scale_list;
    $select_scale .= "</select>\n";

    return $select_scale;
} 

/**
 * select_date()
 * 
 * @param integer $date
 * @param string $name
 * @param string $filter
 * @return string $select_date
 **/
function select_date ($date, $name, $filter)
{
    $select_date = "";
    $select_date .= "<select name=\"" . $name . "\" id=\"" . $name . "\" class=\"selectdate\">\n";

    $mask = "selected=\"selected\"";

    if ($filter == "D") {
        for ($i = 1;$i <= 31;$i++) {
            $select_date .= "<option value=\"" . $i . "\"";
            if ($date == "") {
                if ($i == date("j"))$select_date .= $mask;
            } else if ($i == $date)$select_date .= $mask;
            $select_date .= ">" . $i . "</option>\n";
        } 
    } 
    if ($filter == "M") {
        for ($i = 1;$i <= 12;$i++) {
            $select_date .= "<option value=\"" . $i . "\"";
            if ($date == "") {
                if ($i == date("m"))$select_date .= $mask;
            } else if ($i == $date)$select_date .= $mask;
            $select_date .= ">" . $i . "</option>\n";
        } 
    } 
    if ($filter == "Y") {
        for ($i = 1980;$i <= 2030;$i++) {
            $select_date .= "<option value=\"" . $i . "\"";
            if ($date == "") {
                if ($i == date("Y"))$select_date .= $mask;
            } else if ($i == $date)$select_date .= $mask;
            $select_date .= ">" . $i . "</option>\n";
        } 
    } 
    $select_date .= "</select>\n";
    return $select_date;
} 

?>