<?php

/**
* LogMailing()
* 
* @param string $string 
* @return void 
*/
function LogMailing($string)
{
    $fp = @fopen(LOG_MAILING, 'a');
    @fwrite($fp, $string);
    @fwrite($fp, END_LINE);
    @fclose($fp);
} 

include_once('../config/define_release.php');
include_once('../config/define_db.php');
include_once('../class/class.newsletter.php');
include_once('../class/system/class.'.SQL.'.php');
include_once("../lib/lib_common.php");
include_once("../lib/functions_auth.php");
include_once(SQL . '.inc.php');

set_time_limit(0); // suppression du timeout

$sql_entity = SQL;
$sql_object = new $sql_entity;
$sql_object->DBInitialise();
$sql_object->DBConnexion();

// slection des newsletters  envoyer
$newsletters = $sql_object->DBSelect(SQL_GetNewsletter2Send());
if (count($newsletters) <= 1 && $newsletters[0] == false) exit;

// rcupration des emails
$emails = $sql_object->DBSelect(SQL_GetEmails4Sending());

if (count($emails) == 1 && $emails[0] == false) exit;

$newsletter_object = new newsletter;

$path = SITE_CITY_URL . '/'.$newsletter_object->URI_TEMPLATE;

// html
$template_html = file_get_contents($path . '.html');
// text
$template_txt = file_get_contents($path . '.txt');


$log_sep='##';

for($i = 0;$i < count($newsletters); $i++) {
    $newsletter_id = $newsletters[$i]['newsletter_id'];
    $email_subject = formatText($newsletters[$i]['newsletter_title']);
	
    $newsletter_body_html = formatText($newsletters[$i]['newsletter_body'], '2HTML');
	$email_html_body=str_replace('##TITLE##', $email_subject, $template_html);
	$email_html_body=str_replace('##CONTENTS##', $newsletter_body_html, $email_html_body);
	
    $newsletter_body_txt = formatText($newsletters[$i]['newsletter_body']);
	$email_text_body=str_replace('##CONTENTS##', $newsletter_body_txt, $template_txt);

    for($k = 0; $k < count($emails); $k++) {
		$email_id = $emails[$k]['emailcol_id'];
        $email_dest = $emails[$k]['emailcol_email'];
        include_once("../mail/template.php");
		$current_date = date('[d-m-y H:i:s]');
	    $tolog = $email_id. $log_sep. $email_dest . $log_sep . $newsletter_id . $log_sep . $sending_result . $log_sep . $current_date;
		LogMailing($tolog);
    }
	
	$newsletter_object->SetNewsletterPublished($newsletter_id, $sql_object);
} 

?>