<?php
/**
* DisplayOneSdi()
* Affiche un IDD + infos satellites
* 
* @param int $pointer 
* @return bool true
*/
function DisplayOneSdi($pointer)
{
    global $sdi;
    global $pdf;
	global $report_settings;

    $pdf->AddPage();
	// lien interne si actif
    if ($report_settings['summary'] === true) $pdf->SetLink($pointer+1);
    DisplayGeneralsInfo($sdi[$pointer]);
    DisplayValues($sdi[$pointer]['sdii_id']);
    if ($report_settings['display_provider'] === true) DisplayProviderInfo($sdi[$pointer]);
    if ($report_settings['display_reglementation'] === true) DisplayReglementationInfo($sdi[$pointer]);
    if ($report_settings['display_evaluation'] === true) DisplayEvaluationInfo($sdi[$pointer]);

    return true;
} 

/**
* DisplayGeneralsInfo()
* Affiche les infos gnrales d'un IDD
* 
* @param int $current_record 
* @return bool true
*/
function DisplayGeneralsInfo($current_record)
{
    global $pdf;
    global $lang;
    global $report_settings;
	
    // titre d'un indicateur
    $out_title = formatText(strtoupper($current_record['sdii_name']));
    $pdf->SetColor('SDI_TITLE_COLOR');
    $pdf->SetFont(DOC_POLICE, SDI_TITLE_STYLE, SDI_TITLE_SIZE);
    $pdf->Bookmark(strtolower($out_title));
    $pdf->Write(DOC_HEIGHT, $out_title); 
    // si non publi
    if ($current_record['sdii_statut'] == 'D') {
        $pdf->SetColor('DOC_ADVISE_COLOR');
        $pdf->SetFont(DOC_POLICE, '', SDI_TITLE_SIZE);
        $out_status = ' :: ' . strtolower($lang['statut']['draft']);
        $pdf->Write(DOC_HEIGHT, $out_status);
        $pdf->SetFont(DOC_POLICE, SDI_TITLE_STYLE, SDI_TITLE_SIZE);
        $pdf->SetColor('DOC_COLOR');
    } 
    $pdf->Ln(DOC_HEIGHT); 
    // thme d'appartenance
    $out_theme = formatText('> > ' . $lang['sdi']['theme'] . ' : ' . $current_record['theme_name'] . ' (' . $current_record['sdtheme_name'] . ')') . END_LINE;
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    $pdf->SetColor('SDI_TITLE_COLOR');
    $pdf->Write(DOC_HEIGHT, $out_theme);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);
    $pdf->SetColor('DOC_COLOR'); // r-initialise la couleur de police   
    // description
    $out_desc = formatText($current_record['sdii_description']) . END_LINE;
    $pdf->Bookmark($lang['sdi']['description'], 1, -1);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_desc);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL); 
    // objectif
    $out_goal = formatText(empty_nc($current_record['sdii_goal'])) . END_LINE;
    $out_goal_item = formatText($lang['sdi']['goal']) . END_LINE;
    $pdf->Bookmark($out_goal_item, 2, -1);
    $pdf->FormatSdiItem($out_goal_item);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_goal);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL); 
    // conseil d'amlioration
    $out_consulting = formatText($current_record['sdii_consulting']) . END_LINE;
    $out_consulting_item = formatText($lang['sdi']['consulting']) . END_LINE;
    $pdf->Bookmark($out_consulting_item, 2, -1);
    $pdf->FormatSdiItem($out_consulting_item);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_consulting);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL); 
    // informations de mesure
    $out_mesures_item = formatText($lang['sdi']['info_mesure']) . END_LINE;
    $out_mesures_behavior = ($current_record['sdii_threshold_relative'] == 'Y' ? $lang['sdi']['threshold_relative_Y']: $lang['sdi']['threshold_relative_N']);
    $out_mesures_unit = formatText($lang['sdi']['unit']) . ' : ' . $current_record['sdii_unit'] . END_LINE;
    $pdf->Bookmark($out_mesures_item, 2, -1);
    $pdf->FormatSdiItem($out_mesures_item); 
    // unit de mesure
    $pdf->SetFont(DOC_POLICE, EM_STYLE, MIN_SIZE);
    $pdf->Write(DOC_HEIGHT, $out_mesures_unit . END_LINE); 
    // comportement
    $pdf->Write(DOC_HEIGHT, $out_mesures_behavior . END_LINE);
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE); 
    // tableau de valeurs
    DrawMesuresArray($current_record);
    $pdf->SetFont(DOC_POLICE, EM_STYLE, MIN_SIZE);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);
} 

/**
* DrawMesuresArray()
* Dessine le tableau des valeurs IDD
* 
* @param  $current_record 
* @return bool true
*/
function DrawMesuresArray($current_record)
{
    global $pdf;
    global $lang;

    $cell_width = 40; 
    // initialisation 6 cellules
    $pdf->SetWidths(array_fill(0, 6, $cell_width));
    $pdf->SetAligns(array_fill(0, 6, 'C'));
    $pdf->SetFont(DOC_POLICE, ARRAY_TITLE_STYLE, ARRAY_TITLE_SIZE);
    $pdf->Row(array($lang['sdi']['max_value'], $lang['sdi']['min_value'], $lang['sdi']['threshold_value'], $lang['sdi']['frequency']));
    $pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);
    $pdf->Row(array($current_record['sdii_max_value'], $current_record['sdii_min_value'], $current_record['sdii_threshold_value'], $current_record['sdii_frequency']));
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);

    return true;
} 

/**
* DisplayProviderInfo()
* Affiche les informations Fournisseurs d'un IDD
* 
* @param  $current_record 
* @return bool true
*/
function DisplayProviderInfo($current_record)
{
    global $pdf;
    global $lang;

    $out_name = formatText($current_record['sdip_name']);
    if (!empty($current_record['sdip_service'])) $out_name .= ' - ' . formatText($current_record['sdip_service']);
    if (!empty($current_record['sdip_incharge'])) $out_name .= ' - ' . formatText($current_record['sdip_incharge']) . ' (' . $lang['sdi']['p_incharge'] . ')';
    $out_name .= END_LINE;
    $out_adress = formatText(empty_nc($current_record['sdip_address']));
    $out_phone_fax = $lang['sdi']['p_phone'] . ' : ' . formatText(empty_nc($current_record['sdip_phone']));
    $out_phone_fax .= ' - ' . $lang['sdi']['p_fax'] . ' : ' . formatText(empty_nc($current_record['sdip_fax'])) . END_LINE;
    $out_email_item = $lang['sdi']['p_email'] . ' : ';
    $out_email = formatText($current_record['sdip_email']) . END_LINE;
    $out_desc = formatText(empty_nc($current_record['sdip_description'])) . END_LINE;
    $out_provider_item = formatText($lang['sdi']['p_title']) . END_LINE;

    $pdf->ParagraphBreak();
    $pdf->Bookmark($out_provider_item, 1, -1);
    $pdf->FormatSdiInfo($out_provider_item);

    $firstcell_width = 60;

    $pdf->SetX($pdf->GetX() + $firstcell_width);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_name);

    $pdf->SetX($pdf->GetX() + $firstcell_width);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_adress);

    $pdf->SetX($pdf->GetX() + $firstcell_width);
    $pdf->Cell(0, DOC_HEIGHT, $out_phone_fax);

    $pdf->SetX($pdf->GetX() + $firstcell_width);
    $pdf->Cell($pdf->GetStringWidth($out_email_item), DOC_HEIGHT, $out_email_item);
    if (empty($out_email))$pdf->Cell(0, DOC_HEIGHT, empty_nc($out_email));
    else $pdf->Cell(0, DOC_HEIGHT, $out_email, 0, 0, '', 0, 'mailto:' . $out_email);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);

    return true;
} 

/**
* DisplayReglementationInfo()
* Affiche la rglementation d'un IDD
* 
* @param  $current_record 
* @return bool true
*/
function DisplayReglementationInfo($current_record)
{
    global $pdf;
    global $lang;

    $out_name = formatText(empty_nc($current_record['sdir_title'])) . END_LINE;
    $out_body = formatText(empty_nc($current_record['sdir_body'])) . END_LINE;
    $out_uri = formatText($current_record['sdir_mask_uri']);
    $out_uri_href = $current_record['sdir_referer_uri'];

    $out_name_item = $lang['sdi']['r_title'] . ' : ';
    $out_body_item = $lang['sdi']['r_body'] . ' : ';
    $out_uri_item = $lang['sdi']['r_referer_uri'] . ' : ';

    $out_reglementation_item = formatText($lang['sdi']['add_step4']) . END_LINE;

    $pdf->ParagraphBreak();
    $pdf->Bookmark($out_reglementation_item, 1, -1);
    $pdf->FormatSdiInfo($out_reglementation_item);

    $firstcell_width = 60; 
    // nom de l'organisme fournisseur
    $pdf->SetFont(DOC_POLICE, EM_STYLE, DOC_SIZE);
    $pdf->Cell($firstcell_width, DOC_HEIGHT, $out_name_item, 0, 0, 'R');
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_name);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL); 
    // dtail reglementation
    $pdf->SetFont(DOC_POLICE, EM_STYLE, DOC_SIZE);
    $pdf->Cell($firstcell_width, DOC_HEIGHT, $out_body_item, 0, 0, 'R');
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    $pdf->MultiCell(0, DOC_HEIGHT, $out_body);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL); 
    // lien internet reglementation
    $pdf->SetFont(DOC_POLICE, EM_STYLE, DOC_SIZE);
    $pdf->Cell($firstcell_width, DOC_HEIGHT, $out_uri_item, 0, 0, 'R');
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    if (!empty($out_uri_href)) {
        if (!empty($out_uri)) $pdf->Cell(0, DOC_HEIGHT, $out_uri, 0, 0, '', 0, $out_uri_href);
        if (!empty($out_uri)) $pdf->Cell(0, DOC_HEIGHT, ' (', 0, 0);
        $pdf->Cell(0, DOC_HEIGHT, $out_uri, 0, 0, '', 0, $out_uri_href);
        if (!empty($out_uri)) $pdf->Cell(0, DOC_HEIGHT, ')', 0, 0);
    } else $pdf->Write(DOC_HEIGHT, empty_nc($out_uri));
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);

    return true;
} 

/**
* DisplayEvaluationInfo()
* Affiche le tableau de critres d'valuation
* 
* @param int $current_record 
* @return bool true
*/
function DisplayEvaluationInfo($current_record)
{
    global $pdf;
    global $lang;

    $out_eval_item = formatText($lang['sdi']['e_title']) . END_LINE;

    $pdf->ParagraphBreak();
    $pdf->Bookmark($out_eval_item, 1, -1);
    $pdf->FormatSdiInfo($out_eval_item);

    $cell_width = (integer) 190 / 6;
    $pdf->SetWidths(array_fill(0, 6, $cell_width));
    $pdf->SetAligns(array_fill(0, 6, 'C'));
    $pdf->SetFont(DOC_POLICE, ARRAY_TITLE_STYLE, ARRAY_TITLE_SIZE);
    $pdf->Row(array($lang['sdi']['e_scale_compare'], $lang['sdi']['e_fiability'], $lang['sdi']['e_accessibility'], $lang['sdi']['e_lisibility'], $lang['sdi']['e_relevance'], $lang['sdi']['e_global_performance']));
    $pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);
    $pdf->Row(array($current_record['sdie_scale_compare'], $current_record['sdie_fiability'], $current_record['sdie_accessibility'], $current_record['sdie_lisibility'], $current_record['sdie_relevance'], $current_record['sdie_global_performance']));
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);

    return true;
} 

/**
 * DisplayValues()
 * Affiche les valeurs d'un IDD.
 * 
 * @param int $sdi_id
 * @return bool true
 **/
function DisplayValues($sdi_id)
{
    global $pdf;
    global $lang;
    global $report_settings;
    global $scale_array;
    global $sql_object;

    if ($report_settings['graphic_values'] === true && $report_settings['table_values'] === true) $mode = 'TWICE';
    elseif ($report_settings['graphic_values'] === true || $report_settings['table_values'] === true) $mode = 'ONE';
    else return false;

    $out_values_item = $lang['dashboard']['value'];
    $pdf->ParagraphBreak();
    $pdf->Bookmark($out_values_item, 1, -1);
    $pdf->FormatSdiInfo($out_values_item);

    $scale_no_values = array(); // recipient no values
    $scale_insuffisant_values = array(); // recipient insuffisant values graph
    for($i = 0; $i < count($scale_array); $i++) {
        if ($report_settings['graphic_values'] === true) {
            if (DisplayGraphicValues($sdi_id, $scale_array[$i], GetStatus($report_settings['status']), $mode) === false) array_push($scale_insuffisant_values, $scale_array[$i]);
        } 

        if ($report_settings['table_values'] === true) {
            if (DisplayTableValues($sdi_id, $scale_array[$i], GetStatus($report_settings['status']), $mode) === false) array_push($scale_no_values, $scale_array[$i]);
        } 
    } 
    DisplayNoValuesFor($scale_no_values, $lang['dashboard']['rap_no_values_for']);
    DisplayNoValuesFor($scale_insuffisant_values, $lang['dashboard']['rap_insuffisant_values'], $mode, $scale_no_values);

    return true;
} 

/**
 * GetStatus()
 * Formattage du statut pour requte SQL
 * 
 * @param string $current_status
 * @return string $status
 **/
function GetStatus($current_status)
{
    switch ($current_status) {
        case 'ALL':
            $status = 'SCA';
            break;
        case 'PUBLIC':
            $status = 'SCP';
            break;
    } 
    return $status;
} 

/**
 * DisplayNoValuesFor()
 * Affiche les chelles ne contenant pas de valeurs ou insuffisamment
 * 
 * @param array $array_scale
 * @param string $message
 * @param integer $mode
 * @param integer $array
 * @return bool true
 **/
function DisplayNoValuesFor($array_scale, $message, $mode = -1, $array = -1)
{
    global $pdf;
    global $lang;
    global $scale_denomination_array;
    $content = '';
    $sep = ''; 
    // si mode TWICE et deuxime tableau fourni. On le soustriat au premier.
    if ($array != -1 && $mode == 'TWICE') $array_scale = array_values(array_diff($array_scale, $array));

    if (count($array_scale) == 0) return true;

    for($i = 0; $i < count($array_scale); $i++) {
        $content .= $sep . $scale_denomination_array[$array_scale[$i]];
        $sep = ', ';
    } 
    if (empty($content)) return true;
    $margin = 0;
    $pdf->SetX($pdf->GetX() + $margin);
    $pdf->SetFont(DOC_POLICE, EM_STYLE, DOC_SIZE);
    $pdf->Cell(0, DOC_HEIGHT, $message, 0, 1, 'L');
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    $margin = 10;
    $pdf->SetColor('DOC_ADVISE_COLOR');
    $pdf->SetX($pdf->GetX() + $margin);
    $pdf->MultiCell(0, DOC_HEIGHT, $content);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);
    $pdf->SetColor('DOC_COLOR');

    return true;
} 

/**
 * DisplayGraphicValues()
 * Gnre et affiche les valeurs sous forme graphique
 * 
 * @param int $sdi_id
 * @param int $current_scale
 * @param string $status
 * @param string $mode
 * @return bool true
 **/
function DisplayGraphicValues($sdi_id, $current_scale, $status, $mode)
{
    global $pdf;
    global $sql_object;
    global $scale_denomination_array;

    $values = $sql_object->DBSelect(SQL_getAllValue($status, $current_scale, $sdi_id));
	// renversement des valeurs pour affichage chronologique
	$values = @array_reverse ($values, false);

    $result_sdii = $sql_object->DBSelect(SQL_getInfoSdi($sdi_id));

    if (count($values) < 3) return false; 
    // on checke si le graph tient sur la page sinon Saut de page
    $pdf->CheckPageBreak((GRAPH_HEIGHT * 0.36) + DOC_INTERVAL); 
    // Affichage du titre seulement si $values>= 3
    $out_scale_item = $scale_denomination_array[$current_scale];
    $pdf->Bookmark($out_scale_item, 2, -1);
    $pdf->FormatSdiItem($out_scale_item);
    $pdf->SetY($pdf->GetY() + DOC_INTERVAL);
	
	// stockage de l'ordonne initiale
	$_y = $pdf->GetY();
	
    // positionnement en fonction du mode.
    
    if ($mode == 'TWICE') $_x = 94;
    else $_x = 50;

    include_once ("../class/system/jpgraph/jpgraph.php");
    include_once ("../class/system/jpgraph/jpgraph_bar.php");
    include_once ("../class/system/jpgraph/jpgraph_line.php");
    $unit = $result_sdii[0]['sdii_unit']; 
    
    for ($i = 0; $i < count($values); $i++) {
        $ydata[$i] = $values[$i]['sdiv_value'];
        $ydata2[$i] = $result_sdii[0]['sdii_threshold_value'];
        $dates[$i] = $values[$i]['date_p'];
    }
	
    // Create the graph.
    $graph = new Graph(GRAPH_WIDTH, GRAPH_HEIGHT);
    $graph->SetScale("textlin");
    $graph->SetMarginColor('white'); 

    // $graph->SetMargin(45, 1.5, 30, 70);
    $graph->SetMargin(40, 1, 20, 70); 
    // Box around plotarea
    $graph->SetBox(); 
    // No frame around the image
    $graph->SetFrame(false); 
    // Setup the tab title
    //$graph->title->SetFont(FF_FONT1, FS_BOLD);
    $graph->yaxis->title->Set($unit); 
    // Setup the X and Y grid
    $graph->ygrid->SetFill(true, '#DDDDDD@0.8', '#BBBBBB@0.8');
    $graph->ygrid->SetLineStyle('dashed');
    $graph->ygrid->SetColor('gray@0.5');
    $graph->xgrid->Show();
    $graph->xgrid->SetLineStyle('dashed');
    $graph->xgrid->SetColor('gray@0.5');
	
    // $graph->xaxis->SetFont(FF_FONT1, FS_BOLD, 6);
    // Setup month as labels on the X-axis
    //$graph->xaxis->SetFont(FF_FONT1, FS_BOLD, 8);
	$graph->xaxis->SetTickLabels($dates);
    $graph->xaxis->SetColor('#848484', '#848484');
    $graph->yaxis->SetColor('#848484', '#848484');
    $graph->title->SetFont(FF_FONT1, FS_BOLD, 8);
    $graph->xaxis->SetLabelAngle(90); 
    // Create a bar pot
    $bplot = new BarPlot($ydata);
    $bplot->SetWidth(0.6);
    $fcol = '#99B5D5';
    $tcol = '#839FBE';

    $bplot->SetFillGradient($fcol, $tcol, GRAD_LEFT_REFLECTION); 
    // Set line weigth to 0 so that there are no border
    // around each bar
    $bplot->SetWeight(0); 
    // Create filled line plot
    $lplot = new LinePlot($ydata2);
    $lplot->SetFillColor('orange@0.8');
    $lplot->SetColor('red@0.8');
    $lplot->SetBarCenter();

    $lplot->mark->SetType(MARK_SQUARE);
    $lplot->mark->SetColor('red@0.8');
    $lplot->mark->SetFillColor('orange');

    $lplot->mark->SetSize(1);

    $graph->Add($bplot);
    $graph->Add($lplot); 
    // /////////////////////////////
    // Affichage
    $pdf->GDImage($graph->Stroke(_IMG_HANDLER), $_x, $_y, 0, 0);
    imagedestroy($graph->Stroke(_IMG_HANDLER)); 
    // conversion px -> mm + replacement en ordonnes
    if ($mode == 'TWICE') $pdf->SetY($_y);
    else $pdf->SetY($_y + (GRAPH_HEIGHT * 0.36)); //$pdf->SetY($_y + (GRAPH_HEIGHT * 0.36) + DOC_INTERVAL);
    return true;
} 

/**
 * DisplayTableValues()
 * Affiche un tableau de valeurs a une chelle donne
 * 
 * @param int $sdi_id
 * @param int $current_scale
 * @param string $status
 * @param string $mode
 * @return bool true
 **/
function DisplayTableValues($sdi_id, $current_scale, $status, $mode)
{
    global $pdf;
    global $lang;
    global $sql_object;
    global $scale_denomination_array;

    $_y = $pdf->GetY();
    $sdi_values = $sql_object->DBSelect(SQL_getAllValue($status, $current_scale, $sdi_id));

    if (count($sdi_values) <= 1 && $sdi_values[0] == false) return false;

    if ($mode != 'TWICE' || (count($sdi_values) >= 1 && count($sdi_values) < 3)) {
        // Affichage du titre seulement si affichage des valeurs en standalone
        $out_scale_item = $scale_denomination_array[$current_scale];
        $pdf->Bookmark($out_scale_item, 2, -1);
        $pdf->FormatSdiItem($out_scale_item);
        $pdf->SetY($pdf->GetY() + DOC_INTERVAL);
    } 

    $pdf->Ln(DOC_INTERVAL);
    if ($mode == 'TWICE') $_margin = 20;
    else $_margin = 60;

    $pdf->SetX($_margin);

    $cell_width = 30;
    $pdf->SetWidths(array_fill(0, 2, $cell_width));
    $pdf->SetAligns(array_fill(0, 2, 'C'));
    $pdf->SetFont(DOC_POLICE, ARRAY_TITLE_STYLE, ARRAY_TITLE_SIZE);
    $pdf->Row(array($lang['dashboard']['name_pluriel'], $lang['statut']['published_on']));
    $pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);
    for($i = 0; $i < count($sdi_values); $i++) {
        $pdf->SetX($_margin);
        $current_value = formatText($sdi_values[$i]['sdiv_value']);
        if ($sdi_values[$i]['sdiv_statut'] == 'D') $current_value .= ' *';
        $current_date = formatText($sdi_values[$i]['date_p']);
        $pdf->Row(array($current_value, $current_date));
    } 
    $pdf->SetX($_margin);
    $pdf->SetFont(DOC_POLICE, EM_STYLE, MIN_SIZE);
    $pdf->Cell(0, DOC_HEIGHT, '* ' . strtolower($lang['statut']['draft']), 0, 1);
    $pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
    $pdf->Ln(DOC_INTERVAL * 2); 
    // conversion px -> mm + replacement en ordonnes
    if ($mode == 'TWICE' && count($sdi_values) >= 3 && $pdf->GetY() < ($_y + (GRAPH_HEIGHT * 0.36))) $pdf->SetY($_y + (GRAPH_HEIGHT * 0.36) + DOC_INTERVAL);

    return true;
} 

?>