<?php
include_once('../search/' . SQL . '.inc.php');

/**
 * LogKeywordsSearch()
 * 
 * @param string $keywords 
 * @param string $type 
 * @param string $rub =-1 (option)
 * @return void 
 */
function LogKeywordsSearch($keywords, $type, $searchtype, $rub = -1)
{
    $sep = '##';
    $fp = @fopen(LOG_KEYWORDS, 'a');
    @fwrite($fp, $keywords . $sep); // mots clefs
    @fwrite($fp, $type . $sep); // type ADMIN ou PUBLIC
    @fwrite($fp, $searchtype . $sep); // type de recherche
    if ($rub != -1) @fwrite($fp, $rub . $sep); // rubrique matches
    @fwrite($fp, i2c_realip() . $sep); // adresse
    @fwrite($fp, date('[d-m-y H:i:s]' . $sep)); // date
    @fwrite($fp, date("\n"));
    @fclose($fp);
} 

/**
 * MatchDataFormat()
 * 
 * @param string $keywords 
 * @param string $searchtype 
 * @return string $formatted_keywords
 */
function MatchDataFormat($keywords, $searchtype)
{
    $keywords = trim(addslashes($keywords));
    switch ($searchtype) {
        case 'one':
            $formatted_keywords = $keywords;
            break;
        case 'all':
            $words = explode(' ', $keywords);
            $formatted_keywords = '';
            foreach($words as $value) $formatted_keywords .= ' +' . $value;
            trim($formatted_keywords);
            break;
        case 'exp':
            $formatted_keywords = '"' . $keywords . '"';
            break;
        default:
            $formatted_keywords = $keywords;
            break;
    } 
    return $formatted_keywords;
} 

function GetStatus($short_status)
{
    $write = ' - ';
    switch ($short_status) {
        case 'PA':
            $write .= $GLOBALS['lang']['statut']['PA'];
            break;
        case 'AA':
            $write .= $GLOBALS['lang']['statut']['AA'];
            break;
        case 'P':
            $write = '';
            break;
        case 'Y':
            $write = '';
            break;
        case 'D':
            $write .= $GLOBALS['lang']['statut']['draft'];
            break;
        default:
            $write = '';
    } 
    return $write;
} 

/**
 * DisplayPublicResults()
 * 
 * @param string $keywords
 * @param string $searchtype
 * @return void (echo)
 **/
function DisplayPublicResults($keywords, $searchtype)
{
    $type = 'PUBLIC';
    DisplaySearchNews($keywords, $type, $searchtype);
    //echo '<hr />';
    DisplaySearchPublication($keywords, $type, $searchtype); 
    // echo '<hr />';
    DisplaySearchPubliContents($keywords, $type, $searchtype);
    //echo '<hr />';
    DisplaySearchWorkshop($keywords, $type, $searchtype); 
    // echo '<hr />';
    DisplaySearchWorkshopRep($keywords, $type, $searchtype); 
    // echo '<hr />';
    DisplaySearchWorkshopRepContents($keywords, $type, $searchtype); 
    // echo '<hr />';
    DisplaySearchWorkshopCalendar($keywords, $type, $searchtype); 
    // echo '<hr />';
    DisplaySearchWorkshopCom($keywords, $type, $searchtype);
    //echo '<hr />';
    DisplaySearchSdi($keywords, $type, $searchtype);
    //echo '<hr />';
} 

/**
 * DisplaySearchNews()
 * Affiche les news rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchNews($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_news_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchNews">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['news_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_news = HrefMaker(array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'id' => $data[$i]['news_id']));
                $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
            } 
            if ($type == 'ADMIN') {
                $link_news = 'index.php?rub=news&amp;todo=det&amp;id=' . $data[$i]['news_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            } 

            $news_title = formatText($data[$i]['news_title'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_news . '" title="' . $GLOBALS['links']['actualite']['desc'] . ' : ' . $news_title . '" >' . $news_title . '</a>';
            $content .= '<br />';
            $content .= '<span class="infocomp">' . $published_display . GetStatus($data[$i]['statut']) . '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchNews()
 * Affiche les news rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchNewsletter($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_newsletter_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchNewsletter">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['newsletter_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ol>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            /**
             * * NON IMPLEMENTE 
             * if ($type == 'PUBLIC') {
             * $link_news = HrefMaker(array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'id' => $data[$i]['news_id']));
             * $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
             * }
             */

            if ($type == 'ADMIN') {
                $link_newsletter = 'index.php?rub=newsletter&amp;todo=det&amp;id=' . $data[$i]['newsletter_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            }
            $newsletter_title = formatText($data[$i]['newsletter_title'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_newsletter . '" title="' . $newsletter_title . '" >' . $newsletter_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">' . $published_display . GetStatus($data[$i]['statut']) . '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ol>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchPublication()
 * Affiche les publications rpondant  la requte sur $keywords
 * Requte ffectue sur le titre et le rsum des publications
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchPublication($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_publication_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchPubli">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['publication_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_publi = HrefMaker(array('rub' => $GLOBALS['links']['dossier']['linkvalue'], 'id' => $data[$i]['publi_id']));
                $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
            } 
            if ($type == 'ADMIN') {
                $link_publi = 'index.php?rub=publication&amp;todo=det&amp;id=' . $data[$i]['publi_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            } 

            $publi_title = formatText($data[$i]['publi_title'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_publi . '" title="' . $GLOBALS['links']['dossier']['desc'] . ' : ' . $publi_title . '" >' . $publi_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">' . $published_display . GetStatus($data[$i]['statut']) . '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchPubliContents()
 * Affiche les publications rpondant  la requte sur $keywords
 * Requte ffectue sur le contenu des publications ( titre & body )
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchPubliContents($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_publication_content_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchPubliContents">';
    $content .= '<h4>' . $GLOBALS['lang']['search']['det_publication_module'] . '</h4>' . END_LINE;
    //if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
	if (count($data) == 1 && $data == 0) return true;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_publi_det = HrefMaker(array('rub' => $GLOBALS['links']['dossier-partie']['linkvalue'], 'id' => $data[$i]['publicon_id'], 'parentid' => $data[$i]['publi_id']));
                $link_publi = HrefMaker(array('rub' => $GLOBALS['links']['dossier']['linkvalue'], 'id' => $data[$i]['publi_id']));
                $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
            } 
            if ($type == 'ADMIN') {
                $link_publi_det = 'index.php?rub=contents&amp;todo=det&amp;parent=' . $data[$i]['publi_id'] . '&amp;type=P&amp;id=' . $data[$i]['publicon_id'];
                $link_publi = 'index.php?rub=publication&amp;todo=det&amp;id=' . $data[$i]['publi_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            } 

            $publicon_title = formatText($data[$i]['publicon_title'], '2HTML');
            $publi_title = formatText($data[$i]['publi_title'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_publi_det . '" title="' . $GLOBALS['links']['dossier-partie']['desc'] . ' : ' . $publicon_title . '" >' . $publicon_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">' . $GLOBALS['lang']['name']['publication_module'] . ' : ';
            $content .= '<a href="' . $link_publi . '" title="' . $GLOBALS['links']['dossier']['desc'] . ' : ' . $publi_title . '" >' . $publi_title . '</a>';
            $content .= ' - ' . $published_display . GetStatus($data[$i]['statut']);
            $content .= '</span>';
			$content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchWorkshop()
 * Affiche les groupes de travail rpondant  la requte sur $keywords
 * Requte ffectue sur le libell et le rsum des groupes de travail
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchWorkshop($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_workshop_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchWorkshop">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['workshop_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_workshop = HrefMaker(array('rub' => $GLOBALS['links']['groupe-de-travail']['linkvalue'], 'id' => $data[$i]['workshop_id']));
            } 
            if ($type == 'ADMIN') {
                $link_workshop = 'index.php?rub=workshop&amp;todo=det&amp;id=' . $data[$i]['workshop_id'];
            } 

            $workshop_title = formatText($data[$i]['workshop_denomination'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_workshop . '" title="' . $GLOBALS['links']['groupe-de-travail']['desc'] . ' : ' . $workshop_title . '" >' . $workshop_title . '</a>';
            $statut = GetStatus($data[$i]['statut']);
            if (!empty($statut)) $content .= '<span class="infocomp">(' . $statut . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchWorkshopRepContents()
 * Affiche les groupes de travail rpondant  la requte sur $keywords
 * Requte ffectue sur le contenu des rapports de groupes de travail ( titre & body )
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchWorkshopRep($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_workrep_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchWorkshopRep">';
    $content .= '<h4>' . $GLOBALS['lang']['search']['workshoprep_module'] . '</h4>' . END_LINE;
    //if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
	if (count($data) == 1 && $data == 0) return true;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_workrep = HrefMaker(array('rub' => $GLOBALS['links']['rapport']['linkvalue'], 'id' => $data[$i]['workrep_id']));
                $link_workshop = HrefMaker(array('rub' => $GLOBALS['links']['groupe-de-travail']['linkvalue'], 'id' => $data[$i]['workshop_id']));
                $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
            } 
            if ($type == 'ADMIN') {
                $link_workrep = 'index.php?rub=workshoprep&amp;todo=det&amp;id=' . $data[$i]['workshop_id'];
                $link_workshop = 'index.php?rub=workshop&amp;todo=det&amp;id=' . $data[$i]['workshop_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            } 

            $workrep_title = formatText($data[$i]['workrep_title'], '2HTML');
            $workshop_title = formatText($data[$i]['workshop_denomination'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_workrep . '" title="' . $GLOBALS['links']['rapport']['desc'] . ' : ' . $workrep_title . '" >' . $workrep_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['name']['workshop_module'] . ' : ';
            $content .= '<a href="' . $link_workshop . '" title="' . $GLOBALS['links']['groupe-de-travail']['desc'] . ' : ' . $workshop_title . '" >' . $workshop_title . '</a>';
            $content .= ' - ' . $published_display . GetStatus($data[$i]['statut']) . ')';
            $content .= '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchWorkshopRepContents()
 * Affiche les groupes de travail rpondant  la requte sur $keywords
 * Requte ffectue sur le contenu des rapports de groupes de travail ( titre & body )
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchWorkshopRepContents($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_workrep_content_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchWorkshopContents">';
    $content .= '<h5>' . $GLOBALS['lang']['search']['workshoprepcon_module'] . '</h5>' . END_LINE;
    //if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
	if (count($data) == 1 && $data == 0) return true;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_workrep_det = HrefMaker(array('rub' => $GLOBALS['links']['rapport-partie']['linkvalue'], 'id' => $data[$i]['workrepcon_id'], 'parentid' => $data[$i]['workrep_id']));
                $link_workrep = HrefMaker(array('rub' => $GLOBALS['links']['rapport']['linkvalue'], 'id' => $data[$i]['workrep_id']));
                $published_display = $GLOBALS['lang']['statut']['published_on'] . ' ' . $data[$i]['date_display'];
            } 
            if ($type == 'ADMIN') {
                $link_workrep_det = 'index.php?rub=contents&amp;todo=det&amp;parent=' . $data[$i]['workrep_id'] . '&amp;type=W&amp;id=' . $data[$i]['workrepcon_id'];
                $link_workrep = 'index.php?rub=workshoprep&amp;todo=det&amp;id=' . $data[$i]['workrep_id'];
                $published_display = $GLOBALS['lang']['divers']['date_crea'] . ' ' . $data[$i]['date_display'];
            } 

            $workrepcon_title = formatText($data[$i]['workrepcon_title'], '2HTML');
            $workrep_title = formatText($data[$i]['workrep_title'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_workrep_det . '" title="' . $GLOBALS['links']['dossier-partie']['desc'] . ' : ' . $workrepcon_title . '" >' . $workrepcon_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['name']['workshoprep_module'] . ' : ';
            $content .= '<a href="' . $link_workrep . '" title="' . $GLOBALS['links']['rapport']['desc'] . ' : ' . $workrep_title . '" >' . $workrep_title . '</a>';
            $content .= ' - ' . $published_display . GetStatus($data[$i]['statut']) . ')';
            $content .= '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchWorkshopCalendar()
 * Affiche les groupes de travail rpondant  la requte sur $keywords
 * Requte ffectue sur les tches du calendrier de groupes de travail ( libell & contenu des tches )
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchWorkshopCalendar($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_workshop_calendar_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchWorkshopCal">';
    $content .= '<h4>' . $GLOBALS['lang']['search']['workshopcal_module'] . '</h4>' . END_LINE;
    //if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
	if (count($data) == 1 && $data == 0) return true;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') {
                $link_workcal = HrefMaker(array('rub' => $GLOBALS['links']['calendrier']['linkvalue'], 'id' => $data[$i]['workcal_workshop_id']));
                $link_workshop = HrefMaker(array('rub' => $GLOBALS['links']['groupe-de-travail']['linkvalue'], 'id' => $data[$i]['workcal_workshop_id']));
            } 
            if ($type == 'ADMIN') {
                $link_workcal = 'index.php?rub=workshop&amp;todo=list_cal&amp;id=' . $data[$i]['workcal_workshop_id'];
                $link_workshop = 'index.php?rub=workshop&amp;todo=det&amp;id=' . $data[$i]['workcal_workshop_id'];
            } 

            $workcal_title = formatText($data[$i]['workcal_task'], '2HTML');
            $workshop_title = formatText($data[$i]['workshop_denomination'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_workcal . '" title="' . $GLOBALS['links']['calendrier']['desc'] . ' : ' . $workcal_title . '" >' . $workcal_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['name']['workshop_module'] . ' : ';
            $content .= '<a href="' . $link_workshop . '" title="' . $GLOBALS['links']['groupe-de-travail']['desc'] . ' : ' . $workshop_title . '" >' . $workshop_title . '</a>';
            if (!empty($statut)) $content .= $statut;
            $content .= ')';
            $content .= '</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchWorkshopCom()
 * Affiche les groupes de travail rpondant  la requte sur $keywords
 * Requte ffectue sur les discussions du calendrier de groupes de travail ( titre & contenu )
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchWorkshopCom($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_workshop_com_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchWorkshopCom">';
    $content .= '<h4>' . $GLOBALS['lang']['search']['workshopcom_module'] . '</h4>' . END_LINE;
    //if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
	if (count($data) == 1 && $data == 0) return true;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($data[$i]['workcom_parent'] != 0) $id_com = $data[$i]['workcom_parent'];
            else $id_com = $data[$i]['workcom_id'] ;
            if ($type == 'PUBLIC') {
                $link_workcom = HrefMaker(array('rub' => $GLOBALS['links']['sujet']['linkvalue'], 'id' => $id_com, 'parentid' => $data[$i]['workcom_workshop_id']));
                $link_workshop = HrefMaker(array('rub' => $GLOBALS['links']['groupe-de-travail']['linkvalue'], 'id' => $data[$i]['workcom_workshop_id']));
            } 
            if ($type == 'ADMIN') {
                $link_workcom = 'index.php?rub=workshop&amp;todo=det_com&amp;id=' . $data[$i]['workcom_workshop_id'] . '&amp;com_id=' . $id_com;
                $link_workshop = 'index.php?rub=workshop&amp;todo=det&amp;id=' . $data[$i]['workcom_workshop_id'];
            } 

            $workcom_title = formatText($data[$i]['workcom_subject'], '2HTML');
            $workshop_title = formatText($data[$i]['workshop_denomination'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);

            if ($type == 'ADMIN' || ($type == 'PUBLIC' && CookieWorkshopid($data[$i]['workcom_workshop_id']))) {
                $content .= '<li class="matches">' . END_LINE;
                $content .= '<a href="' . $link_workcom . '" title="' . $GLOBALS['links']['sujet']['desc'] . ' : ' . $workcom_title . '" >' . $workcom_title . '</a>';
				$content .= '<br />';
                $content .= '<span class="infocomp">(' . $GLOBALS['lang']['name']['workshop_module'] . ' : ';
                $content .= '<a href="' . $link_workshop . '" title="' . $GLOBALS['links']['groupe-de-travail']['desc'] . ' : ' . $workshop_title . '" >' . $workshop_title . '</a>';
                if (!empty($statut)) $content .= $statut;
                $content .= ')';
                $content .= '</span>';
                $content .= $pertinence;
                $content .= '</li>' . END_LINE;
            } else $content .= '';
        } 
        $content .= '</ul>' . END_LINE;

        if ($content == '<ul></ul>') return '';
    } 
    $content .= '</div>' . END_LINE;

    echo $content;
} 

/**
 * DisplaySearchSdi()
 * Affiche les indicateurs rpondant  la requte sur $keywords
 * Requte ffectue sur les informations gnrales des indicateurs
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchSdi($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_sdi_search(MatchDataFormat($keywords, $searchtype), $type));

    $content = '<div id="MatchSdi">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['sdi_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') $link_sdi = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'], 'id' => $data[$i]['sdii_id'], 'parentid' => 1));
            if ($type == 'ADMIN') $link_sdi = 'index.php?rub=sdi&amp;todo=det&amp;id=' . $data[$i]['sdii_id'];

            $news_title = formatText($data[$i]['sdii_name'], '2HTML');
            $pertinence = FormatPertinenceIndice($data[$i]['pertinence']);
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_sdi . '" title="' . $GLOBALS['links']['tableau-de-bord-idd']['desc'] . ' : ' . $news_title . '" >' . $news_title . '</a>';
			$content .= '<br />';
            $content .= '<span class="infocomp">( ' . $GLOBALS['lang']['statut']['published_on'] . ' ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= $pertinence;
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchYellowpages()
 * Affiche les organisations de l'annuaire rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchYellowpages($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_yellowpages_search($keywords, $type, $searchtype));

    $content = '<div id="MatchYellowpages">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['yellowpages_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') $link_yp = HrefMaker(array('rub' => $GLOBALS['links']['annuaire-detail']['linkvalue'], 'id' => $data[$i]['yellowp_id']));
            if ($type == 'ADMIN') $link_yp = 'index.php?rub=yellowpages&amp;todo=det&amp;id=' . $data[$i]['yellowp_id'];

            $yp_title = formatText($data[$i]['yellowp_name'], '2HTML');
            $pertinence = $GLOBALS['lang']['divers']['none'];
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_yp . '" title="' . $GLOBALS['links']['annuaire-detail']['desc'] . ' : ' . $yp_title . '" >' . $yp_title . '</a>';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['divers']['date_crea'] . ' : ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchUser()
 * Affiche les utilisateurs rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchUser($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_user_search($keywords, $type, $searchtype));

    $content = '<div id="MatchUser">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['user_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'PUBLIC') $link_user = HrefMaker(array('rub' => $GLOBALS['links']['profil-utilisateur']['linkvalue'], 'id' => $data[$i]['user_id']));
            if ($type == 'ADMIN') $link_user = 'index.php?rub=user&amp;todo=det&amp;id=' . $data[$i]['user_id'];

            $user_title = formatText($data[$i]['user_login']);
            $pertinence = $GLOBALS['lang']['divers']['none'];
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_user . '" title="' . $GLOBALS['links']['profil-utilisateur']['desc'] . ' : ' . $user_title . '" >' . $user_title . '</a>';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['divers']['date_crea'] . ' : ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchTheme()
 * Affiche les theme rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchTheme($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_theme_search($keywords, $type, $searchtype));

    $content = '<div id="MatchTheme">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['theme_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'ADMIN') $link_theme = 'index.php?rub=theme&amp;todo=det&amp;id=' . $data[$i]['theme_id'];

            $theme_title = formatText($data[$i]['theme_name']);
            $pertinence = $GLOBALS['lang']['divers']['none'];
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_theme . '">' . $theme_title . '</a>';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['divers']['date_crea'] . ' : ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchScale()
 * Affiche les chelles rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchScale($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_scale_search($keywords, $type, $searchtype));

    $content = '<div id="MatchScale">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['scale_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'ADMIN') $link_scale = 'index.php?rub=scale&amp;todo=det&amp;id=' . $data[$i]['scale_id'];

            $scale_title = formatText($data[$i]['scale_denomination']);
            $pertinence = $GLOBALS['lang']['divers']['none'];
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_scale . '" title="' . $scale_title . '">' . $scale_title . '</a>';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['divers']['date_crea'] . ' : ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplaySearchLevel()
 * Affiche les niveaux rpondant  la requte sur $keywords
 * 
 * @param string $keywords 
 * @return string $content
 */
function DisplaySearchLevel($keywords, $type, $searchtype)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_level_search($keywords, $type, $searchtype));

    $content = '<div id="MatchScale">';
    $content .= '<h3>' . $GLOBALS['lang']['search']['level_module'] . '</h3>' . END_LINE;
    if (count($data) == 1 && $data == 0) $content .= '<p>' . $GLOBALS['lang']['search']['no_result'] . '</p>' . END_LINE;
    else {
        $content .= '<ul>' . END_LINE;
        for($i = 0; $i < count($data); $i++) {
            if ($type == 'ADMIN') $link_level = 'index.php?rub=level&amp;todo=det&amp;id=' . $data[$i]['level_id'];

            $level_title = formatText($data[$i]['level_name']);
            $pertinence = $GLOBALS['lang']['divers']['none'];
            $published_display = $data[$i]['date_display'];

            $content .= '<li class="matches">' . END_LINE;
            $content .= '<a href="' . $link_level . '" title="' . $level_title . '">' . $level_title . '</a>';
            $content .= '<span class="infocomp">(' . $GLOBALS['lang']['divers']['date_crea'] . ' : ' . $published_display . GetStatus($data[$i]['statut']) . ')</span>';
            $content .= '</li>' . END_LINE;
        } 
        $content .= '</ul>' . END_LINE;
    } 
    $content .= '</div>' . END_LINE;
    echo $content;
} 

/**
 * DisplayQueryTime()
 * Affiche le temps d'execution des requtes
 * 
 * @param float $start_time 
 * @param float $end_time 
 * @return string $content (echo)
 */
function DisplayQueryTime($start_time, $end_time)
{
    $content = '<div id="QueryTime">' . END_LINE;
    $content .= $GLOBALS['lang']['search']['query_time'] . ' ' . (substr($end_time - $start_time, 0, 5)) . ' ' . $GLOBALS['lang']['search']['query_seconds'];
    $content .= '</div>' . END_LINE;
    echo $content;
} 

function DisplayAdvancedSearchForm()
{
    $action = $GLOBALS['links']['resultats-recherche']['linkvalue'];
    $content = '<form action="' . HrefMaker(array('rub' => $action)) . '" method="post">';
    $content .= '<div id="searchcontent">';
    $content .= '<label for="advsearch">' . $GLOBALS['lang']['search']['keywords'] . '</label>';
    $content .= '<input type="text" maxlength="150"  class="textfield" name="search" id="advsearch" style="margin-right:30px" />';
    $content .= '<br class="brendstep" />';
    $content .= '<div style="margin:1em 2.3em 0 0">';
    $content .= '<input type="radio" name="searchtype" id="searchtype_1" value="one" checked="checked "/><span class="radio">' . $GLOBALS['lang']['search']['one_of_them'] . '</span>';
    $content .= '<input type="radio" name="searchtype" id="searchtype_2" value="all" /><span class="radio">' . $GLOBALS['lang']['search']['all_of_them'] . '</span>';
    $content .= '<input type="radio" name="searchtype" id="searchtype_3" value="exp" /><span class="radio">' . $GLOBALS['lang']['search']['expression'] . '</span>';
    $content .= '</div>';
    $content .= '<br class="brendstep" />';
    //$content .= '<input type="submit" value="' . $GLOBALS['lang']['search']['text_button'] . '" size="15" name="valid" class="button" id="validsearch" />';
	$content.='<input type="image" src="../gfx/linea21/images/public/btn_go.gif" value="ok" size="15" name="valid" id="validadvsearch" style="margin-left:35em" />'.END_LINE;	
    $content .= '</div>';
    $content .= '</form>';

    echo $content;
} 

function FormatPertinenceIndice($float) {
	$pertinence_i = ($float != 0) ? number_format(round($float, 3), 3, ',', ' ') : $GLOBALS['lang']['search']['score_not_good'];
	$pertinence= '<span class="pertinence">- <abbr title="'.$GLOBALS['lang']['search']['score'].'">' . $GLOBALS['lang']['search']['score_abbr'] . '</abbr> : ' . $pertinence_i . '</span>';
	
	return $pertinence;
}
?>


