<?php 
//  @param  $rub : connu de admin/index.php
/**
* displayitem()
* affichage des items du menu. Prise en charge de leur ETAT : actif ou non
* 
* @param string $rubactive 
* @param string $currentrub 
* @param string $accesskey 
* @return string $content
*/

function displayitem($rubactive, $currentrub, $accesskey)
{
    if ($rubactive == $currentrub) {
        $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" class=\"aactif\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu']['item'] . ' : ' . $GLOBALS['lang']['menu'][$currentrub] . "\">" . $GLOBALS['lang']['menu'][$currentrub] . " <img src=\"../gfx/default/images/admin/puce_menu_select.gif\" width=\"10\" height=\"10\" alt=\"\" id=\"imgmenu\" /></a></li>\n";
    } else {
        $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu'][$currentrub] . "\">" . $GLOBALS['lang']['menu'][$currentrub] . "</a></li>\n";
    } 
    return $content;
} 

$menu_constructor = '';
if (defined('MOD_NEWS') && HaveRight('news')) $menu_constructor .= displayitem($rub, 'news', 'a');
if (defined('MOD_PUBLICATION') && HaveRight('publication')) {
    if ($rub == 'ressources' || $rub == 'contents') {
        if (isset($type) && $type == 'W') $menu_constructor .= displayitem('workshop', 'publication', 'd');
        if (isset($type) && $type == 'P') $menu_constructor .= displayitem('publication', 'publication', 'd');
    } else {
        $menu_constructor .= displayitem($rub, 'publication', 'd');
    } 
} 

if (defined('MOD_WORKSHOP') && HaveRight('workshop')) {
    if ($rub == 'ressources' || $rub == 'contents' || $rub == 'workshoprep') {
        if (isset($type) && $type == 'W') $menu_constructor .= displayitem('workshop', 'workshop', 'g');
        if (isset($type) && $type == 'P') $menu_constructor .= displayitem('publication', 'workshop', 'g');
        if ($rub == 'workshoprep') $menu_constructor .= displayitem('workshop', 'workshop', 'g');
    } else {
        $menu_constructor .= displayitem($rub, 'workshop', 'g', $GLOBALS['lang']['menu']);
    } 
} 

if (defined('MOD_SDI') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'sdi', 'b');
if (defined('MOD_DASHBOARD') && HaveRight('dashboard')) $menu_constructor .= displayitem($rub, 'dashboard', 'i');
if (defined('MOD_YELLOWPAGES') && HaveRight('yellowpages')) $menu_constructor .= displayitem($rub, 'yellowpages', 'y');
if (defined('MOD_NEWSLETTER') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'newsletter', 'p');
if (defined('MOD_USER') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'user', 'u');
if (defined('MOD_THEME') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'theme', 't');
if (defined('MOD_SCALE') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'scale', 'e');
if (defined('MOD_LEVEL') && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'level', 'n');

?>
<div class="containermenu">
<div class="menu"> 
	<ul>
		<?php echo $menu_constructor; ?>
	</ul>
</div>
<form method="post" action="search.php">
	<div id="containersearch">
		<span><?php echo $GLOBALS['lang']['menu']['search'];?></span>
		<input type="text" name="search" id="searchincome" maxlength="150" accesskey="s" value="" />
		<input type="submit" id="gosearch" name="valid" value="" />
	</div>
</form>
