<?php
// //////////////////////////////////////////////////
// Linea 21 - PHP ressources class
// Class pour gerer les elements d'une publication
// create : 23/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////

/**
* ressources
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class ressources {
    /* @param
	* */
    var $DATE_FORMAT = "%d-%m-%Y";
    var $TDB_LIAISON;
    var $ACTIVE_TABLE;
    var $ACTIVE_TYPE; // valeur 'P' || 'W'
    
    var $B_ID;
    var $B_AUTHOR;
    var $B_TITLE;
    var $B_SUBTITLE;
    var $B_EDITOR;
    var $B_DATE;
    var $B_RANGE;
    var $B_DATE_CREA;
    var $B_LAST_MODIFY;
    var $B_VALIDITY;
    var $TDB_BIBLIO = T_BIBLIO_RES;

    var $L_ID;
    var $L_TEXT;
    var $L_MASK;
    var $L_RANGE;
    var $L_DATE_CREA;
    var $L_LAST_MODIFY;
    var $L_VALIDITY;
    var $TDB_LINK = T_LINK_RES;

    var $M_ID;
    var $M_NAME;
    var $M_DESC;
    var $M_URI;
    var $M_RANGE;
    var $M_DATE_CREA;
    var $M_LAST_MODIFY;
    var $M_VALIDITY;
    var $TDB_MULTI = T_MULTI_RES;
    var $M_MAX_PHOTO_MAX_WIDTH = 720;
    var $M_MAX_PHOTO_MIN_WIDTH = 280;
    var $M_UPLOAD_MAX_MO = 1024000; // taille maximale d'upload des fichiers en octets
    var $M_URI_INPUT = "multimedia/input/"; // dossier racine de stockage des elements multimedias
    var $M_URI_OUTPUT = "multimedia/output/"; // dossier racine de diffusion des elements multimedias
    /**
    * ressources::CheckDataIntegrity()
    * vérifie l'integrité d'un ressource avant Insertion
    * 
    * @access public 
    * @param array $table : contient les composants d'une ressource
    * @param string $type : 'LINK', 'BIBLIO', 'MULTI'
    * @return boolean true
    * si verifié, sinon string 'message d'erreur'
    */
    function CheckDataIntegrity($table, $type)
    {
        if ($type == 'LINK') {
            if (strlen($table[0]) < 2) return $GLOBALS['lang']['ressources']['no_url'];
            if (!$this->IsValidProtocol($table[0])) return $GLOBALS['lang']['ressources']['invalid_protocol'];
            if(CHECK_LINK==true) {
		if (!$this->CheckOnlineFile($table[0])) return $GLOBALS['lang']['ressources']['server_noresponse'];
	    }
        } 
        if ($type == 'BIBLIO') {
            if (strlen($table[0]) < 3) return $GLOBALS['lang']['ressources']['biblio_no_author'];
            if (strlen($table[1]) < 3) return $GLOBALS['lang']['ressources']['biblio_no_title'];
        } 
        if ($type == 'MULTI') {
            if (strlen($table[0]) < 3) return $GLOBALS['lang']['ressources']['multi_no_name'];
            if (strlen($table[1]) < 5) return $GLOBALS['lang']['ressources']['multi_no_description'];
            if (strlen($table[2]) < 2) return $GLOBALS['lang']['ressources']['no_url'];
            if ($table[4] == 'OUT' && !$this->IsValidProtocol($table[2])) return $GLOBALS['lang']['ressources']['invalid_protocol'];
            if ($table[4] == 'IN') $table[2] = SITE_CITY_URL . $table[2];
	    if(CHECK_LINK==true) {
		if (!$this->CheckOnlineFile($table[2])) return $GLOBALS['lang']['ressources']['server_noresponse'];
		}
        } 

        return true;
    } 

    /**
    * ressources::CheckOnlineFile()
    * vérifie l'existence d'un fichier en ligne
    * 
    * @access public 
    * @param  $path 
    * @return boolean 
    */
    function CheckOnlineFile($path)
    {
        $file_pt = @fopen($path, 'r');
        if (!$file_pt) return false;
        else {
            fclose($file_pt);
            return true;
        } 
    } 

    /**
    * ressources::IsValidProtocol()
    * vérifie si une url donnée a un protocole reconnu par un client web standard
    * 
    * @access public 
    * @param array $url : chemin absolu
    * @return boolean 
    */
    function IsValidProtocol($url)
    {
        if (substr($url, 0, 7) != 'http://' && substr($url, 0, 8) != 'https://' && substr($url, 0, 6) != 'ftp://' && substr($url, 0, 7) != 'ftps://') return false;
        else return true;
    } 

    /**
    * ressources::_wichType()
    * détermine les tables de la bdd en action
    * 
    * @access private 
    * @param string $type : type de la ressource Workshop ou publication
    * @param string $ressources : type de la ressource
    * @return void 
    */
    function _wichType($type, $ressources)
    {
        switch ($type) {
            case 'WORKSHOP':
                $this->ACTIVE_TYPE = 'W';
                break;
            case 'PUBLICATION':
                $this->ACTIVE_TYPE = 'P';
                break;
            default:
                return "error";
        } 

        switch ($ressources) {
            case 'BIBLIO':
                $this->TDB_LIAISON = J_BIBLIO;
                $this->ACTIVE_TABLE = T_BIBLIO_RES;
                break;
            case 'LINK':
                $this->TDB_LIAISON = J_LINK;
                $this->ACTIVE_TABLE = T_LINK_RES;
                break;
            case 'MULTI':
                $this->TDB_LIAISON = J_MULTI;
                $this->ACTIVE_TABLE = T_MULTI_RES;
                break;
            default:
                return "error";
        } 
    } 


    /**
	* ressources::AddBiblioRes()
    * Ajout d'une nouvelle ressource bibliographique
    * 
    * @access public 
    * @param array $res_table tableau contenant les infos ressources
    * @param int $ID identifiant du père (rattachement)
    * @param string $type 'PUBLICATION' ou 'WORKSHOP'
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddBiblioRes($ID, $res_table, $type, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
        if ($this->_wichType($type, 'BIBLIO') == "error") exit();
        $this->B_AUTHOR = strip_tags($res_table[0]);
        $this->B_TITLE = strip_tags($res_table[1]);
        $this->B_SUBTITLE = strip_tags($res_table[2]);
        $this->B_EDITOR = strip_tags($res_table[3]);
        $this->B_DATE = strip_tags($res_table[4]);
        $this->B_RANGE = $res_table[5];
        $this->B_VALIDITY = 'Y';
        $requete = "INSERT INTO " . $this->ACTIVE_TABLE . " (bibliores_author, bibliores_title, bibliores_sub_title, bibliores_editor, bibliores_date, bibliores_range, bibliores_date_crea, bibliores_validity) " . "VALUES('" . $this->B_AUTHOR . "', '" . $this->B_TITLE . "', '" . $this->B_SUBTITLE . "', '" . $this->B_EDITOR . "', '" . $this->B_DATE . "', " . $this->B_RANGE . ", NOW(), '" . $this->B_VALIDITY . "');";
        $last_id = $sql_object->DBInsert ($requete, 1);
        if (is_numeric($last_id)) {
            $requete = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
            $result = $sql_object->DBInsert ($requete);
        } 
        return $result;
    } 

    /**
	* ressources::ModifyBiblioRes()
    * modification d'une ressource bibliographique
    * 
    * @access public 
    * @param int $ID identifiant de la ressource
    * @param object $sql_object 
    * @param array $res_table tableau contenant les infos ressources
    * @return bool $result
    */
    function ModifyBiblioRes($ID, $res_table, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
        $this->B_ID = $ID;
        $this->B_AUTHOR = strip_tags($res_table[0]);
        $this->B_TITLE = strip_tags($res_table[1]);
        $this->B_SUBTITLE = strip_tags($res_table[2]);
        $this->B_EDITOR = strip_tags($res_table[3]);
        $this->B_DATE = strip_tags($res_table[4]);
        $requete = "UPDATE " . $this->TDB_BIBLIO . " SET bibliores_author='" . $this->B_AUTHOR . "' , bibliores_title='" . $this->B_TITLE . "', bibliores_sub_title='" . $this->B_SUBTITLE . "', bibliores_editor='" . $this->B_EDITOR . "', bibliores_date='" . $this->B_DATE . "' WHERE bibliores_id='" . $this->B_ID . "';";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* ressources::DeleteBiblioRes()
    * suppression d'une ressource bibliographique
    * 
    * @access public 
    * @param int $ID identifiant de la ressource a supprimer
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteBiblioRes($ID, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->B_ID = $ID;
        } 
        $requete = "UPDATE  " . $this->TDB_BIBLIO . " SET bibliores_validity='N' WHERE bibliores_id=" . $this->B_ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* ressources::AddLinkRes()
    * Ajout d'une ressource de type lien
    * 
    * @access public 
    * @param int $ID identifiant du père (rattachement)
    * @param array $res_table tableau contenant les infos ressources
    * @param string $type 'PUBLICATION' ou 'WORKSHOP'
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddLinkRes($ID, $res_table, $type, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
	
        $notvalidlink = $GLOBALS['lang']['ressources']['invalid_link'];
        if ($this->_wichType($type, 'LINK') == "error") exit;
        $this->L_TEXT = strip_tags($res_table[0]);
        if ($res_table[1] == '') {
            $this->L_MASK = $this->L_TEXT;
        } else {
            $this->L_MASK = strip_tags($res_table[1]);
        } 
        if (is_numeric($res_table[2])) {
            $this->L_RANGE = $res_table[2];
        } 
        $this->L_VALIDITY = 'Y';
        $requete = "INSERT INTO " . $this->ACTIVE_TABLE . " (linkres_text, linkres_mask, linkres_range, linkres_date_crea, linkres_validity) VALUES('" . $this->L_TEXT . "', '" . $this->L_MASK . "', " . $this->L_RANGE . ", NOW(), '" . $this->L_VALIDITY . "');";
        $last_id = $sql_object->DBInsert ($requete, 1);
        if (is_numeric($last_id)) {
            $requete = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
            $result = $sql_object->DBInsert ($requete);
        } 
        return $result;
    } 

    /**
	* ressources::ModifyLinkRes()
    * modification d'une ressource de type lien
    * 
    * @access public 
    * @param int $ID identifiant de la ressource
    * @param array $res_table tableau contenant les infos ressources
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyLinkRes($ID, $res_table, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
	
        $this->L_ID = $ID;
        $this->L_TEXT = strip_tags($res_table[0]);
        if ($res_table[1] == '') {
            $this->L_MASK = $this->L_TEXT;
        } else {
            $this->L_MASK = strip_tags($res_table[1]);
        } 
        $requete = "UPDATE " . $this->TDB_LINK . " SET linkres_text='" . $this->L_TEXT . "' , linkres_mask='" . $this->L_MASK . "' WHERE linkres_id='" . $this->L_ID . "';";
        echo $requete;
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* ressources::DeleteLinkRes()
    * suppression d'une ressource de type lien
    * 
    * @access public 
    * @param int $ID identifiant de la ressource a supprimer
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteLinkRes($ID, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->B_ID = $ID;
        } 
        $requete = "UPDATE  " . $this->TDB_LINK . " SET linkres_validity='N' WHERE linkres_id=" . $this->B_ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

    /**
	* ressources::AddMultiRes()
    * Ajout d'une ressource de type multimedia
    * 
    * @access public 
    * @param int $ID identifiant du père (rattachement)
    * @param array $res_table tableau contenant les infos ressources
    * @param string $type 'PUBLICATION' ou 'WORKSHOP'
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddMultiRes($ID, $res_table, $type, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
	
        if ($this->_wichType($type, 'MULTI') == "error") exit;
        $this->M_NAME = strip_tags($res_table[0]);

        $this->M_DESC = strip_tags($res_table[1]);
        $this->M_URI = strip_tags($res_table[2]);
        $this->M_RANGE = $res_table[3];
        $this->M_VALIDITY = 'Y';
        $requete = "INSERT INTO " . $this->ACTIVE_TABLE . " (multires_name, multires_description, multires_media_uri, multires_range, multires_date_crea, multires_validity) VALUES('" . $this->M_NAME . "', '" . $this->M_DESC . "', '" . $this->M_URI . "', " . $this->M_RANGE . ", NOW(), '" . $this->M_VALIDITY . "');";
        $last_id = $sql_object->DBInsert ($requete, 1);
        if (is_numeric($last_id)) {
            $requete = "INSERT INTO " . $this->TDB_LIAISON . " VALUES(" . $ID . "," . $last_id . ", '" . $this->ACTIVE_TYPE . "');";
            $result = $sql_object->DBInsert ($requete);
        } 
        return $result;
    } 

    /**
	* ressources::ModifyMultiRes()
    * modification d'une ressource de type multimedia
    * 
    * @access public 
    * @param int $ID identifiant de la ressource
    * @param array $res_table tableau contenant les infos ressources
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyMultiRes($ID, $res_table, $sql_object)
    {
	$res_table=$sql_object->DBescape($res_table);
	
        $this->M_ID = $ID;
        $this->M_NAME = strip_tags($res_table[0]);
        $this->M_DESC = strip_tags($res_table[1]);
        $this->M_URI = strip_tags($res_table[2]);
        $requete = "UPDATE " . $this->TDB_MULTI . " SET multires_name='" . $this->M_NAME . "' , multires_description='" . $this->M_DESC . "' , multires_media_uri='" . $this->M_URI . "' WHERE multires_id='" . $this->M_ID . "';";
        $result = $sql_object->DBQuery($requete);

        return $result;
    } 

    /**
	* ressources::DeleteMultiRes()
    * suppression d'une ressource multimedia
    * 
    * @access public 
    * @param int $ID identifiant de la ressource a supprimer
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteMultiRes($ID, $sql_object)
    {
        if (is_numeric($ID)) {
            $this->M_ID = $ID;
        } 
        $requete = "UPDATE  " . $this->TDB_MULTI . " SET multires_validity='N' WHERE multires_id=" . $this->M_ID . ";";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 
} 

?>