<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP workshop_report class
// Class pour gerer les rapports de groupes de travail
// create : 23/09/03
// last_modify	: 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////

/**
* workshop_report
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class workshop_report {
    /* @param
	* */
    var $TDB_WORKREP = T_WORK_REP; // nom de la table.
    var $DATE_FORMAT = "%d-%m-%Y";
    var $ID;
    var $TITLE;
    var $RESUME;
    var $WORKSHOP_ID;
    var $PUBLISHED_DATE;
    var $COMMENT;
    var $DATE_CREA;
    var $LAST_MODIFY;
    var $STATUT;

    /**
    * workshop_report::CheckDataIntegrity()
    * Vérification intégrité des données
    * 
    * @access public 
    * @param array $table : contient les composants d'un compte rendu
    * @return boolean true
    * si verifié, sinon string 'message d'erreur'
    */
    function CheckDataIntegrity($table, $sql_object)
    {
        if (strlen($table[0]) < 3) return $GLOBALS['lang']['workshoprep']['no_title'];
        if (strlen($table[1]) < 3) return $GLOBALS['lang']['workshoprep']['no_resume'];

        return true;
    } 

	
    /**
	* workshop_report::AddWorkshopReport()
    * Ajout d'un un rapport de groupe de travail
    * 
    * @access public 
    * @param array $table_workrep contient les composants du rapport
    * @param object $sql_object 
    * @return integer $last_id
    */
    function AddWorkshopReport($table_workrep, $sql_object)
    {
	$table_workrep=$sql_object->DBescape($table_workrep);
	
        $this->TITLE = strip_tags(trim($table_workrep[0]));
        $this->RESUME = strip_tags(trim($table_workrep[1]));
        $this->COMMENT = strip_tags(trim($table_workrep[2]));
        $this->STATUT = strtoupper($table_workrep[3]);
        $this->WORKSHOP_ID = $table_workrep[4];
       	$this->PUBLISHED_DATE = "NOW()";
       	//abe 18/07/07 
       	//TODO : bug à fixer, rétablir situation
       	//pgsql ne prend pas '' pour valuer vide dans un champ timestamp
        /*
         * 
         if ($this->STATUT == 'P') {
            $this->PUBLISHED_DATE = "NOW()";
        } else {
            $this->PUBLISHED_DATE = "''";
        }
        */ 
        $requete = "INSERT INTO " . $this->TDB_WORKREP . " (workrep_title, workrep_resume, workrep_workshop_id, workrep_published_date, workrep_comment, workrep_statut, workrep_date_crea) VALUES('" . $this->TITLE . "', '" . $this->RESUME . "', " . $this->WORKSHOP_ID . ", " . $this->PUBLISHED_DATE . ", '" . $this->COMMENT . "', '" . $this->STATUT . "', NOW());";
        $last_id = $sql_object->DBInsert ($requete, 1);
        return $last_id;
    } 

	
    /**
	* workshop_report::ModifyWorkshopReport()
    * modification d'un rapport de groupe de travail
    * 
    * @access public 
    * @param int $ID identifiant du rapport de workshop
	* @param array $table_workrep contient les composants du rapport
    * @param object $sql_object 
    * @return bool $result
    */
    function ModifyWorkshopReport($ID, $table_workrep, $sql_object)
    {
	$table_workrep=$sql_object->DBescape($table_workrep);
	
        $this->ID = $ID;
        $this->TITLE = strip_tags(trim($table_workrep[0]));
        $this->RESUME = strip_tags(trim($table_workrep[1]));
        $this->COMMENT = strip_tags(trim($table_workrep[2]));
        $this->STATUT = $table_workrep[3];

        $mask = $this->_HavePublishedDate($table_workrep[4]);

        $requete = "UPDATE  " . $this->TDB_WORKREP . " SET workrep_title='" . $this->TITLE . "', workrep_resume='" . $this->RESUME . "', workrep_comment='" . $this->COMMENT . "', workrep_statut='" . $this->STATUT . "'" . $mask . " WHERE workrep_id='" . $this->ID . "';";
        $result = $sql_object->DBQuery($requete);
        return $result;
    } 

	
	/**
    * workshop_report::_HavePublishedDate()
    * Détermine la date de publication a inserer dans la bdd
    * 
    * @access private 
    * @param string $current_status : statut actuel de la publication
    * @return string $sql_mask
    */
    function _HavePublishedDate($current_status)
    {
        switch ($this->STATUT) {
            case 'P':
                if ($current_status == 'D') $sql_mask = ", workrep_published_date= NOW()";
                else $sql_mask = '';
                break;
            case 'D':
                $sql_mask = ", workrep_published_date= '0001-01-01'";
                break;
            default:
                $sql_mask = '';
        } 
        return $sql_mask;
    } 


    /**
	* workshop_report::DeleteWorkshopReport()
    * suppression d'un rapport de groupe de travail
    * 
    * @access public 
    * @param int $ID id du rapport de groupe de travail
    * @param object $sql_object 
    * @return bool $result
    */
    function DeleteWorkshopReport($ID, $sql_object)
    {
        $this->ID = $ID;
        $requete = "UPDATE  " . $this->TDB_WORKREP . " set workrep_statut='E' WHERE workrep_id='" . $this->ID . "';";
        $result = $sql_object->DBQuery($requete);

        return $result;
    }

} 

?>
