<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP image class
// Création d'image miniature
// create : 28/10/03
// last_modify : 25/03/04
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////

/**
* image
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class image {
    /* @parametres
	* */
    var $IMG_SRC; // chemin relatif de l'image
    var $IMG_DEST; // chemin de destination de l'image
    var $RATIO; // ratio de reduction
    /**
    * image::IsResizableimage()
    * Determine si un fichier est une image redimmensionnable
    * 
    * @access public 
    * @param string $img_src 
    * @return boolean 
    */
    function IsResizableimage($img_src)
    {
        include('../languages/' . LANGUAGE . '/lang_system.'. CHARSET .'.php');
        $ext_list = array ('jpg', 'jpeg', 'png');
        $this->IMG_SRC = $img_src;
        $ext = explode('.', $this->IMG_SRC);
        $ext = $ext[count($ext)-1];
        while (list (, $val) = each ($ext_list)) {
            if ($ext == $val) return true;
        } 
        return $lang['upload']['no_resize'];
    } 

    /**
    * image::_GetFormat()
    * 	Determine le format d'un image
    * 
    * @access private 
    * @return string 'L' || 'P'
    */
    function _GetFormat()
    {
        list($width, $height, $type, $attr) = getimagesize($this->IMG_SRC);
        if ($width > $height) {
            return 'L';
        } else {
            return 'P';
        } 
    } 

    /**
    * image::ThumbCreate()
    * création d'une image miniature
    * 
    * @access public 
    * @param string $image_src : Nom et chemin de l'image originale
    * @param string $image_dest : Nom de l'image de destination
    * @param integer $ratio : Largeur de l'image réduite
    * @return boolean 
    */
    function ThumbCreate($image_src, $image_dest , $ratio = -1)
    {
        $this->IMG_SRC = $image_src;
        $this->IMG_DEST = $image_dest;
        if ($ratio != -1) $this->RATIO = $ratio;

        $IsResizable = $this->IsResizableimage($this->IMG_SRC);
        if (is_string($IsResizable)) return $IsResizable;
        $format = $this->_GetFormat();
        list($width, $height, $type, $attr) = getimagesize($image_src);
        if ($type == 1) $src = imagecreatefromgif($image_src);
        if ($type == 2) $src = imagecreatefromjpeg($image_src);
        if ($type == 3) $src = imagecreatefrompng($image_src); 
        // echo $this->IMG_SRC . "<br />";
        // echo $this->IMG_DEST . "<br />";
        // echo $this->RATIO . "<br />";
        // echo $format . "<br />";
        if ($format == 'L') {
            $im = imagecreatetruecolor($this->RATIO, floor(($this->RATIO * $height) / $width));
            imagecopyresampled($im, $src, 0, 0, 0, 0, $this->RATIO, floor($this->RATIO * $height / $width), $width, $height);
        } elseif ($format == 'P') {
            $im = imagecreatetruecolor(floor(($this->RATIO * $width) / $height), $this->RATIO);
            imagecopyresampled($im, $src, 0, 0, 0, 0, floor($this->RATIO * $width / $height), $this->RATIO, $width, $height);
        } 
        if ($type == 1) $result = imagegif($im, $this->IMG_DEST);
        if ($type == 2) $result = imagejpeg($im, $this->IMG_DEST);
        if ($type == 3) $result = imagepng($im, $this->IMG_DEST);
        return $result;
    } 
} 

?>