<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP mysql_object class
// Interfacage Base de données MySQL
// create : 01/09/03
// last_modify : 28/10/03
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////

/**
* mysql
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2003
* @version 1.0
* @access public 
*/

class mysql {
    /* PROPRIETES DE LA CLASSE */
	var $DB_DEBUG = true;
    var $DB_HOST = DB_HOST;
    var $DB_USER = DB_USER;
    var $DB_PASS = DB_PASS;
    var $DB_NAME = DB_NAME;
    var $DB_LINK = "";
    var $DB_ADMINMAIL = DB_ADMINMAIL;
    var $DB_PAGE_ERR = CURRENT_PAGE;
    var $DATE_FORMAT = '%d-%m-%Y';
    var $RESULT;

    /**
    * mysql::DBInitialise()
    * Initialisation de la connexion
    * 
    * @access public 
    * @param string $user : utilisateur base de données
    * @param string $pass : password utilisateur base de données
    * @param string $serveur : serveur de base de données
    * @param string $bdd : nom de la base de données
    * @return boolean 
    */

    function DBInitialise($user = '', $pass = '', $serveur = '', $bdd = '')
    {
        if ($user != '') {
            $this->DB_USER = $user;
        } 
        if ($pass != '') {
            $this->DB_PASS = $pass;
        } 
        if ($serveur != '') {
            $this->DB_HOST = $serveur;
        } 
        if ($bdd != '') {
            $this->DB_NAME = $bdd;
        } 
        return true;
    } 

    /**
    * mysql::DBConnexion()
    * connexion Base de données
    * 
    * @access public 
    * @param none $ 
    * @return boolean 
    */

    function DBConnexion()
    {
        $this->DB_LINK = @mysql_connect($this->DB_HOST, $this->DB_USER, $this->DB_PASS) or die($this->DBError("La connexion à MySql à échouée"));
        $this->DBSelectDB();
	if(strtolower(CHARSET) == 'utf-8') $this->DBQuery("SET NAMES UTF8");
        return true;
    } 

    /**
    * mysql::DBSelectDB()	
    * Sélection de la Base de données
    * 
    * @access public 
    * @param none $ 
    * @return boolean 
    */

    function DBSelectDB()
    {
        mysql_select_db($this->DB_NAME, $this->DB_LINK) or die($this->DBError("Sélection de la base de données impossible."));
        return true;
    } 

    /**
    * mysql::DBError()
    * Gestion des erreurs MySQL
    * 
    * @access private 
    * @param string $message_err : message retourné par la requête
    * @param string $requete : requête provoquant l'erreur
    * @return boolean 
    */
    function DBError($message_err, $requete = -1)
    {
        $erreur = $message_err . "<br />[<em> erreur n° " . @mysql_errno() . " : " . @mysql_error() . "</em> ]<br />\n";
        if ($requete != -1) {
            $erreur .= "Requête SQL : $requete<br />\n";
        } 
        $date = date("[D d/M/y H:i:s]<br />\n");
        $erreur .= $date;
        $erreur .= "script en cours :" . $this->DB_PAGE_ERR . "<br />";
        if($this->DB_DEBUG===true) echo $erreur;
        if ($this->DB_ADMINMAIL != -1) @error_log ($erreur, 1, $this->DB_ADMINMAIL);
    } 

    /**
    * mysql::DBInsert()
    * Insertion de données dans la BDD
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @param string $returnid : Si $returnid==1 ==> renvoie last_id()
    * @return integer || boolean : $result last_id()
    */

    function DBInsert ($requete, $returnid = -1)
    {
        if (!($this->RESULT = $this->DBQuery($requete))) return false; 
        // Si returnid=1 on renvoie l'id de l'enregistrement
        // A utiliser uniquement si attribut auto_increment
        if ($returnid == 1) {
            if (!(mysql_insert_id())) {
                $requete = "SELECT LAST_INSERT_ID() as last_id";
                $res = $this->DBQuery($requete);
            } else {
                $res = mysql_insert_id();
            } 
        } else {
            $res = true;
        } 
        return $res;
    } 

    /**
    * mysql::DBQuery()
    * effectue une requête en tous genres -UPDATE - DELETE - SELECT
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @return boolean : $result
    */
    function DBQuery ($requete)
    {
        $this->RESULT = mysql_query($requete, $this->DB_LINK) or die($this->DbError("echec de la requête mysql", $requete));
	
        return $this->RESULT;
    } 

    /**
    * mysql::DBSelect()
    * Requêtes - SELECT
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @param string $fetch : renvoie des données, valeur ASSOC (default), ARRAY, OBJECT
    * @return array : $result
    */

    function DBSelect ($requete, $fetch = 'ASSOC')
    {
        if (!($this->RESULT = $this->DBQuery($requete))) {
            @mysql_free_result($this->RESULT);
            return false;
        } 
        if ($fetch == 'ARRAY') {
            $i = 0;
            while ($data = @mysql_fetch_array($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'OBJECT') {
            $i = 0;
            while ($data = @mysql_fetch_object($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'ASSOC') {
            $i = 0;
            while ($data = @mysql_fetch_assoc($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 

        if (!isset($table)) $table = 0;
        return $table;
    } 

    /**
    * mysql::DBescape()
    * Echappement  des variables
    * 
    * @access public 
    * @param string $array : données
    * @return array : $array
    */

    function DBescape ($array)
    {
	
	foreach ($array as $value) {
		if(is_string($value)) {
			if (get_magic_quotes_gpc()) $value=stripslashes($value);
			$value=mysql_real_escape_string($value);
		}
	}
	return $array;
       
    }
    
   /** 
    * mysql::DBaffectedRow()
    * Retourne le nombre d'enregistrements affecté par la dernière requête
    * 
    * @access public 
    * @return integer : $res
    */
    function DBaffectedRow()
    {
        $res = mysql_affected_rows();
        return $res;
    } 
    
    /**
    * mysql::DBclose()
    * Retourne le nombre d'enregistrements affecté par la dernière requête
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @return boolean : $result
    */
    function DBClose()
    {
        @mysql_close();
    } 
} 

?>