<?php 
// //////////////////////////////////////////////////
// Linea 21 - PHP mysql_object class
// Interfacage Base de données PostgreSQL
// create : 20/06/07
// last_modify : 20/06/07
// creative commons 2007 
//http://creativecommons.org/licenses/by-nc-sa/2.0/fr/legalcode
// //////////////////////////////////////////////////

/**
* mysql
* 
* @package linea21
* @author simon 
* @copyright Copyright (c) green-box 2007
* @version 1.0
* @access public 
*/

class pgsql {
    /* PROPRIETES DE LA CLASSE */
    var $DB_DEBUG = true;
    var $DB_HOST = DB_HOST;
    var $DB_USER = DB_USER;
    var $DB_PASS = DB_PASS;
    var $DB_NAME = DB_NAME;
    var $DB_LINK = "";
    var $DB_ADMINMAIL = DB_ADMINMAIL;
    var $DB_PAGE_ERR = CURRENT_PAGE;
    var $DATE_FORMAT = 'DD-MM-YYYY';
    var $RESULT;

    /**
    * mysql::DBInitialise()
    * Initialisation de la connexion
    * 
    * @access public 
    * @param string $user : utilisateur base de données
    * @param string $pass : password utilisateur base de données
    * @param string $serveur : serveur de base de données
    * @param string $bdd : nom de la base de données
    * @return boolean 
    */

    function DBInitialise($user = '', $pass = '', $serveur = '', $bdd = '')
    {
        if ($user != '') {
            $this->DB_USER = $user;
        } 
        if ($pass != '') {
            $this->DB_PASS = $pass;
        } 
        if ($serveur != '') {
            $this->DB_HOST = $serveur;
        } 
        if ($bdd != '') {
            $this->DB_NAME = $bdd;
        } 
        return true;
    } 

    /**
    * mysql::DBConnexion()
    * connexion Base de données
    * 
    * @access public 
    * @param none $ 
    * @return boolean 
    */

    function DBConnexion()
    {
        $this->DB_LINK = @pg_connect('host=' .$this->DB_HOST. ' port=5432 dbname=' . $this->DB_NAME . ' user=' . $this->DB_USER. ' password='  . $this->DB_PASS) 
		or die($this->DBError("La connexion à PostgreSQL à échouée"));
		
        return true;
    }

    /**
    * mysql::DBError()
    * Gestion des erreurs MySQL
    * 
    * @access private 
    * @param string $message_err : message retourné par la requête
    * @param string $requete : requête provoquant l'erreur
    * @return boolean 
    */
    function DBError($message_err, $requete = -1)
    {
	//pg_set_error_verbosity($this->DB_LINK, PGSQL_ERRORS_VERBOSE);
	$res1 = pg_get_result($this->DB_LINK);
	
        $erreur = $message_err . "<br />[<em> PostgreSQL error (pg_result_error): " . @pg_result_error($res1). "<br />";
	$erreur.= "(pg_last_error): " . @pg_last_error() . "</em> ]<br />\n";
        if ($requete != -1) {
            $erreur .= "$requete<br />\n";
        } 
        $date = date("[D d/M/y H:i:s]<br />\n");
        $erreur .= $date;
        $erreur .= "running script :" . $this->DB_PAGE_ERR . "<br />";
        if($this->DB_DEBUG===true) echo $erreur;
        if ($this->DB_ADMINMAIL != -1) @error_log ($erreur, 1, $this->DB_ADMINMAIL);
    } 

    /**
    * mysql::DBInsert()
    * Insertion de données dans la BDD
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @param string $returnid : Si $returnid==1 ==> renvoie last_id()
    * @return integer || boolean : $result last_id()
    */

    function DBInsert ($requete, $returnid = -1)
    {
        if (!($this->RESULT = $this->DBQuery($requete))) return false;
	
        // Si returnid=1 on renvoie l'id de l'enregistrement
        // A utiliser uniquement si attribut auto_increment

        if ($returnid == 1) return $this->_DBgetInsertId($requete);
	
	return true;
       
    }
    
    /**
    * pgsql::DBescape()
    * Echappement  des variables
    * 
    * @access public 
    * @param string $array : données
    * @return array : $array
    */

    function DBescape ($array)
    {
	
	foreach ($array as $value) {
		if(is_string($value)) {
			if (get_magic_quotes_gpc()) $value=stripslashes($value);
			$value=pg_escape_string($value);
		}
	}
	return $array;
       
    }
    
    /**
    * mysql::_DBgetInsertId()
    * Insertion de données dans la BDD
    * 
    * @access private 
    * @param string $requete : requête SQL
    * @return integer
    */

    function _DBgetInsertId ($requete)
    {
	$array = explode(" ", $requete);
	$tablename = $array[2];
	
        if (!($res = $this->DBQuery("SELECT * FROM " . $tablename . " LIMIT 1;"))) return false; 

	$id_name = pg_field_name ( $res, 0);
	$seq = $tablename. '_' . $id_name . '_seq';

	$res = $this->DBSelect("SELECT currval('" . $seq . "');");
	
	return $res[0]['currval'];
       
    }
    

    /**
    * mysql::DBQuery()
    * effectue une requête en tous genres -UPDATE - DELETE - SELECT
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @return boolean : $result
    */
    function DBQuery ($requete)
    {
        $this->RESULT = pg_query($this->DB_LINK, $requete) or die($this->DbError("echec de la requête mysql", $requete));
	
        return $this->RESULT;
    } 

    /**
    * mysql::DBSelect()
    * Requêtes - SELECT
    * 
    * @access public 
    * @param string $requete : requête SQL
    * @param string $fetch : renvoie des données, valeur ASSOC (default), ARRAY, OBJECT
    * @return array : $result
    */

    function DBSelect ($requete, $fetch = 'ASSOC')
    {
        if (!($this->RESULT = $this->DBQuery($requete))) {
            @pg_free_result($this->RESULT);
            return false;
        } 
        if ($fetch == 'ARRAY') {
            $i = 0;
            while ($data = @pg_fetch_array($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'OBJECT') {
            $i = 0;
            while ($data = @pg_fetch_object($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 
        if ($fetch == 'ASSOC') {
            $i = 0;
            while ($data = @pg_fetch_assoc($this->RESULT)) {
                $table[$i] = $data;
                $i++;
            } 
        } 

        if (!isset($table)) $table = 0;
        return $table;
    } 
    
        /**
    * pgsql::DBaffectedRow()
    * Retourne le nombre d'enregistrements affecté par la dernière requête
    * 
    * @access public 
    * @return integer : $res
    */
    function DBaffectedRow()
    {
        $res = pg_affected_rows($this->RESULT);
        return $res;
    } 

        /**
    * pgsql::DBclose()
    * Retourne le nombre d'enregistrements affecté par la dernière requête
    * 
    * @access public 
    * @return integer : $res
    */
    function DBClose()
    {
        @pg_close();
    } 
} 

?>