<?php

include_once('../dashboard/' . SQL . '.inc.php');

/**
 * DisplayListValues()
 * affichage du tableau de bord
 * @param integer $id_filter
 * @param integer $filter
 * @return 
 **/
function DisplayListValues($id_filter = -1, $filter = -1)
{
    $result = $GLOBALS['sql_object'] -> DBSelect(SQL_getListtheme());
    $result_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getListSdi("P", $valueparam = 0));
    $listing = "";
$a='';
    $current_sdtheme = '';
    for ($i = 0;$i < count($result);$i++) {
        if ($result[$i]['sdtheme_id'] != $current_sdtheme && $current_sdtheme <> '') {
            $listing .= "</tbody>" . END_LINE;
            $listing .= "</table>" . END_LINE;
        } 
        if ($result[$i]['sdtheme_id'] != $current_sdtheme) {
			$a++;
            $current_sdtheme = $result[$i]['sdtheme_id'];
            $listing .= "<h2 id=\"h2_".$a."\" class=\"h2_dashboard\">" . formatText($result[$i]['sdtheme_name'], '2HTML') . "</h2>".END_LINE;
            $listing .= '<table cellspacing="0" cellpadding="5" style="width:505px;" class="table_dashboard" summary="'.sprintf($GLOBALS['lang']['dashboard']['list_public_summary'], formatText($result[$i]['sdtheme_name'], '2HTML')).'">' . END_LINE;
			$listing .= '<thead class="semnone">' . END_LINE;
			$listing .= '<tr>' . END_LINE;
			$listing .= '<td>'.$GLOBALS['lang']['dashboard']['graphic_value'].'</td>' . END_LINE;
			//$listing .= '<td>'.$GLOBALS['lang']['dashboard']['numeric_value'].'</td>' . END_LINE;
			$listing .= '<td>'.$GLOBALS['lang']['dashboard']['tendencies_value'].'</td>' . END_LINE;
			$listing .= '<td>'.$GLOBALS['lang']['dashboard']['label_value'].'</td>' . END_LINE;
			$listing .= '</tr>' . END_LINE;
			$listing .= '</thead>' . END_LINE;
			$listing .= '<tbody>' . END_LINE;
			
        } 
        for ($j = 0;$j < count($result_sdi);$j++) {
            if ($result[$i]['theme_id'] == $result_sdi[$j]['sdii_theme']) {
				$link_det_sdi= array('rub'=> $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'],'id'=>$result_sdi[$j]['sdii_id'], 'parentid'=> $id_filter );
                $listing .= "<tr>" . END_LINE;
                $aff_bare = aff_barre($id_filter, $filter, $result_sdi[$j]['sdii_id'], $result_sdi[$j]['sdii_max_value'], $result_sdi[$j]['sdii_min_value'], $result_sdi[$j]['sdii_threshold_value'], $result_sdi[$j]['sdii_unit'], $result_sdi[$j]['sdii_threshold_relative'], $link_det_sdi);
                $listing .= $aff_bare;
                $listing .= "<td><a href=\"" . HrefMaker($link_det_sdi) . "\" title=\"" . formatText($result_sdi[$j]['sdii_name'], '2ATT') . "\">" . formatText(cutText($result_sdi[$j]['sdii_name'], 53), '2HTML') . "</a></td>" . END_LINE;
                $listing .= "</tr>" . END_LINE;
            } 
        } 
    } 
    $listing .= "</tbody>" . END_LINE;
    $listing .= "</table>" . END_LINE;

    echo $listing;
} 

/**
 * value_barre()
 * traitement de la valeur d'un IDD pour valeur du curseur en CSS
 * @param $value
 * @param $max_value
 * @param $min_value
 * @param $threshold_value
 * @param $threshold_relative
 * @return 
 **/
function value_barre ($value, $max_value, $min_value, $threshold_value, $threshold_relative)
{
    if ($max_value == 0) $max_value = 0.000001;
    if ($min_value == 0) $min_value = 0.000001;
    if ($threshold_relative == 'Y') {
        $unitup = 50 / ($max_value - $threshold_value);
        $unitdown = 50 / ($threshold_value - $min_value);
        if ($value > $threshold_value) $result = 50 + (($value - $threshold_value) * $unitup);
        else $result = 50 - (($threshold_value - $value) * $unitdown);
    } else {
        $unitdown = 50 / ($max_value - $threshold_value);
        $unitup = 50 / ($threshold_value - $min_value);
        if ($value > $threshold_value) $result = 50 - (($value - $threshold_value) * $unitdown);
        else $result = 50 + (($threshold_value - $value) * $unitup);
    } 
    return (int)$result;
} 

/**
 * aff_barre()
 * affichage du curseur et compteur pour un IDD
 * @param integer $scale_id
 * @param $filter
 * @param $id
 * @param $max_value
 * @param $min_value
 * @param $threshold_value
 * @param $unit
 * @param $threshold_relative
 * @param $link_det_sdi
 * @return 
 **/
function aff_barre($scale_id = 1, $filter, $id, $max_value, $min_value, $threshold_value, $unit, $threshold_relative, $link_det_sdi)
{
    $result_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getAllValue("SCD", $scale_id, $id));

    if ($result_value <> false) {
        $value_cursor1 = value_barre ($result_value[0]['sdiv_value'], $max_value, $min_value, $threshold_value, $threshold_relative);
        $value_cursor = 116 - $value_cursor1;
    } else $value_cursor1 = "";
    if ($result_value == false) {
        $listing = "<td><img src=\"../gfx/default/images/admin/barre_gris.gif\" title=\"".$GLOBALS['lang']['dashboard']['novalue']."\" alt=\"".$GLOBALS['lang']['dashboard']['novalue']."\" class=\"barre_grise\"/></td>" . END_LINE;
        $listing .= "<td style=\"width:15px\">&nbsp;</td>" . END_LINE;
        //$listing .= "<td>&nbsp;</td>" . END_LINE;
    } else {
        $listing = "<td style=\"width:130px\"><a href=\"" . HrefMaker($link_det_sdi) . "\" class=\"barre\" title=\"" . formatText($result_value[0]['sdiv_value'], '2ATT') . " " . $unit . "\"><img src=\"../gfx/default/images/admin/barre.gif\" alt=\"".formatText($GLOBALS['lang']['dashboard']['value'].": ".$result_value[0]['sdiv_value']." ".$unit.
"\n ".$GLOBALS['lang']['sdi']['min_value'].": ".$min_value." ".$unit.
"\n ".$GLOBALS['lang']['sdi']['threshold_value'].": ".$threshold_value." ".$unit.
"\n ".$GLOBALS['lang']['sdi']['max_value'].": ".$max_value." ".$unit, '2ATT').
"\"/><span>".$GLOBALS['lang']['dashboard']['value'].": ".$result_value[0]['sdiv_value']." ".$unit.
"<br /> ".$GLOBALS['lang']['sdi']['min_value'].": ".$min_value." ".$unit.
"<br /> ".$GLOBALS['lang']['sdi']['threshold_value'].": ".$threshold_value." ".$unit.
"<br /> ".$GLOBALS['lang']['sdi']['max_value'].": ".$max_value." ".$unit.
"</span></a>" . END_LINE;
        $listing .= "<img src=\"../gfx/default/images/admin/cursor.gif\"  title=\"" . $result_value[0]['sdiv_value'] . " " . $unit . "\" class=\"cursor\" style=\"left:-" . $value_cursor . "px;\" alt=\"".$GLOBALS['lang']['dashboard']['barre']."\"/></td>" . END_LINE;
        if (isset($result_value[1]['sdiv_value'])) {
            if ($result_value[0]['sdiv_value'] >= $result_value[1]['sdiv_value']) $listing .= "<td><img src=\"../gfx/default/images/admin/ico_asc.gif\" class=\"img_desc\" alt=\"".formatText($GLOBALS['lang']['dashboard']['value_tendance'].' : '.$GLOBALS['lang']['dashboard']['tendance_asc'], '2ATT')."\" /></td>" . END_LINE;
            else $listing .= "<td><img src=\"../gfx/default/images/admin/ico_desc.gif\" class=\"img_desc\" alt=\"".$GLOBALS['lang']['dashboard']['value_tendance'].' : '.$GLOBALS['lang']['dashboard']['tendance_desc']."\" /></td>" . END_LINE;
        } else $listing .= "<td style=\"width:15px\">&nbsp;</td>" . END_LINE;
        //$listing .= "<td><span class=\"value\"> (" . (int)$result_value[0]['sdiv_value'] . ")</span></td>" . END_LINE;
    } 
    return $listing;
} 

/**
 * DisplayOneSdi()
 * affichage d'un indicateur et infos résumé
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function DisplayOneSdi($sdi_id, $scale_id)
{
    echo GetSdiTitle($sdi_id, $scale_id);
    echo DisplaySwitchAffichagedet($sdi_id,$scale_id);
    echo GetAllValue($sdi_id, $scale_id);
    echo GetOneSdiInfo($sdi_id);
} 

/**
 * DisplayOneSdirules()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function DisplayOneSdirules($sdi_id, $scale_id)
{
    echo GetSdiTitle($sdi_id, $scale_id);
	echo DisplaySwitchAffichagedet($sdi_id,$scale_id);
	echo GetOneSdiRules($sdi_id);
} 
/**
 * DisplayOneSdievaluation()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function DisplayOneSdievaluation($sdi_id, $scale_id)
{
    echo GetSdiTitle($sdi_id, $scale_id);
	echo DisplaySwitchAffichagedet($sdi_id,$scale_id);
	echo GetOneSdiEvaluation($sdi_id);
} 
/**
 * DisplayOneSdiprovider()
 * affichage d'un indicateur et toutes ses infos
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function DisplayOneSdiprovider($sdi_id, $scale_id)
{
    echo GetSdiTitle($sdi_id, $scale_id);
	echo DisplaySwitchAffichagedet($sdi_id,$scale_id);
    echo GetOneSdiProvider($sdi_id);
} 
/**
 * GetAllValue()
 * afficahge de l'ensemble des valeurs publiques d'un IDD
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function GetAllValue($sdi_id, $scale_id)
{
    $result_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getAllValue("SCD", $scale_id, $sdi_id));
    $result_sdi_value = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdiforvalue($sdi_id));
    $content = '<div id="value">' . END_LINE; 
    $content .= '<h2>'.$GLOBALS['lang']['dashboard']['historic'].'</h2>' . END_LINE;
					$content .= '<div class="switch_affichage" id="threshold_aff">'.$GLOBALS['lang']['sdi']['threshold_value'].' : <span>'.$result_sdi_value[0]['sdii_threshold_value'].' '.$result_sdi_value[0]['sdii_unit'].'</span></div>' . END_LINE;

    if ($result_value <> false) {
        if (count($result_value) > 2) {
            $content .= '<h3  class="semnone">'.$GLOBALS['lang']['dashboard']['rep_graph'].' </h3>' . END_LINE;

            $content .= "<img src=\"../dashboard/graph.php?id=" . $sdi_id . "&amp;scale_id=" . $scale_id . "\"  id=\"imggraph\" class=\"graph\" alt=\"".formatText($GLOBALS['lang']['dashboard']['rep_graph'], '2ATT')."\"/>" . END_LINE;
        }  
        //$content .= '<h3 class="semnone">'.$GLOBALS['lang']['dashboard']['value'].' ('.$GLOBALS['lang']['sdi']['threshold_value'].' : '.$result_sdi_value[0]['sdii_threshold_value'].' '.$result_sdi_value[0]['sdii_unit'].')</h3>' . END_LINE;
$content .= '<h3 class="semnone">'.$GLOBALS['lang']['dashboard']['value'].'</h3>' . END_LINE;

        $content .= '<table cellspacing="0" cellpadding="5" class="table_dashboard_det"  summary="'.$GLOBALS['lang']['dashboard']['all_values_summary'].'">' . END_LINE;
        $content .= '<thead>' . END_LINE;
        $content .= '<tr>' . END_LINE;
        $content .= "<td>".$GLOBALS['lang']['dashboard']['date']."</td>" . END_LINE;
        $content .= "<td>".$GLOBALS['lang']['dashboard']['value']." (".$result_sdi_value[0]['sdii_unit'].")</td>" . END_LINE;
        $content .= "</tr>" . END_LINE;
        $content .= "</thead>" . END_LINE;
        $content .= "<tbody>" . END_LINE;

        for ($i = 0;$i < count($result_value);$i++) {
            $content .= "<tr>" . END_LINE;
            $content .= "<td>" . formatText($result_value[$i]['date_p'], '2HTML') . "</td>" . END_LINE;
            $content .= "<td>" . formatText($result_value[$i]['sdiv_value'], '2HTML') . "</td>" . END_LINE;
            $content .= "</tr>" . END_LINE;
        } 

        $content .= "</tbody>" . END_LINE;
        $content .= "</table>" . END_LINE;
        $content .= '</div>' . END_LINE;
        return $content;
    } 
} 

/**
 * GetSdiTitle()
 * affichage nom d'un indicateur
 * @param $sdi_id
 * @param $scale_id
 * @return 
 **/
function GetSdiTitle($sdi_id, $scale_id)
{
    $data_sdi = $GLOBALS['sql_object'] -> DBSelect(SQL_getOnesdiname($sdi_id));
    $data_scale = $GLOBALS['sql_object'] -> DBSelect(SQL_getonescale($scale_id));
    $sdi_name = formatText($data_sdi[0]['sdii_name'], '2HTML');
	$sdi_description = formatText($data_sdi[0]['sdii_description'], '2HTML');
    $scale_name = formatText(cutText($data_scale[0]['scale_denomination'], 150), '2HTML');
	$content = '<h1>' . $sdi_name . '</h1>' . END_LINE;
	$content .= '<p>' . $sdi_description . '</p>' . END_LINE;
	$content .= '<div id="scale_det" class="switch_affichage"> échelle : <span>' . $scale_name . '</span></div><br />' . END_LINE;
    
    return $content;
} 

/**
 * GetOneSdiInfo()
 * récupération des infos générales d'un indicateur
 * @param $sdi_id
 * @return 
 **/
function GetOneSdiInfo($sdi_id)
{
    $data = $GLOBALS['sql_object'] -> DBSelect(SQL_getInfoSdi($sdi_id));

    $sdi_name = formatText($data[0]['sdii_name'], '2HTML');
    $sdi_theme = formatText(cutText($data[0]['theme_name'], 150), '2HTML');
    $sdi_description = formatText($data[0]['sdii_description'], '2HTML');
    $sdi_comment = formatText($data[0]['sdii_comment'], '2HTML');
    $sdi_goal = formatText($data[0]['sdii_goal'], '2HTML');
    $sdi_consulting = formatText($data[0]['sdii_consulting'], '2HTML');

    $content = '<div id="info">' . END_LINE; 
    // $content.='<h1>'.$sdi_name.'</h1>'.END_LINE;
    $content .= '<h2>'.$GLOBALS['lang']['dashboard']['det_sdi2'].'</h2>' . END_LINE;
    //$content .= '<h3>'.$GLOBALS['lang']['divers']['sousthemeref'].' </h3>' . END_LINE;
    //$content .= '<p>' . $sdi_theme . '</p>' . END_LINE;
    //$content .= '<h3> '.$GLOBALS['lang']['sdi']['description'].'</h3>' . END_LINE;
    //$content .= '<p>' . $sdi_description . '</p>' . END_LINE;
    //$content .= '<h3> '.$GLOBALS['lang']['sdi']['comment'].' </h3>' . END_LINE;
    //$content .= '<p>' . $sdi_comment . '</p>' . END_LINE;
    $content .= '<h3> '.$GLOBALS['lang']['sdi']['goal_public'].' </h3>' . END_LINE;
    $content .= '<p class="consultingp">' . $sdi_goal . '</p>' . END_LINE;
    $content .= '<h3 class="det_valeur" id="consulting">'.$GLOBALS['lang']['sdi']['consulting_public'].'</h3>' . END_LINE;
    $content .= '<p class="consultingp">' . $sdi_consulting . '</p>' . END_LINE;
    $content .= '</div><br />' . END_LINE;
    return $content;
} 

/**
 * GetOneSdiRules()
 * récupération des réglementations d'un indicateur
 * @param $sdi_id
 * @return 
 **/
function GetOneSdiRules($sdi_id)
{
    $result_r = $GLOBALS['sql_object'] -> DBSelect(SQL_getRules($sdi_id, $GLOBALS['sql_object'], -1));
    $r_title = formatText($result_r[0]['sdir_title'], '2HTML');
    $r_body = formatText($result_r[0]['sdir_body'], '2HTML');
    $URL = "<a href=\"" . formatText($result_r[0]['sdir_referer_uri'], '2HTML') . "\" title=\"" . formatText($result_r[0]['sdir_mask_uri'], '2ATT') . "\">" . formatText($result_r[0]['sdir_mask_uri'], '2HTML') . "</a>";

    $content = '<div id="rules">' . END_LINE;
 	$content .= '<h2>'.$GLOBALS['lang']['sdi']['r_body'].'</h2>' . END_LINE;
    if ($result_r[0]['sdir_title'] == "") {
        $content .= "<p class=\"info\">".$GLOBALS['lang']['divers']['nodata']." </p>" . END_LINE;
    } else {
        $content .= "<h3>" . $r_title . "</h3>" . END_LINE;
        $content .= "<p>" . $r_body . "</p>" . END_LINE;
        $content .= "<p>" . $URL . "</p>" . END_LINE;
    } 
    $content .= '</div>' . END_LINE;

    return $content;
} 

/**
 * GetOneSdiEvaluation()
 * récupération des critères d'évaluation d'un indicateur
 * @param $sdi_id
 * @return 
 **/
function GetOneSdiEvaluation($sdi_id)
{
    $result_e = $GLOBALS['sql_object'] -> DBSelect(SQL_getEvaluation($sdi_id, $GLOBALS['sql_object'], -1));

    $content = '<div id="evaluation">' . END_LINE;
    $content .= '<h2>'.$GLOBALS['lang']['sdi']['e_title'].'</h2>' . END_LINE;
    $content .= '<table cellspacing="0" cellpadding="5" class="table_dashboard_det" summary="'.$GLOBALS['lang']['dashboard']['evaluation_values_summary'].'">' . END_LINE;
    $content .= '<thead>' . END_LINE;
    $content .= '<tr>' . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_scale_compare']."</td>" . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_fiability']."</td>" . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_accessibility']."</td>" . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_lisibility']."</td>" . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_relevance']."</td>" . END_LINE;
    $content .= "<td>".$GLOBALS['lang']['sdi']['e_global_performance']."</td>" . END_LINE;
    $content .= "</tr>" . END_LINE;
    $content .= "</thead>" . END_LINE;
    $content .= "<tbody>" . END_LINE;
    $content .= "<tr>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_scale_compare'] . "</td>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_fiability'] . "</td>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_accessibility'] . "</td>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_lisibility'] . "</td>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_relevance'] . "</td>" . END_LINE;
    $content .= "<td>" . $result_e[0]['sdie_global_performance'] . "</td>" . END_LINE;
    $content .= "</tr>" . END_LINE;
    $content .= "</tbody>" . END_LINE;
    $content .= "</table>" . END_LINE;
    $content .= '</div>' . END_LINE;

    return $content;
} 

/**
 * GetOneSdiProvider()
 * récupération des infos du fournisseurs d'un indicateur
 * @param $sdi_id
 * @return 
 **/
function GetOneSdiProvider($sdi_id)
{
    $result_p = $GLOBALS['sql_object'] -> DBSelect(SQL_getProvider($sdi_id, $GLOBALS['sql_object'], -1));

    $p_name = formatText($result_p[0]['sdip_name'], '2HTML');
    $p_description = formatText($result_p[0]['sdip_description'], '2HTML');
        
		$content = '<div id="provider">' . END_LINE;
        $content .= '<h2>'.$GLOBALS['lang']['sdi']['p_title'].'</h2>' . END_LINE;
    if ($result_p[0]['sdip_name'] == "") {
        $content .= "<p class=\"info\">".$GLOBALS['lang']['divers']['nodata']." </p>" . END_LINE;
    } else {
        $content .= '<p>' . $p_name . '</p>' . END_LINE;
        $content .= '<p>' . $p_description . '</p>' . END_LINE;
        $content .= '</div>' . END_LINE;
    } 
    return $content;
} 

/**
 * DisplaySwitchAffichage()
 * affichage du switch entre classique et jeune public
 * @param $scale_id
 * @return 
 **/
function DisplaySwitchAffichage($scale_id)
{
    $link_aff_classic = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'], 'id' => $scale_id));
    $link_aff_young = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd-anim']['linkvalue'], 'id' => $scale_id));
    $content = '<div id="switch_aff" class="switch_affichage">' . END_LINE;
    $content .= '<span>'.$GLOBALS['lang']['dashboard']['mode_aff'].' : </span>';
    if ($GLOBALS['links'][$GLOBALS['activeitem']]['linkvalue'] == $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'])
        $content .= '<span class="mod_aff">'.$GLOBALS['lang']['dashboard']['mode_aff_class'].'</span> ' . END_LINE;
    else $content .= '<a href="' . $link_aff_classic . '" title="'.formatText($GLOBALS['lang']['dashboard']['mode_aff_class'], '2ATT').'" >'.$GLOBALS['lang']['dashboard']['mode_aff_class'].'</a> ' . END_LINE;
    if ($GLOBALS['links'][$GLOBALS['activeitem']]['linkvalue'] == $GLOBALS['links']['tableau-de-bord-idd-anim']['linkvalue'])
        $content .= '<span class="mod_aff">'.$GLOBALS['lang']['dashboard']['mode_aff_young'].'</span> ' . END_LINE;
    else $content .= '<a href="' . $link_aff_young . '" title="'.formatText($GLOBALS['lang']['dashboard']['mode_aff_young'], '2ATT').'" >'.$GLOBALS['lang']['dashboard']['mode_aff_young'].'</a> ' . END_LINE;
    $content .= '</div>' . END_LINE;
    return $content;
} 

/**
 * DisplaySwitchAffichagedet()
 * affichage du switch entre infos résumé et détaillées
 * @param $scale_id
 * @return 
 **/
function DisplaySwitchAffichagedet($sdi_id,$scale_id)
{

 $link_aff_info = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'],'id' => $sdi_id, 'parentid' => $scale_id));
    $link_aff_rules = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd-reglementation']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id));
   
    $link_aff_provider = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd-fournisseur']['linkvalue'],'id' => $sdi_id, 'parentid' => $scale_id));
    $link_aff_evaluation = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd-evaluation']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id));
   


$content ="<div class=\"barre_list\" id=\"barre_dashboard\">". END_LINE;
$content .="<ul>". END_LINE;
$content .="<li>". END_LINE;
$content .= '<a href="' . $link_aff_info . '" title="'.formatText($GLOBALS['lang']['dashboard']['mode_aff_info'], '2ATT').'" >'.$GLOBALS['lang']['dashboard']['mode_aff_info'].'</a> ' . END_LINE;
$content .="</li>". END_LINE;
$content .="<li>". END_LINE;
$content .= '<a href="' . $link_aff_rules . '" title="'.formatText($GLOBALS['lang']['dashboard']['mode_aff_rules'], '2ATT').'" class="barre_dash_a" >'.$GLOBALS['lang']['dashboard']['mode_aff_rules'].'</a> ' . END_LINE;
$content .="</li>". END_LINE;
$content .="<li>". END_LINE;
$content .= '<a href="' . $link_aff_provider . '" title="'.$GLOBALS['lang']['dashboard']['mode_aff_provider'].'" class="barre_dash_a" >'.$GLOBALS['lang']['dashboard']['mode_aff_provider'].'</a> ' . END_LINE;
$content .="</li>". END_LINE;
$content .="<li>". END_LINE;
$content .= '<a href="' . $link_aff_evaluation . '" title="'.formatText($GLOBALS['lang']['dashboard']['mode_aff_evaluation'], '2ATT').'" class="barre_dash_a" >'.$GLOBALS['lang']['dashboard']['mode_aff_evaluation'].'</a> ' . END_LINE;
$content .="</li>". END_LINE;
$content .="</ul>". END_LINE;
$content .="</div>". END_LINE;
/*
    $link_aff_classic = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'],'id' => $sdi_id, 'parentid' => $scale_id));
    $link_aff_young = HrefMaker(array('rub' => $GLOBALS['links']['tableau-de-bord-idd-detail']['linkvalue'], 'id' => $sdi_id, 'parentid' => $scale_id));
    $content = '<div id="switch_det" class="switch_affichage">' . END_LINE;
    if ($GLOBALS['links'][$GLOBALS['activeitem']]['linkvalue'] == $GLOBALS['links']['tableau-de-bord-idd']['linkvalue'])
        $content .= '<span class="mod_aff">'.$GLOBALS['lang']['dashboard']['mode_aff_res'].'</span> ' . END_LINE;
    else $content .= '<a href="' . $link_aff_classic . '" title="'.$GLOBALS['lang']['dashboard']['mode_aff_res'].'" >'.$GLOBALS['lang']['dashboard']['mode_aff_res'].'</a> ' . END_LINE;
    if ($GLOBALS['links'][$GLOBALS['activeitem']]['linkvalue'] == $GLOBALS['links']['tableau-de-bord-idd-detail']['linkvalue'])
        $content .= '<span class="mod_aff">'.$GLOBALS['lang']['dashboard']['mode_aff_det'].'</span> ' . END_LINE;
    else $content .= '<a href="' . $link_aff_young . '" title="'.$GLOBALS['lang']['dashboard']['mode_aff_det'].'" >'.$GLOBALS['lang']['dashboard']['mode_aff_det'].'</a> ' . END_LINE;
    $content .= '</div>' . END_LINE;
	* */
    return $content;
} 


/**
 * DisplayYoung()
 * affichage du tableau de bord jeune public
 * @return 
 **/
function DisplayYoung()
{
$content='<div id="anim_dashboard"><object type="application/x-shockwave-flash" data="../dashboard/dashboard.swf" width="506" height="414">
<param name="movie" value="../dashboard/dashboard.swf" />
<a href="http://www.macromedia.com/shockwave/download/download.cgi?P1_Prod_Version=ShockwaveFlash&amp;Lang=French&amp;P5_Language=French" title="téléchargez le plug-in flash pour voir l\'animation flash associé aux indicateurs de développement durable"><img src="../gfx/default/images/public/avertissement.png" width="522" height="427" alt="animation flash de mise en place et consultation des indicateurs de développement durable" /></a>
</object></div>';
    return $content;
} 


?>

