<?php
/**
* ActiveItem()
* Détermine l'item actif et le place en var global
* 
* @return void 
*/
function ActiveItem()
{
    if (array_key_exists('rub', $_REQUEST)) $GLOBALS['activeitem'] = $_REQUEST['rub'];
} 

/**
* MyAccount()
* Renvoie les liens de creation de compte ou de déconnexion
* suivant le statut de l'utilisateur
* 
* @return string content
*/
function MyAccount()
{
    $link_account = array('rub' => $GLOBALS['links']['prefs-utilisateur']['linkvalue']);
	$content  = '<div id="myaccount">' . END_LINE;
	$content .= '<div id="tologin">' . END_LINE;
    $content .= '<a href="' . HrefMaker($link_account) . '" accesskey="u" title="'.$GLOBALS['lang']['header']['myaccount_title'].'"><img src="../gfx/linea21/images/public/menu_myaccount.png" alt="'.$GLOBALS['lang']['header']['myaccount_title'].'" /><span>' . $GLOBALS['lang']['header']['myaccount'] . '</span></a>';
	$content .= '</div>' . END_LINE;
	$link_create = array('rub' => $GLOBALS['links']['inscription-utilisateur']['linkvalue']);
    $link_logout = array('rub' => $GLOBALS['links']['deconnexion']['linkvalue']);
	$content .= '<div id="logout">' . END_LINE;
    if (isset($_COOKIE['linea21']['whois'])) $content .= '<a href="' . HrefMaker($link_logout) . '" accesskey="l" title="'.$GLOBALS['lang']['header']['deconnexion_title'].'">' . $GLOBALS['lang']['header']['deconnexion'] . '</a>';
    else $content .= '<a href="' . HrefMaker($link_create) . '" accesskey="c" title="'.$GLOBALS['lang']['divers']['user_inscription_title'].'">' . $GLOBALS['lang']['divers']['user_inscription'] . '</a>';
    $content .= '</div>' . END_LINE;
	$content .= '</div>' . END_LINE;
	
	echo $content;
}

/**
* AuthForm()
* Formulaire d'authentification pour login ou inscription
* 
* @param string $todo 
* @return void (echo string)
*/
function AuthForm($todo = 'LOGON')
{
    $action = $_SERVER['PHP_SELF'];
    if ($todo == 'LOGON') {
        $input_hidden = $GLOBALS['links']['prefs-utilisateur']['linkvalue'];
        $div_id = 'logon';
    } else {
        $input_hidden = $GLOBALS['links']['inscription-utilisateur']['linkvalue'];
        $div_id = 'subscribe';
    } 
    $form = '<form action="' . $action . '" method="post">' . END_LINE;
    $form .= '<div id="' . $div_id . '">' . END_LINE;
    $form .= '<label for="login" class="labelised">' . $GLOBALS['lang']['divers']['login'] . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="20" class="shorttextfield" name="login" id="login" />' . END_LINE;
	$form .= '<br />'.END_LINE;
    if ($todo == 'LOGON') {
        $form .= '<label for="password" class="labelised">' . $GLOBALS['lang']['divers']['password'] . ' : </label>' . END_LINE;
        $form .= '<input type="password" maxlength="20" class="shorttextfield" name="password" id="password" />' . END_LINE;
    } else {
        $form .= '<label for="email" class="labelised">' . $GLOBALS['lang']['divers']['email'] . ' : </label>' . END_LINE;
        $form .= '<input type="text" maxlength="100" class="shorttextfield" name="email" id="email" />' . END_LINE;
    } 
	$form .= '<br />'.END_LINE;
    $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . END_LINE;
	$form .= '<input type="image" src="../gfx/linea21/images/public/btn_go.gif" value="valider" alt="valider" title="valider" size="15" name="valid" id="valid" style="margin-left:30em" />'.END_LINE;
    $form .= '</div>' . END_LINE;
    $form .= '</form>' . END_LINE;

    echo $form;
} 

/**
* DisplayHTMLTitle()
* Affichage du titre de la page courante
* 
* @return void ( echo string )
*/
function DisplayHTMLTitle()
{
    echo SITE_CITY_NAME . ' - ' . $GLOBALS['links'][$GLOBALS['activeitem']]['title'];
} 

/**
* DisplayMenu()
* Affichage du menu
* 
* @return void ( echo string )
*/
function DisplayMenu()
{
    $content = '<div id="menu">'.END_LINE;
	$content .= '<a href="#contenu" class="semnone" title="'.$GLOBALS['lang']['header']['goto_contents'].'" accesskey="2">'.$GLOBALS['lang']['header']['goto_contents'].'</a>'.END_LINE;
    $content .= '<ul>'.END_LINE;
    while (list($key,) = each ($GLOBALS['menuitems'])) {
        $key == AliasActiveItems($GLOBALS['activeitem']) ? $classe = ' class="actif"' : $classe = '' ;
		$current_link = array('rub' => $GLOBALS['links'][$key]['linkvalue']);
        $content .= '<li id="'.$GLOBALS['menuitems'][$key]['css_id'].'">';
        $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][$key]['desc'] . '" accesskey="' . $GLOBALS['menuitems'][$key]['accesskey'] . '" id="a'.$GLOBALS['menuitems'][$key]['css_id'].'"'.$classe.'>' . $GLOBALS['menuitems'][$key]['name'] . '</a>';
        $content .= '</li>' . END_LINE;
    } 
    $content .= "</ul>";
    $content .= "</div>";
    echo $content;
}

/**
 * HrefMaker()
 * Fabrique un lien en suivant au besoin les règles de l'url_rewriting
 * 
 * @param array $var_table
 * @return string $url_maked
 **/
function HrefMaker($var_table)
{
    $url_maked = '';

    if (defined("MOD_REWRITE") && MOD_REWRITE === true) {
        if (array_key_exists('rub', $var_table)) {
            $url_maked .= $var_table['rub'];
        } 
        if (array_key_exists('filter', $var_table)) {
            $url_maked .= URI_SEPARATOR . $var_table['filter'];
        } 
        if (array_key_exists('id', $var_table)) {
            $url_maked .= URI_SEPARATOR . $var_table['id'];
        } 
        if (array_key_exists('parentid', $var_table)) {
            $url_maked .= URI_SEPARATOR . $var_table['parentid'];
        } 
        if (array_key_exists('parentparentid', $var_table)) {
            $url_maked .= URI_SEPARATOR . $var_table['parentparentid'];
        } 
        if (array_key_exists('debut', $var_table)) {
            $url_maked .= URI_SEPARATOR . $var_table['debut'];
        } 
        $url_maked .= '.html';
    } else {
        if (function_exists('http_build_query')) $url_string = http_build_query($var_table);
        else {
            $url_string = '';
            $sep = '';
            while (list($key, $value) = each ($var_table)) {
                if (!empty($value)) {
                    $url_string .= $sep . $key . '=' . $value;
                    $sep = OUTPUT_SEP;
                } 
            } 
        } 
        $url_maked = 'index.php?' . $url_string;
    } 
    return $url_maked;
} 


/**
 * DisplayTemplate()
 * Fait l'include du template désiré
 * 
 * @return void --> include
 **/
function DisplayTemplate()
{
    foreach ($GLOBALS['links'] as $key => $value) {
        if ($GLOBALS['links'][$key]['linkvalue'] == $GLOBALS['activeitem']) {
            $current_template = $GLOBALS['links'][$key]['template'];
        } 
    } 
    include_once('tpl_' . $current_template . '.php');
} 


/**
 * AliasActiveItems()
 * Retourne l'item actif
 * 
 * @param string $item
 * @return string item actif ou boolean false
 **/
function AliasActiveItems($item)
{
    foreach ($GLOBALS['links'] as $key => $value) {
        if ($GLOBALS['links'][$key]['linkvalue'] == $item) {
            if ($GLOBALS['links'][$key]['alias'] === false) return $GLOBALS['links'][$key]['linkvalue'];
            else return $GLOBALS['links'][$key]['alias'];
        } 
    } 
} 

/**
 * Display_linkin_page()
 * 
 * @param array $table_link
 * @param integer $total
 * @param integer $debut
 * @param integer $pas
 * @return void  (echo)
 **/
function Display_linkin_page($table_link, $total, $debut, $pas = SELECT_LIMIT)
{
    $result = ceil($total / $pas);
    if ($result <= 1) return '&nbsp;';
    else {
        $link = '<div class="lienliste">'.END_LINE;
		$link .= '&lt; &lt; ';
		$sep='';
        for($i = 0; $i < $result; $i++) {
            $current_pos = ($pas * $i);
            if ($debut == $current_pos) $link .= $sep."<span>" . ($i + 1) . "</span> \n";
            else {
                $array_pos = array ('debut' => $current_pos);
                $new_table_link = array_merge ($table_link, $array_pos);
                $link .= $sep.'<a href=" '. HrefMaker($new_table_link) . '">' . ($i + 1) . '</a>'.END_LINE;
            }
			$sep=' | ';
        } 
		$link .= ' &gt; &gt;';
        $link .= '</div>'.END_LINE;
        echo $link;
    } 
} 

?>