<?php

/**
* IncludeLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie publique )
* 
* @return void (include)
*/
function IncludeLang()
{
    include_once('../languages/' . LANGUAGE . '/lang_common.' . CHARSET . '.php');

    if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['annuaire']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_yellowpages.' . CHARSET . '.php');
    }
    if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['tableau-de-bord-idd']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_sdi.' . CHARSET . '.php');
		include_once('../languages/' . LANGUAGE . '/lang_dashboard.' . CHARSET . '.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['groupe-de-travail']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_workshop.' . CHARSET . '.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['dossier']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_publication.' . CHARSET . '.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['prefs-utilisateur']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_user.' . CHARSET . '.php');
    }
    if ($GLOBALS['activeitem'] == $GLOBALS['links']['actualite']['linkvalue'] || $GLOBALS['activeitem'] == $GLOBALS['links']['actualite-archives']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_news.' . CHARSET . '.php');
    }
	if ($GLOBALS['activeitem'] == $GLOBALS['links']['abonnement-newsletter']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_newsletter.' . CHARSET . '.php');
    } 
    if ($GLOBALS['activeitem'] == $GLOBALS['links']['rapport']['linkvalue'] || $GLOBALS['activeitem'] == $GLOBALS['links']['rapport-partie']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_workshoprep.' . CHARSET . '.php');
		include_once('../languages/' . LANGUAGE . '/lang_publication.' . CHARSET . '.php');
    }
	if (AliasActiveItems($GLOBALS['activeitem']) == $GLOBALS['links']['recherche']['linkvalue']) {
		include_once('../languages/' . LANGUAGE . '/lang_search.' . CHARSET . '.php');
    }

    $GLOBALS['lang'] = $lang;
} 

/**
* IncludeAdminLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie admin )
* 
* @return void (include)
*/
function IncludeAdminLang($rubrique)
{
    include_once('../languages/' . LANGUAGE . '/lang_common.' . CHARSET . '.php');
    include_once('../languages/' . LANGUAGE . '/lang_' . $rubrique . '.' . CHARSET . '.php');

    if ($rubrique === 'dashboard') {
        include_once('../languages/' . LANGUAGE . '/lang_sdi.' . CHARSET . '.php');
    } 
    if ($rubrique === 'sdi') {
        include_once('../languages/' . LANGUAGE . '/lang_dashboard.' . CHARSET . '.php');
    } 

    $GLOBALS['lang'] = $lang;
} 

?>