<?php
include_once('../news/' . SQL . '.inc.php');

/**
* DisplayListNews()
* Affichage de la liste des news publique
* 
* @param  $statut 
* @param  $filter 
* @param  $id_filter 
* @param  $debut 
* @return void echo content
*/
function DisplayListNews($statut, $filter, $id_filter, $debut)
{
    if ($statut == 'public') {
        $pas = 100;
        $suffix = '';
    } else $pas = SELECT_LIMIT;
    if ($statut == 'archives_p') $suffix = ' "'.strtolower($GLOBALS['lang']['statut']['PA']).'"';
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getNewsList($debut, $pas, $statut, $filter, $id_filter));
    $datacount = $GLOBALS['sql_object']->DBSelect(SQL_getCountNewsList($statut, $filter, $id_filter));
    $bdd_nb_com = $datacount[0]['num_rows'];
    $bdd_nb_com_display = '<p>' . $bdd_nb_com . ' ' . $GLOBALS['lang']['news']['name2'] . $suffix . '</p>' . END_LINE;
    $content = '<h1 class="semnone">' . $GLOBALS['lang']['news']['list'] . '</h1>' . END_LINE;
    if ($data != 0) {
        // echo $bdd_nb_com_display;	// affichage du nombre d'enregistrements
		$current_link = array('rub' => $GLOBALS['links']['actualite-archives']['linkvalue']);
        Display_linkin_page($current_link, $bdd_nb_com, $debut, $pas);
        for($i = 0; $i < count($data); $i++) {
            $link_detail = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'id' => $data[$i]['news_id']);
            $link_theme = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['theme']['linkvalue'], 'id' => $data[$i]['sdtheme_id']);
            $link_level = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['niveau']['linkvalue'], 'id' => $data[$i]['news_level']);
            $link_scale = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['echelle']['linkvalue'], 'id' => $data[$i]['news_scale']);
            $link_user = array('rub' => $GLOBALS['links']['profil-utilisateur']['linkvalue'], 'id' => $data[$i]['news_posted_by']);
            $news_title = formatText($data[$i]['complete_news_title'], '2HTML');
            $news_header = formatText(cutText($data[$i]['news_header'], 300), '2HTML');
            $news_sdtheme = formatText($data[$i]['sdtheme_name'], '2HTML');
            $level_name = formatText($data[$i]['level_name'], '2HTML');
            $scale_denomination = formatText($data[$i]['scale_denomination'], '2HTML');
            $news_posted_on = formatText($data[$i]['news_published_date_display'], '2HTML');
            $news_posted_by = formatText($data[$i]['user_login'], '2HTML');

            $content .= '<h2 class="nobottommargin"><a href="' . HrefMaker($link_detail) . '" title="' . formatText($news_title, '2ATT') . '">' . $news_title . '</a>' . END_LINE; 
			$content .= '</h2>' . END_LINE;
			$content .= '<p class="published_by">' . END_LINE;
            $content .= $GLOBALS['lang']['statut']['published_on'] . ' ' . $news_posted_on . ' ';
            $content .= $GLOBALS['lang']['divers']['by'].' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links']['profil-utilisateur']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
            $content .= '</p>' . END_LINE;
			
            $content .= '<p class="list_textcontent">' . $news_header . '</p>' . END_LINE;
            $content .= '<p class="filter_info">';
			$content .= $GLOBALS['lang']['divers']['level'] . ' : ';
			$content .= '<a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filter']['niveau']['desc'] . ' : ' . formatText($level_name, '2ATT') . '" class="filter_info_level">' . $level_name . '</a> ' . END_LINE;
			$content .= $GLOBALS['lang']['divers']['themeref'] . ' : ';
            $content .= ' <a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filter']['theme']['desc'] . ' : ' . formatText($news_sdtheme, '2ATT') . '" class="filter_info_theme">' . $news_sdtheme . '</a>' . END_LINE;
			$content .= $GLOBALS['lang']['divers']['scale'] . ' : ';
            $content .= ' <a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filter']['echelle']['desc'] . ' : ' . formatText($scale_denomination, '2ATT') . '" class="filter_info_scale">' . $scale_denomination . '</a></p>' . END_LINE;
            if($i<count($data)-1) $content .= '<hr />' . END_LINE;
        } 
    } else {
        $content .= '<p class="info">' . $GLOBALS['lang']['divers']['nodata'] . '</p>';
    } 

    echo $content;
} 

/**
* DisplayOneNews()
* Affichage d'une actualté en détail
* 
* @param  $news_id 
* @return $stat Nom du statut + echo content
*/
function DisplayOneNews($news_id)
{
    $data = $GLOBALS['sql_object']->DBSelect(SQL_getoneCompleteNews($news_id));
    $content = '';
    if (count($data) != 1) exit;
    else {
        $link_theme = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['theme']['linkvalue'], 'id' => $data[0]['theme_sd_theme']);
        $link_level = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['niveau']['linkvalue'], 'id' => $data[0]['news_level']);
        $link_scale = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'filter' => $GLOBALS['filter']['echelle']['linkvalue'], 'id' => $data[0]['news_scale']);
        $link_user = array('rub' => $GLOBALS['links']['profil-utilisateur']['linkvalue'], 'id' => $data[0]['news_posted_by']);
        $news_title = formatText($data[0]['news_title'], '2HTML');
        $news_header = linkin_content(formatText($data[0]['news_header'], '2HTML'));
        $news_body = linkin_content(formatText($data[0]['news_body'], '2HTML'));
        $news_template = $data[0]['news_template'];
        $news_photo_uri = $data[0]['news_photo_uri'];
        $news_sdtheme = formatText($data[0]['sdtheme_name'], '2HTML');
        $news_scale_denomination = formatText($data[0]['scale_denomination'], '2HTML');
        $news_theme = formatText($data[0]['theme_name'], '2HTML');
        $news_level = formatText($data[0]['level_name'], '2HTML');
        $news_posted_on = formatText($data[0]['news_published_date_display'], '2HTML');
        $news_modify_on = formatText($data[0]['news_last_modify_display'], '2HTML');
        $news_posted_by = formatText($data[0]['user_login'], '2HTML');
        $news_statut = $data[0]['news_statut'];

        $contents = TemplateFormat($news_title, $news_header, $news_body, $news_template, $news_photo_uri);

        $content .= '<h1 class="nobottommargin">' . $news_title . '</h1>' . END_LINE;
		$content .= '<p class="published_by">' . END_LINE;
        $content .= $GLOBALS['lang']['statut']['published_on'] . ' ' . $news_posted_on . ' ';
        $content .= $GLOBALS['lang']['divers']['by'].' <a href="' . HrefMaker($link_user) . '" title="' . $GLOBALS['links']['profil-utilisateur']['desc'] . ' (' . $news_posted_by . ')">' . $news_posted_by . '</a>';
        if ($news_statut == 'PA') {
            $content .= ' (' . $GLOBALS['lang']['statut']['archived_on'] . ' ' . $news_modify_on . ')';
        }
		$content .= '</p>' . END_LINE;
		
        $content .= $contents;
        
        $content .= '<p class="filter_info">' . END_LINE;
		$content .= $GLOBALS['lang']['divers']['level'] . ' : ';
		$content .= '<a href="' . HrefMaker($link_level) . '" title="' . $GLOBALS['filter']['niveau']['desc'] . ' : ' . formatText($news_level, '2ATT') . '" class="filter_info_level">' . $news_level . '</a> ' . END_LINE;
        $content .= ' ' . $GLOBALS['lang']['divers']['themeref'] . ' : ';
		$content .= '<a href="' . HrefMaker($link_theme) . '" title="' . $GLOBALS['filter']['theme']['desc'] . ' : ' . formatText($news_sdtheme, '2ATT') . '" class="filter_info_theme">' . $news_sdtheme . '</a> ';
		//$content .= ' '.$GLOBALS['lang']['divers']['sousthemeref'] . ' :';
		//$content .= $news_theme . END_LINE;
        $content .= ' ' . $GLOBALS['lang']['divers']['scale'] . ' : ';
		$content .= '<a href="' . HrefMaker($link_scale) . '" title="' . $GLOBALS['filter']['echelle']['desc'] . ' : ' . formatText($news_scale_denomination, '2ATT') . '" class="filter_info_scale">' . $news_scale_denomination . '</a>' . END_LINE;
        $content .= '</p>' . END_LINE;
    } 
    echo $content;
    return GetStatutName($news_statut);
} 

/**
* GetStatutName()
* 
* @param  $statut 
* @return $stat Nom du statut
*/
function GetStatutName($statut)
{
    switch ($statut) {
        case 'P':
            $stat = 'public';
            break;
        case 'PA':
            $stat = 'archives_p';
            break;
        case 'AA':
            $stat = 'archives_a';
            break;
        default:
            $stat = 'public';
    } 
    return $stat;
} 

/**
* DisplayLinkNews()
* Affiche ou non 1 lien vers les news a venir ou qui précéde.
* 
* @param  $current_news 
* @param  $direction 
* @param  $statut 
* @return echo content
*/
function DisplayLinkNews($current_news, $direction, $statut)
{
    if ($direction == 'NEXT') {
        $requete = SQL_getNextNews($current_news, $statut);
        $class = 'next';
        $prefix = '&gt; &gt; ';
        $suffix = '';
        $title = $GLOBALS['lang']['news']['next_news'];
    } 
    if ($direction == 'PREVIOUS') {
        $requete = SQL_getPreviousNews($current_news, $statut);
        $class = 'previous';
        $prefix = '';
        $suffix = ' &lt; &lt;';
        $title = $GLOBALS['lang']['news']['prev_news'];
    } 
    $data = $GLOBALS['sql_object']->DBSelect($requete);

    if ($data == false || count($data) != 1) $content = '';
    else {
        $link_news = array('rub' => $GLOBALS['links']['actualite']['linkvalue'], 'id' => $data[0]['news_id']);
		$news_complete_title = formatText($data[0]['news_title'], '2HTML');
        $news_title = formatText(cutText($data[0]['news_title'], 45), '2HTML');

        $content = '<div class="' . $class . '">' . END_LINE;
		$content .= $prefix . END_LINE;
        $content .= '<a href="' . HrefMaker($link_news) . '" title="' . $title .' : '.formatText($news_complete_title, '2ATT'). '">' . $news_title .'</a>';
		$content .= $suffix . END_LINE;
        $content .= '</div>' . END_LINE;
    } 
    echo $content;
} 

/**
* TemplateFormat()
* Mise en page de l'actualité suivant son format
* 
* @param  $title 
* @param  $header 
* @param  $body 
* @param  $template 
* @param  $photouri 
* @return $content
*/
function TemplateFormat($title, $header, $body, $template, $photouri)
{ 
    // '3' Template 2 photos
    if ($template == 3) {
        list($photo1_src, $photo2_src) = GetAllPhotoUri($photouri);
        list($body, $body2) = cutBody($body);
    } 
    if ($template == 1 || $template == 2) list($photo1_src) = GetAllPhotoUri($photouri);
    if ($template == 1) $style = ' class="tplimgleft"';
    if ($template == 2 || $template == 3) $style = ' class="tplimgright"';

    $content = '<div>';
    if ($template != 4) $content .= EnlargeImage('../' . $photo1_src, $style, 'visuel ' . $title);
    $content .= '<p class="chapo">' . $header . '</p>' . END_LINE;
    $content .= '<p class="textcontent">' . $body . '</p>' . END_LINE;
    if ($template == 3) {
        $style = ' class="tplimgleft"';
        $content .= EnlargeImage('../' . $photo2_src, $style, 'visuel ' . $title);
        $content .= '<p class="textcontent">' . $body2 . '</p>' . END_LINE;
    } 
    $content .= '</div>';
    $content .= '<br style="clear:both" />';

    return $content;
} 

?>

