ALTER TABLE news ADD COLUMN idxFTI tsvector;
UPDATE news SET idxFTI=to_tsvector('default',coalesce(news_title,'') ||' '|| coalesce(news_header,'') ||' '|| coalesce(news_body,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_news ON news USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON news
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, news_title, news_header, news_body);



ALTER TABLE newsletter ADD COLUMN idxFTI tsvector;
UPDATE newsletter SET idxFTI=to_tsvector('default',coalesce(newsletter_title,'') ||' '|| coalesce(newsletter_body,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_newsletter ON newsletter USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON newsletter
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, newsletter_title, newsletter_body);


ALTER TABLE publication ADD COLUMN idxFTI tsvector;
UPDATE publication SET idxFTI=to_tsvector('default',coalesce(publi_title,'') ||' '|| coalesce(publi_resume,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_publication ON publication USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON publication
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, publi_title, publi_resume);


ALTER TABLE publication_contents ADD COLUMN idxFTI tsvector;
UPDATE publication_contents SET idxFTI=to_tsvector('default',coalesce(publicon_title,'') ||' '|| coalesce(publicon_body,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_publication_contents ON publication_contents USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON publication_contents
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, publicon_title, publicon_body);


ALTER TABLE sdi_info ADD COLUMN idxFTI tsvector;
UPDATE sdi_info SET idxFTI=to_tsvector('default',coalesce(sdii_name,'') ||' '|| coalesce(sdii_description,'') ||' '|| coalesce(sdii_goal,'') ||' '|| coalesce(sdii_consulting,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_sdi_info ON sdi_info USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON sdi_info
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, sdii_name, sdii_description, sdii_goal, sdii_consulting);


ALTER TABLE workshop ADD COLUMN idxFTI tsvector;
UPDATE workshop SET idxFTI=to_tsvector('default',coalesce(workshop_denomination,'') ||' '|| coalesce(workshop_resume,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_workshop ON workshop USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON workshop
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, workshop_denomination, workshop_resume);


ALTER TABLE workshop_calendar ADD COLUMN idxFTI tsvector;
UPDATE workshop_calendar SET idxFTI=to_tsvector('default',coalesce(workcal_task,'') ||' '|| coalesce(workcal_task_details,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_workshop_calendar ON workshop_calendar USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON workshop_calendar
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, workcal_task, workcal_task_details);


ALTER TABLE workshop_com ADD COLUMN idxFTI tsvector;
UPDATE workshop_com SET idxFTI=to_tsvector('default',coalesce(workcom_subject,'') ||' '|| coalesce(workcom_body,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_workshop_com ON workshop_com USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON workshop_com
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, workcom_subject, workcom_body);


ALTER TABLE workshop_report ADD COLUMN idxFTI tsvector;
UPDATE workshop_report SET idxFTI=to_tsvector('default',coalesce(workrep_title,'') ||' '|| coalesce(workrep_resume,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_workshop_report ON workshop_report USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON workshop_report
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, workrep_title, workrep_resume);


ALTER TABLE workshop_report_contents ADD COLUMN idxFTI tsvector;
UPDATE workshop_report_contents SET idxFTI=to_tsvector('default',coalesce(workrepcon_title,'') ||' '|| coalesce(workrepcon_body,''));
VACUUM FULL ANALYZE;
CREATE INDEX idxFTI_workshop_report_contents ON workshop_report_contents USING gist(idxFTI);
VACUUM FULL ANALYZE;
CREATE TRIGGER tsvectorupdate BEFORE UPDATE OR INSERT ON workshop_report_contents
FOR EACH ROW EXECUTE PROCEDURE
tsearch2(idxFTI, workrepcon_title, workrepcon_body);