<?php
include_once('../workshop/'.SQL.'.inc.php');
/**
 * DisplayUrlAllCalendar()
 * affichage de l'URL de détails d'un calendrier
 * @param $workshop_id
 * @return 
 **/
function DisplayUrlAllCalendar($workshop_id) {
			$link_table= array('rub'=> $GLOBALS['links']['calendrier']['linkvalue'],'id'=>$workshop_id);
	$content='<p>'.END_LINE;
	$content.='<a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['lang']['workshop']['cal_all'], '2ATT').'">'.$GLOBALS['lang']['workshop']['cal_all'].'</a>'.END_LINE;
	$content.='</p>'.END_LINE;
	echo $content;
}

/**
 * DisplayUrlInscription()
 * affichage de l'URL d'inscription au groupe de travail
 * @param $workshop_id
 * @param $testcookie
 * @return 
 **/
function DisplayUrlInscription($workshop_id, $testcookie) {
			$link_table= array('rub'=> $GLOBALS['links']['inscription-groupe-de-travail']['linkvalue'],'id'=>$workshop_id);
			$link_table2= array('rub'=> $GLOBALS['links']['prefs-utilisateur']['linkvalue']);
	
	if (!isset($_COOKIE['linea21'])) {
	$content='<div class="info">'.$GLOBALS['lang']['divers']['noauth'].''.END_LINE;
	$content.='<br />'.$GLOBALS['lang']['divers']['creaauth'].' : '.END_LINE;
	$content.='<a href="'.HrefMaker($link_table2).'" title="'.formatText($GLOBALS['lang']['divers']['auth'], '2ATT').'" >'.$GLOBALS['lang']['divers']['auth'].'</a>'.END_LINE;
	$content.='</div>'.END_LINE;
	}
	else{
	if ($testcookie<>true) {
	$content='<div class="info">'.$GLOBALS['lang']['workshop']['noinscription'].''.END_LINE;
	$content.='<br />'.$GLOBALS['lang']['workshop']['creainscription2'].' : '.END_LINE;
	$content.='<a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['lang']['workshop']['creainscription'], '2ATT').'" onclick="return window.confirm(\''.$GLOBALS['lang']['workshop']['creainscription3'].'\')" >'.$GLOBALS['lang']['workshop']['creainscription'].'</a></div>'.END_LINE; 
	}
	}
	echo $content;
}

/**
 * DisplayUrlDiscussion()
 * affichage URL pour accéder aux discussions
 * @param $work_id
 * @param $contenu
 * @return 
 **/
function DisplayUrlDiscussion($work_id, $contenu) {
			$link_table= array('rub'=> $GLOBALS['links']['discussion']['linkvalue'],'id'=>$work_id);
	$content='<a href="'.HrefMaker($link_table).'" title="'.formatText($contenu, '2ATT').'" id="barre_discussion" >'.$contenu.'</a>'.END_LINE;
	echo $content;
}
/**
 * DisplayUrlCalendar()
 * affichage URL pour accéder aux calendrier
 * @param $work_id
 * @param $contenu
 * @return 
 **/
function DisplayUrlCalendar($work_id, $contenu) {
			$link_table= array('rub'=> $GLOBALS['links']['calendrier']['linkvalue'],'id'=>$work_id);
	$content='<a href="'.HrefMaker($link_table).'" title="'.formatText($contenu, '2ATT').'" id="barre_calendar" >'.$contenu.'</a>'.END_LINE;
	echo $content;
}
/**
 * DisplayUrlListerapport()
 * affichage URL pour accéder aux rapports
 * @param $work_id
 * @param $contenu
 * @return 
 **/
function DisplayUrlListerapport($work_id, $contenu) {
			$link_table= array('rub'=> $GLOBALS['links']['listerapport']['linkvalue'],'id'=>$work_id);
	$content='<a href="'.HrefMaker($link_table).'" title="'.formatText($contenu, '2ATT').'" id="barre_report" >'.$contenu.'</a>'.END_LINE;
	echo $content;
}
/**
 * DisplayUrlListeutilisateurs()
 * affichage URL pour accéder aux utilisatuers
 * @param $work_id
 * @param $contenu
 * @return 
 **/
function DisplayUrlListeutilisateur($work_id, $contenu) {
			$link_table= array('rub'=> $GLOBALS['links']['listeutilisateur']['linkvalue'],'id'=>$work_id);
	$content='<a href="'.HrefMaker($link_table).'" title="'.formatText($contenu, '2ATT').'" id="barre_user" >'.$contenu.'</a>'.END_LINE;
	echo $content;
}
/**
 * DisplayListWorkshop()
 * affichage de la liste de groupe de travail
 * @param integer $id_filter
 * @param integer $filter
 * @return 
 **/
function DisplayListWorkshop($id_filter=-1, $filter=-1) {

if ($filter=="") $filter='public';
$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopList($debut=-1, $limite=-1, $filter , $id_filter));
	
	if($data!=0) 
	{
		$content= '';
		for($i=0; $i<count($data); $i++) {
			$link_table= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'id'=>$data[$i]['workshop_id']);
			$link_table2= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'filter'=> $GLOBALS['filter']['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id']);
			$link_table3= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'filter'=> $GLOBALS['filter']['niveau']['linkvalue'],'id'=>$data[$i]['workshop_level']);
			$workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
			$workshop_resume=formatText(cutText($data[$i]['workshop_resume'],500), '2HTML');
			$workshop_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
			$workshop_level=formatText($data[$i]['level_name'], '2HTML');
			
			$content.='<h2><a href="'.HrefMaker($link_table).'" title="'.formatText($workshop_title, '2ATT').'">'.$workshop_title.'</a>'.END_LINE;
			$content.='</h2>'.END_LINE;
			$content.='<p>'.$workshop_resume.'</p>'.END_LINE;
			$content.='<p class="filter_info">'.$GLOBALS['lang']['divers']['level'].' : <a href="'.HrefMaker($link_table3).'" title="'.formatText($workshop_level, '2ATT').'" class="filter_info_level" >'.$workshop_level.'</a> '.END_LINE;
			$content.=' '.$GLOBALS['lang']['divers']['themeref'].': <a href="'.HrefMaker($link_table2).'" title="'.formatText($workshop_sdtheme, '2ATT').'" class="filter_info_theme">'.$workshop_sdtheme.'</a></p>'.END_LINE;
			$content.='<hr />'.END_LINE;
		}
	} 
	else 
	{
	$content='<p class="info">'.$GLOBALS['lang']['divers']['nodata'].'</p>';
	}
	
	echo $content;
}
/**
 * DisplayCalendar()
 * affichage du calendrier
 * @param $workshop_id
 * @param $nb
 * @return 
 **/
function DisplayCalendar($workshop_id, $nb) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneListCalWorkshop($workshop_id, $nb));
	$content = ''.END_LINE;
	if($data!=0) 
	{
	$datenow= strtotime("now");
$inter=1*24*3600;

		for($i=0; $i<count($data); $i++) {
		
			$workcal_title=formatText($data[$i]['workcal_task'], '2HTML');
			$workcal_resume=formatText($data[$i]['workcal_task_details'], '2HTML');
			$workcal_author=formatText($data[$i]['user_login'], '2HTML');
			$workcal_date_publi=formatText($data[$i]['workcal_task_date_display'], '2HTML');	
			$link_table= array('rub'=> $GLOBALS['links']['profil-utilisateur']['linkvalue'],'id'=>$data[$i]['workcal_posted_by']);
			
			$datetask=$data[$i]['workcal_task_date_display'];
			
$datetask=explode("-", $datetask);
$jour = $datetask[0];
$mois = $datetask[1];
$annee = $datetask[2];
$datetask2 = mktime (0, 0, 0, $mois, $jour, $annee);
	
if (($datetask2+$inter)>$datenow){
			
			$content.='<div class="task_in_date"><p>'.$workcal_date_publi.'</p>';
			$content.='<a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a></div>';
			 $content.='<div class="task_in"><h3>'.$workcal_title.'</h3>'.END_LINE;
			//$content.='<h3>'.$workcal_date_publi.' '.$workcal_title.'</h3>'.END_LINE;
			}
			else {
			$content.='<div class="task_out_date"><p>'.$workcal_date_publi.'</p>';
			$content.='<a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a></div>';
			 $content.='<div class="task_out"><h3>'.$workcal_title.'</h3>'.END_LINE;
			}
			if($nb=="ALL"){
			$content.='<p>'.$workcal_resume.'</p></div>'.END_LINE;
			//$content.='<p></p>'.END_LINE;
			}
			
		}
	} 
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['divers']['nodata'].'</p>';
	}
	
	echo $content;
}

/**
 * DisplayOneWorkshop()
 * affichage du détail d'un groupe de travail
 * @param $workshop_id
 * @param integer $title
 * @return 
 **/
function DisplayOneWorkshop($workshop_id, $title=-1) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompleteWorkshop($workshop_id));
	$content = ''.END_LINE;
	if($data!=0) 
	{
		for($i=0; $i<count($data); $i++) {
		
			$link_table= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'id'=>$workshop_id);
			$link_table2= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'filter'=> $GLOBALS['filter']['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id']);
			$link_table3= array('rub'=> $GLOBALS['links']['groupe-de-travail']['linkvalue'],'filter'=> $GLOBALS['filter']['niveau']['linkvalue'],'id'=>$data[$i]['workshop_level']);
			$workshop_title=formatText($data[$i]['workshop_denomination'], '2HTML');
			$workshop_resume=formatText($data[$i]['workshop_resume'], '2HTML');
			//$workshop_comment=formatText(cutText($data[$i]['workshop_comment'],150), '2HTML');
			$workshop_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
			$workshop_theme=formatText(cutText($data[$i]['theme_name'],50), '2HTML');
			$workshop_level=formatText($data[$i]['level_name'], '2HTML');
			
			
			if ($title<>-1) {
			    $content.='<h1>'.$workshop_title.'</h1>'.END_LINE;
			}
			else{ 
			//$content.='<h2>'.$GLOBALS['lang']['workshop']['det'].'</h2>'.END_LINE;
			$content.='<p class="h1_comment_bg" id="workshop_det">'.$workshop_resume.'</p>'.END_LINE;
			//$content.='<p>'.$workshop_comment.'</p>'.END_LINE;
			$content.='<p class="filter_info">'.$GLOBALS['lang']['divers']['scale'].' : <a href="'.HrefMaker($link_table3).'" title="'.formatText($workshop_level, '2ATT').'" class="filter_info_level" >'.$workshop_level.'</a> '.END_LINE;
			$content.=' '.$GLOBALS['lang']['divers']['themeref'].' : <a href="'.HrefMaker($link_table2).'" title="'.formatText($workshop_sdtheme, '2ATT').'" class="filter_info_theme" >'.$workshop_sdtheme.'</a></p> '.END_LINE;
			//.$GLOBALS['lang']['divers']['sousthemeref'].':'.$workshop_theme.'</p>'.END_LINE;
			}
		}
	} 
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['divers']['nodata'].'</p>';
	}
	
	echo $content;
}

/**
 * DisplayUserWorkshop()
 * affichage des utilisateurs/organisateurs d'un groupe de travail
 * @param $workshop_id
 * @return 
 **/
function DisplayUserWorkshop($workshop_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopUserList($workshop_id));
	$content1='<p>'.$GLOBALS['lang']['workshop']['organizer2'].' :';
	$content2='<p>'.$GLOBALS['lang']['workshop']['user'].' :';
	if($data!=0) 
	{
		for($i=0; $i<count($data); $i++) {
		
			$workcal_author=formatText($data[$i]['user_login'], '2HTML');
			$link_table= array('rub'=> $GLOBALS['links']['profil-utilisateur']['linkvalue'],'id'=>$data[$i]['jwu_user_id']);
			
			if($data[$i]['jwu_user_right']<>"U") $content1.=' <a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a> '.END_LINE;
			else $content2.=' <a href="'.HrefMaker($link_table).'" title="'.formatText($workcal_author, '2ATT').'">'.$workcal_author.'</a> '.END_LINE;
		}
	$content1.='</p>'.END_LINE;
	$content2.='</p>'.END_LINE;
	$content=$content1.$content2;
	} 
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['workshop']['no_user'].'</p>';
	}
	echo $content;
}

/**
 * DisplayListReport()
 * affichage de la liste des rapports d'un groupe de travail
 * @param $workshop_id
 * @return 
 **/
function DisplayListReport($workshop_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkshopReportList($workshop_id,"P"));
	$content = ''.END_LINE;
	if($data!=0) 
	{
		for($i=0; $i<count($data); $i++) {
		
			$link_table= array('rub'=> $GLOBALS['links']['rapport']['linkvalue'],'id'=>$data[$i]['workrep_id']);
			$workrep_title=formatText($data[$i]['workrep_title'], '2HTML');
			$workrep_resume=formatText(cutText($data[$i]['workrep_resume'],200), '2HTML');
			$workrep_date_publi=formatText($data[$i]['workrep_published_date'], '2HTML');	
			$content.='<h3><a href="'.HrefMaker($link_table).'" title="'.formatText($workrep_title, '2ATT').'">'.$workrep_title.'</a></h3>'.END_LINE;
			$content.='<p>'.$workrep_resume.'</p>'.END_LINE;
			$content.='<p class="filter_info">'.$GLOBALS['lang']['workshop']['date_report'].' : <span>'.$workrep_date_publi.'</span></p>'.END_LINE;
			$content.='<hr />'.END_LINE;
		}
		}
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['workshop']['no_report'].'</p>';
	}
	echo $content;
}

/**
 * DisplayListDiscussion()
 * affichage de la liste des discussions
 * @param $workshop_id
 * @param $debut
 * @return 
 **/
function DisplayListDiscussion($workshop_id, $debut) {

$result_workcom_list=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcomList($debut, SELECT_LIMIT, $workshop_id));
$result_nb_com=$GLOBALS['sql_object'] -> DBSelect(SQL_getcountnbcom($workshop_id));
$bdd_nb_com=$result_nb_com[0]['num_rows'];


$table_link=array('rub' => $GLOBALS['links']['discussion']['linkvalue'],'id' => $workshop_id);
echo $bdd_nb_com_display = "<p class=\"nb_sujet\">".$bdd_nb_com." ".$GLOBALS['lang']['workshop']['nb_total_com']."</p>\n";
echo "<h2>".$GLOBALS['lang']['workshop']['com']."</h2>";
echo Display_linkin_page($table_link, $bdd_nb_com, $debut);
if($result_workcom_list!=0) {

	$content= "<table cellspacing=\"1\" cellpadding=\"3\" class=\"table_discussion\" summary=\"".$GLOBALS['lang']['workshop']['com']."\">".END_LINE;
	$content.= "<thead>\n";
	$content.= "<tr>\n"; 
	$content.= "<td>".$GLOBALS['lang']['divers']['statut']."</td>".END_LINE;
	$content.= "<td>".$GLOBALS['lang']['workshop']['com_subject']."</td>".END_LINE;
	$content.= "<td>".$GLOBALS['lang']['workshop']['com_author']."</td>".END_LINE;
	$content.= "<td>".$GLOBALS['lang']['workshop']['com_nb_rep']."</td>".END_LINE;
	$content.= "<td>".$GLOBALS['lang']['workshop']['com_date_last']."</td>".END_LINE;
	$content.= "</tr>".END_LINE;
	$content.= "</thead>".END_LINE;
	$content.= "<tbody>".END_LINE;


for($i=0; $i<count($result_workcom_list); $i++) {

$result_workcom_det=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcom_detList($result_workcom_list[$i]['workcom_id']));
	$link_user= array('rub'=> $GLOBALS['links']['profil-utilisateur']['linkvalue'],'id'=>$result_workcom_list[$i]['workcom_user_id']);
	$link_det_com= array('rub'=> $GLOBALS['links']['sujet']['linkvalue'],'id'=>$result_workcom_list[$i]['workcom_id'], 'parentid' => $workshop_id);
	
	$workcom_title=formatText(cutText($result_workcom_list[$i]['workcom_subject'], 70, 1), '2HTML'); 
	$workcom_user=formatText(cutText($result_workcom_list[$i]['user_login'], 10, 1), '2HTML'); 
	
	
	$content.= "<tr>".END_LINE;
	if ($result_workcom_list[$i]['workcom_statut']=='C') {
	 $content.= "<td><img src=\"../gfx/linea21/images/public/ico_lock_dis.gif\" alt=\"\" /></td>".END_LINE;
	}
	else $content.= "<td>&nbsp;</td>\n";
	$content.= "<td style=\"width:50%\"><a href=\"".HrefMaker($link_det_com)."\" title=\"".formatText($workcom_title, '2ATT')."\" class=\"table_title\">".$workcom_title."</a></td>".END_LINE;
	$content.= "<td><a href=\"".HrefMaker($link_user)."\" title=\"".formatText($workcom_user, '2ATT')."\" class=\"table_auth\">".$workcom_user."</a></td>".END_LINE;
	if ($result_workcom_det[0]['nb_rep']=="") {
	    $content.= "<td>0</td>".END_LINE;
	}
	else $content.= "<td style=\"width:11%\">".$result_workcom_det[0]['nb_rep']."</td>".END_LINE;
	if ($result_workcom_det[0]['workcom_date_crea_display']=="") {
	    $content.= "<td>".$result_workcom_list[$i]['workcom_date_crea_display']."</td>".END_LINE;
	}
	else
	$content.= "<td>".$result_workcom_list[$i]['workcom_date_crea_display']."</td>".END_LINE;
	$content.= "</tr>".END_LINE;
}

$content.= "</tbody>".END_LINE;
$content.= "</table>".END_LINE;
}else {
	$content= '<p class="info">'.$GLOBALS['lang']['workshop']['no_com'].'</p>'.END_LINE;
}
echo $content;
echo "".Display_linkin_page($table_link, $bdd_nb_com, $debut);
}

/**
 * DisplayOneDiscussion()
 * affichage d'une discussion
 * @param $workshop_id
 * @param $discussion_id
 * @param $debut
 * @param integer $type
 * @param $body
 * @param $title
 * @return 
 **/
function DisplayOneDiscussion($workshop_id, $discussion_id, $debut, $type=-1, $body, $title) {

$dataroot=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom($workshop_id, $discussion_id, $discussion_id));
$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom2($workshop_id, $discussion_id, $root= -1, $debut, SELECT_LIMIT));
$result_nb_com=$GLOBALS['sql_object'] -> DBSelect(SQL_getWorkcom_detList($discussion_id));
$bdd_nb_com=$result_nb_com[0]['nb_rep'];


$table_link=array('rub' => $GLOBALS['links']['sujet']['linkvalue'],'id' => $discussion_id, 'parentid' => $workshop_id );


			$subject_title=formatText($dataroot[0]['workcom_subject'], '2HTML');
			$subject_body=formatText($dataroot[0]['workcom_body'], '2HTML');
			$subject_user=formatText(cutText($dataroot[0]['user_login'], 10, 1), '2HTML'); 
			$subject_statut=$dataroot[0]['workcom_statut'];
			
			$content= '';
			echo "<p class=\"nb_sujet\">".$bdd_nb_com_display = $bdd_nb_com." ".$GLOBALS['lang']['workshop']['nb_total_com_mes']."</p>".END_LINE;
			echo'<h2>'.$GLOBALS['lang']['workshop']['com_name'].' : '.$subject_title.'</h2>'.END_LINE;
			echo Display_linkin_page($table_link, $bdd_nb_com, $debut);
			echo '<hr />'.END_LINE;
			if ($debut==0) {

			
			$link_user= array('rub'=> $GLOBALS['links']['profil-utilisateur']['linkvalue'],'id'=>$dataroot[0]['workcom_user_id']);
	

			$content.='<div class="blocksujet">'.END_LINE;
			$content.='<p class="workshop_auth_sujet"><a href="'.HrefMaker($link_user).'" title="'.formatText($subject_user, '2ATT').'">'.$subject_user.'</a> dit :</p>'.END_LINE;
			$content.='<h3>'.$subject_title.'</h3>'.END_LINE;
			$content.='<p>'.$subject_body.'</p>'.END_LINE;
			$content.='<p class="workshop_date_sujet">'.$GLOBALS['lang']['workshop']['com_date_publi'].' : <span>'.$dataroot[0]['workcom_date_crea_display'].'</span></p>'.END_LINE;
			$content.='</div>'.END_LINE;
			$content.='<hr />'.END_LINE;
			}

if ($type==-1) {
    if($data!=0) 
	{
		
		for($i=0; $i<count($data); $i++) {
			
			$subject_title=formatText($data[$i]['workcom_subject'], '2HTML');
			$subject_body=formatText($data[$i]['workcom_body'], '2HTML');
			$subject_user=formatText(cutText($data[$i]['user_login'], 10, 1), '2HTML'); 
			
			$link_user= array('rub'=> $GLOBALS['links']['profil-utilisateur']['linkvalue'],'id'=>$data[$i]['workcom_user_id']);
			$link_edit= array('rub'=> $GLOBALS['links']['message']['linkvalue'],'parentid'=>$workshop_id, 'id'=>$data[$i]['workcom_id'], 'parentparentid'=>$discussion_id );
	
			if(isset($_COOKIE['linea21']['id'])) {
			    if ($data[$i]['workcom_user_id']==$_COOKIE['linea21']['id']) {
			        $edit='<a href="'.HrefMaker($link_edit).'" title="'.formatText($GLOBALS['lang']['workshop']['mod_com_mes'], '2ATT').'">'.$GLOBALS['lang']['workshop']['mod_com_mes'].'</a>'.END_LINE;
			    }else $edit='';
			}
			$content.='<div class="blocksujet">'.END_LINE;
			$content.='<p class="workshop_auth_sujet"><a href="'.HrefMaker($link_user).'" title="'.formatText($subject_user, '2ATT').'">'.$subject_user.'</a> dit :</p>'.END_LINE;
			$content.='<h3>'.$subject_title.'</h3>'.END_LINE;
			$content.='<p>'.$subject_body.'</p>'.END_LINE;
			$content.=' <p class="workshop_date_sujet">'.$edit.' '.$GLOBALS['lang']['workshop']['com_date_publi'].' : <span>'.$data[$i]['workcom_date_crea_display'].'</span></p>'.END_LINE;
			//$content.=$edit;
			$content.='</div>'.END_LINE;
			$content.='<hr />'.END_LINE;
		}
	} 
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['workshop']['no_com_rep'].'</p>';
	}
 
	echo $content;
	 echo Display_linkin_page($table_link, $bdd_nb_com, $debut);
	if ($subject_statut=="P")  DisplayFormMessageAdd($workshop_id, $discussion_id, $body, $title);
	else echo $content='<p class="info">'.$GLOBALS['lang']['workshop']['com_p_lock'].'</p>';
}
else echo $content;
}

/**
 * DisplayConfirm()
 * affichage du message de confirmation de modification d'un message
 * @param $link
 * @return 
 **/
function DisplayConfirm($link) {
	$content='<p class="confirm">'.$GLOBALS['lang']['workshop']['confirm_mod_com'].' <a href="'.$link.'" title="'.$GLOBALS['lang']['workshop']['com_p_back_mes'].'" >'.$GLOBALS['lang']['workshop']['com_p_back_mes'].'</a>'.END_LINE;
	$content.='</p>'.END_LINE;
	echo $content;
}

/**
 * DisplayConfirmAdd()
 * affichage du message de confirmation d'ajout d'un message
 * @return 
 **/
function DisplayConfirmAdd() {
	$content='<p class="confirm">'.$GLOBALS['lang']['workshop']['confirm_add_com'].'</p>'.END_LINE;
	echo $content;
}

/**
 * DisplayFormMessageAdd()
 * affichage du formulaire d'ajout d'un message
 * @param $workshop_id
 * @param $discussion_id
 * @param $body
 * @param $title
 * @return 
 **/
function DisplayFormMessageAdd($workshop_id, $discussion_id, $body, $title) {

	if ($body==''&& $title=='') {
	echo GetFormMessageAdd($workshop_id, $discussion_id, $body, $title);
	}
	 else {
	$result_display=GetWriteCom($title, $body, $discussion_id, $workshop_id);	 
	if ($result_display<>1) {
	echo "<p class=\"error\">".$result_display."</p>";
	echo GetFormMessageAdd($workshop_id, $discussion_id, $body, $title);
	}
	else echo DisplayConfirmAdd();
	}
	}
	
	
/**
 * DisplayFormMessageMod()
 * affichage du formulaire de modification d'un message
 * @param $workshop_id
 * @param $discussion_id
 * @param integer $message_id
 * @param $body
 * @param $title
 * @param integer $post
 * @return 
 **/
function DisplayFormMessageMod($workshop_id, $discussion_id, $message_id=-1, $body, $title, $post=-1) {

	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getOnetopicWorkcom($workshop_id, $message_id, "root"));
	$subject_title=formatText($data[0]['workcom_subject'], '2FIELD');
	$subject_body=formatText($data[0]['workcom_body'], '2FIELD');

	
	if ($post<>-1) {
	echo GetFormMessageMod($workshop_id, $discussion_id, $message_id, $subject_body, $subject_title);
	}
	 else {
	$result_display=GetModCom($title, $body, $message_id, $workshop_id, $discussion_id);	 
	if ($result_display<>1) {
	echo "<p class=\"error\">".$result_display."</p>";
	echo GetFormMessageMod($workshop_id, $discussion_id, $message_id, $body, $title);
	}
	else {
	$link=HrefMaker(array('rub'=>'sujet', 'id'=>$discussion_id, 'parentid'=>$workshop_id));
	echo DisplayConfirm($link);
	}
	}
	
	}
	
/**
 * GetFormMessageMod()
 * formulaire de modification d'un message
 * @param $workshop_id
 * @param $discussion_id
 * @param integer $message_id
 * @param $subject_body
 * @param $subject_title
 * @return 
 **/
function GetFormMessageMod($workshop_id, $discussion_id, $message_id=-1, $subject_body, $subject_title) {
	
	$link = array('rub'=> $GLOBALS['links']['message']['linkvalue'] , 'id' => $message_id,  'parentid' => $workshop_id);
	$form='<h2>'.$GLOBALS['lang']['workshop']['mod_com_mes'].'</h2>'.END_LINE;
	$form.='<form action="'.HrefMaker($link).'" method="post">'.END_LINE;
	$form.='<div id="reponse">'.END_LINE;
	$form.='<label for="title">'.$GLOBALS['lang']['workshop']['com_subject'].' : </label>'.END_LINE;
	$form.='<input type="text" maxlength="50"  name="title" id="title" value="'.$subject_title.'" class="textfield" />'.END_LINE;
	$form.='<label for="body">'.$GLOBALS['lang']['workshop']['com_body'].' : </label>'.END_LINE;
	$form.='<textarea id="body" name="body" rows="12" cols="20" class="textfield">'.$subject_body.'</textarea>'.END_LINE;
	$form.='<input type="hidden" value="'.$workshop_id.'" name="workshop_id" id="workshop_id" />'.END_LINE;
	$form.='<input type="hidden" value="'.$message_id.'" name="message_id" id="message_id" />'.END_LINE;
	$form.='<input type="hidden" value="'.$discussion_id.'" name="discussion_id" id="discussion_id" />'.END_LINE;
	$form.='<br /><input type="image" src="../gfx/linea21/images/public/button_valid.gif" value="valider" name="valider" id="valider" />'.END_LINE;
	//$form.='<input type="submit" value="ok" size="15" name="postsubject" id="postsubject" />'.END_LINE;
	$form.='</div>'.END_LINE;
	$form.='</form>'.END_LINE;
	return $form;
	
	}	
	
	/**
 * GetFormMessageAdd()
 * formulaire d'ajout d'un message
 * @param $workshop_id
 * @param $discussion_id
 * @param $body
 * @param $title
 * @return 
 **/
function GetFormMessageAdd($workshop_id, $discussion_id, $body, $title){
	$link = array('rub'=> $GLOBALS['links']['sujet']['linkvalue'] , 'id' => $discussion_id,  'parentid' => $workshop_id);
	$form='<h2>'.$GLOBALS['lang']['workshop']['add_com_mes'].'</h2>'.END_LINE;
	$form.='<form action="'.HrefMaker($link).'" method="post">'.END_LINE;
	$form.='<div id="reponse">'.END_LINE;
	$form.='<label for="title">'.$GLOBALS['lang']['workshop']['com_subject'].' : </label>'.END_LINE;
	$form.='<input type="text" maxlength="50"  name="title" id="title" value="'.$title.'"  class="textfield"  />'.END_LINE;
	$form.='<label for="body">'.$GLOBALS['lang']['workshop']['com_body'].' : </label>'.END_LINE;
	$form.='<textarea id="body" name="body" rows="12" cols="20" class="textfield">'.$body.'</textarea>'.END_LINE;
	$form.='<input type="hidden" value="'.$workshop_id.'" name="workshop_id" id="workshop_id" />'.END_LINE;
	$form.='<input type="hidden" value="'.$discussion_id.'" name="discussion_id" id="discussion_id" /><br />'.END_LINE;
	$form.='<input type="image" src="../gfx/linea21/images/public/button_valid.gif" value="valider" name="valider" id="valider" />'.END_LINE;
	//$form.='<input type="submit" value="ok" size="15" name="postsubject" id="postsubject" />'.END_LINE;
	$form.='</div>'.END_LINE;
	$form.='</form>'.END_LINE;
	return $form;
}
	
	/**
	 * CheckComIntegrity()
	 * Vérification de l'intégrité des données
	 * @param $title
	 * @param $body
	 * @param $workshop_com_object
	 * @return 
	 **/
	function CheckComIntegrity($title, $body, $workshop_com_object){
	$integrity=1;
	 if (strlen($title) < 3) $integrity=$GLOBALS['lang']['workshop']['com_no_subject'];
     if (strlen($body) < 3) $integrity=$GLOBALS['lang']['workshop']['com_no_body'];
	if(is_string($integrity)) return $integrity;
	else return 1;
	}
	
	/**
	 * GetWriteCom()
	 * Ajout dans la base d'un nouveau message
	 * @param $title
	 * @param $body
	 * @param $discussion_id
	 * @param $workshop_id
	 * @return 
	 **/
	function GetWriteCom($title, $body, $discussion_id, $workshop_id){

	if(isset($_COOKIE['linea21']['id'])) {
	$user_id=$_COOKIE['linea21']['id'];
		
	include_once('../class/class.workshop_com.php');
	$workshop_com_object = new workshop_com;
	
	$result=CheckComIntegrity($title, $body, $workshop_com_object);
	if ($result==1) {
	$table[0] = $title;
  	$table[1] = $body;
  	$table[2] = $discussion_id;
  	$table[3] = $user_id;
	$table[4] = $workshop_id;
	
	$result=$workshop_com_object->AddCom($table , $GLOBALS['sql_object']);
	return 1;
	}
	else return $result;
	} else return "<p class=\"error\">".$GLOBALS['lang']['divers']['errorauth']."</p>";
	}
	
	/**
	 * GetModCom()
	 * Modification dans la base d'un message
	 * @param $title
	 * @param $body
	 * @param $mes_id
	 * @param $workshop_id
	 * @param $discussion_id
	 * @return 
	 **/
	function GetModCom($title, $body, $mes_id, $workshop_id, $discussion_id){

	if(isset($_COOKIE['linea21']['id'])) {
	$user_id=$_COOKIE['linea21']['id'];
	include_once('../class/class.workshop_com.php');
	$workshop_com_object = new workshop_com;
	
	$result=CheckComIntegrity($title, $body, $workshop_com_object);
	if ($result==1) {
	$table[0] = $title;
  	$table[1] = $body;
	$result=$workshop_com_object->ModifyComUser($mes_id, $table , $user_id, $GLOBALS['sql_object']);
	
	if (!is_string($result)) return 1;
	else return $result;
	}
	else return $result;
	} else return "<p class=\"error\">".$GLOBALS['lang']['divers']['errorauth']."</p>";
	}
	
	
	/**
	 * DisplayConfirmInscription()
	 * affichage de la confirmation d'inscription
	 * @param $link
	 * @return 
	 **/
	function DisplayConfirmInscription($link) {
	$content='<p class="confirm">'.$GLOBALS['lang']['workshop']['confirm_inscription'].' <a href="'.$link.'" title="'.$GLOBALS['lang']['workshop']['com_p_back_com'].'" >'.$GLOBALS['lang']['workshop']['com_p_back_com'].'</a>'.END_LINE;
	$content.='</p>'.END_LINE;
	echo $content;
}


		/**
		 * DisplayInscription()
		 * inscription d'un utilisateur au groupe de travail + affichage du résultat
		 * @param $workshop_id
		 * @return 
		 **/
		function DisplayInscription($workshop_id){
	if(isset($_COOKIE['linea21']['login'])) {
	$login=$_COOKIE['linea21']['login'];
	include_once('../class/class.workshop.php');
	$workshop_object = new workshop;
	$result=$workshop_object->AddUserWorkshop($workshop_id, $login , "U", $GLOBALS['sql_object']);
	if (is_numeric($result)) {
	$link=HrefMaker(array('rub'=>'discussion', 'id'=>$workshop_id));
	UpdateCookieWorkshop($workshop_id);
	echo DisplayConfirmInscription($link);
	}
	else echo $result;
	} else echo "<p class=\"error\">".$GLOBALS['lang']['divers']['errorauth']."</p>";
	}
	
?>

