<?php
/**
 * @package linea21.core
 * @subpackage admin
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @param  $rub : connu de admin/index.php
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
* displayitem()
* affichage des items du menu. Prise en charge de leur ETAT : actif ou non
* 
* @param string $rubactive 
* @param string $currentrub 
* @param string $accesskey 
* @return string $content
*/

function displayitem($rubactive, $currentrub, $accesskey)
{
    if ($rubactive == $currentrub) {
        $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" class=\"aactif\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu']['item'] . ' : ' . $GLOBALS['lang']['menu'][$currentrub] . "\">" . $GLOBALS['lang']['menu'][$currentrub] . " <img src=\"../gfx/" .THEME_ADMIN. "/images/admin/puce_menu_select.gif\" width=\"10\" height=\"10\" alt=\"\" id=\"imgmenu\" /></a></li>\n";
    } else {
        $content = "<li><a href=\"index.php?rub=" . $currentrub . "\" accesskey=\"" . $accesskey . "\" title=\"" . $GLOBALS['lang']['menu'][$currentrub] . "\">" . $GLOBALS['lang']['menu'][$currentrub] . "</a></li>\n";
    } 
    return $content;
} 

$menu_constructor = '';
if (MOD_PROJECT === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'project', 'p');
if (MOD_NEWS === 1 && HaveRight('news')) $menu_constructor .= displayitem($rub, 'news', 'a');
if (MOD_PUBLICATION === 1 && HaveRight('publication')) {
    if ($rub == 'resources' || $rub == 'contents') {
        if (isset($type) && $type == 'W') $menu_constructor .= displayitem('workshop', 'publication', 'd');
        if (isset($type) && $type == 'P') $menu_constructor .= displayitem('publication', 'publication', 'd');
    } else {
        $menu_constructor .= displayitem($rub, 'publication', 'd');
    } 
} 

if (MOD_WORKSHOP === 1 && HaveRight('workshop')) {
    if ($rub == 'resources' || $rub == 'content' || $rub == 'workshoprep') {
        if (isset($type) && $type == 'W') $menu_constructor .= displayitem('workshop', 'workshop', 'g');
        if (isset($type) && $type == 'P') $menu_constructor .= displayitem('publication', 'workshop', 'g');
        if ($rub == 'workshoprep') $menu_constructor .= displayitem('workshop', 'workshop', 'g');
    } else {
        $menu_constructor .= displayitem($rub, 'workshop', 'g', $GLOBALS['lang']['menu']);
    } 
} 

if (MOD_SDI === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'sdi', 'b');
if (MOD_DASHBOARD === 1 && HaveRight('dashboard')) $menu_constructor .= displayitem($rub, 'dashboard', 'i');
if (MOD_YELLOWPAGES === 1 && HaveRight('yellowpages')) $menu_constructor .= displayitem($rub, 'yellowpages', 'y');
if (MOD_NEWSLETTER === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'newsletter', 'r');
if (MOD_USER === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'user', 'u');
if (MOD_THEME === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'theme', 't');
if (MOD_SCALE === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'scale', 'e');
if (MOD_LEVEL === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'level', 'n');
if (MOD_SYSTEM === 1 && IsSuperAdmin()) $menu_constructor .= displayitem($rub, 'system', 'n');
?>
<div class="containermenu">
<div class="menu"> 
	<ul>
		<?php echo $menu_constructor; ?>
	</ul>
</div>
<form method="post" action="search.php">
	<div id="containersearch">
		<span><?php echo $GLOBALS['lang']['menu']['search'];?></span>
		<input type="text" name="search" id="searchincome" maxlength="150" accesskey="s" value="" />
		<input type="submit" id="gosearch" name="valid" value="" />
	</div>
</form>