<?php
/**
 * @package linea21.modules
 * @subpackage yellowpages
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Yellowpages Management
 */

class yellowpages {
  /* @param
   * */
  var $TDB_YELLOWPAGES = T_YELLOWPAGES; // nom de la table.
  var $ID;
  var $NAME;
  var $ACTIVITY;
  var $THEME;
  var $STREET;
  var $POSTAL_CODE;
  var $CITY;
  var $COUNTRY;
  var $PHONE;
  var $FAX;
  var $EMAIL;
  var $WEBSITE;
  var $DATE_CREA;
  var $LAST_MODIFY;
  var $STATUT;

  /**
   * yellowpages::CheckDataIntegrity()
   * Vérification des données d'une entreprise
   *
   * @access public
   * @param array $table_yp : contient les composants d'une entreprise
   * @return boolean si ok renvoie true sinon message d'erreurs (string)
   */
  function CheckDataIntegrity($table)
  {
    $notname = $GLOBALS['lang']['yp']['object_notname'];
    $notactivity = $GLOBALS['lang']['yp']['object_notactivity'];
    $notstreet = $GLOBALS['lang']['yp']['object_notstreet'];
    $notpostal_code = $GLOBALS['lang']['yp']['object_notpostal_code'];
    $notcity = $GLOBALS['lang']['yp']['object_notcity'];
    //$notcountry = $GLOBALS['lang']['yp']['object_notcountry'];
    $notemail = $GLOBALS['lang']['yp']['object_notemail'];
    $notphone = $GLOBALS['lang']['yp']['object_notphone'];
    $notfax = $GLOBALS['lang']['yp']['object_notfax'];

    if (strlen($table[0]) < 2) return $notname;
    if (strlen($table[1]) < 2) return $notactivity;
    if (strlen($table[3]) < 2) return $notstreet;
    if (strlen($table[4]) < 2) return $notpostal_code;
    if (strlen($table[5]) < 2) return $notcity;
    //if (strlen($table[6]) < 2) return $notcountry;

    $testmail = $this->_checkEmailValidity($table[9]);
    if ($testmail != 1) return $notemail;

    if (trim($table[7]) != '' && !is_numeric($table[7])) return $notphone;
    if (trim($table[8]) != '' && !is_numeric($table[8])) return $notfax;
    return true;
  }

  /**
   * yellowpages::_checkEmailValidity()
   * Vérification de la grammaire du mail
   *
   * @access private
   * @param string $email
   * @return int 1 ou 0
   */
  function _checkEmailValidity($email)
  {
    $email = strtolower($email);
    if (strlen($email) < 6 || !ereg("@", $email) || preg_match_all("/([^a-zA-Z0-9_\@\.\-])/i", $email, $trouve) || !preg_match("/^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$/i", $email)) {
      return 0;
    }
    return 1;
  }

  /**
   * yellowpages::AddYellowPages()
   * Ajout d'une nouvelle entreprise dans l'annuaire
   *
   * @access public
   * @param array $table contient les composants d'une organisation
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddYellowPages($table, $sql_object)
  {
    $table=$sql_object->DBescape($table);

    $this->NAME = strip_input($table[0]);
    $this->ACTIVITY = strip_input($table[1]);
    $this->THEME = $table[2];
    $this->STREET = strip_input($table[3]);
    $this->POSTAL_CODE = strip_input($table[4]);
    $this->CITY = strip_input($table[5]);
    $this->COUNTRY = strip_input($table[6]);
    $this->PHONE = strip_input($table[7]);
    $this->FAX = strip_input($table[8]);
    $this->EMAIL = strip_input($table[9]);
    $this->WEBSITE = strip_input($table[10]);

    if ($table[11] != '') {
      $table[11] = strtoupper($table[11]);
      switch ($table[11]) {
        case 'P':
          $this->STATUT = $table[11];
          break;
        case 'AA':
          $this->STATUT = $table[11];
          break;
        case 'D':
          $this->STATUT = $table[11];
          break;
        default:
          $this->STATUT = 'AA';
          break;
      }
    } else $this->STATUT = 'AA';

    $requete = "INSERT INTO " . $this->TDB_YELLOWPAGES . " (yellowp_name, yellowp_activity, yellowp_theme, yellowp_street, " . "yellowp_postal_code, yellowp_city, yellowp_country, yellowp_phone, yellowp_fax, yellowp_email, " . "yellowp_website,  yellowp_statut, yellowp_date_crea) " . "VALUES('" . $this->NAME . "', '" . $this->ACTIVITY . "', " . $this->THEME . ", '" . $this->STREET . "', '" . $this->POSTAL_CODE . "', '" . $this->CITY . "', '" . $this->COUNTRY . "', '" . $this->PHONE . "', '" . $this->FAX . "', '" . $this->EMAIL . "', '" . $this->WEBSITE . "', '" . $this->STATUT . "', NOW());";
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }

  /**
   * yellowpages::StateYellowPages()
   * modification du statut d'une organisation
   *
   * @access public
   * @param int $ID identifiant de l'organisation
   * @param string $state (facultatif) 'P' Public/'D' Draft/'AA' AdminArchive/'PA' PublicArchive
   * @param object $sql_object
   * @return bool $result
   */

  function StateYellowPages($ID, $state, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    $this->STATUT = $state;

    $requete = "UPDATE  " . $this->TDB_YELLOWPAGES . " set yellowp_statut='" . $this->STATUT . "' WHERE yellowp_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }


  /*
   * yellowpages::DeleteYellowPages()
   * suppression d'une organisatione
   *
   * @access public
   * @param int $ID identifiant de l'organisation
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteYellowPages($ID, $sql_object)
  {
    $this->ID = $ID;
    $requete = "UPDATE " . $this->TDB_YELLOWPAGES . " SET yellowp_statut='E', yellowp_last_modify = NOW() WHERE yellowp_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * yellowpages::ModifyYellowPages()
   * modification d'une organisation
   *
   * @access public
   * @param int $ID identifiant de l'organisation
   * @param array $table contient les composants d'une entreprise
   * @param object $sql_object
   * @return bool $result
   */
  function ModifyYellowPages($ID, $table, $sql_object)
  {
    $table=$sql_object->DBescape($table);

    $this->ID = $ID;
    $this->NAME = strip_input($table[0]);
    $this->ACTIVITY = strip_input($table[1]);
    $this->THEME = $table[2];
    $this->STREET = strip_input($table[3]);
    $this->POSTAL_CODE = strip_input($table[4]);
    $this->CITY = strip_input($table[5]);
    $this->COUNTRY = strip_input($table[6]);
    $this->PHONE = strip_input($table[7]);
    $this->FAX = strip_input($table[8]);
    $this->EMAIL = strip_input($table[9]);
    $this->WEBSITE = strip_input($table[10]);

    if ($table[11] != '') {
      $table[11]=strtoupper($table[11]);
      switch ($table[11]) {
        case 'P':
          $this->STATUT = $table[11];
          break;
        case 'AA':
          $this->STATUT = $table[11];
          break;
        case 'D':
          $this->STATUT = $table[11];
          break;
        default:
          $this->STATUT = 'AA';
          break;
      }
    } else $this->STATUT = 'AA';

    $requete = "UPDATE  " . $this->TDB_YELLOWPAGES . " set yellowp_name='" . $this->NAME . "', yellowp_activity='" . $this->ACTIVITY . "' , yellowp_theme=" . $this->THEME . ", yellowp_street='" . $this->STREET . "', yellowp_postal_code='" . $this->POSTAL_CODE . "', yellowp_city='" . $this->CITY . "', yellowp_country='" . $this->COUNTRY . "', yellowp_phone='" . $this->PHONE . "', yellowp_fax='" . $this->FAX . "', yellowp_email='" . $this->EMAIL . "', yellowp_website='" . $this->WEBSITE . "', yellowp_statut='" . $this->STATUT . "', yellowp_last_modify = NOW() WHERE yellowp_id=" . $this->ID . ";";

    $result = $sql_object->DBQuery($requete);

    return $result;
  }


}

?>