<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
* IncludeLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie publique )
* 
* @return void (include)
*/
function IncludeLang()
{
    include_once('../languages/' . LANGUAGE . '/lang_common.' . CHARSET . '.php');

    if (ActiveItemAlias($GLOBALS['activeitem']) == 'directory') {
		include_once('../languages/' . LANGUAGE . '/lang_yellowpages.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'dashboard') {
		include_once('../languages/' . LANGUAGE . '/lang_sdi.' . CHARSET . '.php');
		include_once('../languages/' . LANGUAGE . '/lang_dashboard.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'workgroup') {
		include_once('../languages/' . LANGUAGE . '/lang_workshop.' . CHARSET . '.php');
		include_once('../languages/' . LANGUAGE . '/lang_workshoprep.' . CHARSET . '.php');
		include_once('../languages/' . LANGUAGE . '/lang_publication.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'project') {
		include_once('../languages/' . LANGUAGE . '/lang_project.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'publication') {
		include_once('../languages/' . LANGUAGE . '/lang_publication.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'user-prefs') {
		include_once('../languages/' . LANGUAGE . '/lang_user.' . CHARSET . '.php');
    }
    if (ActiveItemAlias($GLOBALS['activeitem']) == 'news') {
		include_once('../languages/' . LANGUAGE . '/lang_news.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'subscribe-newsletter') {
		include_once('../languages/' . LANGUAGE . '/lang_newsletter.' . CHARSET . '.php');
    }
	if (ActiveItemAlias($GLOBALS['activeitem']) == 'search') {
		include_once('../languages/' . LANGUAGE . '/lang_search.' . CHARSET . '.php');
    }

    $GLOBALS['lang'] = $lang;
} 

/**
* IncludeAdminLang()
* Fait les includes de fichiers de langue en fonction de la rubrique active ( partie admin )
* 
* @return void (include)
*/
function IncludeAdminLang($rubrique)
{
    include_once('../languages/' . LANGUAGE . '/lang_common.' . CHARSET . '.php');
    include_once('../languages/' . LANGUAGE . '/lang_' . $rubrique . '.' . CHARSET . '.php');

    if ($rubrique === 'dashboard') {
        include_once('../languages/' . LANGUAGE . '/lang_sdi.' . CHARSET . '.php');
    } 
    if ($rubrique === 'sdi') {
        include_once('../languages/' . LANGUAGE . '/lang_dashboard.' . CHARSET . '.php');
    } 

    $GLOBALS['lang'] = $lang;
} 

?>