<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../config/define.php');
include_once('../config/server.php');
distInclude('../public/'.SQL.'.inc.php'); 
include_once('../languages/' . LANGUAGE. '/lang_common.' . CHARSET . '.php');
include_once('../lib/items.php');
include_once('../lib/lib_common.php');

////////////////////////////////////////
/// Connexion Mysql
///////////////////
include_once('../class/system/class.'.SQL.'.php');
$sql_entity=SQL;
$sql_object = new $sql_entity;
$sql_object -> DBInitialise();
$sql_object -> DBConnexion();
///////////////////
$data=$sql_object -> DBSelect(SQL_getRSS2formatedNews());

$li_items='';
$content='';
if($data!=0) {
	
	for($i=0; $i<count($data); $i++) {
		$news_id=$data[$i]['news_id'];
		$news_title=$data[$i]['news_title'];
		$news_posted_by=$data[$i]['user_login'];
		$news_header=$data[$i]['news_header'];
		$news_body=$data[$i]['news_body'];
		$news_theme=$data[$i]['theme_name'];
		$news_date=$data[$i]['news_published_date_display'];
		$link_news=array ('rub'=>$GLOBALS['links'][LANGUAGE]['news']['linkvalue'], 'id'=>$news_id, 'name' => $news_title);
		
		$li_items.='<rdf:li resource="'.SITE_CITY_URL.HrefMaker($link_news).'" />'.END_LINE;


		$content.='<item rdf:about="'.SITE_CITY_URL.HrefMaker($link_news).'">'.END_LINE;
		$content.='<title>'.$news_title.'</title>'.END_LINE;
		$content.='<link>'.SITE_CITY_URL.HrefMaker($link_news).'</link>'.END_LINE;
		$content.='<dc:date>'.$news_date.'</dc:date>'.END_LINE;
		$content.='<dc:creator>'.$news_posted_by.'</dc:creator>'.END_LINE;
		$content.='<dc:subject>'.$news_theme.'</dc:subject>'.END_LINE;
		$content.='<guid isPermaLink="false">'.$news_id.'@'.SITE_CITY_URL.'</guid>'.END_LINE;
		$content.='<description>'.END_LINE;
		$content.=$news_header.' '.$news_body;
		$content.='</description>'.END_LINE;
		$content.='</item>'.END_LINE;
	}
}





/**
* HEADER RSS
****************************************************************/
header('Content-Type: text/xml');
echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/"
	xmlns:sy="http://purl.org/rss/1.0/modules/syndication/"
	xmlns:admin="http://webns.net/mvcb/"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	xmlns:content="http://purl.org/rss/1.0/modules/content/">'.END_LINE;
  
echo '<channel>'.END_LINE;
echo '<title>'.SITE_CITY_NAME.'</title>'.END_LINE;
echo '<link>'.SITE_CITY_URL.'</link>'.END_LINE;
echo '<description>'.SITE_CITY_URL.'</description>'.END_LINE;
echo '<dc:language>'.strtolower(LANGUAGE).'</dc:language>'.END_LINE;
echo '<dc:creator>'.SITE_CITY_URL.'</dc:creator>'.END_LINE;
echo '<dc:rights>Copyrights '.date("Y").'</dc:rights>'.END_LINE;
echo '<dc:date>'.date("Y-m-j").'</dc:date>'.END_LINE;
//echo '<dc:date>'.date("Y-m-j\TH:i:s").'</dc:date>'.END_LINE;
echo '<admin:generatorAgent rdf:resource="http://cafelog.com/?v=0.6.1"/>'.END_LINE;
echo '<admin:errorReportsTo rdf:resource="'.SITE_CITY_MAIL.'"/>'.END_LINE;
echo '<sy:updatePeriod>hourly</sy:updatePeriod>'.END_LINE;
echo '<sy:updateFrequency>1</sy:updateFrequency>'.END_LINE;
echo '<sy:updateBase>2000-01-01T12:00+00:00</sy:updateBase>'.END_LINE;

echo '<image rdf:resource="http://www.linea21.com/logo_linea.gif" />'.END_LINE;

# LISTES ITEMS
echo '<items>'.END_LINE;
echo '<rdf:Seq>'.END_LINE;
echo $li_items.END_LINE;
echo '</rdf:Seq>'.END_LINE;
echo '</items>'.END_LINE;


echo $content;

  
/**
* FOOTER RSS
**********************************************************/
echo '</channel>'.END_LINE;
echo '</rss>'.END_LINE;
?>




