# BUILD Linea21 DB script - UTF-8 format
CREATE DATABASE IF NOT EXISTS `linea` DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;
USE linea;
#
# Table structure for table `bibliography_resources`
#

DROP TABLE IF EXISTS `bibliography_resources`;
CREATE TABLE `bibliography_resources` (
  `bibliores_id` int(10) unsigned NOT NULL auto_increment,
  `bibliores_author` varchar(200) NOT NULL default '',
  `bibliores_title` varchar(255) NOT NULL default '',
  `bibliores_sub_title` varchar(255) NOT NULL default '',
  `bibliores_editor` varchar(255) NOT NULL default '',
  `bibliores_date` varchar(100) NOT NULL default '',
  `bibliores_range` tinyint(3) unsigned NOT NULL default '0',
  `bibliores_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `bibliores_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `bibliores_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`bibliores_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;

#
# Dumping data for table `bibliography_resources`
#
# --------------------------------------------------------

#
# Table structure for table `category_user`
#

DROP TABLE IF EXISTS `category_user`;
CREATE TABLE `category_user` (
  `catus_id` tinyint(4) unsigned NOT NULL auto_increment,
  `catus_name` varchar(100) NOT NULL default '',
  `catus_description` varchar(255) NOT NULL default '',
  `catus_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `catus_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`catus_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;

#
# Dumping data for table `category_user`
#

INSERT INTO `category_user` (`catus_id`, `catus_name`, `catus_description`, `catus_date_crea`, `catus_last_modify`) VALUES (1, 'administrateur', 'super administrateur', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO `category_user` (`catus_id`, `catus_name`, `catus_description`, `catus_date_crea`, `catus_last_modify`) VALUES (2, 'utilisateur privilegié', 'utilisateur privilegié', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO `category_user` (`catus_id`, `catus_name`, `catus_description`, `catus_date_crea`, `catus_last_modify`) VALUES (3, 'utilisateur simple', 'utilisateur simple', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

# --------------------------------------------------------

#
# Table structure for table `email_collector`
#

DROP TABLE IF EXISTS `email_collector`;
CREATE TABLE `email_collector` (
  `emailcol_id` int(10) unsigned NOT NULL auto_increment,
  `emailcol_email` varchar(200) NOT NULL default '',
  `emailcol_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `emailcol_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `emailcol_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`emailcol_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `j_biblio`
#

DROP TABLE IF EXISTS `j_biblio`;
CREATE TABLE `j_biblio` (
  `j_root_id` int(11) NOT NULL default '0',
  `j_biblio_id` int(11) NOT NULL default '0',
  `j_type` enum('P','W') NOT NULL default 'P'
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;


# --------------------------------------------------------
#
# Table structure for table `j_link`
#

DROP TABLE IF EXISTS `j_link`;
CREATE TABLE `j_link` (
  `j_root_id` int(11) NOT NULL default '0',
  `j_link_id` int(11) NOT NULL default '0',
  `j_type` enum('P','W') NOT NULL default 'P'
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;


# --------------------------------------------------------
#
# Table structure for table `j_multi`
#

DROP TABLE IF EXISTS `j_multi`;
CREATE TABLE `j_multi` (
  `j_root_id` int(11) NOT NULL default '0',
  `j_multi_id` int(11) NOT NULL default '0',
  `j_type` enum('P','W') NOT NULL default 'P'
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;


# --------------------------------------------------------
#
# Table structure for table `j_parts`
#

DROP TABLE IF EXISTS `j_parts`;
CREATE TABLE `j_parts` (
  `j_root_id` int(11) NOT NULL default '0',
  `j_parts_id` int(11) NOT NULL default '0',
  `j_type` enum('P','W') NOT NULL default 'P'
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin;


# --------------------------------------------------------
#
# Table structure for table `j_work_users`
#

DROP TABLE IF EXISTS `j_work_users`;
CREATE TABLE `j_work_users` (
  `jwu_id` int(10) unsigned NOT NULL auto_increment,
  `jwu_workshop_id` int(10) unsigned NOT NULL default '0',
  `jwu_user_id` int(10) unsigned NOT NULL default '0',
  `jwu_user_right` enum('A','O','U') NOT NULL default 'U',
  PRIMARY KEY  (`jwu_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `level`
#

DROP TABLE IF EXISTS `level`;
CREATE TABLE `level` (
  `level_id` tinyint(3) unsigned NOT NULL auto_increment,
  `level_name` varchar(200) NOT NULL default '',
  `level_description` text NOT NULL default '',
  `level_comment` text NOT NULL default '',
  `level_visual_identity` varchar(100) NOT NULL default '',
  `level_range` tinyint(3) unsigned NOT NULL default '0',
  `level_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `level_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `level_statut` enum('P','D','E') NOT NULL default 'P',
  PRIMARY KEY  (`level_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=5 ;

#
# Dumping data for table `level`
#

INSERT INTO `level` (`level_id`, `level_name`, `level_description`, `level_comment`, `level_visual_identity`, `level_range`, `level_date_crea`, `level_last_modify`, `level_statut`) VALUES (1, 'jeune public', 'premiers pas en matière d\'environnement, développement durable', '', '', 1, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');
INSERT INTO `level` (`level_id`, `level_name`, `level_description`, `level_comment`, `level_visual_identity`, `level_range`, `level_date_crea`, `level_last_modify`, `level_statut`) VALUES (2, 'débutant', 'connaissance succintes sur les sujets d\'environnement, développement durable', '', '', 2, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');
INSERT INTO `level` (`level_id`, `level_name`, `level_description`, `level_comment`, `level_visual_identity`, `level_range`, `level_date_crea`, `level_last_modify`, `level_statut`) VALUES (3, 'intérmediaire', 'initiés aux problématiques du développement durable', '', '', 3, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');
INSERT INTO `level` (`level_id`, `level_name`, `level_description`, `level_comment`, `level_visual_identity`, `level_range`, `level_date_crea`, `level_last_modify`, `level_statut`) VALUES (4, 'expert', 'vous avez des connaissances solides sur le sujet et maitrisez les enjeux', '', '', 4, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');

# --------------------------------------------------------

#
# Table structure for table `link_resources`
#

DROP TABLE IF EXISTS `link_resources`;
CREATE TABLE `link_resources` (
  `linkres_id` int(10) unsigned NOT NULL auto_increment,
  `linkres_text` text NOT NULL,
  `linkres_mask` varchar(200) NOT NULL default '',
  `linkres_range` tinyint(3) unsigned NOT NULL default '0',
  `linkres_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `linkres_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `linkres_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`linkres_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `multimedia_resources`
#

DROP TABLE IF EXISTS `multimedia_resources`;
CREATE TABLE `multimedia_resources` (
  `multires_id` int(11) unsigned NOT NULL auto_increment,
  `multires_name` varchar(200) NOT NULL default '',
  `multires_description` text NOT NULL,
  `multires_media_uri` varchar(255) NOT NULL default '',
  `multires_range` tinyint(11) unsigned NOT NULL default '0',
  `multires_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `multires_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `multires_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`multires_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `news`
#

DROP TABLE IF EXISTS `news`;
CREATE TABLE `news` (
  `news_id` int(10) unsigned NOT NULL auto_increment,
  `news_title` varchar(200) NOT NULL default '',
  `news_header` text NOT NULL,
  `news_body` text NOT NULL,
  `news_theme` tinyint(4) NOT NULL default '0',
  `news_scale` tinyint(4) NOT NULL default '0',
  `news_level` tinyint(4) NOT NULL default '0',
  `news_template` tinyint(4) NOT NULL default '0',
  `news_photo_uri` varchar(255) NOT NULL default '',
  `news_range` tinyint(3) unsigned NOT NULL default '0',
  `news_posted_by` int(11) NOT NULL default '0',
  `news_published_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `news_perempt_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `news_is_national` enum('Y','N') NOT NULL default 'N',
  `news_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `news_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `news_statut` enum('D','P','AA','PA','E') NOT NULL default 'D',
  PRIMARY KEY  (`news_id`),
  FULLTEXT KEY `news_index` (`news_title`,`news_header`,`news_body`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `newsletter`
#

DROP TABLE IF EXISTS `newsletter`;
CREATE TABLE `newsletter` (
  `newsletter_id` mediumint(9) NOT NULL auto_increment,
  `newsletter_title` varchar(200) default NULL,
  `newsletter_body` text NOT NULL,
  `newsletter_posted_by` int(11) NOT NULL default '0',
  `newsletter_published_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `newsletter_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `newsletter_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `newsletter_statut` enum('D','W','P','E') NOT NULL default 'D',
  PRIMARY KEY  (`newsletter_id`),
  FULLTEXT KEY `newsletter_index` (`newsletter_title`,`newsletter_body`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `profile`
#

DROP TABLE IF EXISTS `profile`;
CREATE TABLE `profile` (
  `profile_id` int(11) unsigned NOT NULL auto_increment,
  `profile_email` varchar(200) NOT NULL default '',
  `profile_email_display` enum('Y','N') NOT NULL default 'Y',
  `profile_city` varchar(100) NOT NULL default '',
  `profile_birthdate` date NOT NULL default '0001-01-01',
  `profile_leisures` varchar(150) NOT NULL default '',
  `profile_job` varchar(150) NOT NULL default '',
  `profile_avatar` varchar(255) NOT NULL default '',
  `profile_quotation` varchar(150) NOT NULL default '',
  `profile_signature` varchar(200) NOT NULL default '',
  `profile_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `profile_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`profile_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=2 ;

#
# Dumping data for table `profile`
#

INSERT INTO `profile` (`profile_id`, `profile_email`, `profile_email_display`, `profile_city`, `profile_birthdate`, `profile_leisures`, `profile_job`, `profile_avatar`, `profile_quotation`, `profile_signature`, `profile_date_crea`, `profile_last_modify`) VALUES (1, 'change_your@address.com', 'N', '', '0001-01-01', '', 'administrateur linea21', '', '', '', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

# --------------------------------------------------------

#
# Table structure for table `publication`
#

DROP TABLE IF EXISTS `publication`;
CREATE TABLE `publication` (
  `publi_id` int(10) unsigned NOT NULL auto_increment,
  `publi_title` varchar(200) NOT NULL default '',
  `publi_resume` text NOT NULL,
  `publi_theme` tinyint(4) NOT NULL default '0',
  `publi_scale` tinyint(4) NOT NULL default '0',
  `publi_level` tinyint(4) NOT NULL default '0',
  `publi_posted_by` tinyint(4) NOT NULL default '0',
  `publi_published_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `publi_comment` text NOT NULL,
  `publi_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `publi_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `publi_statut` enum('D','P','AA','PA','E') NOT NULL default 'D',
  PRIMARY KEY  (`publi_id`),
  FULLTEXT KEY `publi_index` (`publi_title`,`publi_resume`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


#
# Table structure for table `publication_contents`
#

DROP TABLE IF EXISTS `publication_contents`;
CREATE TABLE `publication_contents` (
  `publicon_id` int(10) unsigned NOT NULL auto_increment,
  `publicon_title` varchar(200) NOT NULL default '',
  `publicon_body` text NOT NULL,
  `publicon_template` tinyint(3) unsigned NOT NULL default '0',
  `publicon_photos_uri` varchar(255) NOT NULL default '',
  `publicon_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `publicon_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `publicon_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`publicon_id`),
  FULLTEXT KEY `publication_contents_index` (`publicon_title`,`publicon_body`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `rights`
#

DROP TABLE IF EXISTS `rights`;
CREATE TABLE `rights` (
  `rights_id` int(11) unsigned NOT NULL auto_increment,
  `rights_dashboard` enum('A','O','U') NOT NULL default 'U',
  `rights_workshop` enum('A','O','U') NOT NULL default 'U',
  `rights_project` enum('A','U') NOT NULL default 'U',
  `rights_publication` enum('A','O','U') NOT NULL default 'U',
  `rights_news` enum('A','O','U') NOT NULL default 'U',
  `rights_yellowpages` enum('A','O','U') NOT NULL default 'U',
  `rights_theme` enum('A','U') NOT NULL default 'U',
  `rights_scale` enum('A','U') NOT NULL default 'U',
  `rights_level` enum('A','U') NOT NULL default 'U',
  `rights_category_user` enum('A','U') NOT NULL default 'U',
  `rights_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `rights_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`rights_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=2 ;

#
# Dumping data for table `rights`
#

INSERT INTO `rights` (`rights_id`, `rights_dashboard`, `rights_workshop`, `rights_project`, `rights_publication`, `rights_news`, `rights_yellowpages`, `rights_theme`, `rights_scale`, `rights_level`, `rights_category_user`, `rights_date_crea`, `rights_last_modify`) VALUES (1, 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', 'A', CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);


# --------------------------------------------------------
#
# Table structure for table `scale`
#

DROP TABLE IF EXISTS `scale`;
CREATE TABLE `scale` (
  `scale_id` tinyint(4) unsigned NOT NULL auto_increment,
  `scale_denomination` varchar(200) NOT NULL default '',
  `scale_surface` double unsigned NOT NULL default '0',
  `scale_inhabitantsnumber` bigint(20) unsigned NOT NULL default '0',
  `scale_root` tinyint(3) unsigned NOT NULL default '0',
  `scale_comment` text NOT NULL default '',
  `scale_dependencies` tinyint(3) unsigned NOT NULL default '0',
  `scale_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `scale_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `scale_statut` enum('P','D','E','I') NOT NULL default 'P',
  PRIMARY KEY  (`scale_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=2 ;

#
# Dumping data for table `scale`
#

INSERT INTO `scale` (`scale_id`, `scale_denomination`, `scale_surface`, `scale_inhabitantsnumber`, `scale_root`, `scale_comment`, `scale_dependencies`, `scale_date_crea`, `scale_last_modify`, `scale_statut`) VALUES (1, 'Echelle racine', '', 0, 0, '', 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');

# --------------------------------------------------------


# --------------------------------------------------------
#
# Table structure for table `sd_theme`
#

DROP TABLE IF EXISTS `sd_theme`;
CREATE TABLE `sd_theme` (
  `sdtheme_id` tinyint(3) unsigned NOT NULL auto_increment,
  `sdtheme_name` varchar(150) NOT NULL default '',
  `sdtheme_description` text NOT NULL,
  `sdtheme_range` tinyint(4) NOT NULL default '0',
  `sdtheme_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdtheme_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`sdtheme_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=5 ;

#
# Dumping data for table `sd_theme`
#

INSERT INTO `sd_theme` (`sdtheme_id`, `sdtheme_name`, `sdtheme_description`, `sdtheme_range`, `sdtheme_date_crea`, `sdtheme_last_modify`) VALUES (1, 'social', '', 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO `sd_theme` (`sdtheme_id`, `sdtheme_name`, `sdtheme_description`, `sdtheme_range`, `sdtheme_date_crea`, `sdtheme_last_modify`) VALUES (2, 'économique', '', 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO `sd_theme` (`sdtheme_id`, `sdtheme_name`, `sdtheme_description`, `sdtheme_range`, `sdtheme_date_crea`, `sdtheme_last_modify`) VALUES (3, 'environnement', '', 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);
INSERT INTO `sd_theme` (`sdtheme_id`, `sdtheme_name`, `sdtheme_description`, `sdtheme_range`, `sdtheme_date_crea`, `sdtheme_last_modify`) VALUES (4, 'gouvernance', '', 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP);

# --------------------------------------------------------

#
# Table structure for table `sdi_evaluation`
#

DROP TABLE IF EXISTS `sdi_evaluation`;
CREATE TABLE `sdi_evaluation` (
  `sdie_id` int(10) unsigned NOT NULL auto_increment,
  `sdie_scale_compare` tinyint(3) unsigned NOT NULL default '0',
  `sdie_fiability` tinyint(3) unsigned NOT NULL default '0',
  `sdie_accessibility` tinyint(3) unsigned NOT NULL default '0',
  `sdie_lisibility` tinyint(3) unsigned NOT NULL default '0',
  `sdie_relevance` tinyint(3) unsigned NOT NULL default '0',
  `sdie_global_performance` tinyint(3) unsigned NOT NULL default '0',
  `sdie_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdie_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`sdie_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `sdi_info`
#

DROP TABLE IF EXISTS `sdi_info`;
CREATE TABLE `sdi_info` (
  `sdii_id` int(10) unsigned NOT NULL auto_increment,
  `sdii_name` varchar(255) NOT NULL default '',
  `sdii_description` text NOT NULL,
  `sdii_comment` text NOT NULL,
  `sdii_theme` tinyint(3) unsigned NOT NULL default '0',
  `sdii_range` tinyint(3) unsigned NOT NULL default '0',
  `sdii_goal` text NOT NULL,
  `sdii_consulting` text NOT NULL,
  `sdii_unit` varchar(100) NOT NULL default '',
  `sdii_max_value` float NOT NULL default '0',
  `sdii_min_value` float NOT NULL default '0',
  `sdii_threshold_value` float NOT NULL default '0',
  `sdii_threshold_relative` enum('Y','N') NOT NULL default 'Y',
  `sdii_frequency` int(11) NOT NULL default '0',
  `sdii_provider` int(10) unsigned NOT NULL default '0',
  `sdii_evaluation` int(10) unsigned NOT NULL default '0',
  `sdii_reglementation` int(10) unsigned NOT NULL default '0',
  `sdii_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdii_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `sdii_statut` enum('P','D','E') NOT NULL default 'P',
  PRIMARY KEY  (`sdii_id`),
  FULLTEXT KEY `sdi_info_index` (`sdii_name`,`sdii_description`,`sdii_goal`,`sdii_consulting`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;



# --------------------------------------------------------
#
# Table structure for table `sdi_provider`
#

DROP TABLE IF EXISTS `sdi_provider`;
CREATE TABLE `sdi_provider` (
  `sdip_id` int(10) unsigned NOT NULL auto_increment,
  `sdip_name` varchar(255) NOT NULL default '',
  `sdip_service` varchar(255) NOT NULL default '',
  `sdip_description` text NOT NULL default '',
  `sdip_incharge` varchar(150) NOT NULL default '',
  `sdip_address` text NOT NULL default '',
  `sdip_phone` varchar(10) NOT NULL default '',
  `sdip_fax` varchar(12) NOT NULL default '',
  `sdip_email` varchar(200) NOT NULL default '',
  `sdip_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdip_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`sdip_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `sdi_reglementation`
#

DROP TABLE IF EXISTS `sdi_reglementation`;
CREATE TABLE `sdi_reglementation` (
  `sdir_id` int(10) unsigned NOT NULL auto_increment,
  `sdir_title` varchar(255) NOT NULL default '',
  `sdir_body` text NOT NULL,
  `sdir_referer_uri` text NOT NULL,
  `sdir_mask_uri` varchar(255) NOT NULL default '',
  `sdir_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdir_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`sdir_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `sdi_value`
#

DROP TABLE IF EXISTS `sdi_value`;
CREATE TABLE `sdi_value` (
  `sdiv_id` int(10) unsigned NOT NULL auto_increment,
  `sdiv_value` float NOT NULL default '0',
  `sdiv_sdi_info` int(10) unsigned NOT NULL default '0',
  `sdiv_scale` tinyint(3) unsigned NOT NULL default '0',
  `sdiv_date_published` date NOT NULL default '0001-01-01',
  `sdiv_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `sdiv_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `sdiv_statut` enum('P','D','E') NOT NULL default 'P',
  PRIMARY KEY  (`sdiv_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;



# --------------------------------------------------------
#
# Table structure for table `theme`
#

DROP TABLE IF EXISTS `theme`;
CREATE TABLE `theme` (
  `theme_id` tinyint(4) unsigned NOT NULL auto_increment,
  `theme_name` varchar(200) NOT NULL default '',
  `theme_visual_uri` varchar(255) NOT NULL default '',
  `theme_sd_theme` tinyint(3) unsigned NOT NULL default '0',
  `theme_desc_project` text NOT NULL default '',
  `theme_desc_dashboard` text NOT NULL default '',
  `theme_desc_publication` text NOT NULL default '',
  `theme_desc_news` text NOT NULL default '',
  `theme_desc_workshop` text NOT NULL default '',
  `theme_range_project` tinyint(4) unsigned NOT NULL default '0',
  `theme_range_dashboard` tinyint(4) unsigned NOT NULL default '0',
  `theme_range_publication` tinyint(4) unsigned NOT NULL default '0',
  `theme_range_news` tinyint(4) unsigned NOT NULL default '0',
  `theme_range_workshop` tinyint(4) unsigned NOT NULL default '0',
  `theme_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `theme_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `theme_statut` enum('P','D','E') NOT NULL default 'P',
  PRIMARY KEY  (`theme_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


#
# Dumping data for table `theme`
#

INSERT INTO `theme` (`theme_id`, `theme_name`, `theme_visual_uri`, `theme_sd_theme`, `theme_desc_dashboard`, `theme_desc_project`, `theme_desc_publication`, `theme_desc_news`, `theme_desc_workshop`, `theme_range_dashboard`, `theme_range_project`, `theme_range_publication`, `theme_range_news`, `theme_range_workshop`, `theme_date_crea`, `theme_last_modify`, `theme_statut`) VALUES 
(1, 'sous thème à modifier', '', 1, 'description', 'description', 'description', 'description', 'description', 0, 0, 0, 0, 0, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'P');


# --------------------------------------------------------
#
# Table structure for table `user`
#

DROP TABLE IF EXISTS `luser`;
CREATE TABLE `luser` (
  `user_id` int(11) unsigned NOT NULL auto_increment,
  `user_login` varchar(20) NOT NULL default '',
  `user_password` varchar(20) NOT NULL default '',
  `user_community` int(11) NOT NULL default '0',
  `user_category` tinyint(4) NOT NULL default '0',
  `user_rights` int(11) NOT NULL default '0',
  `user_profile` int(11) NOT NULL default '0',
  `user_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `user_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `user_validity` enum('D','Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`user_id`),
  KEY `user_login` (`user_login`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin AUTO_INCREMENT=2 ;

#
# Dumping data for table `user`
#

INSERT INTO `luser` (`user_id`, `user_login`, `user_password`, `user_community`, `user_category`, `user_rights`, `user_profile`, `user_date_crea`, `user_last_modify`, `user_validity`) VALUES (1, 'admin', 'ldz8xiJGiGs4U', 1, 1, 1, 1, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP, 'Y');


# --------------------------------------------------------
#
# Table structure for table `workshop`
#

DROP TABLE IF EXISTS `workshop`;
CREATE TABLE `workshop` (
  `workshop_id` int(10) unsigned NOT NULL auto_increment,
  `workshop_denomination` varchar(255) NOT NULL default '',
  `workshop_resume` text NOT NULL,
  `workshop_theme` tinyint(4) NOT NULL default '0',
  `workshop_comment` text NOT NULL default '',
  `workshop_level` tinyint(3) unsigned NOT NULL default '0',
  `workshop_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `workshop_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `workshop_statut` enum('D','P','AA','PA','E') NOT NULL default 'D',
  PRIMARY KEY  (`workshop_id`),
  FULLTEXT KEY `workshop_index` (`workshop_denomination`,`workshop_resume`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `workshop_calendar`
#

DROP TABLE IF EXISTS `workshop_calendar`;
CREATE TABLE `workshop_calendar` (
  `workcal_id` int(10) unsigned NOT NULL auto_increment,
  `workcal_task_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `workcal_task` varchar(200) NOT NULL default '',
  `workcal_task_details` text NOT NULL,
  `workcal_workshop_id` int(11) NOT NULL default '0',
  `workcal_posted_by` tinyint(4) NOT NULL default '0',
  `workcal_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `workcal_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `workcal_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`workcal_id`),
  FULLTEXT KEY `workshop_cal_index` (`workcal_task`,`workcal_task_details`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `workshop_com`
#

DROP TABLE IF EXISTS `workshop_com`;
CREATE TABLE `workshop_com` (
  `workcom_id` int(10) unsigned NOT NULL auto_increment,
  `workcom_subject` varchar(200) NOT NULL default '',
  `workcom_body` text NOT NULL,
  `workcom_parent` int(10) unsigned NOT NULL default '0',
  `workcom_workshop_id` tinyint(3) unsigned NOT NULL default '0',
  `workcom_user_id` int(10) unsigned NOT NULL default '0',
  `workcom_last_user_id` int(10) unsigned NOT NULL default '0',
  `workcom_viewed` int(10) unsigned NOT NULL default '0',
  `workcom_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `workcom_last_modify` datetime NOT NULL default '0001-01-01 00:00:00',
  `workcom_statut` enum('P','C','E') NOT NULL default 'P',
  PRIMARY KEY  (`workcom_id`),
  FULLTEXT KEY `workshop_com_index` (`workcom_subject`,`workcom_body`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `workshop_report`
#

DROP TABLE IF EXISTS `workshop_report`;
CREATE TABLE `workshop_report` (
  `workrep_id` int(10) unsigned NOT NULL auto_increment,
  `workrep_title` varchar(200) NOT NULL default '',
  `workrep_resume` text NOT NULL,
  `workrep_workshop_id` int(10) unsigned NOT NULL default '0',
  `workrep_published_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `workrep_comment` text NOT NULL default '',
  `workrep_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `workrep_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `workrep_statut` enum('D','P','AA','PA','E') NOT NULL default 'D',
  PRIMARY KEY  (`workrep_id`),
  FULLTEXT KEY `workshop_report_index` (`workrep_title`,`workrep_resume`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `workshop_report_contents`
#

DROP TABLE IF EXISTS `workshop_report_contents`;
CREATE TABLE `workshop_report_contents` (
  `workrepcon_id` int(10) unsigned NOT NULL auto_increment,
  `workrepcon_title` varchar(100) NOT NULL default '',
  `workrepcon_body` text NOT NULL,
  `workrepcon_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `workrepcon_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `workrepcon_validity` enum('Y','N') NOT NULL default 'Y',
  PRIMARY KEY  (`workrepcon_id`),
  FULLTEXT KEY `workshop_report_contents_index` (`workrepcon_title`,`workrepcon_body`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


# --------------------------------------------------------
#
# Table structure for table `yellowpages`
#

DROP TABLE IF EXISTS `yellowpages`;
CREATE TABLE `yellowpages` (
  `yellowp_id` int(10) unsigned NOT NULL auto_increment,
  `yellowp_name` varchar(150) NOT NULL default '',
  `yellowp_activity` varchar(255) NOT NULL default '',
  `yellowp_theme` tinyint(4) NOT NULL default '0',
  `yellowp_street` varchar(200) NOT NULL default '',
  `yellowp_postal_code` varchar(6) NOT NULL default '',
  `yellowp_city` varchar(100) NOT NULL default '',
  `yellowp_country` varchar(100) NOT NULL default '',
  `yellowp_phone` varchar(12) NOT NULL default '',
  `yellowp_fax` varchar(12) NOT NULL default '',
  `yellowp_email` varchar(150) NOT NULL default '',
  `yellowp_website` varchar(150) NOT NULL default '',
  `yellowp_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `yellowp_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `yellowp_statut` enum('D','P','AA','E') NOT NULL default 'D',
  PRIMARY KEY  (`yellowp_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


-- 
-- Creating the **Project** table
--
CREATE TABLE `project` (
  `project_id` int(11) NOT NULL auto_increment,
  `project_parent_id` int(11) NOT NULL,
  `project_priority_id` int(11) NOT NULL,
  `project_scale_id` int(11) NOT NULL,
  `project_name` varchar(255) character set utf8 collate utf8_bin NOT NULL,
  `project_description` text character set utf8 collate utf8_bin,
  `project_body` text character set utf8 collate utf8_bin NOT NULL,
  `project_begin_date` date NOT NULL default '0001-01-01',
  `project_estimated_date` date NOT NULL default '0001-01-01',
  `project_end_date` date NOT NULL default '0001-01-01',
  `project_posted_by` int(11) NOT NULL,
  `project_published_date` datetime NOT NULL default '0001-01-01 00:00:00',
  `project_date_crea` datetime NOT NULL default '0001-01-01 00:00:00',
  `project_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `project_statut` enum('D','P','AA','PA','E') character set utf8 collate utf8_bin NOT NULL,
  PRIMARY KEY  (`project_id`),
  FULLTEXT KEY `project_name` (`project_name`,`project_description`,`project_body`)
)  ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;

-- 
-- Creating and populating the **Priority** table
--
CREATE TABLE `priority` (
  `priority_id` int(11) NOT NULL auto_increment,
  `priority_name` varchar(255) NOT NULL,
  `priority_date_crea` datetime default NULL,
  `priority_last_modify` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`priority_id`)
) ENGINE=MyISAM DEFAULT CHARACTER SET utf8 COLLATE utf8_bin ;


INSERT INTO `priority` VALUES (1, 'basse', NOW(), NOW());
INSERT INTO `priority` VALUES (2, 'moyenne', NOW(), NOW());
INSERT INTO `priority` VALUES (3, 'haute', NOW(), NOW());


SET NAMES 'utf8';
