<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../user/'.SQL.'.inc.php');


function DisplayInfoUser($user_id) {

	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));
	$content = '';
	if(count($data)!=1) return false;
	else 
	{
		
		// formattage des données
		$user_login=formatText($data[0]['user_login'], '2HTML');
		$user_public_email=$data[0]['profile_email_display'];
		$user_email=$data[0]['profile_email'];
		$user_email=formatText('<a href="mailto:'.$user_email.'">'.$user_email.'</a>', '2HTML');
		$user_groupe=formatText($data[0]['catus_name'], '2HTML');
			    	    	    	    	    	
		if($user_public_email=='Y') $user_public_email=$GLOBALS['lang']['divers']['yes'];
		else $user_public_email=$GLOBALS['lang']['divers']['no'];
		$user_profile_city=formatText(empty_nc($data[0]['profile_city']), '2HTML');
		$user_profile_birthdate=formatText(empty_nc($data[0]['profile_birthdate']), '2HTML');
		$user_profile_leisures=formatText(empty_nc($data[0]['profile_leisures']), '2HTML');
		$user_profile_job=formatText(empty_nc($data[0]['profile_job']), '2HTML');
		$user_profile_quotation=formatText(empty_nc($data[0]['profile_quotation']), '2HTML');
		$user_profile_signature=formatText(empty_nc($data[0]['profile_signature']), '2HTML');
		
		if(!empty($data[0]['profile_avatar'])) {
			list($complete_uri)=GetAllPhotoUri('../'.$data[0]['profile_avatar']);
			$user_profile_avatar='<img src="'.$complete_uri.'" alt="'.$GLOBALS['lang']['user']['avatar'].' '.$user_login.'" />';
		} else $user_profile_avatar=$GLOBALS['lang']['divers']['none'];
		
		$profile_last_modify_display=$data[0]['profile_last_modify_display'];
		$profile_date_crea_display=$data[0]['profile_date_crea_display'];

		$content.=GetLinkModifyUserInfo($user_id);
		$content.='<h1>'.$GLOBALS['lang']['user']['profile'].' '.$user_login.'</h1>'.END_LINE;
		$content.='<div class="h1_comment" id="h1_user">';
		$content.=$GLOBALS['lang']['user']['h1_public_comment'];
		$content.='</div>';
		$content.='<div id="userprofil">'.END_LINE;
		$content.='<dl>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['type'].'</dt>'.END_LINE;
		$content.='<dd>'.$user_groupe.'</dd>'.END_LINE;
		$content.='<dt>'. $GLOBALS['lang']['user']['email']. '</dt>'.END_LINE;
		if($user_public_email=='Y')	$content.='<dd>'.$user_email.'</dd>'.END_LINE;
		else $content.='<dd>'.$GLOBALS['lang']['statut']['draftpdf'].'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['birthdate'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_birthdate.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['city'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_city.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['leisures'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_leisures.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['job'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_job.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['avatar'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_avatar.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['quotation'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_quotation.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['user']['signature'].'</dt>'.END_LINE;
		$content.='<dd>'. $user_profile_signature.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['divers']['last_modify'].'</dt>'.END_LINE;
		$content.='<dd>'. $profile_last_modify_display.'</dd>'.END_LINE;
		$content.='<dt>'.$GLOBALS['lang']['divers']['date_crea'].'</dt>'.END_LINE;
		$content.='<dd>'. $profile_date_crea_display.'</dd>'.END_LINE;
		$content.='</dl>'.END_LINE;
		$content.='</div>'.END_LINE;
		
				
	}	
	echo $content;
}

function DisplayFormProfileUser($user_id, $submitted=-1) {

	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getAllUserInfo($user_id));
	$content = '';
	$mask_display_mail_1='';
	$mask_display_mail_2='';
	
	// en modification simple
	if($submitted==-1) {
		if(count($data)!=1) return false;
		else 
		{
			// formattage des données
			$form_login=formatText($data[0]['user_login'], '2FIELD');
			$form_public_email=$data[0]['profile_email_display'];
			$form_email=formatText($data[0]['profile_email'], '2FIELD');
			$current_email=formatText($data[0]['profile_email'], '2FIELD');
			$form_groupe=formatText($data[0]['catus_name'], '2FIELD');
			$current_avatar=$data[0]['profile_avatar'];
				    	    	    	    	    	
			if($form_public_email=='Y') $mask_display_mail_1=' checked="checked"';
			else $mask_display_mail_2=' checked="checked"';
			$form_profile_city=formatText($data[0]['profile_city'], '2FIELD');
			$form_profile_birthdate = isNullDate($data[0]['profile_birthdate']) ? '--' : formatDate($data[0]['profile_birthdate'], true);
			list($form_date_y, $form_date_m, $form_date_d)=explode('-', $form_profile_birthdate);
			$form_profile_leisures=formatText($data[0]['profile_leisures'], '2FIELD');
			$form_profile_job=formatText($data[0]['profile_job'], '2FIELD');
			$form_profile_quotation=formatText($data[0]['profile_quotation'], '2FIELD');
			$form_profile_signature=formatText($data[0]['profile_signature'], '2FIELD');
	
			if(!empty($data[0]['profile_avatar'])) {
				list($complete_uri)=GetAllPhotoUri('../'.$data[0]['profile_avatar']);
				$user_profile_avatar='<img src="'.$complete_uri.'" alt="'.$GLOBALS['lang']['user']['avatar'].' '.$_COOKIE['linea21']['login'].'" />';
			} else $user_profile_avatar=$GLOBALS['lang']['divers']['none'];
			
			$profile_last_modify_display=$data[0]['profile_last_modify_display'];
			$profile_date_crea_display=$data[0]['profile_date_crea_display'];
	}
	
	// un submit à déjà été fait, on affiche les infos entrées par l'utilisateur
	} else {
		$form_email=$_REQUEST['email'];
		$current_email=$_REQUEST['current_email'];
		$current_avatar=base64_decode($_REQUEST['current_avatar']);
		
		if(!empty($current_avatar)) {
				list($complete_uri)=GetAllPhotoUri('../'.$current_avatar);
				$user_profile_avatar='<img src="'.$complete_uri.'" alt="'.$GLOBALS['lang']['user']['avatar'].' '.$_COOKIE['linea21']['login'].'" />';
			} else $user_profile_avatar=$GLOBALS['lang']['divers']['none'];
			
		if($_REQUEST['email_display']=='Y') $mask_display_mail_1=' checked="checked"';
		else $mask_display_mail_2=' checked="checked"';
		$form_date_d=$_REQUEST['date_d'];
		$form_date_m=$_REQUEST['date_m'];
		$form_date_y=$_REQUEST['date_y'];
		$form_profile_city=$_REQUEST['city'];
		$form_profile_leisures=$_REQUEST['leisures'];
		$form_profile_job=$_REQUEST['job'];
		$form_profile_quotation=$_REQUEST['quotation'];
		$form_profile_signature=$_REQUEST['signature'];
	}

		$content.='<form action="index.php" method="post" enctype="multipart/form-data">'.END_LINE;
		$content.='<div id="userprofilmodify">'.END_LINE;
		$content.='<table class="modifyuser" summary="'.$GLOBALS['lang']['user']['p_mod_table_summary'].'">'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="email">'.$GLOBALS['lang']['user']['email'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="email" type="text" class="textfield" id="email" maxlength="200" value="'.$form_email.'" />'.END_LINE;
		$content.='<br />';
		$content.='<div class="advertise">'.END_LINE;
		$content.=$GLOBALS['lang']['user']['info_mail'].END_LINE;
		$content.='</div>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="email_display_Y">'.$GLOBALS['lang']['user']['email_display'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input type="radio" id="email_display_Y" class="radio" name="email_display" value="Y"'.$mask_display_mail_1.' /><span class="radio">'.$GLOBALS['lang']['divers']['yes'].'</span>'.END_LINE;
		$content.='<input type="radio" id="email_display_N" class="radio" name="email_display" value="N"'.$mask_display_mail_2.' /><span class="radio">'.$GLOBALS['lang']['divers']['no'].'</span>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="date_d">'.$GLOBALS['lang']['user']['birthdate'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.= sprintf(input_date($form_date_y, $form_date_m, $form_date_d));
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="city">'.$GLOBALS['lang']['user']['city'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="city" type="text" class="textfield" id="city" maxlength="100" value="'.$form_profile_city.'" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="leisures">'.$GLOBALS['lang']['user']['leisures'].' :</label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="'.$form_profile_leisures.'" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="job">'.$GLOBALS['lang']['user']['job'].' :</label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="job" type="text" class="textfield" id="job" maxlength="150" value="'.$form_profile_job.'" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		
		$content.='<tr>'.END_LINE;
		$content.='<td class="labelised">'.END_LINE;
		$content.=$GLOBALS['lang']['user']['current_avatar'].' : '.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.=$user_profile_avatar.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="avatar">'.$GLOBALS['lang']['user']['avatar'].' :</label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="avatar" type="file" size="47" id="avatar" class="textfield" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="quotation">'.$GLOBALS['lang']['user']['quotation'].' :</label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="quotation" type="text" class="textfield" id="quotation" maxlength="150" value="'.$form_profile_quotation.'" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="signature">'.$GLOBALS['lang']['user']['signature'].' :</label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="signature" type="text" class="textfield" id="signature" maxlength="200" value="'.$form_profile_signature.'" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='</table>'.END_LINE;
		
		$content.='<hr />'.END_LINE;
		$content.='<div class="advertise">'.END_LINE;
		$content.=$GLOBALS['lang']['user']['info_password'].END_LINE;
		$content.='</div>'.END_LINE;
		$content.='<table class="modifyuser">'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="password">'.$GLOBALS['lang']['user']['p_new_password'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="password" type="password" class="textfield" id="password" maxlength="20" value="" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='<tr>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<label for="password2">'.$GLOBALS['lang']['user']['p_new_password_confirm'].' : </label>'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='<td>'.END_LINE;
		$content.='<input name="password2" type="password" class="textfield" id="password2" maxlength="20" value="" />'.END_LINE;
		$content.='</td>'.END_LINE;
		$content.='</tr>'.END_LINE;
		$content.='</table>'.END_LINE;
		
		$content.='</div>'.END_LINE;
		$content.='<div style="text-align:right;margin:1em 0">'.END_LINE;
		$content.='<input name="current_email" type="hidden" value="'.$current_email.'" id="current_email" />'.END_LINE;
		$content.='<input name="current_avatar" type="hidden" value="'.base64_encode($current_avatar).'" id="current_avatar" />'.END_LINE;
		$content.='<input name="id" type="hidden" value="'.$user_id.'" id="id" />'.END_LINE;
		$content.='<input type="hidden" maxlength="20" size="15" name="rub" id="rub" value="'.$GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue'].'" />'.END_LINE;
		$content.= '<input type="image" src="../gfx/' .THEME_PUBLIC. '/images/public/' .LANGUAGE. '/button_valid.gif" value="'.$GLOBALS['lang']['btn']['valid'].'" alt="'.$GLOBALS['lang']['btn']['valid'].'" title="'.$GLOBALS['lang']['btn']['valid'].'" size="15" name="modprofile" id="modprofile" style="margin-left:30em" />'.END_LINE;
		$content.='</div>'.END_LINE;
		$content.='</form>'.END_LINE;

		echo $content;
}

function ModifyProfile() {
	
	$link_home= array('rub'=> $GLOBALS['links'][LANGUAGE]['home']['linkvalue']);
	
	$id=$_COOKIE['linea21']['id'];
	$integrity=1;
	$table_user[0]= ''; // valeur login --> Non checké
	$table_user[1] =$_REQUEST['email'];
	$table_profile[0] = $_REQUEST['email'];
	$table_profile[1] = $_REQUEST['email_display'];
	$table_profile[2] = $_REQUEST['city'];
	$form_date_d = trim($_REQUEST['date_d']);
	$form_date_m = trim($_REQUEST['date_m']);
	$form_date_y = trim($_REQUEST['date_y']);
	$form_date=$form_date_d . '-' . $form_date_m . '-' . $form_date_y;

	if(!empty($form_date_d) && !empty($form_date_m) && !empty($form_date_y)) {
	  $date_integrity=checkdate_validity($form_date);
	} else {
	  $date_integrity=true;
	}
	if(is_string($date_integrity)) $integrity = $date_integrity;
	else {
		$table_profile[3]= $form_date;
	}
	
	$table_profile[4] = $_REQUEST['leisures'];
	$table_profile[5] = $_REQUEST['job'];
	$table_profile[6] = $_REQUEST['quotation'];
	$table_profile[7] = $_REQUEST['signature'];
	$table_profile[8] = base64_decode($_REQUEST['current_avatar']);

	
	include_once('../class/class.user.php');
	$user_object= new user;
	$data_user_integrity=$user_object->CheckDataIntegrity($table_user);
	if(is_string($data_user_integrity)) $integrity=$data_user_integrity;

	if(!empty($_REQUEST['password'])) {
		$integrity=$user_object->checkPasswordValidity($_REQUEST['password'], $_REQUEST['password2']);
	}
	if(!is_string($integrity)) {
		if(isset($_FILES['avatar']) && $_FILES['avatar']['name']!='') {
			include_once('../class/system/class.upload.php');
			$upload_object= new upload;
			$upload=$_FILES['avatar'];
			$size_integrity=$upload_object->CheckMaxFile($upload['size'], $user_object->UPLOAD_MAX_MO);
			if(is_string($size_integrity)) $integrity=$size_integrity;
			$format_integrity=$upload_object->CheckExtImage($upload['name']);
			if(is_string($format_integrity)) $integrity=$format_integrity;
			if(!is_string($integrity)) {
				$final_name=$id.".".$upload_object->GetExtension($upload ['name']);
				$table_profile[8]=$user_object->URI_INPUT.$final_name;
				
				$destination="../".$user_object->URI_INPUT;
				$result_upload=$upload_object->UploadFile($upload, $final_name, $destination);
			}
		}
	}
	
	
	if(!is_string($integrity)) {
		$result=$user_object->ModifyProfile($id, $table_profile, $GLOBALS['sql_object']);

		if($result == true) {
			$string =$GLOBALS['lang']['user']['p_confirm_mod'].'.';
			$string.=' <a href="'.HrefMaker($link_home).'" title="'.$GLOBALS['lang']['user']['p_confirm_back'].'" >'.$GLOBALS['lang']['user']['p_confirm_back'].'</a>';
			$integrity = array('code'=> 'confirm', 'string' => $string);
		}
		if(($_REQUEST['email']!=$_REQUEST['current_email']) || !empty($_REQUEST['password'])) {
			if($_REQUEST['email']!=$_REQUEST['current_email']) {
				$new_pass=$user_object->GetNewPassword();
				$todo_mail='change_mail';	 // choix template pour mail
				$new_email=$_REQUEST['email']; 	// renseignement nouvel email
			}
			if(!empty($_REQUEST['password'])) {
				$new_pass=$_REQUEST['password'];
				$todo_mail='change_pass';	 // choix template pour mail
				$user_email=$_REQUEST['email'];		// renseignement email
			}
			$user_object->UpdateUserPassword($id, $new_pass, $GLOBALS['sql_object']);
			UpdateCookiePassword($new_pass);
			
			/** include envoi de mail */
			include_once('../user/mail_actions.php');
			include_once('../mail/template.php');
		}
	} else {
		$integrity = array('code'=> 'error', 'string' => $integrity);
	}
	
	$return_result ='<div class="'.$integrity['code'].'">'.END_LINE;
	$return_result.=$integrity['string'].END_LINE;
	$return_result.='</div>'.END_LINE;
	
	echo $return_result;
	if(!isset($result)) return DisplayFormProfileUser($_COOKIE['linea21']['id'], 1);
}

function GetLinkModifyUserInfo($user_id) {
	
	$content ='';
	if(isset($_COOKIE['linea21']['whois']) && $user_id==$_COOKIE['linea21']['id']) {
		$link_edit= array('rub'=> $GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue']);
	
		$content.='<div class="switchnav">'.END_LINE;
		$content.='<a href="'.HrefMaker($link_edit).'" title="'.$GLOBALS['lang']['user']['p_mod'].'">'.$GLOBALS['lang']['user']['p_mod'].'</a>';
		$content.='</div>'.END_LINE;
	}
	return $content;
}

function DisplayAuthTextInfo() {
	$link_account= array('rub'=> $GLOBALS['links'][LANGUAGE]['user-registration']['linkvalue']);
	$content ='<div class="info">'.END_LINE;
	$content.=$GLOBALS['lang']['user']['info_inscription'].END_LINE;
	 $content.='<a href="'.HrefMaker($link_account).'">'.$GLOBALS['lang']['user']['info_inscription2'].' </a>'.END_LINE;
	$content.='.<br />'.$GLOBALS['lang']['user']['info_inscription3'].''.END_LINE;
	$content.='</div>'.END_LINE;
	echo $content;
}

function DisplaySubscribeTextInfo() {
	$content ='<div class="info">'.END_LINE;
	//$content.=$GLOBALS['lang']['user']['info_inscription3'].'<br />'.END_LINE;
	//$content.=$GLOBALS['lang']['user']['info_inscription4'].'<br />'.END_LINE;
	$content.=$GLOBALS['lang']['user']['info_inscription5'].END_LINE;
	$content.='</div>';
	echo $content;
}
?>

