<?php
/**
 * @package linea21.modules
 * @subpackage news
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * News Management
 */

class news {
  /* @param
   * */
  var $TDB_NEWS = T_NEWS; // nom de la table.
  var $NB_TEMPLATE = 3; // nombre de templates associés a la classe
  var $URI_INPUT = "news/input/"; // dossier racine de stockage des photos
  var $URI_OUTPUT = "news/output/"; // dossier racine de diffusion des archives
  var $UPLOAD_MAX_MO = UPLOAD_MAX_MO; // taille maximale d'upload des photos en octets
  var $MAX_PHOTO_MAX_WIDTH = MAX_PHOTO_MAX_WIDTH;
  var $MAX_PHOTO_MIN_WIDTH = MAX_PHOTO_MIN_WIDTH;
  var $ID;
  var $TITLE;
  var $HEADER;
  var $BODY;
  var $THEME;
  var $SCALE;
  var $LEVEL;
  var $TEMPLATE;
  var $PHOTO_URI;
  var $RANGE;
  var $POSTED_BY;
  var $POST_DATE;
  var $PUBLISHED_DATE;
  var $PEREMPT_DATE;
  var $IS_NATIONAL;
  var $STATUT;

  /**
   * news::_getDate()
   * date courante et ajout
   *
   * @access private
   * @param int $m chiffre des mois
   * @param int $d chiffre des jours
   * @param int $y chiffre des années
   * @return string $format_date
   * @return
   */
  function _getDate($m = 0, $d = 0, $y = 0)
  {
    $format_date = mktime(date("H"), date("i"), date("s"), date("m") + $m, date("d") , date("Y"), -1);
    $format_date = strftime('%Y-%m-%d %H:%M:%S', $format_date);

    return $format_date;
  }

  /**
   * news::GetTemplateName()
   * Obtention de la dénomination du template
   *
   * @param integer $num
   * @return string $return
   */
  function GetTemplateName($num)
  {
    if ($num == 1) $return = $GLOBALS['lang']['news']['template_1'];
    if ($num == 2) $return = $GLOBALS['lang']['news']['template_2'];
    if ($num == 3) $return = $GLOBALS['lang']['news']['template_3'];
    if ($num == 4) $return = $GLOBALS['lang']['news']['template_4'];

    return $return;
  }

  /**
   * news::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table : contient les composants Nécessaires d'une news
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */

  function CheckDataIntegrity($table)
  {
    if (strlen($table[0]) < 3) return $GLOBALS['lang']['news']['no_title'];
    if (strlen($table[1]) < 3) return $GLOBALS['lang']['news']['no_header'];
    if (strlen($table[2]) < 3) return $GLOBALS['lang']['news']['no_body'];
    if ($table[3] <= 0 || !is_numeric($table[3])) return $GLOBALS['lang']['news']['no_theme'];
    if ($table[4] <= 0 || !is_numeric($table[4])) return $GLOBALS['lang']['news']['no_scale'];
    if ($table[5] <= 0 || !is_numeric($table[5])) return $GLOBALS['lang']['news']['no_level'];
    if ($table[6] <= 0 || !is_numeric($table[6])) return $GLOBALS['lang']['news']['no_template'];

    return true;
  }

  /**
   * news::AddNews()
   * Ajout d'une news
   *
   * @access public
   * @param array $table_news : contient les composants d'une news
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddNews($table_news, $sql_object)
  {
    $table_news=$sql_object->DBescape($table_news);

    if ($table_news[0] != '') {
      $this->TITLE = strip_input(trim($table_news[0]), true);
    }
    if ($table_news[1] != '') {
      $this->HEADER = strip_input(trim($table_news[1]), true);
    }
    if ($table_news[2] != '') {
      $this->BODY = strip_input(trim($table_news[2]), true);
    }
    if (is_numeric($table_news[3])) {
      $this->THEME = $table_news[3];
    }
    if (is_numeric($table_news[4])) {
      $this->SCALE = $table_news[4];
    }
    if (is_numeric($table_news[5])) {
      $this->LEVEL = $table_news[5];
    }
    if (is_numeric($table_news[6])) {
      $this->TEMPLATE = $table_news[6];
    }
    if ($table_news[7] != '') {
      $this->PHOTO_URI = $table_news[7];
    }
    if (is_numeric($table_news[8])) {
      $this->RANGE = $table_news[8];
    }
    if (is_numeric($table_news[9])) {
      $this->POSTED_BY = $table_news[9];
    }
    if ($table_news[11] != '') {
      $this->IS_NATIONAL = strtoupper($table_news[11]);
    }
    if ($table_news[12] != '') {
      $this->STATUT = strtoupper($table_news[12]);
    }
    if ($this->STATUT == 'P') {
      $this->PUBLISHED_DATE = $this->_getDate();
      if ($table_news[10] != '') {
        $this->PEREMPT_DATE = $table_news[10];
      } else {
        $this->PEREMPT_DATE = '0001-01-01';
      }
    } else {
      $this->PUBLISHED_DATE = '0001-01-01';
      $this->PEREMPT_DATE = '0001-01-01';
    }
    $requete = "INSERT INTO " . $this->TDB_NEWS . " (news_title, news_header, news_body, news_theme, news_scale, " . "news_level, news_template, news_photo_uri, news_range, news_posted_by, news_published_date, " . "news_perempt_date, news_is_national, news_statut, news_date_crea) " . "VALUES('" . $this->TITLE . "', '" . $this->HEADER . "', '" . $this->BODY . "', " . $this->THEME . ", " . $this->SCALE . ", " . $this->LEVEL . ", " . $this->TEMPLATE . ", '" . $this->PHOTO_URI . "', " . $this->RANGE . ", " . $this->POSTED_BY . ", '" . $this->PUBLISHED_DATE . "' , '" . $this->PEREMPT_DATE . "', '" . $this->IS_NATIONAL . "', '" . $this->STATUT . "', now());";
    
    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }

  /**
   * news::DeleteNews()
   * suppression d'une news
   *
   * @access public
   * @param int $ID : identifiant de la news
   * @param object $sql_object
   * @return bool $result
   */

  function DeleteNews($ID, $sql_object)
  {
    $this->ID = $ID;
    $requete = "UPDATE  " . $this->TDB_NEWS . " set news_statut='E', news_last_modify=NOW() WHERE news_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }

  /**
   * news::ModifyNews()
   * modification d'une news
   *
   * @access public
   * @param integer $ID : identifiant de la news
   * @param object $sql_object
   * @param array $table_news : contient les composants d'une news
   * @return boolean $result
   */
  function ModifyNews($ID, $table_news, $sql_object)
  {
    $table_news=$sql_object->DBescape($table_news);
    if (is_numeric($ID)) {
      $this->ID = $ID;
    }
    if ($table_news[0] != '') {
      $this->TITLE = strip_input(trim($table_news[0]), true);
    }
    if ($table_news[1] != '') {
      $this->HEADER = strip_input(trim($table_news[1]), true);
    }
    if ($table_news[2] != '') {
      $this->BODY = strip_input(trim($table_news[2]), true);
    }
    if (is_numeric($table_news[3])) {
      $this->THEME = $table_news[3];
    }
    if (is_numeric($table_news[4])) {
      $this->SCALE = $table_news[4];
    }
    if (is_numeric($table_news[5])) {
      $this->LEVEL = $table_news[5];
    }
    if (is_numeric($table_news[6])) {
      $this->TEMPLATE = $table_news[6];
    }
    if ($table_news[7] != '') {
      $this->PHOTO_URI = $table_news[7];
    }
    if ($table_news[8] != '') {
      $this->STATUT = $table_news[8];
    }

    $mask = $this->_HavePublishedDate($table_news[9]);

    $requete = "UPDATE  " . $this->TDB_NEWS . " set news_title='" . $this->TITLE . "', news_header='" . $this->HEADER . "', news_body='" . $this->BODY . "' , news_theme='" . $this->THEME . "', news_scale='" . $this->SCALE . "', news_level='" . $this->LEVEL . "', news_template='" . $this->TEMPLATE . "', news_photo_uri='" . $this->PHOTO_URI . "', news_statut='" . $this->STATUT . "', news_last_modify=NOW() " . $mask . " WHERE news_id='" . $this->ID . "';";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }

  /**
   * news::_HavePublishedDate()
   * Détermine la date de publication a inserer dans la bdd
   *
   * @access private
   * @param string $current_status : statut actuel de l'actualité
   * @return string $sql_mask
   */
  function _HavePublishedDate($current_status)
  {
    switch ($this->STATUT) {
      case 'P':
        if ($current_status == 'D') $sql_mask = ", news_published_date= NOW()";
        else $sql_mask = '';
        break;
      case 'D':
        $sql_mask = ", news_published_date= '0001-01-01'";
        break;
      default:
        $sql_mask = '';
    }
    return $sql_mask;
  }
}

?>
