<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

function GetCurrentCssStyle() {
  return $current_css_style= !isset($_COOKIE['linea21_style']) ? 'default' : $_COOKIE['linea21_style'];
}


function StyleIt() {

  switch(GetCurrentCssStyle()) {
    case 'nostyle':
      $content= '';
      $content .= '<link rel="alternate stylesheet" type="text/css" title="minimal" href="../gfx/' .THEME_PUBLIC. '/css/minimal.css" media="screen" />'.END_LINE;
      $content .= '<link rel="alternate stylesheet" type="text/css" title="classique" href="../gfx/' .THEME_PUBLIC. '/css/public.css" media="screen" />'.END_LINE;
      $content .= '<link rel="alternate stylesheet" type="text/css" title="blanc sur noir" href="../gfx/' .THEME_PUBLIC. '/css/darkstyle.css" media="screen" />'.END_LINE;
      break;
    case 'darkstyle':
      $content  = '<link rel="alternate stylesheet" type="text/css" title="minimal" href="../gfx/' .THEME_PUBLIC. '/css/minimal.css" media="screen" />'.END_LINE;
      $content .= '<link rel="alternate stylesheet" type="text/css" title="classique" href="../gfx/' .THEME_PUBLIC. '/css/public.css" media="screen" />'.END_LINE;
      $content .= '<link rel="stylesheet" type="text/css" href="../gfx/' .THEME_PUBLIC. '/css/darkstyle.css" />'.END_LINE;
      break;
    case 'minimal':
      $content  = '<link rel="alternate stylesheet" type="text/css" title="blanc sur noir" href="../gfx/' .THEME_PUBLIC. '/css/darkstyle.css" media="screen" />'.END_LINE;
      $content .= '<link rel="alternate stylesheet" type="text/css" title="classique" href="../gfx/' .THEME_PUBLIC. '/css/public.css" media="screen" />'.END_LINE;
      $content .= '<link rel="stylesheet" type="text/css" href="../gfx/' .THEME_PUBLIC. '/css/minimal.css" />'.END_LINE;
      break;
    default:
      $content  = '<link rel="alternate stylesheet" type="text/css" title="minimal" href="../gfx/' .THEME_PUBLIC. '/css/minimal.css" media="screen" />'.END_LINE;
      $content .= '<link rel="alternate stylesheet" type="text/css" title="blanc sur noir" href="../gfx/' .THEME_PUBLIC. '/css/darkstyle.css" media="screen" />'.END_LINE;
      $content .= '<link rel="stylesheet" type="text/css" href="../gfx/' .THEME_PUBLIC. '/css/public.css" media="screen" />'.END_LINE;
      $content .= '<link rel="stylesheet" type="text/css" href="../gfx/' .THEME_PUBLIC. '/css/public_' .LANGUAGE. '.css" media="screen" />'.END_LINE;
  }
  return $content;
}



function FooterStyleSwitcher() {

  $all_styles = array ('aucun style' => 'nostyle',
				'classique'  => 'default',
				'minimal'  => 'minimal',
				'blanc sur noir' => 'darkstyle');

  $array=array_diff ( $all_styles, array(GetCurrentCssStyle()));
  $sep='';
  $content='';
  foreach ($array as $key => $value) {
    $link= array('rub'=> $GLOBALS['links'][LANGUAGE]['css-switch']['linkvalue'], 'id' => $value, 'rewrite_override' => true);
    $content.=$sep.'<a href="'.HrefMaker($link).'">'.$key.'</a>'.END_LINE;
    $sep=' - ';
  }
  return $content;
}

?>