<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * optimize()
 * callback method
 * to ob_start()
 * @param string $buffer
 * @return string
 */
function optimize($buffer) {

  $title = implode(' - ', $GLOBALS['current_title']);


  return str_replace('##TITLE##', $title, $buffer);
}

/**
 * implode_with_keys()
 * implode avec clefs associées renvoyées
 * sous forme de chaîne de caractères
 * @param string $glue
 * @param string $array
 * @return string
 */
function implode_with_keys($glue, $array) {
  $output = array();
  foreach( $array as $key => $item )
  $output[] = $key . "=" . $item;

  return implode($glue, $output);
}

/**
 * getHttpParameters()
 * Renvoie les paramètres HTTP
 * sous forme de chaîne de caractères
 * @return string
 */
function getHttpParameters($prefix = '?') {

  return $prefix. (string) implode_with_keys('&', $_REQUEST);
}

/**
 * strip_input()
 * Remove PHP and HTML code
 * @param string $str
 * @param string $exceptions
 * @return string
 */
function strip_input($str, $exceptions = false) {

  if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR != (string) 0) {
    return $str;
  }
  else {
    if($exceptions)  {
      return strip_tags($str, ALLOWABLE_TAGS);
    }
    else {
      return strip_tags($str);
    }
  }

}

/**
 * IncludeTextResizerJs()
 * Include jQuery text-resizer plugin
 * if no js wysiwyg are enabled
 * @return void
 */
function IncludeTextResizerJs() {

  if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR == (string) 0 )
  {
    echo '<script type="text/javascript" src="../lib/js/jquery.textarearesizer.compressed.js"></script>';
    echo '<script type="text/javascript">
	  		$(document).ready(function() {
    			$(\'textarea.largetextfield:not(.processed)\').TextAreaResizer();
    		})
	  		</script>'.END_LINE;
  }
}

/**
 * IncludeRichTextEditor()
 * Include RichTextEditor if enabled
 * @return void
 */
function IncludeRichTextEditor() {

  if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR != (string) 0 )  {
    if(strtolower(RICH_TEXT_EDITOR) == 'tinymce')
    {
      echo '<script type="text/javascript" src="../lib/js/tinymce/jscripts/tiny_mce/tiny_mce.js"></script>'.END_LINE;
      echo '<script type="text/javascript" src="../lib/js/tinymce/jscripts/tiny_mce/config.js"></script>'.END_LINE;
    }
    if(strtolower(RICH_TEXT_EDITOR) == 'fck')
    {
       
      echo '<script type="text/javascript" src="../lib/js/fckeditor/fckeditor.js"></script>'.END_LINE;
      echo '<script type="text/javascript">
      		$(document).ready(function(){
    		
      		FCKeditor.BasePath = "../lib/js/fckeditor/";
      		FCKeditor.MinWidth = "300px";
			FCKeditor.ReplaceAllTextareas(\'largetextfield\');
    

 			 });
      		</script>'.END_LINE;
    }
  }

}


/**
 * IncludeLightboxJs()
 * Include Lightbox jQuery plugin
 * if needed
 * @return void
 */
function IncludeLightboxJs() {

  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  $todo = isset($_REQUEST['todo']) ? $_REQUEST['todo'] : '';

  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);
  $s = $rub . '|' . $todo;
  $a = $GLOBALS['lightbox_includes'];

  if(in_array($s, $a)) {

    echo '<script type="text/javascript" src="../lib/js/jquery.lightbox-0.5.pack.js"></script>'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="../gfx/'.THEME_ADMIN.'/css/jquery.lightbox-0.5.css" />'.END_LINE;
    echo '
        <script type="text/javascript">
    $(function() {
    	$("a.lightbox").lightBox();
    });
    </script>'. END_LINE;
  }
}

/**
 * IncludedatePickerJs()
 * Include Lightbox jQuery date Picker
 * if needed
 * @return void
 */
function IncludedatePickerJs() {

  $rub = isset($_REQUEST['rub']) ? $_REQUEST['rub'] : '';
  $todo = isset($_REQUEST['todo']) ? $_REQUEST['todo'] : '';

  if(ActiveItemKey($rub)) $rub = ActiveItemKey($rub);
  $s = $rub . '|' . $todo;
  $a = $GLOBALS['datePicker_includes'];

  if(in_array($s, $a)) {
    echo '<script type="text/javascript" src="../lib/js/jquery.datePicker.js"></script>'.END_LINE;
    echo '<link type="text/css" rel="stylesheet" href="../gfx/'.THEME_ADMIN.'/css/datePicker.css" />'.END_LINE;
    echo '<script type="text/javascript" src="../lib/js/date.js"></script>'.END_LINE;
    if(LANGUAGE != 'en') {
      echo '<script type="text/javascript" src="../lib/js/date_'. strtolower(LANGUAGE).'.js"></script>'. END_LINE;
    }
  }
}

/**
 * SureCreateDir()
 * Créer un dossier s'il n'existe pas.
 * @param string $pathname
 * @param integer $perms
 * @return integer $ver_num
 */
function SureCreateDir($pathname, $perms) {
  if(!file_exists($pathname)) {
    return mkdir ($pathname, $perms, true);
  } else {
    return true;
  }
}


/**
 * SureRemoveDir()
 * Supprime le contenu d'un dossier et le dossier lui-même si précisé.
 *
 * @return integer $ver_num
 */
function SureRemoveDir($dir, $DeleteMe) {
  if(!$dh = @opendir($dir)) return;
  while (($obj = readdir($dh))) {
    if($obj=='.' || $obj=='..') continue;
    if (!@unlink($dir.'/'.$obj)) SureRemoveDir($dir.'/'.$obj, true);
  }
  if ($DeleteMe){
    closedir($dh);
    @rmdir($dir);
  }
}

/**
 * num_phpversion()
 * Retourne un entier comme numéro de version PHP
 *
 * @return integer $ver_num
 */
function num_phpversion() {
  $ver = explode( '.', phpversion() );
  $ver_num = $ver[0] . $ver[1] . $ver[2];

  return $ver_num;
}

/**
 * cutText()
 * Découpe un texte à une longeur donnée.
 *
 * @param string $content
 * @param integer $length
 * @param integer $abbr
 * @param string $end
 * @return
 */
function cutText($content, $length, $abbr = 0, $end = '...')
{
  // fix bug #16
  if(function_exists('mb_substr')) $substr = mb_substr($content, 0, $length, CHARSET);
  else  $substr = substr($content, 0, $length);
  if (strlen($content) > $length) {
    if ($abbr == 1) $content_light = "<abbr title=\"" . $content . "\">" . $substr . $end . "</abbr>\n";
    else $content_light = $substr . $end;
  } else $content_light = $content;
  return $content_light;
}

/**
 * cutBody()
 * Renvoie un texte en 2 parties dans un tableau
 *
 * @param string $text
 * @return array $body
 */
function cutBody($text)
{
  $middle = (strlen($text) / 2);
  $end = strlen($text);
  $body[0] = substr($text, 0, $middle);
  $body[1] = substr($text, $middle, $end);
  $chaine = preg_split("/(\.(<br \/>| ))/", $body[1], 2);

  $body[0] .= $chaine[0] . ".";
  $body[1] = @trim($chaine[1]);

  return $body;
}

/**
 * EnlargeImage()
 * Miniatures; agrandissement onclick
 *
 * @param string $uri
 * @param string $style
 * @param string $alt_desc
 * @return string $img_link
 */
function EnlargeImage($uri, $style = '', $alt_desc = '')
{
  list($width, $height, $type, $attr) = getimagesize($uri);
  //$img_link = '<a href="' . $uri . '" title="' . $GLOBALS['lang']['divers']['enlarge_photo'] . '" onclick="displayImage(\'' . $uri . '\', \'\', \'' . $width . '\', \'' . $height . '\'); return false;">' . END_LINE;
  $img_link = '<a href="' . $uri . '" title="' . $GLOBALS['lang']['divers']['enlarge_photo'] . '" class="lightbox">' . END_LINE;

  $img_link .= '<img src="' . get_min_name($uri) . '" alt="' . $GLOBALS['lang']['divers']['enlarge_photo'] . ' ' . $alt_desc . '"' . $style . ' />' . END_LINE;
  $img_link .= '</a>' . END_LINE;

  return $img_link;
}

/**
 * formatNavTitle()
 * Formatage des titres ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatNavTitle($content)
{
  $content = formatText($content, '2HTML');
  $content = cutText($content, 70, 1);

  return $content;
}

/**
 * formatTextli()
 * Formatage des listes ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatTextli($content)
{
  $content = formatText($content, '2HTML');
  $content = cutText($content, 65, 1);
  return $content;
}

/**
 * formatTitleh2()
 * Formatage des titres h2 ( interface admin )
 *
 * @param string $content
 * @return string $content
 */
function formatTitleh2($content)
{
  $content = formatText($content, '2HTML');
  return $content;
}

/**
 * formatText()
 * Formatage de texte pour affichage
 *
 * @param  $content
 * @param string $format
 * @return string $content
 */
function formatText($content, $format = -1)
{
  $content = stripslashes(trim($content));
  switch ($format) {
    case '2HTML':
      $content = nl2br($content);
      break;
    case '2FIELD':
      $content = htmlentities($content, ENT_QUOTES, 'utf-8');
      break;
    case '2ATT':
      $content = htmlentities($content, ENT_QUOTES, 'utf-8');
      break;
    case '2XML':
      $content = strip_tags($content);
      break;
    case '2FILE':
      //$content = addslashes(trim($content));
      $content = htmlspecialchars($content, ENT_QUOTES, 'utf-8');
      break;
    default:
  }
  return $content;
}

/**
 * ReplaceInvalidChars()
 * Remplacement des caractères invalides  par leurs entités HTML
 *
 * @param string $str
 * @return string $valid_string
 */
function ReplaceInvalidChars($str)
{
  $htmlentities_chars = array('å' => '&#338;', 'ú' => '&#339;',
        'ä' => '&#352;', 'ö' => '&#353;',
        'ü' => '&#376;', 'à' => '&#710;',
        'ò' => '&#732;', 'ñ' => '&#8211;',
        'ó' => '&#8212;', 'ë' => '&#8216;',
        'í' => '&#8217;', 'Ç' => '&#8218;',
        'ì' => '&#8220;', 'î' => '&#8221;',
        'Ñ' => '&#8222;', 'Ü' => '&#8224;',
        'á' => '&#8225;', 'Ö' => '&#8230;',
        'â' => '&#8240;', 'É' => '&#402;',
        'ã' => '&#8249;', 'õ' => '&#8250;',
        'Ä' => '&#8364;', 'ô' => '&#8482;',
        'ï' => '&#8226;', 'ò' => '&#732;',
        'ô' => '&#8482;');

  //$valid_string = str_replace(array_keys($htmlentities_chars), array_values($htmlentities_chars), $str);
  //return $valid_string;
  return $str;
}

function stripAccents($string) {

  $search = explode(",","ç,æ,œ,á,é,í,ó,ú,à,è,ì,ò,ù,ä,ë,ï,ö,ü,ÿ,â,ê,î,ô,û,å,e,i,ø,u");
  $replace = explode(",","c,ae,oe,a,e,i,o,u,a,e,i,o,u,a,e,i,o,u,y,a,e,i,o,u,a,e,i,o,u");

  return str_replace($search, $replace, $string);


}

function stripText($text) {

  $text = strtolower($text);

  // strip all non word chars
  $text = preg_replace('/\W/', ' ', $text);
  // replace all white space sections with a dash
  $text = preg_replace('/\ +/', '-', $text);
  // trim dashes
  $text = preg_replace('/\-$/', '', $text);
  $text = preg_replace('/^\-/', '', $text);

  return $text;
}

/**
 * toStringSqlDate()
 * Renvoie la date au format SQL
 *
 * @param string $format
 * @return string $s
 */
function toStringSqlDate($format = 'short')
{
  $date_format =   array(
                   'dd-mm-yyyy' => array(
                      	'mysql' => array('short'=> '%d-%m-%Y', 'long'=> 
  array('12' => '%d-%m-%Y  %r', '24' => '%d-%m-%Y  %T')),
                    	'pgsql' => array('short'=> 'DD-MM-YYYY', 'long'=> 
  array('12' => 'DD-MM-YYYY HH12:MI:SS', '24' => 'DD-MM-YYYY HH24:MI:SS'))),
                    'yyyy-mm-dd' => array(
                      	'mysql' => array('short'=> '%Y-%m-%d', 'long'=> 
  array('12' => '%Y-%m-%d  %r', '24' => '%Y-%m-%d  %T')),
                    	'pgsql' => array('short'=> 'YYYY-MM-DD', 'long'=> 
  array('12' => 'YYYY-MM-DD HH12:MI:SS', '24' => 'YYYY-MM-DD HH24:MI:SS'))),

  );
   
  if($format == 'long') $s = $date_format[DATE_FORMAT][SQL][$format][TIME_FORMAT];
  else $s = $date_format[DATE_FORMAT][SQL][$format];

  return $s;
}


/**
 * date_compare()
 * Compare 2 dates with a given operator.
 * @param  $date1
 * @param  $date2
 * @param  $op
 * @return boolean
 */
function date_compare($date1, $date2, $op) {

  $date1= strtotime(formatDate($date1, true));
  $date2= strtotime(formatDate($date2, true));

  switch($op) {
    case '>':
      if($date1 > $date2) return true;
      else return false;
      break;
    case '<':
      if($date1 < $date2) return true;
      else return false;
    case '>=':
      if($date1 >= $date2) return true;
      else return false;
      break;
    case '<=':
      if($date1 <= $date2) return true;
      else return false;
    case '==':
      if($date1 == $date2) return true;
      else return false;
    default:
      return false;
  }
}


/**
 * distInclude()
 * Include the required file
 * if no user file is found,
 * includes the dist/ version file.
 *
 * @param string $file
 * @return void
 */
function distInclude($file)
{
  if(file_exists($file)) {
    include_once($file);
  } else {
    include_once(dirname($file).'/dist/'.basename($file));
  }
}

/**
 * formatDate()
 * Renvoie la date aux formats yyyy-mm-dd ou dd-mm-yyyy suivant le cas de départ
 * Si $db == true renvoie toujours la date au format yyyy-mm-dd
 *
 * @param string $date
 * @param boolean $db
 * @return string $new_date
 */
function formatDate($date, $db = false)
{
  @list($part1, $part2, $part3) = explode('-', $date);
  if(strlen($part1) == 2) {
    $new_date = $part3 . '-' . $part2 . '-' . $part1;
  } else {
    $new_date = $part1 . '-' . $part2 . '-' . $part3;
  }
  if($db == true) {
    // always return yyyy-mm-dd format
    if(strlen($part1) == 2) {
      $new_date = $part3 . '-' . $part2 . '-' . $part1;
    } else {
      $new_date = $part1 . '-' . $part2 . '-' . $part3;
    }
  }

  return $new_date;
}

/**
 * isNullDate()
 *
 * @param string $date
 * @return boolean
 */
function isNullDate($date)
{
  if($date == '0001-01-01' || $date == '01-01-0001') {
    return true;
  } else return false;

}

/**
 * empty_nc()
 * retourne le contenu ou N.C
 *
 * @param string $content
 * @return string $content
 */
function empty_nc($content)
{
  $content = trim($content);
  if (empty($content) || isNullDate($content)) $content = $GLOBALS['lang']['divers']['nc'];

  return $content;
}

/**
 * empty_none()
 * retourne le contenu ou 'aucun'
 *
 * @param string $content
 * @return string $content
 */
function empty_none($content)
{
  $content = trim($content);
  if (empty($content)) $content = $GLOBALS['lang']['divers']['none'];

  return $content;
}

/**
 * empty_none()
 * retourne le contenu ou 0
 *
 * @param string $content
 * @return string $content
 */
function empty_numeric($content)
{
  $content = trim($content);
  if (empty($content)) $content = 0;

  return $content;
}

/**
 * checkdate_validity()
 * Vérifie la validité d'une date
 *
 * @param string $date
 * @param string $msg (optionnal)
 * @return boolean true or error message (string)
 */
function checkdate_validity($date, $msg= '')
{

  $date=formatDate($date, true);
  @list($year, $month, $day) = explode('-', $date);

  if(!preg_match('/^\d{4}-\d\d-\d\d$/', $date)) {
    $msg .= $GLOBALS['lang']['date']['not_valid'];
    return $msg;
  }

  if (!@checkdate($month , $day , $year)) return $msg . $GLOBALS['lang']['date']['date_do_not_exist'];
  return true;
}

/**
 * display_errors()
 * Affichage d'un message d'erreur utilisateur
 *
 * @param string $msg
 * @return void (echo)
 */
function display_errors($msg)
{
  $display_it = "<div class=\"error\">\n";
  $display_it .= $msg;
  $display_it .= "</div>\n";
  echo $display_it;
}

/**
 * system_error()
 * Affichage d'un message d'erreur syst�me
 *
 * @param string $msg
 * @return void (echo)
 */
function system_error($msg = ERROR_SYSTEM)
{
  $display_it = "<div class=\"systemerror\">\n";
  $display_it .= $msg;
  $display_it .= "</div>\n";
  echo $display_it;
  exit;
}

/**
 * get_temp_name()
 * obtenir le nom temporaire d'un fichier
 *
 * @param string $path
 * @return string $temp_path
 */
function get_temp_name($path)
{
  $short_path = dirname($path);
  $filename = basename($path);
  $temp_path = $short_path . "/temp_" . $filename;
  return $temp_path;
}

/**
 * get_min_name()
 * obtenir le nom de la miniature d'un fichier
 *
 * @param string $path
 * @return string $min_path
 */
function get_min_name($path)
{
  $short_path = dirname($path);
  $filename = basename($path);
  $min_path = $short_path . "/min_" . $filename;
  return $min_path;
}

/**
 * ExcedMaxSize()
 * Teste si une image dépasse ou non la taille autorisée (en pixels)
 *
 * @param string $path
 * @param integer $width_max
 * @return boolean
 */
function ExcedMaxSize($path, $width_max)
{
  list($width, $height, $type, $attr) = getimagesize($path);
  if ($width > $width_max || $height > $width_max) return true;
  else return false;
}

/**
 * GetAllPhotoUri()
 * renvoie les paths des photos dans un tableau
 *
 * @param string $path
 * @param string $opt
 * @return array $tab
 */
function GetAllPhotoUri($path, $opt = -1)
{
  if (empty($path)) return false;
  else {
    $tab = explode('|', $path);
    if ($opt == 'min') array_walk($tab, 'get_min_name');
    return $tab;
  }
}

/**
 * cancel_button()
 * génére un bouton de retour
 *
 * @param  $back_uri
 * @return string
 */
function cancel_button($back_uri)
{
  return '<input name="annuler" type="button" value="' . $GLOBALS['lang']['btn']['annul'] . '" class="button" id="annuler" onclick="window.location=\'' . $back_uri . '\';" />';
}

/**
 * GetDisplayUserRight()
 * renvoie les droits d'un utilisateur
 *
 * @param string $indice
 * @param string $module
 * @return string
 */
function GetDisplayUserRight($indice, $module = -1)
{
  $indice = strtoupper($indice);
  if ($indice == 'U') return $GLOBALS['lang']['user']['norights'];
  if ($indice == 'A') return $GLOBALS['lang']['user']['adminrights'];
  if ($indice == 'O' && $module == 'dashboard') return $GLOBALS['lang']['user']['managerrights'];
  if ($indice == 'O' && $module == 'workshop') return $GLOBALS['lang']['user']['animatorrights'];
  if ($indice == 'O' && ($module != 'workshop' && $module != 'dashboard')) return $GLOBALS['lang']['user']['redactorrights'];
}

/**
 * Display_linkin_page()
 *
 * @param array $table_link
 * @param integer $total
 * @param integer $debut
 * @param integer $pas
 * @return void
 **/
function Display_linkin_page($table_link, $total, $debut, $pas = SELECT_LIMIT)
{
  $result = ceil($total / $pas);
  if ($result <= 1) return '&nbsp;';
  else {
    $link = '<div class="lienliste">'.END_LINE;
    $link .= '&lt; &lt; ';
    $sep='';
    for($i = 0; $i < $result; $i++) {
      $current_pos = ($pas * $i);
      if ($debut == $current_pos) $link .= $sep."<span>" . ($i + 1) . "</span> \n";
      else {
        $array_pos = array ('debut' => $current_pos);
        $new_table_link = array_merge ($table_link, $array_pos);
        $link .= $sep.'<a href="'. HrefMaker($new_table_link) . '">' . ($i + 1) . '</a>'.END_LINE;
      }
      $sep=' | ';
    }
    $link .= ' &gt; &gt;';
    $link .= '</div>'.END_LINE;
    echo $link;
  }
}

/**
 * linkin_page()
 * création d'un navigateur de pages numérotées
 *
 * @param string $string_uri
 * @param integer $total
 * @param integer $debut
 * @param integer $pas
 * @return string $link
 */
function linkin_page($string_uri, $total, $debut, $pas = SELECT_LIMIT)
{
  $result = ceil($total / $pas);
  if ($result <= 1) return '&nbsp;';
  else {
    if (strpos($string_uri, '?') === false) $string_uri .= '?';
    else $string_uri .= '&amp;';
    $link = '<div class="lienliste">';
    for($i = 0; $i < $result; $i++) {
      $current_pos = ($pas * $i);
      if ($debut == $current_pos) $link .= "<span>" . ($i + 1) . "</span> \n";
      else $link .= "<a href=\"" . $string_uri . "debut=" . $current_pos . "\">" . ($i + 1) . "</a> \n";
    }
    $link .= '</div>';
    return $link;
  }
}

/**
 * display_statut()
 * renvoie le statut en pleines lettres
 *
 * @param string $statut
 * @return string $result
 */
function display_statut($statut)
{
  switch ($statut) {
    case 'P':
      $result = $GLOBALS['lang']['statut']['public'];
      break;
    case 'D':
      $result = $GLOBALS['lang']['statut']['draft'];
      break;
    case 'E':
      $result = $GLOBALS['lang']['statut']['E'];
      break;
    case 'AA':
      $result = $GLOBALS['lang']['statut']['AA'];
      break;
    case 'PA':
      $result = $GLOBALS['lang']['statut']['PA'];
      break;
    case 'C':
      $result = $GLOBALS['lang']['statut']['C'];
      break;
    case 'U':
      $result = $GLOBALS['lang']['statut']['U'];
      break;
    case 'O':
      $result = $GLOBALS['lang']['statut']['O'];
      break;
    case 'A':
      $result = $GLOBALS['lang']['statut']['A'];
      break;
    case 'W':
      $result = $GLOBALS['lang']['statut']['W'];
      break;
    default:
      $result = $GLOBALS['lang']['statut']['public'];
  }
  return $result;
}

/**
 * linkin_content()
 * Cherche les liens et emails dans du contenu -> linkage
 *
 * @param string $content
 * @param string $option
 * @return string $content
 */
function linkin_content($content, $option = 'ALL')
{
  if(defined('AUTO_LINK') && AUTO_LINK == 1)
  {
    if(defined('RICH_TEXT_EDITOR') && RICH_TEXT_EDITOR == (string) 0) {
      if ($option == 'ALL' || $option == 'MAIL') {
        $content = eregi_replace("( |<br />)+([_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)+)", '\\1<a href="mailto:\\2">\\2</a>', $content);
      }
      if ($option == 'ALL' || $option == 'LINK') {
        $content = eregi_replace("(http|https|ftp|ftps)://([-a-z0-9#?/&=:,_;@%.{}]*)([a-z0-9=]{2,4})", '<a href="\\1://\\2\\3" class="out">\\1://\\2\\3</a>', $content);
      }
    }
  }

  return $content;
}

/**
 * QuickBoxNow()
 * Génération de la quickbox
 *
 * @param string $module
 * @param string $h1
 * @param string $liste
 * @param string $suffixclass
 * @return string $quickbox
 */
function QuickBoxNow($module, $h1, $liste, $suffixclass = '')
{
  $quickbox = "<div class=\"entete\">\n<div class=\"qb_ico\" id=\"qbico" . $suffixclass . "\" title=\"" . $module . "\"></div>\n";
  $quickbox .= "<div class=\"quickbox\" id=\"qbbg" . $suffixclass . "\">\n";
  $quickbox .= "<h1>" . $h1 . "</h1>\n";
  $quickbox .= "<ul>";
  $quickbox .= $liste;
  $quickbox .= "</ul>";
  $quickbox .= "</div>";
  $quickbox .= "</div>";

  return $quickbox;
}

/**
 * ReloadIndex()
 * Chargement de l'index après destruction de sessions
 *
 * @param string $item
 * @return void
 */
function ReloadIndex($item)
{
  switch ($item) {
    case 'public':
      return header("Location: ../public/logout.php");
      break;
    case 'admin':
      return header("Location: ../admin/logout.php");
      break;
  }
}

/**
 * getmicrotime()
 * renvoie le temps en microsecondes
 *
 * @return float
 */
function getmicrotime()
{
  list($usec, $sec) = explode(" ", microtime());
  return ((float)$usec + (float)$sec);
}



/**
 * GenerateXhtmlPage()
 *
 * @param $string
 * @param integer $time
 * @param unknown $redirect
 * @return
 **/
function GenerateXhtmlPage($string, $time = 2, $redirect = SITE_CITY_URL)
{


  $page  = '<?xml version="1.0" encoding="ISO-8859-1" xml:lang="' . LANGUAGE . '"?>' . END_LINE;
  $page .= '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">' . END_LINE;
  $page .= '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="' . LANGUAGE . '">' . END_LINE;
  $page .= '<head>' . END_LINE;
  $page .= '<meta http-equiv="content-type" content="text/html;charset=' . CHARSET . '" />' . END_LINE;
  $page .= '<meta http-equiv="content-langage" content="' . CHARSET . '" />' . END_LINE;
  $page .= '<meta http-equiv="refresh" content="' . $time . ';url=' . $redirect . '">' . END_LINE;
  $page .= '<link rel="icon" type="image/gif" href="../gfx/' .THEME_ADMIN. '/images/admin/favicon.gif" />' . END_LINE;
  $page .= '<title>'.SITE_CITY_NAME.'</title>' . END_LINE;
  $page .= '</head>' . END_LINE;
  $page .= '<body>' . END_LINE;
  $page .= '<div class="info" style="margin-top:10em">'.$string.END_LINE;
  $page .= '<br />';
  $page .= sprintf( $GLOBALS['lang']['divers']['redirect_string'], $redirect, $time);
  $page .= '</div>'. END_LINE;
  $page .= '</body>' . END_LINE;
  $page .= '</html>' . END_LINE;

  return $page;
}



?>