<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');  
////////////


if (isset($_GET['id'])) $id = $_GET['id'];
if (isset($_POST['id'])) $id = $_POST['id'];

$req_det = SQL_getoneCompleteProject($id);
$result = $sql_object->DBSelect($req_det);
if ($result == 0 || count($result) != 1) exit;

$project_object = new project;

$display_name = formatText($result[0]['project_name'], '2HTML');
$display_priority = formatText($result[0]['project_priority'], '2HTML');
if(!is_numeric($result[0]['project_parent_id']) || $result[0]['project_parent_id']==0) {
  $display_parent = $lang['divers']['none'];
} else {
  $display_parent = '<a href="'.$rub_link .'&amp;todo=det&amp;id='.$result[0]['project_parent_id'].'" title="'.$GLOBALS['lang']['project']['det'].' '.formatText($result[0]['parent_name'], '2ALT').'">'.formatText($result[0]['parent_name'], '2HTML').'</a>';
}
$display_description = linkin_content(formatText(empty_none($result[0]['project_description']), '2HTML'));
$display_body = linkin_content(formatText($result[0]['project_body'], '2HTML'));

$display_scale = formatText($result[0]['scale_denomination'], '2HTML');
$display_user = formatText($result[0]['user_login'], '2HTML');
$display_begin_date = empty_nc($result[0]['project_begin_date_display']);
$display_estimated_date = empty_nc($result[0]['project_estimated_date_display']);
$display_end_date = empty_nc($result[0]['project_end_date_display']);
$display_date_crea = $result[0]['project_date_crea_display'];
$display_last_modify = $result[0]['project_last_modify_display'];
$project_posted_by = $result[0]['project_posted_by'];
$project_scale_id = $result[0]['project_scale_id'];


$display_statut = display_statut($result[0]['project_statut']);
if ($result[0]['project_published_date_display'] == '01-01-0001') $display_published_date = $GLOBALS['lang']['statut']['draft'];
else $display_published_date = $result[0]['project_published_date_display'];

$link_sup = $rub_link . "&amp;todo=sup&amp;id=";
$link_mod = $rub_link . "&amp;todo=mod&amp;id=";

?>
<div id="chemin">
	<ul>
		<li>
			<a href="index.php">
			<?php echo $GLOBALS['lang']['way']['home']; ?>
			</a>
		</li>
		<li>
			<a href="<?php echo $rub_link;?>">
			<?php echo $GLOBALS['lang']['menu']['project']; ?>
			</a>
		</li>
		<li>
			<span><?php echo formatNavTitle($GLOBALS['lang']['project']['det'] . " : " . $display_name); ?></span>
		</li>
	</ul>
</div>
  <!--end barre haute -->
<?php
include_once("quickicons.php");

?>
<div class="contentcontainer">
<?php
include_once($dir . "/menurub.php");

?>
<div id="content">
		<?php
echo "<h2>";
echo formatTitleh2($display_name);
echo "</h2>\n";
echo "\t<a href=\"" . $link_sup . $id . "\" class=\"ico_sup2\" title=\"" . $GLOBALS['lang']['project']['sup'] . "\"></a>\n";
echo "\t<a href=\"" . $link_mod . $id . "\" class=\"ico_mod2\" title=\"" . $GLOBALS['lang']['project']['mod'] . "\"></a>\n";

echo "<dl class=\"dl3\">\n";
echo "<dt>" . $GLOBALS['lang']['project']['name'] . "</dt>\n";
echo "<dd>" . $display_name . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['parent'] . "</dt>\n";
echo "<dd>" . $display_parent . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['description'] . "</dt>\n";
echo "<dd>" . $display_description . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['body'] . " :</dt>\n";
echo "<dd>" . $display_body . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['begin_date'] . " :</dt>\n";
echo "<dd>" . $display_begin_date . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['estimated_date'] . " :</dt>\n";
echo "<dd>" . $display_estimated_date . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['end_date'] . " :</dt>\n";
echo "<dd>" . $display_end_date . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['priority'] . "</dt>\n";
echo "<dd>" . $display_priority . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['project']['scale'] . " :</dt>\n";
echo '<dd><a href="?rub=scale&amp;todo=det&amp;id='.$project_scale_id.'">' . $display_scale . '</a></dd>'.END_LINE;
echo "<dt>" . $GLOBALS['lang']['project']['author'] . " :</dt>\n";
echo '<dd><a href="?rub=user&amp;todo=det&amp;id='.$project_posted_by.'">' . $display_user . '</a></dd>'.END_LINE;
echo "<dt>" . $GLOBALS['lang']['statut']['published_on'] . "</dt>\n";
echo "<dd>" . $display_published_date . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['divers']['date_crea'] . "</dt>\n";
echo "<dd>" . $display_date_crea . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['divers']['last_modify'] . "</dt>\n";
echo "<dd>" . $display_last_modify . "</dd>\n";
echo "<dt>" . $GLOBALS['lang']['divers']['statut'] . "</dt>\n";
echo "<dd>" . $display_statut . "</dd>\n";
echo "</dl>\n";

?>

</div>
<?php include_once($dir . "/help.php");
?>
</div>
