<?php
/**
 * @package linea21.core
 * @subpackage search
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */
?>
<div id="chemin">
	<ul>
		<li>
			<a href="index.php"><?php echo $GLOBALS['lang']['way']['home'];?></a>
		</li>
		<li>
			<a href="<?php echo $rub_link;?>"><?php echo $GLOBALS['lang']['menu']['search'];?></a>
		</li>
	</ul>
</div>
<!--end barre haute -->

<?php
include_once("quickicons.php");
?>
<div class="contentcontainer">
<?php include_once($dir . "/menurub.php"); ?>
<div id="content">
<?php
if (!isset($_POST['valid'])) {
    echo '<h2>' . $GLOBALS['lang']['menu']['search'] . '</h2>' . END_LINE;

    ?>
<form action="<?php echo $_SERVER['PHP_SELF'];?>" method="post">
<div id="searchcontent">
<label for="search"><?php echo $GLOBALS['lang']['search']['keywords'];?></label>
<input type="text" maxlength="150"  class="textfield" name="search" id="search" style="margin-right:30px" />
<br class="brendstep" />
<div style="margin-right:30px">
<input type="radio" name="searchtype" id="searchtype_1" value="one" checked="checked" /><span class="radio"><?php echo $GLOBALS['lang']['search']['one_of_them'];?></span>
<input type="radio" name="searchtype" id="searchtype_2" value="all" /><span class="radio"><?php echo $GLOBALS['lang']['search']['all_of_them'];?></span>
<input type="radio" name="searchtype" id="searchtype_3" value="exp" /><span class="radio"><?php echo $GLOBALS['lang']['search']['expression'];?></span>
</div>
<input type="hidden" name="rub" id="rubsearch" value="<?php echo $rub;?>" />
<br class="brendstep" />
<input type="submit" value="<?php echo $GLOBALS['lang']['search']['text_button'];?>" size="15" name="valid" class="button" id="validsearch" />
</div>
</form>
<?php
} else {
	$type = 'ADMIN';
    include_once($dir . "/display.php");
    if (!isset($_REQUEST['search']) || strlen($_REQUEST['search']) <= 3)
	{
	echo '<div class="info">'.END_LINE;
    	echo $GLOBALS['lang']['search']['min_length'];
    	echo  '</div>'.END_LINE; 
    } else {
        if (isset($_REQUEST['searchincome'])) $str = trim($_REQUEST['searchincome']);
        else $str = $_REQUEST['search'];
        if (!isset($_REQUEST['searchtype'])) $searchtype = 'one';
        else $searchtype = $_REQUEST['searchtype'];
		if($searchtype=='one') $display_method=$GLOBALS['lang']['search']['one_of_them'];
		if($searchtype=='all') $display_method=$GLOBALS['lang']['search']['all_of_them'];
		if($searchtype=='exp') $display_method=$GLOBALS['lang']['search']['expression'];
        echo '<h2>' . $GLOBALS['lang']['search']['result'] . '</h2>' . END_LINE;
		
        echo '<div id="KeyWords">'.END_LINE;
		echo $GLOBALS['lang']['search']['keywords'];
		echo formatText($str, '2HTML').'<br />'.END_LINE;
		echo $GLOBALS['lang']['search']['method'];
		echo $display_method.'<br />'.END_LINE;
		echo '</div>'.END_LINE;
        $start_time = getmicrotime();
        if ($rub == 'home') $rub = 'all';
        switch ($rub) {
        case 'project':
			IsSuperAdmin() ? DisplaySearchProject($str, $type, $searchtype) : ReloadIndex('admin');
        case 'news':
			HaveRight('news') ? DisplaySearchNews($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'newsletter':
            IsSuperAdmin() ? DisplaySearchNewsletter($str, $type, $searchtype) : ReloadIndex('admin');
            break;
		case 'publication':
			HaveRight('publication') ? DisplaySearchPublication($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('publication') ? DisplaySearchPubliContents($str, $type, $searchtype) : ReloadIndex('admin');
            break;
		case 'workshop':
			HaveRight('workshop') ? DisplaySearchWorkshop($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('workshop') ? DisplaySearchWorkshopCalendar($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('workshop') ? DisplaySearchWorkshopCom($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'workshoprep':
			HaveRight('workshop') ? DisplaySearchWorkshopRep($str, $type, $searchtype) : ReloadIndex('admin');
			HaveRight('workshop') ? DisplaySearchWorkshopRepContents($str, $type, $searchtype) : ReloadIndex('admin');
            break;
		case 'dashboard':
			HaveRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'sdi':
			HaveRight('dashboard') ? DisplaySearchSdi($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'yellowpages':
			IsSuperAdmin() ? DisplaySearchYellowpages($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'user':
			IsSuperAdmin() ? DisplaySearchUser($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'theme':
			IsSuperAdmin() ? DisplaySearchTheme($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'scale':
			IsSuperAdmin() ? DisplaySearchScale($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'level':
			IsSuperAdmin() ? DisplaySearchLevel($str, $type, $searchtype) : ReloadIndex('admin');
			break;
		case 'all':
		    if (IsSuperAdmin()) DisplaySearchProject($str, $type, $searchtype);
		    echo '<hr />';
			if (HaveRight('news')) DisplaySearchNews($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchNewsletter($str, $type, $searchtype);
			echo '<hr />';
			if (HaveRight('publication')) DisplaySearchPublication($str, $type, $searchtype);
			if (HaveRight('publication')) DisplaySearchPubliContents($str, $type, $searchtype);
			echo '<hr />';
			if (HaveRight('workshop')) DisplaySearchWorkshop($str, $type, $searchtype);
			if (HaveRight('workshop')) DisplaySearchWorkshopRep($str, $type, $searchtype);
			if (HaveRight('workshop')) DisplaySearchWorkshopRepContents($str, $type, $searchtype);
			if (HaveRight('workshop')) DisplaySearchWorkshopCalendar($str, $type, $searchtype);
			if (HaveRight('workshop')) DisplaySearchWorkshopCom($str, $type, $searchtype);
			echo '<hr />';
			if (HaveRight('dashboard')) DisplaySearchSdi($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchYellowpages($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchUser($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchTheme($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchScale($str, $type, $searchtype);
			echo '<hr />';
			if (IsSuperAdmin()) DisplaySearchLevel($str, $type, $searchtype);
			echo '<hr />';
			break;
		default:
        } 
        $end_time = getmicrotime();
        DisplayQueryTime($start_time, $end_time);
        LogKeywordsSearch($str, $type, $searchtype, $rub);
    } 
} 

?>
</div>
<?php include_once($dir."/help.php"); ?>
</div>
  
