<?php
/**
 * @package linea21.modules
 * @subpackage workshop
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Workgroup Calendar Management
 */

class calendar {
  /* @param
   * */

  var $TDB_CALENDAR = T_WORK_CAL; // nom de la table.
  var $ID;
  var $TASK_DATE;
  var $TASK;
  var $TASK_DETAILS;
  var $WORKSHOP_ID;
  var $POSTED_BY;
  var $DATE_CREA;
  var $LAST_MODIFY;
  var $VALIDITY;

  /**
   * calendar::CheckDataIntegrity()
   * Vérification intégrité des données
   *
   * @access public
   * @param array $table contient les composants d'une tache
   * @return boolean true
   * si verifié, sinon string 'message d'erreur'
   */
  function CheckDataIntegrity($table, $sql_object)
  {
    if (strlen($table[1]) < 3) return $GLOBALS['lang']['workshop']['no_task'];
    if (strlen($table[2]) < 3) return $GLOBALS['lang']['workshop']['no_task_details'];
    if(!empty($table[0])) return checkdate_validity($table[0]);
    return true;
  }

  /**
   * calendar::AddTask()
   * Ajout d'une nouvelle tache dans le calendrier
   *
   * @access public
   * @param array $table_task contient les composants d'une tache
   * @param object $sql_object
   * @return integer $last_id
   */
  function AddTask($table_task, $sql_object)
  {
    $table_task=$sql_object->DBescape($table_task);
    if ($table_task[0] != '') {
      $this->TASK_DATE = formatDate($table_task[0], true);
    }
    if ($table_task[1] != '') {
      $this->TASK = strip_input(trim($table_task[1]));
    }
    if ($table_task[2] != '') {
      $this->TASK_DETAILS = strip_input(trim($table_task[2]), true);
    }
    if (is_numeric($table_task[3])) {
      $this->WORKSHOP_ID = $table_task[3];
    }
    if (is_numeric($table_task[4])) {
      $this->POSTED_BY = $table_task[4];
    }

    $this->VALIDITY = "Y";

    $requete = "INSERT INTO " . $this->TDB_CALENDAR . " (workcal_task_date, workcal_task, workcal_task_details, workcal_workshop_id, workcal_posted_by, workcal_validity, workcal_date_crea) " . "VALUES('" . $this->TASK_DATE . "', '" . $this->TASK . "', '" . $this->TASK_DETAILS . "', " . $this->WORKSHOP_ID . ", '" . $this->POSTED_BY . "', '" . $this->VALIDITY . "', NOW());";

    $last_id = $sql_object->DBInsert ($requete, 1);
    return $last_id;
  }

  /**
   * calendar::DeleteTask()
   * suppression d'une tache
   *
   * @access public
   * @param int $id identifiant de la tache
   * @param object $sql_object
   * @return bool $result
   */
  function DeleteTask($ID, $sql_object)
  {
    if (is_numeric($ID)) {
      $this->ID = $ID;
    } else return false;
    $requete = "UPDATE " . $this->TDB_CALENDAR . " SET workcal_validity='N' WHERE workcal_id=" . $this->ID . ";";
    $result = $sql_object->DBQuery ($requete);
    return $result;
  }

  /**
   * calendar::ModifyTask()
   * modification d'une tache
   *
   * @access public
   * @param int $ID identifiant de la tache
   * @param object $sql_object
   * @param array $table_task contient les composants d'une tache
   * @return bool $result
   */
  function ModifyTask($ID, $table_task, $sql_object)
  {
    $table_task=$sql_object->DBescape($table_task);
    if ($table_task[0] != '') {
      $this->TASK_DATE = formatDate($table_task[0], true);
    }
    if ($table_task[1] != '') {
      $this->TASK = strip_input(trim($table_task[1]));
    }
    if ($table_task[2] != '') {
      $this->TASK_DETAILS = strip_input(trim($table_task[2]), true);
    }

    $requete = "UPDATE  " . $this->TDB_CALENDAR . " SET workcal_task_date='" . $this->TASK_DATE . "', workcal_task='" . $this->TASK . "' , workcal_task_details='" . $this->TASK_DETAILS . "', workcal_last_modify=NOW() WHERE workcal_id=" . $ID . ";";
    $result = $sql_object->DBQuery($requete);
    return $result;
  }
}

?>