<?php
/**
 * @package linea21.core
 * @subpackage system
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Upload management
 */

class upload {
  /* @parametres
   * */
  var $FINAL_NAME;
  var $FILE;
  var $DESTINATION;
  var $FTP_SERVER = "localhost";
  var $FTP_USER = "demo_linea";
  var $FTP_PASSWD = "demo_linea";
  var $FTP_MODE = "FTP_BINARY";
  var $FTP_ADMINMAIL = MAIL_LINEA;
  var $TEXT_LENGTH = 5;
  var $TEXT = 5;
  var $IMAGE_TYPE = array("jpeg", "jpg", "png");

  /**
   * upload::CheckMaxFile()
   * Vérifie la taille d'un fichier
   *
   * @access public
   * @param string $file_size : taille du fichier a uploader
   * @param string $max_file : taille de fichier maximale
   * @return bool true si ok sinon message d'erreur (string)
   */
  function CheckMaxFile($file_size, $max_file)
  {
    include('../languages/' . LANGUAGE . '/lang_system.'. CHARSET .'.php');
    if ($file_size > $max_file) {
      $ko_maxfile = $max_file / 1024;
      return $lang['upload']['upload_size'] . $ko_maxfile . " " . $lang['upload']['ko_size'];
    }
    return true;
  }

  /**
   * upload::CheckMimeImageType()
   * verifie le type Mime d'une image
   *
   * @access public
   * @param string $dirname : chemin + nom du fichier
   * @return boolean $result
   */
  function CheckMimeImageType($dirname)
  {
    if (function_exists('exif_imagetype')) {
      $exif_type = exif_imagetype($dirname);
      if ($exif_type == 1 || $exif_type == 2 || $exif_type == 3) return true;
      else unlink($dirname);
    }
    return false;
  }

  /**
   * upload::CheckExtImage()
   * Verifie l'extension d'une image
   *
   * @access public
   * @param string $filename : nom du fichier
   * @return string $result
   */
  function CheckExtImage($filename)
  {
    include('../languages/' . LANGUAGE . '/lang_system.'. CHARSET .'.php');

    $result = $lang['upload']['CheckExtImage'];

    $extension = $this->GetExtension($filename);
    $ext = $this->IMAGE_TYPE;
    for ($i = 0;$i < count($ext);$i++) {
      if ($extension == $ext[$i]) return true;
    }

    return $result;
  }

  /**
   * upload::GetExtension()
   * détermine l'extension d'un fichier
   *
   * @access public
   * @param string $filename : fichier source
   * @return string $extension
   */
  function GetExtension($filename)
  {
    $ext = explode('.', $filename);
    $extension = $ext[count($ext)-1];
    return $extension;
  }

  /**
   * upload::GetName()
   * obtenir le nom d'un fichier, sans son extension
   *
   * @access public
   * @param string $filename : fichier source
   * @return string $name
   */
  function GetName($filename)
  {
    $ext = explode('.', $filename);
    $i = 0;
    $name = '';
    while ($i < count($ext)-1) {
      $name .= $ext[$i] . '.';
      $i++;
    }
    return $name;
  }

  /**
   * upload::Archivefile()
   * archive un fichier si nécessaire
   *
   * @access public
   * @param  $path
   * @return void
   */
  function Archivefile($path)
  {
    $ext = $this->IMAGE_TYPE;
    $short_path = dirname($path);
    $filename = basename($path);
    $temp_path = $short_path . "/temp_" . $filename;
    $shortname = $this->GetName($filename);

    for($i = 0; $i < count($ext); $i++) {
      $current_path = $short_path . "/" . $shortname . $ext[$i];
      $current_old_path = $short_path . "/old_" . $shortname . $ext[$i];
      $current_temp_path = $short_path . "/temp_" . $shortname . $ext[$i];
      if (file_exists($current_temp_path)) {
        if (file_exists($current_old_path)) unlink($current_old_path);
        if (file_exists($current_path)) rename($current_path, $current_old_path);
        // gestion des fichiers de miniatures
        if (file_exists(get_min_name($current_old_path))) unlink(get_min_name($current_old_path));
        if (file_exists(get_min_name($current_path))) rename(get_min_name($current_path), get_min_name($current_old_path));
      }
    }

    if (file_exists($temp_path)) rename ($temp_path, $path);
    if (file_exists(get_min_name($temp_path))) rename (get_min_name($temp_path), get_min_name($path));
    return true;
  }

  /**
   * upload::_HTTPUpload()
   * upload un fichier - Protocole HTTP
   *
   * @access private
   * @return boolean : Message d'erreur ou True;
   */
  function _HTTPUpload()
  {
    include('../languages/' . LANGUAGE . '/lang_system.'. CHARSET .'.php');
    $result = false;
    if ($this->FILE['name'] != 'none' && $this->FILE['size'] != 0) {
      if (file_exists($this->DESTINATION . "/" . $this->FINAL_NAME)) unlink ($this->DESTINATION . "/" . $this->FINAL_NAME);
      if (!file_exists($this->DESTINATION . "/" . $this->FINAL_NAME)) {
        if (!file_exists($this->DESTINATION)) {
          mkdir($this->DESTINATION, 0755);
        }
        if (move_uploaded_file($this->FILE['tmp_name'], $this->DESTINATION . $this->FINAL_NAME)) {
          $result = true;
        } else {
          $result = $lang['upload']['prohibited_transfert'];
        }
      } else {
        $result = "'" . $this->FINAL_NAME . "'" . $lang['upload']['file_exist_yet'];
      }
    }
    return $result;
  }

  /**
   * upload::_FTPUpload()
   * !!! NON IMPLEMENTE/ NON TESTE !!!
   * upload un fichier - Protocole FTP
   *
   * @access private
   * @return boolean : Message d'erreur ou True;
   */
  function _FTPUpload()
  {
    include('../languages/' . LANGUAGE . '/lang_system.'. CHARSET .'.php');
    $this->DESTINATION = "./" . $this->DESTINATION;
    $result = false;
    $conn_id = @ftp_connect($this->FTP_SERVER);
    $login_result = @ftp_login($conn_id, $this->FTP_USER, $this->FTP_PASSWD);
    if ((!$conn_id) || (!$login_result)) {
      $erreur = $lang['upload']['ftp_conn_failed'] . END_LINE;
      $erreur .= $lang['upload']['ftp_conn'] . ' ' . $this->FTP_SERVER . ' ' . $lang['upload']['ftp_user'] . ' : ' . FTP_USER ;
      if ($this->FTP_ADMINMAIL != -1) @error_log ($erreur, 1, $this->FTP_ADMINMAIL);
    } else {
      if (!(@ftp_chdir($conn_id, $this->DESTINATION))) {
        ftp_mkdir($conn_id, $this->DESTINATION);
        ftp_chdir($conn_id, $this->DESTINATION);
      }
      $upload_result = ftp_put($conn_id, $this->FINAL_NAME, $this->FILE['tmp_name'], $this->FTP_MODE);
      if (!$upload_result) {
        $result = $lang['upload']['ftp_transfert_error'];
      } else {
        $result = true;
      }
      ftp_close($conn_id);
    }
    return $result;
  }

  /**
   * upload::UploadFile()
   * upload d'un fichier
   *
   * @access public
   * @param string $file : tableau contenant les caractéristiques du fichier à télécharger
   * @param string $final_name : nom de sortie du fichier
   * @param string $destination : répertoire de destination du fichier
   * @return boolean : Message d'erreur ou True;
   */
  function UploadFile($file, $final_name, $destination)
  {
    $this->FILE = $file;
    $this->FINAL_NAME = $final_name;
    $this->DESTINATION = $destination;

    /**
     * echo "poids maxi en ko : " . $_POST['MAX_FILE_SIZE'] . "<br>";
     * echo "nom du fichier : " . $file['name'] . "<br>";
     * echo "nom temp du fichier : " . $file['tmp_name'] . "<br>";
     * echo "taille du fichier : " . $file['size'] . "<br>";
     * echo "type du fichier : " . $file['type'] . "<br>";
     * echo "ereur du fichier : " . $file['error'] . "<br>";
     * echo "nom final du fichier : " . $final_name . "<br>";
     * echo "destination du fichier : " . $destination . "<br>";
     * echo "methode de transfert du fichier : " . $method . "<br>";
     */

    switch (UPLOAD_METHOD) {
      case 'FTP':
        $result = $this->_FTPUpload();
        break;
      case 'HTTP':
        $result = $this->_HTTPUpload();
        break;
      default:
        $result = $this->_HTTPUpload();
        break;
    }

    return $result;
  }
}

?>