<?php
/**
 * @package linea21.core
 * @subpackage config_files
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//BE CAREFULL THIS FILE IS A SYSTEM FILE : use define_release.ini and define_db.ini for settings

/////////////////////////////////////
//	VARIABLES GLOABLES
/////////////////////////////////////

define('END_LINE',		"\n");
define('TAB_LINE',		"\t");

$GLOBALS['authorized_theme_sections'] = array ('THEME_SETTINGS');
$GLOBALS['authorized_db_sections'] = array ('DATABASE');
$GLOBALS['authorized_release_sections'] = array ('LANGUAGE_SETTINGS','LOCALES_SETTINGS','MODULES_SETTINGS', 'SYSTEM_SETTINGS', 'SERVER_SETTINGS','MAIL_SETTINGS','MAIL_INFORMATIONS', 'SUPPORT_SETTINGS','LOGS_SETTINGS');

$GLOBALS['current_title'] = array(); // HTML <title> tag



$GLOBALS['menuitems'] = array (
    					'news', 
                        'project', 
    					'dashboard',
    					'workgroup', 
    					'publication',
    					'directory'
                        );

$GLOBALS['links'] = array (
// french
                    'fr' => array(
    					'home'=> array ('linkvalue' => 'accueil', 'accesskey' => '1', 'title' => 'accueil', 'desc'=>'accéder à l\'accueil', 'alias'=> false, 'template'=>'home'),
    					'project'=> array ('linkvalue' => 'projet', 'accesskey' => 'a', 'title' => 'projets', 'desc'=>'les projets d\'action durable', 'alias'=> false, 'template'=>'publication'), 
    					'project-archives'=> array ('linkvalue' => 'projet-archives', 'title' => 'projets', 'desc'=>'les projets d\'action durable', 'alias'=> 'project', 'template'=>'publication'), 
    					'news'=> array ('linkvalue' => 'actualite', 'accesskey' => 'n', 'title' => 'actualités', 'desc'=>'l\'actualité de votre commune', 'alias'=> false, 'template'=>'publication'), 
    					'news-archives'=> array ('linkvalue' => 'actualite-archives', 'title' => 'actualités - archives', 'desc'=>'les archives de l\'actualité de votre commune', 'alias'=> 'news', 'template'=>'publication'),
    					'report'=> array ('linkvalue' => 'rapport', 'title' => 'rapports de groupes de travail', 'desc'=>'voir le rapport du groupe de travail', 'alias'=> 'workgroup', 'template'=>'publication'),
    					'report-part'=> array ('linkvalue' => 'rapport-partie', 'title' => 'détail rapport de groupe de travail', 'desc'=>'voir la partie du rapport du groupe de travail', 'alias'=> 'workgroup', 'template'=>'publication'),
    					'directory'=> array ('linkvalue' => 'annuaire', 'accesskey' => 'y', 'title' => 'annuaire', 'desc'=>'annuaire des professionnels de l\'environnement/développement durable', 'alias'=> false, 'template'=>'yellowpages'),
    					'directory-detail'=> array ('linkvalue' => 'annuaire-detail', 'title' => 'annuaire', 'desc'=>'annuaire des professionnels de l\'environnement/développement durable', 'alias'=> 'directory', 'template'=>'yellowpages'),
    					'directory-add'=> array ('linkvalue' => 'annuaire-ajout', 'title' => 'annuaire', 'desc'=>'annuaire des professionnels de l\'environnement/développement durable', 'alias'=> 'directory', 'template'=>'yellowpages'),
    					'workgroup'=> array ('linkvalue' => 'groupe-de-travail', 'accesskey' => 'w', 'title' => 'groupes de travail', 'desc'=>'accéder et participer aux groupes de travails', 'alias'=> false, 'template'=>'workshop'), 
    					'subscribe-workgroup'=> array ('linkvalue' => 'inscription-groupe-de-travail', 'title' => 'groupes de travail', 'desc'=>'s\'inscrire à un groupe de tavail', 'alias'=> 'workgroup', 'template'=>'workshop'), 
    					'calendar'=> array ('linkvalue' => 'calendrier', 'title' => 'calendrier du groupe de travail', 'desc'=>'calendrier du groupe de travail', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'discussion'=> array ('linkvalue' => 'discussion', 'title' => 'discussions du groupe de travail', 'desc'=>'discussions du groupe de travail', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'subject'=> array ('linkvalue' => 'sujet', 'title' => 'sujet de discussions du groupe de travail', 'desc'=>'sujet de discussions du groupe de travail', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'message'=> array ('linkvalue' => 'message', 'title' => 'édition de message', 'desc'=>'édition de message', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'publication'=> array ('linkvalue' => 'dossier', 'accesskey' => 'p', 'title' => 'dossiers', 'desc'=>'accéder aux dossiers thématiques', 'alias'=> false, 'template'=>'publication'),
    					'publication-archives'=> array ('linkvalue' => 'dossier-archives', 'title' => 'dossiers', 'desc'=>'accéder aux archives des dossiers thématiques', 'alias'=> 'publication', 'template'=>'publication'),
    					'publication-part'=> array ('linkvalue' => 'dossier-partie', 'title' => 'dossiers', 'desc'=>'accéder en détail au dossier thématique', 'alias'=> 'publication', 'template'=>'publication'),
    					'dashboard'=> array ('linkvalue' => 'tableau-de-bord-idd', 'accesskey' => 'd', 'title' => 'tableau de bord IDD', 'desc'=>'l\'état des indicateurs en direct', 'alias'=> false, 'template'=>'dashboard'),  
                        'dashboard-anim'=> array ('linkvalue' => 'tableau-de-bord-idd-anim', 'title' => 'tableau de bord IDD animé', 'desc'=>'l\'état des indicateurs en direct', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-rules'=> array ('linkvalue' => 'tableau-de-bord-idd-reglementation', 'title' => 'réglementation d\'un indicateur', 'desc'=>'réglementation d\'un indicateur', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-assessment'=> array ('linkvalue' => 'tableau-de-bord-idd-evaluation', 'title' => 'critères d\'évaluation', 'desc'=>'critères d\'évaluation', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-provider'=> array ('linkvalue' => 'tableau-de-bord-idd-fournisseur', 'title' => 'fournisseur d\'un indicateur', 'desc'=>'fournisseur d\'un indicateur', 'alias'=> 'dashboard', 'template'=>'dashboard'),
    					'user-prefs'=> array ('linkvalue' => 'prefs-utilisateur', 'accesskey' => 'u', 'title' => 'préférences utilisateurs', 'desc'=>'accéder à vos préférences utilisateurs', 'alias'=> false, 'template'=>'user'),
    					'logout'=> array ('linkvalue' => 'deconnexion', 'accesskey' => 'l','title' => 'se déconnecter', 'desc'=>'se déconnecter', 'alias'=> false, 'template'=>'user'),
    					'user-registration'=> array ('linkvalue' => 'inscription-utilisateur', 'accesskey' => 'c', 'title' => 'inscription utilisateur', 'desc'=>'créer mon compte', 'alias'=> 'user-prefs', 'template'=>'user'),
    					'user-profile'=> array ('linkvalue' => 'profil-utilisateur', 'title' => 'profil utilisateur', 'desc'=>'voir le profil utilisateur', 'alias'=> 'user-prefs', 'template'=>'user'),
    					'search'=> array ('linkvalue' => 'recherche', 'accesskey' => '4', 'title' => 'effectuer une recherche avancée', 'desc'=>'recherche avancée', 'alias'=> false, 'template'=>'search'),
    					'search-result'=> array ('linkvalue' => 'resultats-recherche', 'title' => 'résultats de la recherche', 'desc'=>'résultats de la recherche', 'alias'=> 'search', 'template'=>'search'),
    					'accessibility'=> array ('linkvalue' => 'accessibilite', 'accesskey' => '0', 'title' => 'Charte d\'accessibilité Linea21', 'desc'=>'Charte d\'accessibilité Linea21', 'alias'=> false, 'template'=>'accessibility'),
    					'report-all'=> array ('linkvalue' => 'listerapport', 'title' => 'rapports du groupe de travail', 'desc'=>'rapports du groupe de travail', 'alias'=> 'workgroup', 'template'=>'workshop'),  
                        'user-all'=> array ('linkvalue' => 'listeutilisateur', 'title' => 'utilisateurs du groupe de travail', 'desc'=>'utilisateurs du groupe de travail', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'subscribe-newsletter'=> array ('linkvalue' => 'abonnement-newsletter', 'title' => 's\'abonner à la newsletter', 'desc'=>'s\'abonner à la newsletter', 'alias'=> false, 'template'=>'message'),
    					'css-switch'=> array ('linkvalue' => 'changer-de-style', 'title' => 'changer-de-style et mise en page', 'desc'=>'changer-de-style et mise en page', 'alias'=> false, 'template'=>'message')
),
// english
                    'en' => array(
    					'home'=> array ('linkvalue' => 'home', 'accesskey' => '1', 'title' => 'home', 'desc'=>'Go to the Home page', 'alias'=> false, 'template'=>'home'),
    					'project'=> array ('linkvalue' => 'project', 'accesskey' => 'a', 'title' => 'projects', 'desc'=>'Sustainable Development projects', 'alias'=> false, 'template'=>'publication'),
						'project-archives'=> array ('linkvalue' => 'project-archives', 'title' => 'projects', 'desc'=>'Sustainable Development projects', 'alias'=> 'project', 'template'=>'publication'), 
    					'news'=> array ('linkvalue' => 'news', 'accesskey' => 'n', 'title' => 'news', 'desc'=>'News of the city', 'alias'=> false, 'template'=>'publication'), 
    					'news-archives'=> array ('linkvalue' => 'news-archives', 'title' => 'news archives', 'desc'=>'News archives', 'alias'=> 'news', 'template'=>'publication'),
    					'report'=> array ('linkvalue' => 'report', 'title' => 'Workgroup report', 'desc'=>'See the workgroup report', 'alias'=> 'workgroup', 'template'=>'publication'),
    					'report-part'=> array ('linkvalue' => 'report-part', 'title' => 'Workgroup report detail', 'desc'=>'See the workgroup report part', 'alias'=> 'workgroup', 'template'=>'publication'),
    					'directory'=> array ('linkvalue' => 'directory', 'accesskey' => 'y', 'title' => 'Organisations Directory', 'desc'=>'Sustainable Development organisations directory', 'alias'=> false, 'template'=>'yellowpages'),
    					'directory-detail'=> array ('linkvalue' => 'directory-detail', 'title' => 'Organisations Directory', 'desc'=>'Sustainable Development organisations directory', 'alias'=> 'directory', 'template'=>'yellowpages'),
    					'directory-add'=> array ('linkvalue' => 'directory-add', 'title' => 'Organisations Directory', 'desc'=>'Sustainable Development organisations directory', 'alias'=> 'directory', 'template'=>'yellowpages'),
    					'workgroup'=> array ('linkvalue' => 'workgroup', 'accesskey' => 'w', 'title' => 'Workgroups', 'desc'=>'access and involve into workroups', 'alias'=> false, 'template'=>'workshop'), 
    					'subscribe-workgroup'=> array ('linkvalue' => 'subscribe-to-workgroup', 'title' => 'Workgroup subscription', 'desc'=>'Subscribe to a workgroup', 'alias'=> 'workgroup', 'template'=>'workshop'), 
    					'calendar'=> array ('linkvalue' => 'calendar', 'title' => 'Workgroup calendar', 'desc'=>'Workgroup calendar', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'discussion'=> array ('linkvalue' => 'discussion', 'title' => 'Workgroup forum', 'desc'=>'Workgroup forum', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'subject'=> array ('linkvalue' => 'subject', 'title' => 'subject of the message', 'desc'=>'Workgroup forum subjects', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'message'=> array ('linkvalue' => 'message', 'title' => 'edit message', 'desc'=>'Edit forum message', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'publication'=> array ('linkvalue' => 'publication', 'accesskey' => 'p', 'title' => 'publications', 'desc'=>'Thematic publications', 'alias'=> false, 'template'=>'publication'),
    					'publication-archives'=> array ('linkvalue' => 'publication-archives', 'title' => 'publications archives', 'desc'=>'Thematic publications archives', 'alias'=> 'publication', 'template'=>'publication'),
    					'publication-part'=> array ('linkvalue' => 'publication-part', 'title' => 'publication part', 'desc'=>'Thematic publication in detail', 'alias'=> 'publication', 'template'=>'publication'),
    					'dashboard'=> array ('linkvalue' => 'dashboard', 'accesskey' => 'd', 'title' => 'SDI dashboard', 'desc'=>'Dashboard : indicators monitoring in real time', 'alias'=> false, 'template'=>'dashboard'),  
                        'dashboard-anim'=> array ('linkvalue' => 'animated-dashboard', 'title' => 'animated SDI dashboard', 'desc'=>'Dashboard : indicators monitoring in real time', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-rules'=> array ('linkvalue' => 'dashboard-rules', 'title' => 'Indicator rules', 'desc'=>'Indicator rules', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-assessment'=> array ('linkvalue' => 'dashboard-assessment', 'title' => 'Indicator assessment', 'desc'=>'Indicator assessment', 'alias'=> 'dashboard', 'template'=>'dashboard'),  
                        'dashboard-provider'=> array ('linkvalue' => 'dashboard-provider', 'title' => 'Indicator provider', 'desc'=>'Indicator provider', 'alias'=> 'dashboard', 'template'=>'dashboard'),
    					'user-prefs'=> array ('linkvalue' => 'user-prefs', 'accesskey' => 'u', 'title' => 'user preferences', 'desc'=>'Access your user preferences', 'alias'=> false, 'template'=>'user'),
    					'logout'=> array ('linkvalue' => 'logout', 'accesskey' => 'l', 'title' => 'se déconnecter', 'desc'=>'log-out', 'alias'=> false, 'template'=>'user'),
    					'user-registration'=> array ('linkvalue' => 'user-reristration', 'accesskey' => 'c', 'title' => 'register', 'desc'=>'Register, create an account', 'alias'=> 'user-prefs', 'template'=>'user'),
    					'user-profile'=> array ('linkvalue' => 'user-profile', 'title' => 'user profile', 'desc'=>'See user profile', 'alias'=> 'user-prefs', 'template'=>'user'),
    					'search'=> array ('linkvalue' => 'search', 'accesskey' => '4', 'title' => 'perform an advanced search', 'desc'=>'Perform an advanced search', 'alias'=> false, 'template'=>'search'),
    					'search-result'=> array ('linkvalue' => 'search-results', 'title' => 'search results', 'desc'=>'Search results', 'alias'=> 'search', 'template'=>'search'),
    					'accessibility'=> array ('linkvalue' => 'accessibility', 'accesskey' => '1', 'title' => 'Linea21 accessibility policy', 'desc'=>'Linea21 accessibility policy', 'alias'=> false, 'template'=>'accessibility'),
    					'report-all'=> array ('linkvalue' => 'all-report', 'title' => 'all workgroup reports', 'desc'=>'Workgroup reports', 'alias'=> 'workgroup', 'template'=>'workshop'),  
                        'user-all'=> array ('linkvalue' => 'all-users', 'title' => 'workgroup users', 'desc'=>'Workgroup users', 'alias'=> 'workgroup', 'template'=>'workshop'),
    					'subscribe-newsletter'=> array ('linkvalue' => 'subscribe-newsletter', 'title' => 'subscribe our newsletter', 'desc'=>'Subscribe our newsletter', 'alias'=> false, 'template'=>'message'),
    					'css-switch'=> array ('linkvalue' => 'change-css-style', 'title' => 'change CSS', 'desc'=>'change style & CSS', 'alias'=> false, 'template'=>'message')
)

);


$GLOBALS['filters'] = array (
                        'fr' => array(
    						'level' => array('linkvalue' => 'niveau', 'name' => 'niveau', 'desc'=>'filtrer par niveau', 'active' => 0),
    						'theme' => array('linkvalue' => 'theme', 'name' => 'thème', 'desc'=>'filtrer par thème', 'active' => 0),
    						'scale' => array('linkvalue' => 'echelle', 'name' => 'échelle', 'desc'=>'filtrer par échelle', 'active' => 0),
                        	'priority' => array('linkvalue' => 'priorite', 'name' => 'priorité', 'desc'=>'filtrer par priorité', 'active' => 0),
                            'alpha' => array('linkvalue' => 'alpha', 'name' => 'alpha', 'desc'=>'filtrer par ordre alphabétique', 'active' => 0)
),
                        'en' => array(
                            'level' => array('linkvalue' => 'level', 'name' => 'level', 'desc'=>'filter by level', 'active' => 0),
    						'theme' => array('linkvalue' => 'theme', 'name' => 'theme', 'desc'=>'filter by theme', 'active' => 0),
    						'scale' => array('linkvalue' => 'scale', 'name' => 'scale', 'desc'=>'filter by scale', 'active' => 0),
                        	'priority' => array('linkvalue' => 'priority', 'name' => 'priority', 'desc'=>'filter by priority', 'active' => 0),
                            'alpha' => array('linkvalue' => 'alpha', 'name' => 'alpha', 'desc'=>'filter by alphabetical order', 'active' => 0)
)
);

/**
 * These globals have to be declared after $GLOBALS['links'] array.
 */ 
$GLOBALS['datePicker_includes'] = array('project|add', 'project|mod',
  			 'dashboard|add', 'dashboard|mod',
  			 'workshop|add_cal', 'workshop|mod_cal', 
  			 'prefs-utilisateur|');

$GLOBALS['lightbox_includes'] = array('news|add', 'news|mod', 'news|det',
  			  'contents|add', 'contents|mod', 'contents|det',
              $GLOBALS['links']['en']['publication-part']['linkvalue'].'|',
              $GLOBALS['links']['en']['news']['linkvalue'].'|',
);

//inclusion des paramètres configurés  dans les fichiers *.ini
include_once ("../class/class.config_file.php");

if(!isset($CONFIG))
{
  $CONFIG = new config_file;
  $CONFIG->initializeIniParams();
}
?>
