<?php
/**
 * @package linea21.modules
 * @subpackage content
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

$contents_object = new contents;

if($type=='P') {
	$requete= SQL_getPublicationTitle($parent);
	$result=$sql_object->DBSelect($requete);
	$current_title=FormatText($result[0]['publi_title'], '2HTML');
	$current_owner=$result[0]['publi_posted_by'];
	
	//////////// Check Droits utilisateur ////////////
	if (!HaveRight('publication')) ReloadIndex('admin');
	///////////
	
	$requete= SQL_getOnePublicationParts($id);
	$result=$sql_object->DBSelect($requete);
	$display_title=formatText($result[0]['publicon_title'], '2HTML');
	$display_body=linkin_content(formatText($result[0]['publicon_body'],'2HTML'));
	$display_template=$contents_object->GetTemplateName($result[0]['publicon_template']);
	$display_date_crea=$result[0]['publicon_date_crea_display'];
	$display_last_modify=$result[0]['publicon_last_modify_display'];
	
	$reca_visual="<dt>".$GLOBALS['lang']['contents']['visu1'].": </dt>\n";
	if(empty($result[0]['publicon_photos_uri'])) {
		$reca_visual.="<dd>".$GLOBALS['lang']['divers']['none']."</dd>\n";
	} else {
		$complete_uri='../'.$result[0]['publicon_photos_uri'];
		$reca_visual.="<dd>".EnlargeImage($complete_uri)."</dd>\n";
	}
	}
if($type=='W') {
	$requete= SQL_getWorkshopRepTitleAndGroup($parent);
	$result=$sql_object->DBSelect($requete);
	$current_title=FormatText($result[0]['workrep_title']).' ('.FormatText($result[0]['workshop_denomination']).')';
	$current_workshop_id=$result[0]['workrep_workshop_id'];
	
	//////////// Check Droits utilisateur ////////////
	if (!HaveRight('workshop')) ReloadIndex('admin');
	///////////
	
	$requete= SQL_getOneWorkshopParts($id);
	$result=$sql_object->DBSelect($requete);
	$display_title=formatText($result[0]['workrepcon_title'], '2HTML');
	$display_body=formatText($result[0]['workrepcon_body'], '2HTML');
	$display_date_crea=$result[0]['workrepcon_date_crea_display'];
	$display_last_modify=$result[0]['workrepcon_last_modify_display'];
}

$link_sup="?rub=contents&amp;todo=sup&amp;parent=".$parent."&amp;type=".$type."&amp;id=";
$link_mod="?rub=contents&amp;todo=mod&amp;parent=".$parent."&amp;type=".$type."&amp;id=";

?>

<div id="chemin">
	<ul>
		<li>
			<a href="index.php"><? echo $GLOBALS['lang']['way']['home']; ?></a>
		</li>
		<li>
			<a href="<?php echo $rub_link; ?>"><? echo $GLOBALS['lang']['menu'][$mod_inc]; ?></a>
		</li>
		<li>
			<span><? echo formatNavTitle($GLOBALS['lang']['contents'][$mod_inc.'_type']." : ". $current_title); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
include_once("quickicons.php");
?>


<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
		<?php
		echo "<h2>";
		echo formatTitleh2($current_title);;
		echo "</h2>\n";
		if (($type=='W' && AuthUser4Workshop($current_workshop_id, $sql_object)) || ($type=='P' && GetSessionElement('id')==$current_owner) || IsSuperAdmin()) {
			echo "\t<a href=\"".$link_sup.$id."\" class=\"ico_sup2\" title=\"".$GLOBALS['lang']['contents']['sup']."\"></a>\n";
			echo "\t<a href=\"".$link_mod.$id."\" class=\"ico_mod2\" title=\"".$GLOBALS['lang']['contents']['mod']."\"></a>\n";
		}
		echo "<dl class=\"dl3\">\n";
		echo "<dt>".$GLOBALS['lang']['contents']['title']."</dt>\n";
		echo "<dd>". $display_title."</dd>\n";
		echo "<dt>". $GLOBALS['lang']['contents']['body']. "</dt>\n";
		echo "<dd>".$display_body."</dd>\n";
		if($type=='P') {
			echo "<dt>".$GLOBALS['lang']['contents']['template']." :</dt>\n";
			echo "<dd>".$display_template."</dd>\n";
			echo $reca_visual;
		}
		echo "<dt>".$GLOBALS['lang']['divers']['date_crea'] ." :</dt>\n";
		echo "<dd>". $display_date_crea. "</dd>\n";
		echo "<dt>".$GLOBALS['lang']['divers']['last_modify'] ." :</dt>\n";
		echo "<dd>". $display_last_modify. "</dd>\n";
		echo "</dl>\n";
		?>

</div>
<?php include_once($dir."/help.php"); ?>
</div>
