<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */


/**
 * MyAccount()
 * Renvoie les liens de creation de compte ou de déconnexion
 * suivant le statut de l'utilisateur
 *
 * @return string content
 */
function MyAccount()
{
  $link_account = array('rub' => $GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue']);
  $content  = '<div id="myaccount">' . END_LINE;
  $content .= '<div id="tologin">' . END_LINE;
  $content .= '<a href="' . HrefMaker($link_account) . '" accesskey="u" title="'.$GLOBALS['lang']['header']['myaccount_title'].'"><img src="../gfx/' .THEME_PUBLIC. '/images/public/' .LANGUAGE. '/menu_myaccount.png" alt="'.$GLOBALS['lang']['header']['myaccount_title'].'" /><span>' . $GLOBALS['lang']['header']['myaccount'] . '</span></a>';
  $content .= '</div>' . END_LINE;
  $link_create = array('rub' => $GLOBALS['links'][LANGUAGE]['user-registration']['linkvalue']);
  $link_logout = array('rub' => $GLOBALS['links'][LANGUAGE]['logout']['linkvalue']);
  $content .= '<div id="logout">' . END_LINE;
  if (isset($_COOKIE['linea21']['whois'])) $content .= '<a href="' . HrefMaker($link_logout) . '" accesskey="l" title="'.$GLOBALS['lang']['header']['deconnexion_title'].'">' . $GLOBALS['lang']['header']['deconnexion'] . '</a>';
  else $content .= '<a href="' . HrefMaker($link_create) . '" accesskey="c" title="'.$GLOBALS['lang']['divers']['user_inscription_title'].'">' . $GLOBALS['lang']['divers']['user_inscription'] . '</a>';
  $content .= '</div>' . END_LINE;
  $content .= '</div>' . END_LINE;

  echo $content;
}

/**
 * AuthForm()
 * Formulaire d'authentification pour login ou inscription
 *
 * @param string $todo
 * @return void (echo string)
 */
function AuthForm($todo = 'LOGON')
{

  if ($todo == 'LOGON') {
    $input_hidden = $GLOBALS['links'][LANGUAGE]['user-prefs']['linkvalue'];
    $div_id = 'logon';
  } else {
    $input_hidden = $GLOBALS['links'][LANGUAGE]['user-registration']['linkvalue'];
    $div_id = 'subscribe';
  }
  $form = '<form action="index.php" method="post">' . END_LINE;
  $form .= '<div id="' . $div_id . '">' . END_LINE;
  $form .= '<label for="login" class="labelised">' . $GLOBALS['lang']['divers']['login'] . ' : </label>' . END_LINE;
  $form .= '<input type="text" maxlength="20" class="shorttextfield" name="login" id="login" />' . END_LINE;
  $form .= '<br />'.END_LINE;
  if ($todo == 'LOGON') {
    $form .= '<label for="password" class="labelised">' . $GLOBALS['lang']['divers']['password'] . ' : </label>' . END_LINE;
    $form .= '<input type="password" maxlength="20" class="shorttextfield" name="password" id="password" />' . END_LINE;
  } else {
    $form .= '<label for="email" class="labelised">' . $GLOBALS['lang']['divers']['email'] . ' : </label>' . END_LINE;
    $form .= '<input type="text" maxlength="100" class="shorttextfield" name="email" id="email" />' . END_LINE;
  }
  $form .= '<br />'.END_LINE;
  $form .= '<input type="hidden" name="rub" id="rub" value="' . $input_hidden . '" />' . END_LINE;
  $form .= '<input type="image" src="../gfx/' .THEME_PUBLIC. '/images/public/btn_go.gif" value="'.$GLOBALS['lang']['btn']['valid'].'" alt="'.$GLOBALS['lang']['btn']['valid'].'" title="'.$GLOBALS['lang']['btn']['valid'].'" size="15" name="valid" id="valid" style="margin-left:30em" />'.END_LINE;
  $form .= '</div>' . END_LINE;
  $form .= '</form>' . END_LINE;

  echo $form;
}

/**
 * SetHTMLTitle()
 * Aggregate string
 * to the global array $GLOBALS['current_title']
 * @param $str string
 * @return void
 */
function SetHTMLTitle($str)
{
  if(count($GLOBALS['current_title']) == 0) array_push($GLOBALS['current_title'], SITE_CITY_NAME);
  array_push($GLOBALS['current_title'], $str);
}

/**
 * DisplayMenu()
 * Affichage du menu
 *
 * @return void ( echo string )
 */
function DisplayMenu()
{
  $content = '<div id="menu">'.END_LINE;
  $content .= '<a href="#contenu" class="semnone" title="'.$GLOBALS['lang']['header']['goto_contents'].'" accesskey="2">'.$GLOBALS['lang']['header']['goto_contents'].'</a>'.END_LINE;
  $content .= '<ul>'.END_LINE;
  while (list($key, $value) = each ($GLOBALS['menuitems'])) {

    (ActiveItemAlias($GLOBALS['activeitem']) == $value) ? $classe = ' class="actif"' : $classe = '' ;
    $current_link = array('rub' => $GLOBALS['links'][LANGUAGE][$value]['linkvalue']);
    $content .= '<li id="menu_'.$value.'">';
    $content .= '<a href="' . HrefMaker($current_link) . '" title="' . $GLOBALS['links'][LANGUAGE][$value]['desc'] . '" accesskey="' . $GLOBALS['links'][LANGUAGE][$value]['accesskey'] . '" id="amenu_'.$value.'"'.$classe.'>' . $GLOBALS['links'][LANGUAGE][$value]['title'] . '</a>';
    $content .= '</li>' . END_LINE;
  }
  $content .= "</ul>";
  $content .= "</div>";
  echo $content;
}


/**
 * HrefMaker()
 * Generated a well-formed string URL for SEO
 * if MOD_REWRITE is set to 1
 * Can be override if the given array contains a key
 * named 'rewrite_override'
 * @param array $array
 * @return string $url_maked
 **/
function HrefMaker($array)
{
  $url_maked = '';

  if (defined("MOD_REWRITE") && MOD_REWRITE == true && !in_array('rewrite_override', $array)) {
    if (array_key_exists('rub', $array)) {
      $url_maked .= $array['rub'];
    }
    if (array_key_exists('filter', $array)) {
      $url_maked .= URI_SEPARATOR . '@@'.$array['filter'];
    }
    if (array_key_exists('name', $array)) {
      $url_maked .= URI_SEPARATOR . stripText(stripAccents($array['name'])). ','. $array['id'];
    }
    else {
      if (array_key_exists('id', $array)) {

        $url_maked .= URI_SEPARATOR . $array['id'];
      }
    }
    if (array_key_exists('parentid', $array)) {
      $url_maked .= URI_SEPARATOR . $array['parentid'];
    }
    if (array_key_exists('parentparentid', $array)) {
      $url_maked .= URI_SEPARATOR . $array['parentparentid'];
    }
    if (array_key_exists('debut', $array)) {
      $url_maked .= URI_SEPARATOR . '-' . $array['debut'] . '-' ;
    }
    $url_maked .= '.html';
  }
  else
  {
    //if(isset($array['name'])) $array['name'] = stripText(stripAccents($array['name']));
    if(isset($array['name'])) unset($array['name']);
    if(isset($array['rewrite_override'])) unset($array['rewrite_override']);
    if (function_exists('http_build_query')) $url_string = http_build_query($array);
    else {
      $url_string = '';
      $sep = '';
      while (list($key, $value) = each ($array)) {
        if (!empty($value)) {
          $url_string .= $sep . $key . '=' . $value;
          $sep = OUTPUT_SEP;
        }
      }
    }
    $url_maked = 'index.php?' . $url_string;
  }
  return $url_maked;
}


/**
 * DisplayTemplate()
 * Include the required template
 * if no user template is found in /public/
 * includes the /public/dist/ version.
 *
 * @return void
 **/
function DisplayTemplate()
{
  $key = ActiveItemKey($GLOBALS['activeitem']);
  $current_template = $GLOBALS['links'][LANGUAGE][$key]['template'];
  distInclude('tpl_' . $current_template . '.php');
}

/**
 * ActiveItem()
 * Détermine l'item actif et le place en var global
 *
 * @return void
 */
function ActiveItem()
{
  if (array_key_exists('rub', $_REQUEST)) $GLOBALS['activeitem'] = $_REQUEST['rub'];
  else $GLOBALS['activeitem'] = $GLOBALS['links'][LANGUAGE]['home']['linkvalue'];
}

/**
 * ActiveItemKey()
 * Return the Active item key
 * @param string $item
 * @return string
 **/
function ActiveItemKey($item)
{
  foreach ($GLOBALS['links'][LANGUAGE] as $key => $value) {
    if ($GLOBALS['links'][LANGUAGE][$key]['linkvalue'] == $item)  return $key;
  }
  return false;
}

/**
 * ActiveItemAlias()
 * Return the active item
 * or its alias
 * @param string $item
 * @return string
 **/
function ActiveItemAlias($item)
{
  $key = ActiveItemKey($item);
  if ($GLOBALS['links'][LANGUAGE][$key]['alias'] === false) return $key;
  else return $GLOBALS['links'][LANGUAGE][$key]['alias'];
}

?>