<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * SetCookieTest()
 * set un cookie pour test acceptation client
 *
 * @return void
 */
function SetCookieTest()
{
  setcookie('linea21_cookietest', 'ok', (time() + 3600 * 720 * 6), '/');
}

/**
 * SetCookieUserStyle()
 * set le cookie de style css de l'interface publique
 *
 * @param  $table
 * @return void
 */
function SetCookieUserStyle($value)
{
  setcookie('linea21_style', $value, (time() + 3600 * 720 * 6), '/');
  SetCookieTest();
}

/**
 * SetCookieDefaultUserStyle()
 * supprime le cookie de style css de l'interface publique
 * permettant l'affichage du style par défaut
 *
 * @param  $table
 * @return void
 */
function SetCookieDefaultUserStyle()
{
  if (isset($_COOKIE['linea21_style'])) setcookie('linea21_style', '', (time() - 3600), '/');
  SetCookieTest();
}

/**
 * SetCookieUserStyle()
 * set le cookie de style css de l'interface publique
 *
 * @param  $table
 * @return void
 */
function SetUserStyle($value)
{
  if ($value != 'default') {
    SetCookieUserStyle($value);
  } else {
    SetCookieDefaultUserStyle();
  }
}

if(isset($_REQUEST['id'])) {
  $style=$_REQUEST['id'];
  SetUserStyle($style);
  $link= array('rub'=> $GLOBALS['links'][LANGUAGE]['css-switch']['linkvalue']);
  header("Location: ".HrefMaker($link));
  exit;
}


if(!isset($_COOKIE['linea21_cookietest'])) {
  $msg['code']='error';
  $msg['string']=$GLOBALS['lang']['divers']['cookies'];

} else {
  if (isset($_COOKIE['linea21_cookietest'])) setcookie('linea21_cookietest', '', (time() - 3600), '/');
  header("Location: ".SITE_CITY_URL);
}

?>