<?php
/**
 * @package linea21.modules
 * @subpackage project
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');  
////////////
?>

<div id="chemin">
	<ul>
		<li>
			<a href="index.php"><? echo $GLOBALS['lang']['way']['home']; ?></a>
		</li>
		<li>
			<a href="<?php echo $rub_link; ?>"><? echo $GLOBALS['lang']['menu']['project']; ?></a>
		</li>
		<li>
			<span><? echo formatNavTitle($GLOBALS['lang']['project']['add']); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
$form_name='';
$form_description='';
$form_body='';
$form_parent_id=-1;
$form_scale_id=-1;
$form_priority_id=-1;
$mask_statut_P="checked=\"checked\"";
$mask_statut_D='';
$form_begin_date='';
$form_estimated_date='';
$form_end_date='';


$project_object = new project;

if(isset($_POST['enregistrer'])) {
	$data_table=unserialize(urldecode($_POST['data_table']));
	$result=$project_object->AddProject($data_table, $sql_object);
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
	if(is_numeric($result)) header("Location: ".$link_confirm);
	else  system_error();
}

if(isset($_POST['valider'])) {
	$table[0]=$_POST['project_name'];
	$table[1]=$_POST['project_description'];
	$table[2]=$_POST['project_body'];
	$table[3]=$_POST['project_parent_id'];
	$table[4]=$_POST['project_scale_id'];
	$table[5]=$_POST['project_priority_id'];
	$table[6]=$_POST['project_begin_date'];
	$table[7]=$_POST['project_estimated_date'];
	$table[8]=$_POST['project_end_date'];
	$table[9]=GetSessionElement('id'); // ID posteur
	$table[10]=$_POST['project_statut'];
	
	$project_object= new project;
	$integrity=$project_object->CheckDataIntegrity($table);

	if(is_string($integrity)) {
		$text_format='2FIELD';
	} else {
		$text_format='2HTML';
	}
	$form_name=formatText($_POST['project_name'], $text_format);
	$form_description=formatText($_POST['project_description'], $text_format);
	$form_body=formatText($_POST['project_body'], $text_format);
	$form_begin_date=$_POST['project_begin_date'];
	$form_estimated_date=$_POST['project_estimated_date'];
	$form_end_date=$_POST['project_end_date'];

	$form_scale_id=$_POST['project_scale_id'];
	$form_parent_id=$_POST['project_parent_id'];
	$form_priority_id=$_POST['project_priority_id'];

	if($_POST['project_statut']=='D') $mask_statut_D="checked=\"checked\""; else $mask_statut_D='';
	if($_POST['project_statut']=='P') $mask_statut_P="checked=\"checked\""; else $mask_statut_P='';
	$table=urlencode(serialize($table));
}


if(!isset($integrity) || is_string($integrity)) {
include_once("../lib/input_helpers.php");

// select-box des projets
$data=$sql_object->DBSelect(SQL_getProjectsList(0,1000, 'public'));
$select_parent=ProjectSelectBox($data, "project_parent_id", $form_parent_id);

// select-box des échelles
$data=$sql_object->DBSelect($req_list_scale);
$select_scale=ScaleSelectBox($data, "project_scale_id", $form_scale_id);

// select-box des priorités
$data=$sql_object->DBSelect($req_list_priority);
$select_priority=PrioritySelectBox($data, "project_priority_id", $form_priority_id);

}

include_once("quickicons.php");

?>

<script type="text/javascript" charset="utf-8">
    Date.format = '<?php echo DATE_FORMAT ?>';
    
	$.dpText = {
	TEXT_PREV_YEAR		:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_PREV_YEAR']; ?>',
	TEXT_PREV_MONTH		:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_PREV_MONTH']; ?>',
	TEXT_NEXT_YEAR		:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_NEXT_YEAR']; ?>',
	TEXT_NEXT_MONTH		:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_NEXT_MONTH']; ?>',
	TEXT_CLOSE			:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_CLOSE']; ?>',
	TEXT_CHOOSE_DATE	:	'<?php echo $GLOBALS['lang']['datePicker']['TEXT_CHOOSE_DATE']; ?>'
	}
	
	$(function()
	{
		$('.date-pick').datePicker({startDate:'01/01/1990'});
		$('#project_begin_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_estimated_date').dpSetStartDate(d.addDays(1).asString());
    				$('#project_end_date').dpSetStartDate(d.addDays(1).asString());
    			}
    		}
    	);
    	$('#project_estimated_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_begin_date').dpSetEndDate(d.addDays(-1).asString());
    			}
    		}
    	);
    	$('#project_end_date').bind(
    		'dpClosed',
    		function(e, selectedDates)
    		{
    			var d = selectedDates[0];
    			if (d) {
    				d = new Date(d);
    				$('#project_begin_date').dpSetEndDate(d.addDays(-1).asString());
    			}
    		}
    	);
		
    });
</script>


<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
			<?php
			if(isset($integrity) && is_string($integrity)) display_errors($integrity);
			?>
			<h2><? echo formatTitleh2($GLOBALS['lang']['project']['add']); ?></h2>
			<form id="addproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<p>
				<label for="project_name"><? echo $GLOBALS['lang']['project']['name']; ?> : *</label>
				<input name="project_name" type="text" maxlength="200" id="project_name" class="textfield" value="<?php echo $form_name; ?>" />
				</p>
				<p>
				<label for="project_parent_id" ><? echo $GLOBALS['lang']['project']['parent']; ?> :</label>
				<?php echo $select_parent; ?>
				</p>
				<p>
				<label for="project_description"><? echo $GLOBALS['lang']['project']['description']; ?> : *</label>
				<textarea id="project_description" name="project_description" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_description; ?></textarea>
				</p>
				<p>
				<label for="project_body"><? echo $GLOBALS['lang']['project']['body']; ?> : *</label>
				<textarea id="project_body" name="project_body" class="largetextfield" <?php echo AREA_SETTINGS; ?>><?php echo $form_body; ?></textarea>
				</p>
				<p>
				<label for="project_begin_date" ><? echo $GLOBALS['lang']['project']['begin_date']; ?> : </label>
				<input name="project_begin_date" type="text" maxlength="10" id="project_begin_date" class="date-pick shorttextfield date-text" value="<?php echo $form_begin_date; ?>" />
				</p>
				<p class="post-date">
				<label for="project_estimated_date" ><? echo $GLOBALS['lang']['project']['estimated_date']; ?> : </label>
				<input name="project_estimated_date" type="text" maxlength="10" id="project_estimated_date" class="date-pick shorttextfield date-text" value="<?php echo $form_estimated_date; ?>" />
				</p>
				<p class="post-date">
				<label for="project_end_date" ><? echo $GLOBALS['lang']['project']['end_date']; ?> : </label>
				<input name="project_end_date" type="text" maxlength="10" id="project_end_date" class="date-pick shorttextfield date-text" value="<?php echo $form_end_date; ?>" />
				</p>
				<p class="post-date">
				<label for="project_priority_id" ><? echo $GLOBALS['lang']['project']['priority']; ?> : *</label>
				<?php echo $select_priority; ?>
				</p>
				<p>
				<label for="project_scale_id" ><? echo $GLOBALS['lang']['project']['scale']; ?> : *</label>
				<?php echo $select_scale; ?>
				</p>
				<p>
				<label for="statut_P"><? echo $GLOBALS['lang']['project']['statut']; ?> : </label>
				<input name="project_statut" type="radio" id="statut_P" value="P" <?php echo $mask_statut_P; ?> /><span class="radio"><?php echo $GLOBALS['lang']['statut']['public']; ?></span>
				<input name="project_statut" type="radio" id="statut_D" value="D" <?php echo $mask_statut_D; ?> /><span class="radio"><?php echo $GLOBALS['lang']['statut']['draft']; ?></span>
				<br />
				</p>
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<?php echo cancel_button('javascript:history.go(-1);'); ?>
				<input name="valider" type="submit" value="<? echo $GLOBALS['lang']['btn']['valid'] ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
<?php include_once($dir."/help.php"); ?>
</div>
<?php
// Récapitulatif
} else	{

$requete=SQL_getonescaleDenomination($form_scale_id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $scale_denomination=formatText($result[0]['scale_denomination'], '2HTML');

$requete=SQL_getonepriorityName($form_priority_id);
$result=$sql_object->DBSelect($requete);
if($result==0 || count($result)!=1) exit;
else $priority_name=formatText($result[0]['priority_name'], '2HTML');

if($form_parent_id != -1) {
  $requete=SQL_getProjectName($form_parent_id);
  $result=$sql_object->DBSelect($requete);
  if($result==0 || count($result)!=1) exit;
  else $parent_name=formatText($result[0]['project_name'], '2HTML');
} else $parent_name=$lang['divers']['none'];

?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
<div id="content">
			<h2><? echo formatTitleh2($GLOBALS['lang']['recap']['title']); ?></h2>
			<?php
			echo "<dl class=\"dl3\">\n";
			echo "<dt>".$GLOBALS['lang']['project']['name']."</dt>\n";
			echo "<dd>". $form_name."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['parent']."</dt>\n";
			echo "<dd>". $parent_name."</dd>\n";
			echo "<dt>". $GLOBALS['lang']['project']['description']. "</dt>\n";
			echo "<dd>".empty_nc(linkin_content($form_description))."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['body']." :</dt>\n";
			echo "<dd>".linkin_content($form_body)."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['begin_date']." :</dt>\n";
			echo "<dd>".empty_nc($form_begin_date)."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['estimated_date']." :</dt>\n";
			echo "<dd>".empty_nc($form_estimated_date)."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['end_date']." :</dt>\n";
			echo "<dd>".empty_nc($form_end_date)."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['priority']." :</dt>\n";
			echo "<dd>".$priority_name."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['project']['scale']." :</dt>\n";
			echo "<dd>".$scale_denomination."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['divers']['statut']."</dt>\n";
			echo "<dd>". display_statut($_POST['project_statut']). "</dd>\n";
			echo "</dl>\n";
			?>
			<form id="addproject" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<div>
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
				<?php echo cancel_button('?rub_project&amp;todo=list'); ?>
				<input name="retour" type="button" value="<? echo $GLOBALS['lang']['btn']['preview']; ?>" class="button" id="retour" onclick="history.go(-1);" />
				<input name="enregistrer" type="submit" value="<? echo $GLOBALS['lang']['btn']['save']; ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
	<?php include_once($dir."/help.php"); ?>
</div>
<?php
}
?>
