<?php
/**
 * @package linea21.core
 * @subpackage public
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

function DisplayProjectBoard() {
  $content ='';
  if(ActiveItemKey($GLOBALS['activeitem']) == 'home') {
    $content .= '<a href="'.HrefMaker(array('rub' => $GLOBALS['links'][LANGUAGE]['project']['linkvalue'])).'" title="'.$GLOBALS['links'][LANGUAGE]['project']['title'].'"><img src="../gfx/'. THEME_PUBLIC.'/images/public/'. LANGUAGE. '/agenda21.png" style="margin:0" alt="'.$GLOBALS['links'][LANGUAGE]['project']['title'].'" /></a>';
    $content .= '<br />';
  }
  echo $content;
}

function DisplayNewsletterForm() {
  $action=$GLOBALS['links'][LANGUAGE]['subscribe-newsletter']['linkvalue'];
  $form  = '<form action="index.php" method="post">' . END_LINE;
  $form .= '<div id="newsletter_form">' . END_LINE;
  $form .= '<label for="newsletteremail">' . $GLOBALS['lang']['divers']['email'] . ' : </label>' . END_LINE;
  $form .= '<input type="text" maxlength="200" size="19" class="shorttextfield" name="newsletteremail" id="newsletteremail" />' . END_LINE;
  $form .= '<input type="image" src="../gfx/' .THEME_PUBLIC. '/images/public/btn_go.gif" value="'.$GLOBALS['lang']['btn']['valid'].'" alt="'.$GLOBALS['lang']['btn']['valid'].'" title="'.$GLOBALS['lang']['btn']['valid'].'" size="15" name="valid"  id="valid_newsletter" />'.END_LINE;
  $form .='<br />';
  $form .= '<input type="checkbox" name="del_action" id="del_action" style="float:left;margin:0em 1em 0 3.2em" />';
  $form .= '<input type="hidden" name="rub" id="rub_newsletter" value='.$GLOBALS['links'][LANGUAGE]['subscribe-newsletter']['linkvalue'].' />' . END_LINE;
  $form .= '<label for="del_action" class="checkboxlab">'.$GLOBALS['lang']['newsletter']['unsubscribe'].'</label>' . END_LINE;
  $form .= '</div>' . END_LINE;
  $form .= '</form>' . END_LINE;

  echo $form;
}

function DisplayBoardLastNews($nb) {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_NewsBoard($nb));

  $content = '<div id="recentnews">'.END_LINE;
  //$content.= '<p>'.$GLOBALS['lang']['divers']['actu_left'].'</p>';
  $content.= '<p>'.$GLOBALS['lang']['divers']['actu_left'].'</p>';
  if($data!=0)
  {
    $content.= '<ul>'.END_LINE;
    for($i=0; $i<count($data); $i++) {
      $title=formatText($data[$i]['news_title'],'2HTML');
      $link_table= array('rub'=> $GLOBALS['links'][LANGUAGE]['news']['linkvalue'],'id'=>$data[$i]['news_id'], 'name' => $data[$i]['news_title']);
      $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['news']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
      #$content.='<em> Posté le '.$data[$i]['news_published_date_display'].'</em>'.END_LINE;
      $content.='</li>'.END_LINE;
    }
    $content.= '</ul>'.END_LINE;
  }
  else
  {
    $content.=$GLOBALS['lang']['divers']['nodata'];
  }
  $content.= '</div>'.END_LINE;

  echo $content;
}
function DisplayBoardLastSdi() {
  $data=$GLOBALS['sql_object'] -> DBSelect(SQL_Get_SdiBoard());

  $content = '<div id="recentSdi">'.END_LINE;
  $content.= '<p>'.$GLOBALS['lang']['divers']['sdi_left'].'</p>';
  if($data!=0)
  {
    $content.= '<ul>'.END_LINE;
    $test=array();
    for($i=0; $i<count($data); $i++) {
      if (!in_array($data[$i]['sdii_id'], $test) && count($test)<3){
        $test[$i]=$data[$i]['sdii_id'];
        $title=formatText($data[$i]['sdii_name'],'2HTML');
        $link_table= array('rub'=> $GLOBALS['links'][LANGUAGE]['dashboard']['linkvalue'],'id'=>$data[$i]['sdii_id'], 'parentid'=>$data[$i]['sdiv_scale'], 'name' => $data[$i]['sdii_name'] );
        $content.='<li><a href="'.HrefMaker($link_table).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['dashboard']['desc'].' : '.$title, '2ATT').'">'.$title.'</a>';
        $content.='</li>'.END_LINE;
      }
    }
    $content.= '</ul>'.END_LINE;
  }
  else
  {
    $content.=$GLOBALS['lang']['divers']['nodata'];
  }
  $content.= '</div>'.END_LINE;

  echo $content;
}

function DisplaySearchForm() {

  $action=$GLOBALS['links'][LANGUAGE]['search-result']['linkvalue'];

  $form ='<form action="index.php" method="post">'.END_LINE;
  $form.='<div id="searchinput">'.END_LINE;
  $form.='<br /><label for="search">'.$GLOBALS['lang']['menu']['search'].' </label>'.END_LINE;
  $form.='<input type="text" maxlength="100" size="15" name="search" id="search" accesskey="4" class="shorttextfield" />'.END_LINE;
  $form.= '<input type="hidden" name="rub" id="rub_search" value='.$GLOBALS['links'][LANGUAGE]['search-result']['linkvalue'].' />' . END_LINE;
  $form.='<input type="image" src="../gfx/' .THEME_PUBLIC. '/images/public/btn_go.gif"  value="'.$GLOBALS['lang']['btn']['valid'].'" alt="'.$GLOBALS['lang']['btn']['valid'].'" title="'.$GLOBALS['lang']['btn']['valid'].'" size="15" name="valid" id="validsearch" />'.END_LINE;
  $form.='</div>'.END_LINE;
  $form.='</form>'.END_LINE;
  $form.='<p id="searchadv">';
  $form.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][LANGUAGE]['search']['linkvalue'])).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['search']['title'], '2ATT').'">';
  $form.=$GLOBALS['lang']['menu']['advancedsearch'];
  $form.='</a>';
  $form.='</p>';
  echo $form;
}
function DisplayLogo() {
  echo '<div id="logo"></div>'.END_LINE;
}
function DisplayFooterleft() {
  $content='<div id="footerleft">'.END_LINE;
  $content.='<a href="mailto:'.SITE_CITY_MAIL.'" ';
  $content.='title="'.SITE_CITY_MAIL.'" >'.$GLOBALS['lang']['divers']['contact'].' </a> | ';
  $content.='<a href="'.HrefMaker(array('rub'=> $GLOBALS['links'][LANGUAGE]['accessibility']['linkvalue'])).'" ';
  $content.='title="'.formatText($GLOBALS['lang']['divers']['accessibility'], '2ATT').'" accesskey="0"> '.$GLOBALS['lang']['divers']['accessibility'].' </a>  | <a href="rss.php" title="RSS">rss</a>';
  $content.=''.END_LINE;
  $content.='<br /><br /><img src="../gfx/' .THEME_PUBLIC. '/images/public/xhtml11.png" alt="XHTML 1.1 valid " /></div>'.END_LINE;
  echo $content;
}

?>