<?php
/**
 * @package linea21.modules
 * @subpackage publication
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

include_once('../publication/'.SQL.'.inc.php');

function DisplayListPublication($statut, $filter, $id_filter, $debut) {

if($statut=='public') {
	$pas=100; 
	$suffix='';
} else $pas=SELECT_LIMIT;
if($statut=='archives_p') $suffix=' '.$GLOBALS['lang']['statut']['PA'];
$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationList($debut, $pas, $statut, $filter, $id_filter));
$datacount=$GLOBALS['sql_object'] -> DBSelect(SQL_getCountPublicationList($statut, $filter, $id_filter));
$bdd_nb_com=$datacount[0]['num_rows'];
$bdd_nb_com_display = '<p>'.$bdd_nb_com.' '.$GLOBALS['lang']['publication']['name2'].' '.$suffix.'</p>'.END_LINE;

$content= '<h1>'.$GLOBALS['lang']['publication']['listing'].'</h1>'.END_LINE;
$content.='<div class="h1_comment" id="h1_publication">';
$content.=$GLOBALS['lang']['publication']['h1_public_comment'];
$content.='</div>';
	if($data!=0) 
	{
		//echo $bdd_nb_com_display;
		$current_link = array('rub' => $GLOBALS['links'][LANGUAGE]['publication-archives']['linkvalue']);
		Display_linkin_page($current_link,$bdd_nb_com, $debut, $pas);
		for($i=0; $i<count($data); $i++) {
			$link_detail= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'id'=>$data[$i]['publi_id'], 'name' => $data[$i]['publi_title']);
			$link_theme= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['theme']['linkvalue'],'id'=>$data[$i]['sdtheme_id'], 'name' =>  $data[$i]['sdtheme_name']);
			$link_level= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['level']['linkvalue'],'id'=>$data[$i]['publi_level'], 'name' =>  $data[$i]['level_name']);
			$link_scale= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['scale']['linkvalue'],'id'=>$data[$i]['publi_scale'], 'name' =>  $data[$i]['scale_denomination']);
			$link_user= array('rub'=> $GLOBALS['links'][LANGUAGE]['user-profile']['linkvalue'],'id'=>$data[$i]['publi_posted_by'], 'name' => $data[$i]['user_login']);
			$publi_title=formatText($data[$i]['complete_publi_title'], '2HTML');
			$publi_resume=formatText($data[$i]['publi_resume'], '2HTML');
			$publi_sdtheme=formatText($data[$i]['sdtheme_name'], '2HTML');
			$level_name=formatText($data[$i]['level_name'], '2HTML');
			$scale_denomination=formatText($data[$i]['scale_denomination'], '2HTML');
			$publi_posted_on=formatText($data[$i]['publi_published_date_display'], '2HTML');
			$publi_posted_by=formatText($data[$i]['user_login'], '2HTML');
			
			$content.='<h2 class="nobottommargin"><a href="'.HrefMaker($link_detail).'" title="'.$publi_title.'">'.$publi_title.'</a>'.END_LINE;
			$content.='</h2>'.END_LINE;
			$content.='<p class="published_by">'.END_LINE;
			$content.='Publié le '.$publi_posted_on.' ';
			$content.='par <a href="'.HrefMaker($link_user).'" title="'.formatText($GLOBALS['links'][LANGUAGE]['user-profile']['desc']. ' ('.$publi_posted_by.')', '2ATT').'">'.$publi_posted_by.'</a>';
			$content.='</p>'.END_LINE;
			$content.='<p class="list_textcontent">'.$publi_resume.'</p>'.END_LINE;
			$content.='<p class="filter_info">';
			$content .= $GLOBALS['lang']['divers']['level'] . ' : ';
			$content.='<a href="'.HrefMaker($link_level).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['level']['desc'].' : '.$level_name, '2ATT').'" class="filter_info_level">'.$level_name.'</a> '.END_LINE;
			$content .= $GLOBALS['lang']['divers']['themeref'] . ' : ';
			$content.='<a href="'.HrefMaker($link_theme).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['theme']['desc'].' : '.$publi_sdtheme, '2ATT').'" class="filter_info_theme">'.$publi_sdtheme.'</a>'.END_LINE;
			$content .= $GLOBALS['lang']['divers']['scale'] . ' : ';
			$content.='<a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['scale']['desc'].' : '.$scale_denomination, '2ATT').'" class="filter_info_scale">'.$scale_denomination.'</a>'.END_LINE;
			$content.='</p>'.END_LINE;
			$content.='<hr />'.END_LINE;
		}
	} 
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['divers']['nodata'].'</p>';
	}
	
	echo $content;
}


function DisplayOnePublication($publi_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getoneCompletePublication($publi_id, 'P'));
	$content = '';
	if(count($data)!=1) exit;
	else 
	{		
			$link_theme= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['theme']['linkvalue'],'id'=>$data[0]['theme_sd_theme'], 'name' => $data[0]['sdtheme_name']);
			$link_level= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['level']['linkvalue'],'id'=>$data[0]['publi_level'], 'name' => $data[0]['level_name']);
			$link_scale= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication']['linkvalue'],'filter'=> $GLOBALS['filters'][LANGUAGE]['scale']['linkvalue'],'id'=>$data[0]['publi_scale'], 'name' => $data[0]['scale_denomination']);
			$link_user= array('rub'=> $GLOBALS['links'][LANGUAGE]['user-profile']['linkvalue'],'id'=>$data[0]['publi_posted_by'], 'name' => $data[0]['user_login']);

			$publi_title=formatText($data[0]['publi_title'], '2HTML');
			$publi_resume=linkin_content(formatText($data[0]['publi_resume'], '2HTML'));			
			
			$publi_sdtheme=formatText($data[0]['sdtheme_name'], '2HTML');
			$publi_scale_denomination=formatText($data[0]['scale_denomination'], '2HTML');
			$publi_theme=formatText($data[0]['theme_name'], '2HTML');
			$publi_level=formatText($data[0]['level_name'], '2HTML');
			
			$publi_posted_on=formatText($data[0]['publi_published_date_display'], '2HTML');
			$publi_posted_by=formatText($data[0]['user_login'], '2HTML');
			$publi_modify_on=formatText($data[0]['publi_last_modify_display'], '2HTML');
			$publi_statut=$data[0]['publi_statut'];
			
			// workrep_workshop_id
			
			$content.='<h1 class="nobottommargin">'.$publi_title.'</h1>'.END_LINE;
			$content.='<p class="published_by">'.END_LINE;
			$content.=$GLOBALS['lang']['statut']['published_on'].' '.$publi_posted_on.' ';
			$content.=$GLOBALS['lang']['divers']['by'].' <a href="'.HrefMaker($link_user).'" title="'.$GLOBALS['links'][LANGUAGE]['user-profile']['desc']. ' ('.$publi_posted_by.')">'.$publi_posted_by.'</a>';
			if($publi_statut=='PA')  {
				$content.=' ('.$GLOBALS['lang']['statut']['archived_on'].' '.$publi_modify_on.')';
			}
			$content.='</p>'.END_LINE;
			$content.='<p class="publi_resume">'.$publi_resume.'</p>';

			$content.='<p class="filter_info">';
			$content.=$GLOBALS['lang']['divers']['level'].' : '.END_LINE;
			$content.='<a href="'.HrefMaker($link_level).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['level']['desc'].' : '.$publi_level, '2ATT').'" class="filter_info_level">'.$publi_level.'</a> '.END_LINE;
			$content.=$GLOBALS['lang']['divers']['themeref'].' : '.END_LINE;
			$content.='<a href="'.HrefMaker($link_theme).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['theme']['desc'].' : '.$publi_sdtheme, '2ATT').'" class="filter_info_theme">'.$publi_sdtheme.'</a>'.END_LINE;
			//$content.$GLOBALS['lang']['divers']['sousthemeref'].' : '.END_LINE;
			//$content.=$publi_theme.END_LINE;
			$content.=$GLOBALS['lang']['divers']['scale'].' : ';
			$content.='<a href="'.HrefMaker($link_scale).'" title="'.formatText($GLOBALS['filters'][LANGUAGE]['scale']['desc'].' : '.$publi_scale_denomination, '2ATT').'" class="filter_info_scale">'.$publi_scale_denomination.'</a>'.END_LINE;
			$content.='</p>'.END_LINE;
			$content.='<hr />'.END_LINE;

			
	}	
	echo $content;
}

function DisplayPublicationParts($publi_id) {
	$data=$GLOBALS['sql_object'] -> DBSelect(SQL_getPublicationParts($publi_id));	
	$content ='<div id="parts">'.END_LINE;
	$content.='<h2>'.$GLOBALS['lang']['publication']['parts'].'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$link_parts= array('rub'=> $GLOBALS['links'][LANGUAGE]['publication-part']['linkvalue'],'id'=> $data[$i]['publicon_id'],'parentid'=>$publi_id, 'name' => $data[$i]['publicon_title']);
			$publicon_title=formatText($data[$i]['publicon_title'], '2HTML');
			$content.='<li>'.END_LINE;
			$content.='<span class="num">'.($i+1).' - </span>'.END_LINE;
			$content.='<a href="'. HrefMaker($link_parts).'">';
			$content.=$publicon_title;
			$content.='</a>';
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
	}
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['publication']['no_part'].'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />';
	
	echo $content;
}

function DisplayPublicationLinks($publi_id) {

	$data=SQL_GetResources($publi_id, 'P', 'LINK', $GLOBALS['sql_object']);
	$content ='<div id="links">'.END_LINE;
	$content.='<h2>'.$GLOBALS['lang']['publication']['link_res'].'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$linkres_mask=formatText($data[$i]['linkres_mask'], '2HTML');
			$linkres_text=$data[$i]['linkres_text'];
			$content.='<li>'.END_LINE;
			$content.='<a href="'. $linkres_text.'" class="out">';
			$content.=$linkres_mask;
			$content.='</a>';
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
		
	}
	else 
	{
	$content.='<p class="info">'.$GLOBALS['lang']['publication']['no_link'].'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />'.END_LINE;
	
	echo $content;
}

function DisplayPublicationBiblio($publi_id) {

	$data=SQL_GetResources($publi_id, 'P', 'BIBLIO', $GLOBALS['sql_object']);
	$content ='<div id="biblio">'.END_LINE;
	$content.='<h2>'.$GLOBALS['lang']['publication']['biblio_res'].'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$bibliores_author=formatText($data[$i]['bibliores_author'], '2HTML');
			$bibliores_title=formatText($data[$i]['bibliores_title'], '2HTML');
			$bibliores_sub_title=empty($data[$i]['bibliores_sub_title']) ?  '' : ', '.formatText($data[$i]['bibliores_sub_title'], '2HTML');
			$bibliores_editor=empty($data[$i]['bibliores_editor']) ?  '' : ' - '.formatText($data[$i]['bibliores_editor'], '2HTML');
			$bibliores_date=empty($data[$i]['bibliores_date']) ?  '' : ', '.formatText($data[$i]['bibliores_date'], '2HTML');
			
			$content.='<li>'.END_LINE;
			$content.=$bibliores_author.' - <span class="biblio_title">'.$bibliores_title;
			$content.=$bibliores_sub_title.'</span>'. $bibliores_editor.$bibliores_date;
			$content.='</li>'.END_LINE;
		}
		$content.='</ul>'.END_LINE;
		
	}
	else 
	{
		$content.='<p class="info">'.$GLOBALS['lang']['publication']['no_biblio'].'</p>';
	}
	$content.='</div>'.END_LINE;
	//$content.='<hr />'.END_LINE;
	
	echo $content;
}

function DisplayPublicationMulti($publi_id) {

	$data=SQL_GetResources($publi_id, 'P', 'MULTI', $GLOBALS['sql_object']);
	$content ='<div id="multi">'.END_LINE;
	$content.='<h2>'.$GLOBALS['lang']['publication']['multi_res'].'</h2>'.END_LINE;
	if($data!=0) 
	{	
		$content.='<ul>'.END_LINE;
		for($i=0; $i<count($data); $i++) {
			$multires_name=formatText($data[$i]['multires_name'], '2HTML');
			$multires_description=formatText($data[$i]['multires_description'], '2HTML');
			if($data[$i]['multires_media_uri'][0]=='m') $multires_media_uri='../'.$data[$i]['multires_media_uri'];
			else $multires_media_uri=$data[$i]['multires_media_uri'];
			
			$content.='<li>'.END_LINE;
			$content.='<a href="'.$multires_media_uri.'" class="out">'.$multires_name.'</a><br />'.END_LINE;
			$content.='<div>'.END_LINE;
			$content.=$multires_description.END_LINE;
			$content.='</div>'.END_LINE;
			$content.='</li>'.END_LINE;
			
		}
		$content.='</ul>'.END_LINE;
	}
	else 
	{
		$content.='<p class="info">'.$GLOBALS['lang']['publication']['no_multi'].'</p>';
	}
	$content.='</div>'.END_LINE;
	
	echo $content;
}
?>