<?php
/**
 * @package linea21.utils
 * @subpackage report_sdi
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * Define, compose and generate a SDI (Sustainable Development Indicators) PDF report
 */

///////////////////////////////////
// Récupération de données
///////////////////////////////////

// liste des échelles sélectionées
$scale_content='';
for($i=0; $i<count($scale_array); $i++) {
	$scale_content.=$scale_denomination_array[$scale_array[$i]].END_LINE;
}

// liste des indicateurs sélectionés
$sdi_content='';
for($i=0; $i<count($sdi); $i++) {
	$sdi_content.=$sdi[$i]['sdii_name'].END_LINE;
}
//////////////////////////////////


$pdf->AddPage();
$pdf->SetY($pdf->GetY()+20);
$pdf->SetX($pdf->GetX()+152);
$pdf->Bookmark($lang['dashboard']['rap_infopubli']);
// logo
$pdf->Image('inc_report/logo_p.png',$pdf->GetX(), $pdf->GetY(), 0, 0, 'PNG', SITE_LINEA_URL);


//////////////////////////////////
// 	tableau récapitulatif
//////////////////////////////////
$margin = 20;
$pdf->SetY($pdf->GetY()+20);
$pdf->SetWidths(array(50, 140));
$pdf->SetAligns(array('R', 'L'));
$pdf->SetFont(DOC_POLICE, ARRAY_DATA_STYLE, ARRAY_DATA_SIZE);
// organisme émetteur
$pdf->Row(array('', formatText(SITE_CITY_NAME)));
// titre du rapport
$pdf->Row(array($lang['dashboard']['rap_title'], formatText($report_settings['title'])));
// date de création
$pdf->Row(array($lang['divers']['date_crea'], date("d-m-Y H:i:s")));
// auteur
$pdf->Row(array($lang['dashboard']['rap_author'], formatText($report_settings['author'])));
// mail de l'auteur
$pdf->Row(array($lang['dashboard']['rap_mail_author'], formatText($report_settings['mail_author'])));
// service
$pdf->Row(array($lang['dashboard']['rap_service'], formatText($report_settings['service_author'])));
// adresse
$pdf->Row(array($lang['dashboard']['rap_adress'], formatText($report_settings['adress_author'])));
// indicateurs
$pdf->Row(array($lang['dashboard']['rap_indicators'], $sdi_content));
// Echelles
$pdf->Row(array($lang['dashboard']['rap_scale'], $scale_content));
// temps de génération
$pdf->Row(array($lang['dashboard']['rap_generated'].' ('.$lang['divers']['seconds'].')', $total_time));

$pdf->SetFont(DOC_POLICE, DOC_STYLE, DOC_SIZE);
?>