<?php
/**
 * @package linea21.modules
 * @subpackage resources
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Resource' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

if(isset($_POST['id']))	$id=$_POST['id'];
if(isset($_GET['id']))	$id=$_GET['id'];

if($type=='P') {
	$requete= SQL_getPublicationTitle($parent);
	$result=$sql_object->DBSelect($requete);
	$current_title=FormatText($result[0]['publi_title'], '2HTML');
	$publi_owner=$result[0]['publi_posted_by'];
	
	//////////// Check Droits utilisateur ////////////
	if (!HaveRight('publication')) ReloadIndex('admin');
	if (GetSessionElement('id')!=$publi_owner && !IsSuperAdmin()) ReloadIndex('admin');
	///////////
}
if($type=='W') {
	$requete= SQL_getWorkshopRepTitleAndGroup($parent);
	$result=$sql_object->DBSelect($requete);
	$current_title=FormatText($result[0]['workrep_title'].' ('.$result[0]['workshop_denomination'].')', '2HTML');
	$workshop_id=$result[0]['workrep_workshop_id'];
	
	//////////// Check Droits utilisateur ////////////
	if (!HaveRight('workshop')) ReloadIndex('admin');
	if (!AuthUser4Workshop($workshop_id, $sql_object) && !IsSuperAdmin()) ReloadIndex('admin');
	///////////
}

$resources_object= new resources;

if(isset($_POST['enregistrer'])) {
	$data_table=unserialize(urldecode($_POST['data_table']));
	$result=$resources_object->ModifyLinkRes($id, $data_table, $sql_object);
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo."&type=".$type."&id=".$parent;
	if($result) header("Location: ".$link_confirm);
	else  system_error();
}

if(isset($_POST['valider'])) {
	$table[0]=$_POST['link_url'];
	$table[1]=$_POST['link_url_mask'];

	$integrity=$resources_object->CheckDataIntegrity($table,'LINK');

	if(is_string($integrity)) {
		$text_format='2FIELD';
	} else {
		$text_format='2HTML';
	}
	$form_url=formatText($_POST['link_url'], $text_format);
	$form_url_mask=formatText($_POST['link_url_mask'], $text_format);

	$table=urlencode(serialize($table));
}

if(!isset($_POST['valider'])) {
	$requete= SQL_getLinkInfo($id);
	$result=$sql_object->DBSelect($requete);
	$form_url=formatText($result[0]['linkres_text'], '2FIELD');
	$form_url_mask=formatText($result[0]['linkres_mask'], '2FIELD');
}
?>

<div id="chemin">
	<ul>
		<li>
			<a href="index.php"><? echo $GLOBALS['lang']['way']['home']; ?></a>
		</li>
		<li>
			<a href="<?php echo $rub_link; ?>"><? echo $GLOBALS['lang']['menu'][$mod_inc]; ?></a>
		</li>
		<li>
			<span><? echo formatNavTitle($GLOBALS['lang']['resources'][$mod_inc.'_type'].' : '. $current_title); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
include_once("quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
			<?php
			if(isset($integrity) && is_string($integrity)) display_errors($integrity);
			?>
			<h2><? echo formatTitleh2($current_title); ?></h2>
			<form id="modlink" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<p>
				<label for="link_url"><? echo $GLOBALS['lang']['resources']['url']; ?> : *</label>
				<input name="link_url" type="text" class="textfield" id="link_url" maxlength="1000" value="<?php echo $form_url; ?>" />
				</p>
				<p>
				<label for="link_url_mask"><? echo $GLOBALS['lang']['resources']['url_mask']; ?> : </label>
				<input name="link_url_mask" type="text" class="textfield" id="link_url_mask" maxlength="200" value="<?php echo $form_url_mask; ?>" />
				</p>
				<div>
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
				<input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
				<?php echo cancel_button($cancel_link); ?>
				<input name="valider" type="submit" value="<? echo $GLOBALS['lang']['btn']['valid'] ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
<?php include_once($dir."/help.php"); ?>
</div>
<?php
// Récapitulatif
} else	{

if(trim($form_url_mask)=='') {
	$form_url_mask=$GLOBALS['lang']['divers']['none'];
	$display_visual_test="<a href=\"".$form_url."\" class=\"out\">".$form_url."</a>";
} else {
	$display_visual_test="<a href=\"".$form_url."\" class=\"out\">".$form_url_mask."</a>";
}

?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
<div id="content">
			<h2><? echo formatTitleh2($GLOBALS['lang']['recap']['title']); ?></h2>
			<?php
			echo "<dl class=\"dl3\">\n";
			echo "<dt>".$GLOBALS['lang']['resources']['url']."</dt>\n";
			echo "<dd>".$form_url."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['resources']['url_mask']."</dt>\n";
			echo "<dd>".$form_url_mask."</dd>\n";
			echo "<dt>".$GLOBALS['lang']['resources']['url_visual_test']."</dt>\n";
			echo "<dd>".$display_visual_test."</dd>\n";
			echo "</dl>\n";
			?>
			<form id="modlink" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<div>
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="type" type="hidden" value="<?php echo $type; ?>" id="type" />
				<input name="parent" type="hidden" value="<?php echo $parent; ?>" id="parent" />
				<input name="data_table" type="hidden" value="<?php echo $table; ?>" id="data_table" />
				<?php echo cancel_button($cancel_link); ?>
				<input name="retour" type="button" value="<? echo $GLOBALS['lang']['btn']['preview'] ?>" class="button" id="retour" onclick="history.go(-1);" />
				<input name="enregistrer" type="submit" value="<? echo $GLOBALS['lang']['btn']['save'] ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
	<?php include_once($dir."/help.php"); ?>
</div>
<?php
}
?>
