<?php
/**
 * @package linea21.core
 * @subpackage user
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!IsSuperAdmin()) ReloadIndex('admin');
////////////
include_once('../lib/input_helpers.php');

// USER
if (isset($_GET['id']))	$id=$_GET['id'];
if (isset($_POST['id'])) $id=$_POST['id'];

$mask_dashboard_1='';
$mask_dashboard_2='';
$mask_publication_1='';
$mask_publication_2='';
$mask_news_1='';
$mask_news_2='';
$mask_workshop_1='';
$mask_workshop_2='';
$mask_display_mail_1='';
$mask_display_mail_2='';


if(isset($_POST['switch_type'])) {
	$switch_type=$_POST['switch_type'];
	
	$user_object= new user;
	if($switch_type=='2SIMPLE_USER') $table_right=$user_object->InitUserRight('SIMPLE_USER');
	if($switch_type=='2ADMIN_USER') $table_right=$user_object->InitUserRight('ADMIN_USER');
	
	$result=$user_object->ModifyRight($id, $table_right, $sql_object);
	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo."_t&id=".$id;
	if($result) header("Location: ".$link_confirm);
	else  system_error();
}

$requete=SQL_getAllUserInfo($id);
$data=$sql_object->DBSelect($requete, 'OBJECT');
if(count($data)>1) exit();
$current_title =$data[0]->user_login;
$user_login =$data[0]->user_login;
$user_category = $data[0]->user_category;
if($user_category==1) {
	$switch_type='2SIMPLE_USER';
	$switch_link=$GLOBALS['lang']['user']['2SIMPLE_USER'];
} else {
	$switch_type='2ADMIN_USER';
	$switch_link=$GLOBALS['lang']['user']['2ADMIN_USER'];
} 

$switch_form=	"<form id=\"switchform\" name=\"switchform\" action=\"".$_SERVER['SCRIPT_NAME']."\" method=\"post\" >\n";
$switch_form.=	"<div>\n";
$switch_form.=	"<input type=\"hidden\" name=\"switch_type\" id=\"switch_type\" value=\"".$switch_type."\" />\n";
$switch_form.=	"<input name=\"id\" type=\"hidden\" value=\"".$id."\" id=\"id\" />\n";
$switch_form.=	"<input name=\"rub\" type=\"hidden\" value=\"".$rub."\" id=\"rub\" />\n";
$switch_form.=	"<input name=\"todo\" type=\"hidden\" value=\"".$todo."\" id=\"todo\" />\n";
$switch_form.=	"</div>\n";
$switch_form.=	"</form>\n";

// droits utilisateur
$rights_id=$data[0]->rights_id;
$form_rights_dashboard=$data[0]->rights_dashboard;
$form_rights_publication=$data[0]->rights_publication;
$form_rights_news=$data[0]->rights_news;
$form_rights_workshop=$data[0]->rights_workshop;


// profil utilisateur
$profile_id=$data[0]->profile_id;
$form_profile_email = $current_email = $data[0]->profile_email;
$form_profile_email_display=$data[0]->profile_email_display;
$form_profile_city=formatText($data[0]->profile_city, '2FIELD');
$form_profile_birthdate= isNullDate($data[0]->profile_birthdate) ? '--' : formatDate($data[0]->profile_birthdate, true);
list($form_date_y, $form_date_m, $form_date_d)=explode('-', $form_profile_birthdate);
$form_profile_leisures=formatText($data[0]->profile_leisures, '2FIELD');
$form_profile_job=formatText($data[0]->profile_job, '2FIELD');
$form_profile_avatar=$data[0]->profile_avatar;
$form_profile_quotation=formatText($data[0]->profile_quotation, '2FIELD');
$form_profile_signature=formatText($data[0]->profile_signature, '2FIELD');
$form_profile_last_modify_display=$data[0]->profile_last_modify_display;

if(isset($_POST['valider'])) {
	$table_user[0]=$user_login;
	$integrity=1;
	$form_profile_email = $table_profile[0] = $table_user[1] =$_POST['email'];
	$form_profile_email_display = $table_profile[1] = $_POST['email_display'];
	$form_profile_city = $table_profile[2] =  $_POST['city'];
	$form_date_d = $_POST['date_d'];
	$form_date_m = $_POST['date_m'];
	$form_date_y = $_POST['date_y'];	
	$form_birthdate=$form_date_d . '-' . $form_date_m . '-' . $form_date_y;

	if(!empty($form_date_d) && !empty($form_date_m) && !empty($form_date_y)) {
	  $date_integrity=checkdate_validity($form_birthdate);
	} else {
	  $date_integrity=true;
	}
	if(is_string($date_integrity)) $integrity = $date_integrity;
	else {
		$table_profile[3]= $form_date_y.'-'.$form_date_m.'-'.$form_date_d;
		$form_profile_birthdate=$table_profile[3];
		$form_profile_birthdate=formatDate($form_profile_birthdate);
	}
	$table_profile[4] = $_POST['leisures'];
	$table_profile[5] = $_POST['job'];
	$table_profile[6] = $_POST['quotation'];
	$table_profile[7] = $_POST['signature'];
	$table_right['dashboard']=$_POST['dashboard'];
	$table_right['publication']=$_POST['publication'];
	$table_right['news']=$_POST['news'];
	$table_right['workshop']=$_POST['workshop'];
	
	if(is_string($integrity)) $format_text='2FIELD'; else $format_text='2HTML';
	$form_profile_leisures = formatText($_POST['leisures'], $format_text);
	$form_profile_job = formatText($_POST['job'], $format_text);
	$form_profile_quotation = formatText($_POST['quotation'], $format_text);
	$form_profile_signature = formatText($_POST['signature'], $format_text);
	$form_rights_dashboard = $_POST['dashboard'];
	$form_rights_publication = $_POST['publication'];
	$form_rights_news = $_POST['news'];
	$form_rights_workshop = $_POST['workshop'];
	
	$table_right=urlencode(serialize($table_right));
	$current_email=$_POST['current_email'];


	$user_object= new user;
	$data_user_integrity=$user_object->CheckDataIntegrity($table_user);
	
	if(is_string($data_user_integrity)) $integrity=$data_user_integrity;

	if(!is_string($integrity)) {
		if(isset($_FILES['avatar']) && $_FILES['avatar']['name']!='') {
			include_once('../class/system/class.upload.php');
			$upload_object= new upload;
			$upload=$_FILES['avatar'];
			$size_integrity=$upload_object->CheckMaxFile($upload['size'], $user_object->UPLOAD_MAX_MO);
			if(is_string($size_integrity)) $integrity=$size_integrity;
			$format_integrity=$upload_object->CheckExtImage($upload['name']);
			if(is_string($format_integrity)) $integrity=$format_integrity;
			if(!is_string($integrity)) {
				$final_name=$id.".".$upload_object->GetExtension($upload ['name']);
				$temp_name="temp_".$final_name;
				$destination="../".$user_object->URI_INPUT;
				$table_profile[8]=$user_object->URI_INPUT.$final_name;
				
				$form_profile_avatar=$user_object->URI_INPUT.$temp_name;
				$result_upload=$upload_object->UploadFile($upload, $temp_name, $destination);
			}
		} else  {
			$table_profile[8]=$form_profile_avatar;
			$archive_it=0;
		}
	}
	$table_profile=urlencode(serialize($table_profile));
}

if(isset($_POST['enregistrer'])) {
	$current_email=$_POST['current_email'];
	include_once('../class/system/class.upload.php');
	$table_right=unserialize(urldecode($_POST['table_right']));
	$table_profile=unserialize(urldecode($_POST['table_profile']));
	$new_email=$table_profile[0];
	$user_object= new user;

	$result1=$user_object->ModifyRight($id, $table_right, $sql_object);
	$result2=$user_object->ModifyProfile($id, $table_profile, $sql_object);
	
	if($new_email!=$current_email) {
		$new_pass=$user_object->GetNewPassword();
		$user_object->UpdateUserPassword($id, $new_pass, $sql_object);
		
		/** include envoi de mail */
		$todo_mail='change_mail';
		include_once('../user/mail_actions.php');
		include_once('../mail/template.php');
	}
	$upload_object= new upload;
	$visual_uri="../".$table_profile[8];
	$result_rename=$upload_object->Archivefile($visual_uri);

	$link_confirm="confirm.php?rub=".$rub."&todo=".$todo;
	if($result1 && $result2) header("Location: ".$link_confirm);
	else  system_error();
}

// préparation des données
if($form_rights_dashboard=='U') $mask_dashboard_1="checked=\"checked\"";
if($form_rights_dashboard=='O') $mask_dashboard_2="checked=\"checked\"";
if($form_rights_publication=='U') $mask_publication_1="checked=\"checked\"";
if($form_rights_publication=='O') $mask_publication_2="checked=\"checked\"";
if($form_rights_news=='U') $mask_news_1="checked=\"checked\"";
if($form_rights_news=='O') $mask_news_2="checked=\"checked\"";
if($form_rights_workshop=='U') $mask_workshop_1="checked=\"checked\"";
if($form_rights_workshop=='O') $mask_workshop_2="checked=\"checked\"";
if($form_profile_email_display=='Y') $mask_display_mail_1="checked=\"checked\"";
if($form_profile_email_display=='N') $mask_display_mail_2="checked=\"checked\"";
if(!empty($form_profile_avatar)) {
	$complete_uri='../'.$form_profile_avatar;
	$user_profile_avatar='<img src="'.$complete_uri.'" alt="'.$GLOBALS['lang']['user']['avatar'].' '.$user_login.'" />';
} else $user_profile_avatar=$GLOBALS['lang']['divers']['none'];


// preparation affichage detaillé 
$rights_display='';
if(defined('MOD_SDI') && $user_category!=1) {
	$rights_display.= "<label for=\"dashboard_1\" class=\"rights\">>> ".$GLOBALS['lang']['menu']['dashboard']." : </label><br />\n";
	$rights_display.= "<div class=\"radiomargin\">\n";
	$rights_display.= "<input type=\"radio\" id=\"dashboard_1\" class=\"radio\" name=\"dashboard\" value=\"U\" ".$mask_dashboard_1." /><span class=\"radio\">". $GLOBALS['lang']['user']['norights']."</span>\n";
	$rights_display.= "<input type=\"radio\" id=\"dashboard_2\" class=\"radio\" name=\"dashboard\" value=\"O\" ".$mask_dashboard_2."/><span class=\"radio\">". $GLOBALS['lang']['user']['managerrights']."</span>\n";
	$rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"dashboard\" name=\"dashboard\" value=\"".$form_rights_dashboard."\" />\n";
if(defined('MOD_PUBLICATION') && $user_category!=1) {
	$rights_display.= "<label for=\"publication_1\" class=\"rights\">>> ".$GLOBALS['lang']['menu']['publication']." : </label><br />\n";
	$rights_display.= "<div class=\"radiomargin\">\n";
	$rights_display.= "<input type=\"radio\" id=\"publication_1\" class=\"radio\" name=\"publication\" value=\"U\" ".$mask_publication_1." /><span class=\"radio\">". $GLOBALS['lang']['user']['norights']."</span>\n";
	$rights_display.= "<input type=\"radio\" id=\"publication_2\" class=\"radio\" name=\"publication\" value=\"O\" ".$mask_publication_2." /><span class=\"radio\">". $GLOBALS['lang']['user']['redactorrights']."</span>\n";
	$rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"publication\" name=\"publication\" value=\"".$form_rights_publication."\" />\n";
if(defined('MOD_NEWS') && $user_category!=1) {
	$rights_display.= "<label for=\"news_1\" class=\"rights\">>> ".$GLOBALS['lang']['menu']['news']." : </label><br />\n";
	$rights_display.= "<div class=\"radiomargin\">\n";
	$rights_display.= "<input type=\"radio\" id=\"news_1\" class=\"radio\" name=\"news\" value=\"U\" ".$mask_news_1." /><span class=\"radio\">". $GLOBALS['lang']['user']['norights']."</span>\n";
	$rights_display.= "<input type=\"radio\" id=\"news_2\" class=\"radio\" name=\"news\" value=\"O\" ".$mask_news_2."/><span class=\"radio\">". $GLOBALS['lang']['user']['redactorrights']."</span>\n";
	$rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"news\" name=\"news\" value=\"".$form_rights_news."\" />\n";
if(defined('MOD_WORKSHOP') && $user_category!=1) {
	$rights_display.= "<label for=\"workshop_1\" class=\"rights\">>> ".$GLOBALS['lang']['menu']['workshop']." : </label><br />\n";
	$rights_display.= "<div class=\"radiomargin\">\n";
	$rights_display.= "<input type=\"radio\" id=\"workshop_1\" class=\"radio\" name=\"workshop\" value=\"U\" ".$mask_workshop_1." /><span class=\"radio\">". $GLOBALS['lang']['user']['norights']."</span>\n";
	$rights_display.= "<input type=\"radio\" id=\"workshop_2\" class=\"radio\" name=\"workshop\" value=\"O\" ".$mask_workshop_2." /><span class=\"radio\">". $GLOBALS['lang']['user']['animatorrights']."</span>\n";
	$rights_display.= "</div>\n";
} else $rights_display.="<input type=\"hidden\" id=\"wokshop\" name=\"workshop\" value=\"".$form_rights_workshop."\" />\n";
if($user_category==1) {
$rights_display.="<p class=\"info\">\n";
$rights_display.=$GLOBALS['lang']['user']['admin_type_info'];
$rights_display.="\n</p>\n";
}
?>
<div id="chemin">
	<ul>
		<li>
			<a href="index.php"><?php echo $GLOBALS['lang']['way']['home']; ?></a>
		</li>
		<li>
			<a href="<?php echo $rub_link; ?>"><?php echo $GLOBALS['lang']['menu']['user']; ?></a>
		</li>
		<li>
			<span><?php echo formatNavTitle($GLOBALS['lang']['user']['mod'].' : '.$current_title); ?></span>
		</li>
	</ul>
</div>
<!--end barre haute -->
<?php
include_once("quickicons.php");
?>

<?php
if(!isset($integrity) || is_string($integrity)) {
?>
<div class="contentcontainer">
<?php
include_once($dir."/menurub.php");
?>
		<div id="content">
			<?php
			if(isset($integrity) && is_string($integrity)) display_errors($integrity);
			?>
			<h2><?php echo formatTitleh2($current_title); ?></h2>
			<div class="mod_link">
			<a href="<?php echo $rub_link."&amp;todo=mod_p&amp;id=".$id; ?>"><?php echo $GLOBALS['lang']['user']['new_password']; ?></a> | 
			<?php echo "<a href=\"#\" onclick=\"document.getElementById('switchform').submit()\">".$switch_link."</a>"; ?>
			<br />
			
			</div>
			<form id="moduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post" enctype="multipart/form-data">
				<p>
					<h3><?php echo $GLOBALS['lang']['user']['update_rights']; ?> : <br /></h3>
					<?php echo $rights_display; ?>
				</p>
				<hr />
				<p>
					<h3><?php echo $GLOBALS['lang']['user']['profile']; ?> : </h3>
				</p>
				<p>
				<label for="email" ><?php echo $GLOBALS['lang']['user']['email']; ?> : *</label>
				<input name="email" type="text" class="textfield" id="email" maxlength="200" value="<?php echo $form_profile_email; ?>" />
				</p>
				<p>
				<label for="email_display_Y" ><?php echo $GLOBALS['lang']['user']['email_display']; ?> : </label>
				<div class="radiomargin">
				<input type="radio" id="email_display_Y" class="radio" name="email_display" value="Y"<?php echo $mask_display_mail_1; ?> /><span class="radio"><?php echo $GLOBALS['lang']['divers']['yes']; ?></span>
				<input type="radio" id="email_display_N" class="radio" name="email_display" value="N"<?php echo $mask_display_mail_2; ?> /><span class="radio"><?php echo $GLOBALS['lang']['divers']['no']; ?></span>
				</div>
				</p>
				<p>
				<dl class="dl_mod">
				<dt><?php echo $GLOBALS['lang']['user']['avatar']; ?></dt>
				<dd><?php echo $user_profile_avatar; ?></dd>
				</dl>
				</p>
				<p>
				<label for="avatar" ><?php echo $GLOBALS['lang']['user']['avatar']; ?> : </label>
				<input name="avatar" type="file" id="avatar" size="47" class="file" />
				</p>
				<p>
				<label for="birthdate_d" ><?php echo $GLOBALS['lang']['user']['birthdate']; ?> :</label>
				<?php echo input_date($form_date_y, $form_date_m, $form_date_d); ?>
				</p>
				<p>
				<label for="city" ><?php echo $GLOBALS['lang']['user']['city']; ?> :</label>
				<input name="city" type="text" class="textfield" id="city" maxlength="100" value="<?php echo $form_profile_city; ?>" />
				</p>
				<p>
				<label for="leisures" ><?php echo $GLOBALS['lang']['user']['leisures']; ?> :</label>
				<input name="leisures" type="text" class="textfield" id="leisures" maxlength="150" value="<?php echo $form_profile_leisures; ?>" />
				</p>
				<p>
				<label for="job" ><?php echo $GLOBALS['lang']['user']['job']; ?> :</label>
				<input name="job" type="text" class="textfield" id="job" maxlength="150" value="<?php echo $form_profile_job; ?>" />
				</p>
				<p>
				<label for="quotation" ><?php echo $GLOBALS['lang']['user']['quotation']; ?> :</label>
				<input name="quotation" type="text" class="textfield" id="quotation" maxlength="150" value="<?php echo $form_profile_quotation; ?>" />
				</p>
				<p>
				<label for="signature" ><?php echo $GLOBALS['lang']['user']['signature'] ?> :</label>
				<input name="signature" type="text" class="textfield" id="signature" maxlength="200" value="<?php echo $form_profile_signature; ?>" />
				</p>
				<div>
				<input name="current_email" type="hidden" value="<?php echo $current_email; ?>" id="current_email" />
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<?php echo cancel_button('javascript:history.go(-1);'); ?>
				<input name="valider" type="submit" value="<?php echo $GLOBALS['lang']['btn']['valid'] ?>" class="button" id="valider" />
				</div>
			</form>
			<?php echo $switch_form; ?>
		</div>
		<?php include_once($dir."/help.php"); ?>
</div>
<?php
// Récapitulatif
} else	{
//prepa affichage de droits
	$reca_droits='';
	$reca_droits.="<dl class=\"dl3\">\n";
	$reca_droits.="<dt class=\"dl_intitule\">".$GLOBALS['lang']['user']['rights']." : </dt>\n";
	$reca_droits.="<dd>&nbsp;<br /></dd>\n";
	if(defined('MOD_SDI'))  {
		$reca_droits.="<dt> . ".$GLOBALS['lang']['menu']['sdi']."</dt>\n";
		$reca_droits.="<dd>".GetDisplayUserRight($form_rights_dashboard, 'dashboard')."<br /></dd>\n";
	}
	if(defined('MOD_PUBLICATION'))  {
		$reca_droits.="<dt>  . ".$GLOBALS['lang']['menu']['publication']."</dt>\n";
		$reca_droits.="<dd>".GetDisplayUserRight($form_rights_publication)."<br /></dd>\n";
	}
	if(defined('MOD_WORKSHOP'))  {
		$reca_droits.="<dt>  . ".$GLOBALS['lang']['menu']['workshop']."</dt>\n";
		$reca_droits.="<dd>".GetDisplayUserRight($form_rights_workshop, 'workshop')."<br /></dd>\n";
	}
	if(defined('MOD_NEWS'))  {
		$reca_droits.="<dt>  . ".$GLOBALS['lang']['menu']['news']."</dt>\n";
		$reca_droits.="<dd>".GetDisplayUserRight($form_rights_news)."<br /></dd>\n";
	}
	$reca_droits.="</dl>\n";

	
if($form_profile_email_display=='Y') $form_profile_email_string=$GLOBALS['lang']['divers']['yes'];
if($form_profile_email_display=='N') $form_profile_email_string=$GLOBALS['lang']['divers']['no'];
$form_profile_email='<a href="mailto:'.$form_profile_email.'">'.$form_profile_email.'</a>';
$form_profile_city=empty_nc($form_profile_city);
$form_profile_birthdate = ($form_profile_birthdate=='--') ? '' : $form_profile_birthdate;
$form_profile_birthdate=empty_nc($form_profile_birthdate);
$form_profile_leisures=empty_nc($form_profile_leisures);
$form_profile_job=empty_nc($form_profile_job);
$user_profile_avatar=empty_none($user_profile_avatar);
$form_profile_signature=empty_nc($form_profile_signature);
$form_profile_quotation=empty_nc($form_profile_quotation);
?>
<div class="contentcontainer">
		<?php
		include_once($dir."/menurub.php");
		?>
		<div id="content">
		<?php
		echo "<h2>".formatTitleh2($GLOBALS['lang']['recap']['title'])."</h2>";
		echo $reca_droits;
		echo "<dl class=\"dl3\">\n";
		echo "<dt class=\"dl_intitule\">".$GLOBALS['lang']['user']['profile']." :</dt>\n";
		echo "<dd>&nbsp;</dd>\n";
		echo "<dt>". $GLOBALS['lang']['user']['email']. "</dt>\n";
		echo "<dd>".$form_profile_email."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['email_display']."</dt>\n";
		echo "<dd>". $form_profile_email_string."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['birthdate']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_birthdate)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['city']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_city)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['leisures']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_leisures)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['job']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_job)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['avatar']."</dt>\n";
		echo "<dd>". stripslashes($user_profile_avatar)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['quotation']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_quotation)."</dd>\n";
		echo "<dt>".$GLOBALS['lang']['user']['signature']."</dt>\n";
		echo "<dd>". stripslashes($form_profile_signature)."</dd>\n";
		echo "</dl>\n";			
		?>
			<form id="moduser" action="<?php echo $_SERVER['SCRIPT_NAME']; ?>" method="post">
				<div>
				<input name="id" type="hidden" value="<?php echo $id; ?>" id="id" />
				<input name="rub" type="hidden" value="<?php echo $rub; ?>" id="rub" />
				<input name="todo" type="hidden" value="<?php echo $todo; ?>" id="todo" />
				<input name="current_email" type="hidden" value="<?php echo $current_email; ?>" id="current_email" />
				<input name="table_right" type="hidden" value="<?php echo $table_right; ?>" id="table_right" />
				<input name="table_profile" type="hidden" value="<?php echo $table_profile; ?>" id="table_profile" />
				<?php echo cancel_button('?rub=user&todo=list'); ?>
				<input name="retour" type="button" value="<?php echo $GLOBALS['lang']['btn']['preview'] ?>" class="button" id="retour" onclick="history.go(-1);" />
				<input name="enregistrer" type="submit" value="<?php echo $GLOBALS['lang']['btn']['save'] ?>" class="button" id="valider" />
				</div>
			</form>
		</div>
		<?php include_once($dir."/help.php"); ?>
</div>
<?php
}
?>
