<?php
/**
 * @package linea21.modules
 * @subpackage content
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 * 'Content' module is used by 'Publication' and 'Workshop' modules
 */

//////////// Check Inclusion de pages ////////////
if (!function_exists('AuthenthificationProcess')) {
    include_once("../lib/lib_common.php");
    ReloadIndex('admin');
} 
////////////

//////////// Check Droits utilisateur ////////////
if (!HaveRight('publication') && !HaveRight('workshop')) ReloadIndex('admin');
///////////

$qbx_module=_t('menu',$mod_inc);
if($type=='W') {
	$quickbox_type=_t('contents','qb_title_type_W');
	$suffix_css='w';
	}
if($type=='P') {
	$quickbox_type=_t('contents','qb_title_type_P');
	$suffix_css='p';
}

if ($todo == 'add' || $todo== 'det') {
	if($type=='P') $req_quickbox=SQL_getPublicationParts($parent, 'CREA', 'Y', 10);
	if($type=='W') $req_quickbox=SQL_getWorkshopParts($parent, 'CREA', 'Y', 10);
	$result=$sql_object->DBSelect($req_quickbox);
	$qbx_liste='';
	$nb='';
	if($result==0) {
		$qbx_liste.="<li>"._t('divers','nodata')."</li>";
	} else {	
		if(count($result)>=10) $nb=10; else $nb=count($result);
		for($i=0; $i<count($result); $i++) {
			$qbx_link='?rub=contents&amp;todo=det&amp;type='.$type.'&amp;parent='.$parent.'&amp;id=';
			if($type=='P') {
				$qbx_part_title=$result[$i]['publicon_title'];
				$qbx_part_date=$result[$i]['publicon_date_crea_display'];
				$qbx_link.=$result[$i]['publicon_id'];
			}
			if($type=='W') {
				$qbx_part_title=$result[$i]['workrepcon_title'];
				$qbx_part_date=$result[$i]['workrepcon_date_crea_display'];
				$qbx_link.=$result[$i]['workrepcon_id'];
				}
			$qbx_part_title=formatText(cutText($qbx_part_title, 50), '2HTML');
			$qbx_liste.="<li><a href=\"".$qbx_link."\" title=\""._t('divers','date_crea').": ".$qbx_part_date." \">". $qbx_part_title ."</a></li>\n";
		}
	}
	$qbx_h1=$nb._t('contents','qb_titleadd');

} 
if ($todo == 'mod') {
	if($type=='P') $req_quickbox=SQL_getPublicationParts($parent, 'MODIFY', 'Y', 10);
	if($type=='W') $req_quickbox=SQL_getWorkshopParts($parent, 'MODIFY', 'Y', 10);
	$result=$sql_object->DBSelect($req_quickbox);
	$qbx_liste='';
	$nb='';
if($result==0) {
	$qbx_liste.="<li>"._t('divers','nodata')."</li>";
} else {	
	if(count($result)>=10) $nb=10; else $nb=count($result);
	for($i=0; $i<count($result); $i++) {
			$qbx_link='?rub=contents&amp;todo=det&amp;type='.$type.'&amp;parent='.$parent.'&amp;id=';
			if($type=='P') {
					$qbx_part_title=$result[$i]['publicon_title'];
					$qbx_part_date_crea=$result[$i]['publicon_date_crea_display'];
					$qbx_part_last_modify=$result[$i]['publicon_last_modify_display'];
					$qbx_link.=$result[$i]['publicon_id'];
					
			}
			if($type=='W') {
					$qbx_part_title=$result[$i]['workrepcon_title'];
					$qbx_part_date_crea=$result[$i]['workrepcon_date_crea_display'];
					$qbx_part_last_modify=$result[$i]['workrepcon_last_modify_display'];
					$qbx_link.=$result[$i]['workrepcon_id'];
			}
			$qbx_part_title=formatText(cutText($qbx_part_title, 50), '2HTML');
			$qbx_liste.="<li><a href=\"".$qbx_link."\" title=\""._t('divers','last_modify')." ".$qbx_part_last_modify." - ("._t('divers','date_crea').": ".$qbx_part_date_crea.") \">". $qbx_part_title ."</a></li>\n";
	}
	$qbx_h1=$nb._t('contents','qb_titlemod');
}

} 
if ($todo == 'sup') {
	if($type=='P') $req_quickbox=SQL_getPublicationParts($parent, 'MODIFY', 'N', 10);
	if($type=='W') $req_quickbox=SQL_getWorkshopParts($parent, 'MODIFY', 'N', 10);
	$result=$sql_object->DBSelect($req_quickbox);
	$qbx_liste='';
	$nb='';
	if($result==0) {
		$qbx_liste.="<li>"._t('divers','nodata')."</li>";
	} else {	
		if(count($result)>=10) $nb=10; else $nb=count($result);
		for($i=0; $i<count($result); $i++) {
			if($type=='P') {
					$qbx_part_title=$result[$i]['publicon_title'];
					$qbx_part_date_crea=$result[$i]['publicon_date_crea_display'];
					$qbx_part_last_modify=$result[$i]['publicon_last_modify_display'];	
			}
			if($type=='W') {
					$qbx_part_title=$result[$i]['workrepcon_title'];
					$qbx_part_date_crea=$result[$i]['workrepcon_date_crea_display'];
					$qbx_part_last_modify=$result[$i]['workrepcon_last_modify_display'];
			}
			$qbx_part_title=formatText(cutText($qbx_part_title, 50), '2HTML');
			$qbx_liste.="<li><a href=\"#\" title=\""._t('divers','date_sup')." ".$qbx_part_last_modify." - ("._t('divers','date_crea').": ".$qbx_part_date_crea.") \">". $qbx_part_title ."</a></li>\n";
		}
	}
	$qbx_h1=$nb._t('contents','qb_titlesup');
} 
echo QuickBoxNow($qbx_module, $qbx_h1, $qbx_liste, $suffix_css);
echo "</div>\n";
?>