<?php
/**
 * @package linea21.modules
 * @subpackage dashboard
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

ob_start();
session_start();
include_once("../lib/functions_auth.php");

include_once("../config/define.php");
include_once("../config/server.php");
//////////// Check Inclusion de pages //////////// 
if (!function_exists('AuthenthificationProcess')){ 
include_once("../lib/lib_common.php");
ReloadIndex('admin');
}
////////////

$scale_id=$_GET['scale_id'];
$id=$_GET['id'];

include("../class/system/class.".SQL.".php");
include("../class/class.sdi.php");
include(SQL.".inc.php");
$sql_entity=SQL;
$sql_object = new $sql_entity;
$sql_object -> DBInitialise();
$sql_object -> DBConnexion();

$req_sdiav=SQL_getAllValue("SCP", $scale_id, $id);	
$value = $sql_object -> DBSelect($req_sdiav);
$req_sdii=SQL_getInfoSdi($id);
$result_sdii = $sql_object -> DBSelect($req_sdii);

require_once "../class/system/artichow/BarPlot.class.php";
require_once "../class/system/artichow/LinePlot.class.php";

$unit=$result_sdii[0]['sdii_unit'];
$title=formatText($result_sdii[0]['sdii_name']);
$title=cutText($title, 50, 0); 
for ($i=0; $i<count($value); $i++) {
	$ydata[$i]=$value[$i]['sdiv_value'];
	$ydata2[$i]=$result_sdii[0]['sdii_threshold_value'];
	list($day, $month, $year)=explode('-',$value[$i]['date_p']);
	$months[$i] = $day . '-' .$month. '-'. substr($year, 2, 2);	
}

// Create the graph. 
$graph = new Graph(450,300);
if(function_exists('imageantialias')) {
  $graph->setAntiAliasing(TRUE);
}
$graph->border->setColor(new Color(133, 133, 133, 50));

$group = new PlotGroup;
$group->setSpace(5, 5, 5, 0);
$group->setBackgroundColor(
	new Color(244, 244, 244)
);
$group->grid->hideVertical();
$group->grid->setColor(new Color(0, 0, 0, 80));
$group->grid->setType(LINE_DOTTED);
$group->setPadding(40, 15, 20, 50);


$bplot = new BarPlot($ydata);
//$bplot->setSpace(4, 4, 4, 0);
//$bplot->setPadding(15, 15, 5, 50);
$bplot->SetBarGradient(
	new LinearGradient(
		new Color(207, 228, 252, 0),
		new Color(146, 174, 206, 0),
		90
	)
);	

$group->axis->left->title->set($unit);
$group->axis->left->title->setFont(new Tuffy(10));
$group->axis->left->title->move(-4, 0);
$group->axis->left->setTitleAlignment(LABEL_TOP);

/**
Affichage des valeurs en haut de colonnes
$bplot->label->set($ydata);
$bplot->label->move(0, -23);
$bplot->label->setBackgroundGradient(
	new LinearGradient(
		new Color(250, 250, 250, 10),
		new Color(255, 200, 200, 30),
		0
	)
);
*/

$bplot->label->border->setColor(new Color(20, 20, 20, 20));
$bplot->label->setPadding(3, 1, 1, 0);
$bplot->barBorder->setColor(new Color(161, 182, 206, 0));

$group->axis->bottom->setLabelText($months); 
$group->axis->bottom->label->setAngle(55);
$group->axis->bottom->label->setFont(new Tuffy(7));

$group->add($bplot);


$plot = new LinePlot($ydata2, LINEPLOT_MIDDLE);
$plot->setFillColor(new Color(254, 148, 64, 50));
$plot->setColor(new Color(254, 148, 64, 0));
$plot->mark->setType(MARK_SQUARE);

$plot->mark->setSize(5);
$plot->mark->setFill(new Color(246, 149, 55, 20));
$plot->mark->border->show();
$plot->mark->border->setColor(new Color(254, 148, 64, 0));

$group->add($plot);
$graph->add($group);


$graph->draw();

?>
