<?php
/**
 * @package linea21.utils
 * @subpackage lib
 * @author linea21 <info@linea21.com>
 * @version $id SVN
 * @access public
 * @license http://opensource.org/licenses/gpl-3.0.html
 */

/**
 * SetHTMLTitle()
 * Aggregate string
 * to the global array $GLOBALS['current_title']
 * @param $str string
 * @return void
 */
function SetHTMLTitle($str)
{
  if(count($GLOBALS['current_title']) == 0) array_push($GLOBALS['current_title'], SITE_CITY_NAME);
  array_push($GLOBALS['current_title'], $str);
}



/**
 * HrefMaker()
 * Generated a well-formed string URL for SEO
 * if MOD_REWRITE is set to 1
 * Can be override if the given array contains a key
 * named 'rewrite_override'
 * @param array $array
 * @return string $url_maked
 **/
function HrefMaker($array)
{
  $url_maked = '';

  if (defined("MOD_REWRITE") && MOD_REWRITE == true && !in_array('rewrite_override', $array)) {
    if (array_key_exists('rub', $array)) {
      $url_maked .= $array['rub'];
    }
    if (array_key_exists('filter', $array)) {
      $url_maked .= URI_SEPARATOR . '@@'.$array['filter'];
    }
    if (array_key_exists('name', $array)) {
      $url_maked .= URI_SEPARATOR . stripText(stripAccents($array['name'])). ','. $array['id'];
    }
    else {
      if (array_key_exists('id', $array)) {

        $url_maked .= URI_SEPARATOR . $array['id'];
      }
    }
    if (array_key_exists('parentid', $array)) {
      $url_maked .= URI_SEPARATOR . $array['parentid'];
    }
    if (array_key_exists('parentparentid', $array)) {
      $url_maked .= URI_SEPARATOR . $array['parentparentid'];
    }
    if (array_key_exists('debut', $array)) {
      $url_maked .= URI_SEPARATOR . '-' . $array['debut'] . '-' ;
    }
    $url_maked .= '.html';
  }
  else
  {
    $url_maked = get_permalink($array);
  }
  return $url_maked;
}

/**
 * display_permalink()
 * Display permalink
 * @param array $array
 * @return string
 */
function formatted_permalink($array, $sep = '') {

  if(defined('MOD_REWRITE') && MOD_REWRITE == 1) {
    return $sep.'<a href="'.get_permalink($array).'" title="'. _t('divers','permalink').'" class="permalink"><span>'._t('divers','permalink').'</span></a>';
  } else {
    return '';
  }
}

/**
 * get_permalink()
 * Get permalink
 * @param array $array
 * @return string
 */
function get_permalink($array) {
  if(isset($array['name'])) unset($array['name']);
  if(isset($array['rewrite_override'])) unset($array['rewrite_override']);
  if (function_exists('http_build_query')) $url_string = http_build_query($array);
  else {
    $url_string = '';
    $sep = '';
    while (list($key, $value) = each ($array)) {
      if (!empty($value)) {
        $url_string .= $sep . $key . '=' . $value;
        $sep = OUTPUT_SEP;
      }
    }
  }
  $url_maked = 'index.php?' . $url_string;

  return $url_maked;
}

/**
 * DisplayTemplate()
 * Include the required template
 * if no user template is found in /public/
 * includes the /public/dist/ version.
 *
 * @return void
 **/
function DisplayTemplate()
{
  $key = ActiveItemKey($GLOBALS['activeitem']);
  $current_template = $GLOBALS['links'][LANGUAGE][$key]['template'];
  distInclude(THEME_PUBLIC_PATH.'tpl_' . $current_template . '.php', THEME_PUBLIC_DIST);
}

/**
 * ActiveItem()
 * Détermine l'item actif et le place en var global
 *
 * @return void
 */
function ActiveItem()
{
  if (array_key_exists('rub', $_REQUEST)) $GLOBALS['activeitem'] = $_REQUEST['rub'];
  else $GLOBALS['activeitem'] = $GLOBALS['links'][LANGUAGE]['home']['linkvalue'];
}

/**
 * ActiveItemKey()
 * Return the Active item key
 * @param string $item
 * @return string
 **/
function ActiveItemKey($item)
{
  foreach ($GLOBALS['links'][LANGUAGE] as $key => $value) {
    if ($GLOBALS['links'][LANGUAGE][$key]['linkvalue'] == $item)  return $key;
  }
  return false;
}

/**
 * ActiveItemAlias()
 * Return the active item
 * or its alias
 * @param string $item
 * @return string
 **/
function ActiveItemAlias($item)
{
  $key = ActiveItemKey($item);
  if ($GLOBALS['links'][LANGUAGE][$key]['alias'] === false) return $key;
  else return $GLOBALS['links'][LANGUAGE][$key]['alias'];
}

?>